/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.SplineMesh;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CreateSplineMeshTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    static int counter;
    static final int FLAT = 0;
    static final int CYLINDER = 1;
    static final int TORUS = 2;
    boolean shiftDown;
    Point clickPoint;
    int usize = 5;
    int vsize = 5;
    int shape = 0;
    int smoothing = 3;
    double thickness = 0.5;

    public CreateSplineMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("splineMesh.gif");
        selectedIcon = this.loadImage("selected/splineMesh.gif");
    }

    public void activate() {
        super.activate();
        this.setHelpText();
    }

    private void setHelpText() {
        StringBuffer buf = new StringBuffer("Drag to create a ");
        buf.append(this.usize + " by " + this.vsize);
        if (this.shape == 0) {
            buf.append(" flat");
        } else if (this.shape == 1) {
            buf.append(" cylindrical");
        } else {
            buf.append(" toriodal");
        }
        if (this.smoothing == 2) {
            buf.append(", interpolating");
        } else {
            buf.append(", approximating");
        }
        buf.append(" spline mesh.  Shift-drag to constrain shape.  Double-click icon to change mesh properties.");
        this.theWindow.setHelpText(buf.toString());
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.shiftDown = e.isShiftDown();
        ((SceneViewer)view).beginDraggingBox(this.clickPoint, this.shiftDown);
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Scene theScene = ((LayoutWindow)this.theFrame).getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.shiftDown) {
            if (Math.abs(dragPoint.x - this.clickPoint.x) > Math.abs(dragPoint.y - this.clickPoint.y)) {
                dragPoint.y = dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(dragPoint.x - this.clickPoint.x);
            } else {
                dragPoint.x = dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(dragPoint.y - this.clickPoint.y);
            }
        }
        if (dragPoint.x == this.clickPoint.x || dragPoint.y == this.clickPoint.y) {
            ((SceneViewer)view).repaint();
            return;
        }
        Vec3 v1 = cam.convertScreenToWorld(this.clickPoint, 20.0);
        Vec3 v2 = cam.convertScreenToWorld(new Point(dragPoint.x, this.clickPoint.y), 20.0);
        Vec3 v3 = cam.convertScreenToWorld(dragPoint, 20.0);
        Vec3 orig = v1.plus(v3).times(0.5);
        Vec3 xdir = dragPoint.x < this.clickPoint.x ? v1.minus(v2) : v2.minus(v1);
        Vec3 ydir = dragPoint.y < this.clickPoint.y ? v3.minus(v2) : v2.minus(v3);
        double xsize = xdir.length();
        double ysize = ydir.length();
        xdir = xdir.times(1.0 / xsize);
        ydir = ydir.times(1.0 / ysize);
        Vec3 zdir = xdir.cross(ydir);
        Vec3[][] v = this.getMeshPoints(xsize, ysize);
        float[] usmoothness = new float[this.usize];
        float[] vsmoothness = new float[this.vsize];
        int i = 0;
        while (i < this.usize) {
            usmoothness[i] = 1.0f;
            ++i;
        }
        i = 0;
        while (i < this.vsize) {
            vsmoothness[i] = 1.0f;
            ++i;
        }
        SplineMesh obj = new SplineMesh(v, usmoothness, vsmoothness, this.smoothing, this.shape != 0, this.shape == 2);
        obj.setTexture(theScene.getDefaultTexture());
        obj.setTextureMapping(theScene.getDefaultTexture().getDefaultMapping());
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(orig, zdir, ydir), "Spline Mesh " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        ((LayoutWindow)this.theFrame).addObject(info, undo);
        this.theWindow.setUndoRecord(undo);
        Vector objects = theScene.getObjects();
        ((LayoutWindow)this.theFrame).setSelection(objects.size() - 1);
        this.theWindow.updateImage();
    }

    private Vec3[][] getMeshPoints(double xsize, double ysize) {
        Vec3[][] v = new Vec3[this.usize][this.vsize];
        if (this.shape == 0) {
            double xmin = -xsize * 0.5;
            double ymin = -ysize * 0.5;
            double uscale = 1.0 / (double)(this.usize - 1);
            double vscale = 1.0 / (double)(this.vsize - 1);
            int i = 0;
            while (i < this.usize) {
                int j = 0;
                while (j < this.vsize) {
                    v[i][j] = new Vec3(xsize * (double)i * uscale + xmin, ysize * (double)j * vscale + ymin, 0.0);
                    ++j;
                }
                ++i;
            }
        } else if (this.shape == 1) {
            double rad = xsize * 0.5;
            double ymin = -ysize * 0.5;
            double uscale = Math.PI * 2 / (double)this.usize;
            double vscale = 1.0 / (double)(this.vsize - 1);
            int i = 0;
            while (i < this.usize) {
                int j = 0;
                while (j < this.vsize) {
                    v[i][j] = new Vec3(rad * Math.sin(uscale * (double)i), ysize * (double)j * vscale + ymin, rad * Math.cos(uscale * (double)i));
                    ++j;
                }
                ++i;
            }
        } else {
            double rad = Math.min(xsize, ysize) * 0.25 * this.thickness;
            double radx = xsize * 0.5 - rad;
            double rady = ysize * 0.5 - rad;
            double uscale = Math.PI * 2 / (double)this.usize;
            double vscale = Math.PI * 2 / (double)this.vsize;
            Vec3 vr = new Vec3();
            Vec3 vc = new Vec3();
            int i = 0;
            while (i < this.usize) {
                vc.set(radx * Math.cos(uscale * (double)i), rady * Math.sin(uscale * (double)i), 0.0);
                vr.set(rad * Math.cos(uscale * (double)i), rad * Math.sin(uscale * (double)i), 0.0);
                int j = 0;
                while (j < this.vsize) {
                    v[i][j] = new Vec3(vc.x + vr.x * Math.cos(vscale * (double)j), vc.y + vr.y * Math.cos(vscale * (double)j), rad * Math.sin(vscale * (double)j));
                    ++j;
                }
                ++i;
            }
        }
        return v;
    }

    public void iconDoubleClicked() {
        int minv;
        final ValueSlider thicknessSlider = new ValueSlider(0.0, 1.0, 100, this.thickness);
        final Choice shapeChoice = new Choice();
        Choice smoothingChoice = new Choice();
        thicknessSlider.setEnabled(this.shape == 2);
        ValueField usizeField = new ValueField((double)this.usize, 7);
        ValueField vsizeField = new ValueField((double)this.vsize, 7);
        smoothingChoice.add("Interpolating");
        smoothingChoice.add("Approximating");
        if (this.smoothing == 2) {
            smoothingChoice.select(0);
        } else {
            smoothingChoice.select(1);
        }
        shapeChoice.add("Flat");
        shapeChoice.add("Cylinder");
        shapeChoice.add("Torus");
        if (this.shape == 0) {
            shapeChoice.select(0);
        } else if (this.shape == 1) {
            shapeChoice.select(1);
        } else {
            shapeChoice.select(2);
        }
        shapeChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                thicknessSlider.setEnabled(shapeChoice.getSelectedIndex() == 2);
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, "Select the mesh size and shape:", new Component[]{usizeField, vsizeField, shapeChoice, smoothingChoice, thicknessSlider}, new String[]{"U Size", "V Size", "Shape", "Smoothing Method", "Thickness"});
        if (!dlg.clickedOk()) {
            return;
        }
        int minu = shapeChoice.getSelectedIndex() == 0 ? 2 : 3;
        int n = minv = shapeChoice.getSelectedIndex() == 2 ? 3 : 2;
        if (usizeField.getValue() < (double)minu) {
            new MessageDialog(this.theFrame, "U Size must be at least " + minu + ".");
            return;
        }
        if (vsizeField.getValue() < (double)minv) {
            new MessageDialog(this.theFrame, "V Size must be at least " + minv + ".");
            return;
        }
        this.usize = (int)usizeField.getValue();
        this.vsize = (int)vsizeField.getValue();
        int i = smoothingChoice.getSelectedIndex();
        this.smoothing = i == 0 ? 2 : 3;
        i = shapeChoice.getSelectedIndex();
        this.shape = i == 0 ? 0 : (i == 1 ? 1 : 2);
        this.thickness = thicknessSlider.getValue();
        this.setHelpText();
    }

    static {
        counter = 1;
    }
}

