/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.EditingWindow;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TriangleMesh;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.VectorKeyframe;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Cube
extends Object3D {
    double halfx;
    double halfy;
    double halfz;
    BoundingBox bounds;
    RenderingMesh cachedMesh;
    WireframeMesh cachedWire;

    public Cube(double xsize, double ysize, double zsize) {
        this.halfx = xsize / 2.0;
        this.halfy = ysize / 2.0;
        this.halfz = zsize / 2.0;
        this.bounds = new BoundingBox(-this.halfx, this.halfx, -this.halfy, this.halfy, -this.halfz, this.halfz);
    }

    public Object3D duplicate() {
        Cube obj = new Cube(this.halfx * 2.0, this.halfy * 2.0, this.halfz * 2.0);
        obj.setTexture(this.theTexture);
        if (this.texMapping != null) {
            obj.setTextureMapping(this.texMapping.duplicate());
        }
        obj.setMaterial(this.theMaterial);
        if (this.matMapping != null) {
            obj.setMaterialMapping(this.matMapping.duplicate());
        }
        return obj;
    }

    public void copyObject(Object3D obj) {
        Cube c = (Cube)obj;
        Vec3 size = c.getBounds().getSize();
        this.setSize(size.x, size.y, size.z);
        this.setTexture(c.getTexture());
        if (c.getTextureMapping() != null) {
            this.setTextureMapping(c.getTextureMapping().duplicate());
        }
        this.setMaterial(c.getMaterial());
        if (c.getMaterialMapping() != null) {
            this.setMaterialMapping(c.getMaterialMapping().duplicate());
        }
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        this.halfx = xsize / 2.0;
        this.halfy = ysize / 2.0;
        this.halfz = zsize / 2.0;
        this.bounds = new BoundingBox(-this.halfx, this.halfx, -this.halfy, this.halfy, -this.halfz, this.halfz);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public int canConvertToTriangleMesh() {
        return 1;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        Vec3[] v = new Vec3[14];
        int[][] faces = new int[][]{{1, 0, 12}, {2, 1, 12}, {3, 2, 12}, {0, 3, 12}, {1, 2, 9}, {2, 6, 9}, {6, 5, 9}, {5, 1, 9}, {0, 1, 8}, {1, 5, 8}, {5, 4, 8}, {4, 0, 8}, {3, 0, 11}, {0, 4, 11}, {4, 7, 11}, {7, 3, 11}, {4, 5, 13}, {5, 6, 13}, {6, 7, 13}, {7, 4, 13}, {2, 3, 10}, {3, 7, 10}, {7, 6, 10}, {6, 2, 10}};
        int i = 0;
        while (i < 14) {
            v[i] = new Vec3();
            ++i;
        }
        v[7].x = v[11].x = -this.halfx;
        v[4].x = v[11].x;
        v[3].x = v[11].x;
        v[0].x = v[11].x;
        v[6].x = v[9].x = this.halfx;
        v[5].x = v[9].x;
        v[2].x = v[9].x;
        v[1].x = v[9].x;
        v[3].y = v[12].y = -this.halfy;
        v[2].y = v[12].y;
        v[1].y = v[12].y;
        v[0].y = v[12].y;
        v[7].y = v[13].y = this.halfy;
        v[6].y = v[13].y;
        v[5].y = v[13].y;
        v[4].y = v[13].y;
        v[7].z = v[10].z = -this.halfz;
        v[6].z = v[10].z;
        v[3].z = v[10].z;
        v[2].z = v[10].z;
        v[5].z = v[8].z = this.halfz;
        v[4].z = v[8].z;
        v[1].z = v[8].z;
        v[0].z = v[8].z;
        TriangleMesh mesh = new TriangleMesh(v, (int[][])faces);
        mesh.setSmoothingMethod(0);
        mesh.setTexture(this.getTexture());
        mesh.setTextureMapping(this.getTextureMapping().duplicate());
        mesh.setMaterial(this.getMaterial());
        if (this.getMaterial() != null) {
            mesh.setMaterialMapping(this.getMaterialMapping().duplicate());
        }
        return mesh;
    }

    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        Vec3[] vert = this.bounds.getCorners();
        int[] from = new int[]{0, 2, 3, 1, 4, 6, 7, 5, 0, 1, 2, 3};
        int[] to = new int[]{2, 3, 1, 0, 6, 7, 5, 4, 4, 5, 6, 7};
        this.cachedWire = new WireframeMesh(vert, from, to);
        return this.cachedWire;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        Vec3[] vert = this.bounds.getCorners();
        Vec3[] norm = new Vec3[6];
        RenderingTriangle[] tri = new RenderingTriangle[12];
        norm[0] = new Vec3(1.0, 0.0, 0.0);
        norm[1] = new Vec3(-1.0, 0.0, 0.0);
        norm[2] = new Vec3(0.0, 1.0, 0.0);
        norm[3] = new Vec3(0.0, -1.0, 0.0);
        norm[4] = new Vec3(0.0, 0.0, 1.0);
        norm[5] = new Vec3(0.0, 0.0, -1.0);
        tri[0] = this.texMapping.mapTriangle(0, 4, 5, 3, 3, 3, vert);
        tri[1] = this.texMapping.mapTriangle(0, 5, 1, 3, 3, 3, vert);
        tri[2] = this.texMapping.mapTriangle(0, 1, 3, 1, 1, 1, vert);
        tri[3] = this.texMapping.mapTriangle(0, 3, 2, 1, 1, 1, vert);
        tri[4] = this.texMapping.mapTriangle(1, 5, 3, 4, 4, 4, vert);
        tri[5] = this.texMapping.mapTriangle(5, 7, 3, 4, 4, 4, vert);
        tri[6] = this.texMapping.mapTriangle(0, 2, 4, 5, 5, 5, vert);
        tri[7] = this.texMapping.mapTriangle(2, 6, 4, 5, 5, 5, vert);
        tri[8] = this.texMapping.mapTriangle(2, 3, 7, 2, 2, 2, vert);
        tri[9] = this.texMapping.mapTriangle(2, 7, 6, 2, 2, 2, vert);
        tri[10] = this.texMapping.mapTriangle(5, 4, 7, 0, 0, 0, vert);
        tri[11] = this.texMapping.mapTriangle(4, 6, 7, 0, 0, 0, vert);
        RenderingMesh mesh = new RenderingMesh(vert, norm, tri);
        mesh.setParameters(info.texParamValue);
        if (interactive) {
            this.cachedMesh = mesh;
        }
        return mesh;
    }

    public void setTexture(Texture tex) {
        super.setTexture(tex);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public void setTextureMapping(TextureMapping mapping) {
        super.setTextureMapping(mapping);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        ValueField xField = new ValueField(2.0 * this.halfx, 3, 5);
        ValueField yField = new ValueField(2.0 * this.halfy, 3, 5);
        ValueField zField = new ValueField(2.0 * this.halfz, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog((Frame)((Object)parent), "Select cube size:", new Component[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setSize(xField.getValue(), yField.getValue(), zField.getValue());
        cb.execute();
    }

    public Cube(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.halfx = in.readDouble();
        this.halfy = in.readDouble();
        this.halfz = in.readDouble();
        this.bounds = new BoundingBox(-this.halfx, this.halfx, -this.halfy, this.halfy, -this.halfz, this.halfz);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.halfx);
        out.writeDouble(this.halfy);
        out.writeDouble(this.halfz);
    }

    public Keyframe getPoseKeyframe() {
        return new VectorKeyframe(2.0 * this.halfx, 2.0 * this.halfy, 2.0 * this.halfz);
    }

    public void applyPoseKeyframe(Keyframe k) {
        VectorKeyframe key = (VectorKeyframe)k;
        this.setSize(key.x, key.y, key.z);
    }

    public String[] getPoseValueNames() {
        return new String[]{"X Size", "Y Size", "Z Size"};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        VectorKeyframe key = (VectorKeyframe)k;
        ValueField xField = new ValueField(key.x, 3, 5);
        ValueField yField = new ValueField(key.y, 3, 5);
        ValueField zField = new ValueField(key.z, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog((Frame)((Object)parent), "Select cube size:", new Component[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        key.set(xField.getValue(), yField.getValue(), zField.getValue());
    }
}

