/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.ColorChooser;
import artofillusion.EditingWindow;
import artofillusion.Light;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class DirectionalLight
extends Light {
    static BoundingBox bounds;
    static WireframeMesh mesh;
    static final int SEGMENTS = 8;

    public DirectionalLight(RGBColor theColor, float theIntensity) {
        this.setParameters(theColor, theIntensity, false, 0.5f);
    }

    public Object3D duplicate() {
        return new DirectionalLight(this.color, this.intensity);
    }

    public void copyObject(Object3D obj) {
        DirectionalLight lt = (DirectionalLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.ambient, lt.decayRate);
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public void getLight(RGBColor light, float distance) {
        light.copy(this.color);
        light.scale(this.intensity);
    }

    public boolean canSetMaterial() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean editable() {
        return true;
    }

    public DirectionalLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), false, 0.0f);
        bounds = new BoundingBox(-0.15, 0.15, -0.15, 0.15, -0.15, 0.25);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        Panel patch = this.color.getSample(50, 30);
        ValueField intensityField = new ValueField((double)this.intensity, 0);
        RGBColor oldColor = this.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", DirectionalLight.this.color);
                ((Component)e.getSource()).setBackground(DirectionalLight.this.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, "Parameters for directional light:", new Component[]{patch, intensityField}, new String[]{"Color", "Intensity"});
        if (!dlg.clickedOk()) {
            this.color.copy(oldColor);
            return;
        }
        this.setParameters(this.color, (float)intensityField.getValue(), this.ambient, this.decayRate);
        cb.execute();
    }

    public Keyframe getPoseKeyframe() {
        return new DirectionalLightKeyframe(this.color, this.intensity, this.decayRate);
    }

    public void applyPoseKeyframe(Keyframe k) {
        DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.ambient, key.decayRate);
    }

    public String[] getPoseValueNames() {
        return new String[]{"Intensity", "Decay Rate"};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{this.intensity, this.decayRate};
    }

    public double[][] getPoseValueRange() {
        return new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
        Panel patch = key.color.getSample(50, 30);
        ValueField intensityField = new ValueField(key.intensity, 0);
        ValueField decayField = new ValueField(key.decayRate, 1);
        RGBColor oldColor = key.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", key.color);
                ((Component)e.getSource()).setBackground(key.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, "Parameters for directional light:", new Component[]{patch, intensityField, decayField}, new String[]{"Color", "Intensity", "Decay Rate"});
        if (!dlg.clickedOk()) {
            key.color.copy(oldColor);
            return;
        }
        key.intensity = (float)intensityField.getValue();
        key.decayRate = (float)decayField.getValue();
    }

    static {
        double[] sine = new double[8];
        double[] cosine = new double[8];
        bounds = new BoundingBox(-0.15, 0.15, -0.15, 0.15, -0.15, 0.25);
        int i = 0;
        while (i < 8) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
            ++i;
        }
        Vec3[] vert = new Vec3[32];
        int[] from = new int[32];
        int[] to = new int[32];
        i = 0;
        while (i < 8) {
            vert[i] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], -0.15);
            vert[i + 8] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.0);
            vert[i + 16] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.05);
            vert[i + 24] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.25);
            from[i] = i;
            to[i] = (i + 1) % 8;
            from[i + 8] = i;
            to[i + 8] = i + 8;
            from[i + 16] = i + 8;
            to[i + 16] = (i + 1) % 8 + 8;
            from[i + 24] = i + 16;
            to[i + 24] = i + 24;
            ++i;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class DirectionalLightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public float decayRate;

        public DirectionalLightKeyframe(RGBColor color, float intensity, float decayRate) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.decayRate = decayRate;
        }

        public Keyframe duplicate() {
            return new DirectionalLightKeyframe(this.color, this.intensity, this.decayRate);
        }

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public double[] getGraphValues() {
            return new double[]{this.intensity, this.decayRate};
        }

        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.decayRate = (float)values[1];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate));
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            DirectionalLightKeyframe k3 = (DirectionalLightKeyframe)o3;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate));
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            DirectionalLightKeyframe k3 = (DirectionalLightKeyframe)o3;
            DirectionalLightKeyframe k4 = (DirectionalLightKeyframe)o4;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed() + weight4 * (double)k4.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen() + weight4 * (double)k4.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue() + weight4 * (double)k4.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity + weight4 * (double)k4.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate + weight4 * (double)k4.decayRate));
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof DirectionalLightKeyframe)) {
                return false;
            }
            DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.decayRate == this.decayRate;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
        }

        public DirectionalLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat());
        }
    }
}

