/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.EditingWindow;
import artofillusion.ViewerCanvas;
import artofillusion.ui.MessageDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;

public abstract class EditingTool {
    protected EditingWindow theWindow;
    protected Frame theFrame;
    public static final int ALL_CLICKS = 0;
    public static final int OBJECT_CLICKS = 1;
    public static final int HANDLE_CLICKS = 2;

    public EditingTool(EditingWindow win) {
        this.theWindow = win;
        if (win != null) {
            this.theFrame = win.getFrame();
        }
    }

    public EditingWindow getWindow() {
        return this.theWindow;
    }

    protected Image loadImage(String name) {
        ImageProducer ip;
        if (this.theFrame == null) {
            return null;
        }
        try {
            ip = (ImageProducer)this.getClass().getResource("/artofillusion/Icons/" + name).getContent();
        }
        catch (Exception e) {
            new MessageDialog(this.theFrame, new String[]{"Error loading icon:", name});
            return null;
        }
        Image im = this.theFrame.createImage(ip);
        MediaTracker mt = new MediaTracker(this.theFrame);
        mt.addImage(im, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            new MessageDialog(this.theFrame, new String[]{"Error loading icon:", name});
            return null;
        }
        return im;
    }

    protected Image createSelectedImage() {
        FilteredImageSource ip = new FilteredImageSource(this.getIcon().getSource(), new HighlightFilter());
        Image im = this.theFrame.createImage(ip);
        MediaTracker mt = new MediaTracker(this.theFrame);
        mt.addImage(im, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            return null;
        }
        return im;
    }

    public abstract Image getIcon();

    public abstract Image getSelectedIcon();

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
    }

    public void mousePressedOnObject(MouseEvent e, ViewerCanvas view, int obj) {
    }

    public void mousePressedOnHandle(MouseEvent e, ViewerCanvas view, int obj, int handle) {
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
    }

    public void mouseMoved(MouseEvent e, ViewerCanvas view) {
    }

    public void keyPressed(KeyEvent e, ViewerCanvas view) {
    }

    public void activate() {
        this.theWindow.setTool(this);
    }

    public void deactivate() {
    }

    public void iconDoubleClicked() {
    }

    class HighlightFilter
    extends RGBImageFilter {
        public HighlightFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = (r + g + b) / 3;
            g = b = g / 3;
            return (rgb & 0xFF000000) + (r << 16) + (g << 8) + b;
        }
    }
}

