/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageAverager {
    int width;
    int height;
    int num;
    short[] red;
    short[] green;
    short[] blue;
    short[] alpha;

    public ImageAverager(int width, int height) {
        int size = width * height;
        this.width = width;
        this.height = height;
        this.red = new short[size];
        this.green = new short[size];
        this.blue = new short[size];
        this.alpha = new short[size];
    }

    public void addImage(Image im) {
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return;
        }
        if (data.length != this.red.length) {
            return;
        }
        int i = 0;
        while (i < data.length) {
            int n = i;
            this.alpha[n] = (short)(this.alpha[n] + (data[i] >> 24 & 0xFF));
            int n2 = i;
            this.red[n2] = (short)(this.red[n2] + (data[i] >> 16 & 0xFF));
            int n3 = i;
            this.green[n3] = (short)(this.green[n3] + (data[i] >> 8 & 0xFF));
            int n4 = i;
            this.blue[n4] = (short)(this.blue[n4] + (data[i] & 0xFF));
            ++i;
        }
        ++this.num;
    }

    public Image getAverageImage() {
        int[] data = new int[this.red.length];
        int i = 0;
        while (i < data.length) {
            int a = this.alpha[i] / this.num;
            int r = this.red[i] / this.num;
            int g = this.green[i] / this.num;
            int b = this.blue[i] / this.num;
            data[i] = (a << 24) + (r << 16) + (g << 8) + b;
            ++i;
        }
        MemoryImageSource source = new MemoryImageSource(this.width, this.height, data, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    public void clear() {
        this.num = 0;
        int i = 0;
        while (i < this.red.length) {
            this.blue[i] = 0;
            this.green[i] = 0;
            this.red[i] = 0;
            this.alpha[i] = 0;
            ++i;
        }
    }
}

