/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ImageMap;
import artofillusion.ImageOrColor;
import artofillusion.ImageOrValue;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.Texture2D;
import artofillusion.TextureSpec;
import artofillusion.Vec2;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ImageMapTexture
extends Texture2D {
    ImageOrColor diffuseColor;
    ImageOrColor specularColor;
    ImageOrColor transparentColor;
    ImageOrColor emissiveColor;
    ImageOrValue roughness;
    ImageOrValue cloudiness;
    ImageOrValue transparency;
    ImageOrValue specularity;
    ImageOrValue bump;
    ImageOrValue displacement;
    boolean tileX;
    boolean tileY;
    boolean mirrorX;
    boolean mirrorY;
    Vec2 tempGrad;

    public ImageMapTexture() {
        RGBColor white = new RGBColor(1.0f, 1.0f, 1.0f);
        this.diffuseColor = new ImageOrColor(white);
        this.specularColor = new ImageOrColor(white);
        this.transparentColor = new ImageOrColor(white);
        this.emissiveColor = new ImageOrColor(new RGBColor(0.0f, 0.0f, 0.0f));
        this.transparency = new ImageOrValue(0.0f);
        this.specularity = new ImageOrValue(0.0f);
        this.roughness = new ImageOrValue(0.2f);
        this.cloudiness = new ImageOrValue(0.0f);
        this.bump = new ImageOrValue(0.0f);
        this.displacement = new ImageOrValue(0.0f);
        this.tileY = true;
        this.tileX = true;
        this.name = "";
        this.tempGrad = new Vec2();
    }

    public static String getTypeName() {
        return "Image Mapped";
    }

    public boolean bumpMapped() {
        return this.bump.getImage() != null && this.bump.getValue() != 0.0f;
    }

    public boolean displacementMapped() {
        return this.displacement.getImage() != null && this.displacement.getValue() != 0.0f;
    }

    public void getTextureSpec(TextureSpec spec, double x, double y, double xsize, double ysize, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 1.0;
            spec.roughness = 1.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        x = this.mirrorX ? ((int)(f = Math.floor(x)) % 2 == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? ((int)(f = Math.floor(y)) % 2 == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        float transVal = this.transparency.getValue(wrapx, wrapy, x, y, xsize, ysize);
        float specVal = this.specularity.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.diffuseColor.getColor(spec.diffuse, wrapx, wrapy, x, y, xsize, ysize);
        spec.diffuse.scale((1.0f - transVal) * (1.0f - specVal));
        this.specularColor.getColor(spec.specular, wrapx, wrapy, x, y, xsize, ysize);
        spec.specular.scale((1.0f - transVal) * specVal);
        this.transparentColor.getColor(spec.transparent, wrapx, wrapy, x, y, xsize, ysize);
        spec.transparent.scale(transVal);
        this.emissiveColor.getColor(spec.emissive, wrapx, wrapy, x, y, xsize, ysize);
        spec.roughness = this.roughness.getValue(wrapx, wrapy, x, y, xsize, ysize);
        spec.cloudiness = this.cloudiness.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.bump.getGradient(this.tempGrad, wrapx, wrapy, x, y, xsize, ysize);
        spec.bumpGrad.set(this.tempGrad.x * 0.04, this.tempGrad.y * 0.04, 0.0);
    }

    public void getTransparency(RGBColor trans, double x, double y, double xsize, double ysize, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        x = this.mirrorX ? ((int)(f = Math.floor(x)) % 2 == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? ((int)(f = Math.floor(y)) % 2 == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        float transVal = this.transparency.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.transparentColor.getColor(trans, wrapx, wrapy, x, y, xsize, ysize);
        trans.scale(transVal);
    }

    public double getDisplacement(double x, double y, double xsize, double ysize, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            return 0.0;
        }
        x = this.mirrorX ? ((int)(f = Math.floor(x)) % 2 == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? ((int)(f = Math.floor(y)) % 2 == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        return this.displacement.getValue(wrapx, wrapy, x, y, xsize, ysize);
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        float transVal = this.transparency.getAverageValue();
        float specVal = this.specularity.getAverageValue();
        this.diffuseColor.getAverageColor(spec.diffuse);
        spec.diffuse.scale((1.0f - transVal) * (1.0f - specVal));
        this.specularColor.getAverageColor(spec.specular);
        spec.specular.scale((1.0f - transVal) * specVal);
        this.transparentColor.getAverageColor(spec.transparent);
        spec.transparent.scale(transVal);
        this.emissiveColor.getAverageColor(spec.emissive);
        spec.roughness = this.roughness.getAverageValue();
        spec.cloudiness = this.cloudiness.getAverageValue();
        spec.bumpGrad.set(0.0, 0.0, 0.0);
    }

    public boolean usesImage(ImageMap image) {
        return this.diffuseColor.getImage() == image || this.specularColor.getImage() == image || this.transparentColor.getImage() == image || this.emissiveColor.getImage() == image || this.roughness.getImage() == image || this.cloudiness.getImage() == image || this.transparency.getImage() == image || this.specularity.getImage() == image || this.bump.getImage() == image || this.displacement.getImage() == image;
    }

    public Texture duplicate() {
        ImageMapTexture m = new ImageMapTexture();
        m.name = this.name;
        m.diffuseColor.copy(this.diffuseColor);
        m.specularColor.copy(this.specularColor);
        m.transparentColor.copy(this.transparentColor);
        m.emissiveColor.copy(this.emissiveColor);
        m.transparency = this.transparency.duplicate();
        m.specularity = this.specularity.duplicate();
        m.roughness = this.roughness.duplicate();
        m.cloudiness = this.cloudiness.duplicate();
        m.bump = this.bump.duplicate();
        m.displacement = this.displacement.duplicate();
        m.tileX = this.tileX;
        m.tileY = this.tileY;
        m.mirrorX = this.mirrorX;
        m.mirrorY = this.mirrorY;
        return m;
    }

    public void edit(Frame fr, Scene sc) {
        new Editor(fr, sc);
    }

    public ImageMapTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.diffuseColor = new ImageOrColor(in, theScene);
        this.specularColor = new ImageOrColor(in, theScene);
        this.transparentColor = new ImageOrColor(in, theScene);
        this.emissiveColor = new ImageOrColor(in, theScene);
        this.roughness = new ImageOrValue(in, theScene);
        this.cloudiness = new ImageOrValue(in, theScene);
        this.transparency = new ImageOrValue(in, theScene);
        this.specularity = new ImageOrValue(in, theScene);
        this.bump = new ImageOrValue(in, theScene);
        this.displacement = new ImageOrValue(in, theScene);
        this.tileX = in.readBoolean();
        this.tileY = in.readBoolean();
        this.mirrorX = in.readBoolean();
        this.mirrorY = in.readBoolean();
        this.tempGrad = new Vec2();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        this.diffuseColor.writeToFile(out, theScene);
        this.specularColor.writeToFile(out, theScene);
        this.transparentColor.writeToFile(out, theScene);
        this.emissiveColor.writeToFile(out, theScene);
        this.roughness.writeToFile(out, theScene);
        this.cloudiness.writeToFile(out, theScene);
        this.transparency.writeToFile(out, theScene);
        this.specularity.writeToFile(out, theScene);
        this.bump.writeToFile(out, theScene);
        this.displacement.writeToFile(out, theScene);
        out.writeBoolean(this.tileX);
        out.writeBoolean(this.tileY);
        out.writeBoolean(this.mirrorX);
        out.writeBoolean(this.mirrorY);
    }

    class Editor
    extends Dialog
    implements ActionListener,
    AdjustmentListener,
    ItemListener {
        TextField nameField;
        Panel transPanel;
        Panel specPanel;
        Panel shinPanel;
        Panel clearPanel;
        Panel bumpPanel;
        Panel displacePanel;
        Panel diffColorPanel;
        Panel specColorPanel;
        Panel transColorPanel;
        Panel emissColorPanel;
        Checkbox tileXBox;
        Checkbox tileYBox;
        Checkbox mirrorXBox;
        Checkbox mirrorYBox;
        MaterialPreviewer preview;
        ImageMapTexture newTexture;
        Frame parent;

        public Editor(Frame fr, Scene sc) {
            super(fr, true);
            GridBagConstraints gc = new GridBagConstraints();
            this.parent = fr;
            this.newTexture = (ImageMapTexture)ImageMapTexture.this.duplicate();
            Panel p = new Panel();
            Button b = new Button("Ok");
            p.add(b);
            b.setActionCommand("ok");
            b.addActionListener(this);
            b = new Button("Cancel");
            p.add(b);
            b.setActionCommand("cancel");
            b.addActionListener(this);
            this.add((Component)p, "South");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridwidth = 2;
            this.preview = new MaterialPreviewer(this.newTexture, null, 200, 160);
            p.add((Component)this.preview, gc);
            gc.gridx = 0;
            gc.anchor = 13;
            gc.insets = new Insets(0, 0, 0, 5);
            gc.gridwidth = 1;
            p.add((Component)new Label("Name"), gc);
            p.add((Component)new Label("Diffuse Color"), gc);
            p.add((Component)new Label("Specular Color"), gc);
            p.add((Component)new Label("Transparent Color"), gc);
            p.add((Component)new Label("Emissive Color"), gc);
            gc.gridx = 1;
            gc.fill = 2;
            this.nameField = new TextField(ImageMapTexture.this.name, 15);
            p.add((Component)this.nameField, gc);
            gc.fill = 0;
            gc.anchor = 17;
            this.diffColorPanel = this.newTexture.diffuseColor.getEditingPanel(this.parent, sc, this);
            p.add((Component)this.diffColorPanel, gc);
            this.specColorPanel = this.newTexture.specularColor.getEditingPanel(this.parent, sc, this);
            p.add((Component)this.specColorPanel, gc);
            this.transColorPanel = this.newTexture.transparentColor.getEditingPanel(this.parent, sc, this);
            p.add((Component)this.transColorPanel, gc);
            this.emissColorPanel = this.newTexture.emissiveColor.getEditingPanel(this.parent, sc, this);
            p.add((Component)this.emissColorPanel, gc);
            this.add((Component)p, "West");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridwidth = 2;
            gc.gridx = 0;
            gc.anchor = 10;
            this.tileXBox = new Checkbox("Tile Horizontally", ImageMapTexture.this.tileX);
            p.add((Component)this.tileXBox, gc);
            this.tileYBox = new Checkbox("Tile Vertically", ImageMapTexture.this.tileY);
            p.add((Component)this.tileYBox, gc);
            this.mirrorXBox = new Checkbox("Mirror Horizontally", ImageMapTexture.this.mirrorX);
            p.add((Component)this.mirrorXBox, gc);
            this.mirrorYBox = new Checkbox("Mirror Vertically", ImageMapTexture.this.mirrorY);
            p.add((Component)this.mirrorYBox, gc);
            gc.gridwidth = 1;
            gc.anchor = 13;
            p.add((Component)new Label("Transparency"), gc);
            p.add((Component)new Label("Specularity"), gc);
            p.add((Component)new Label("Roughness"), gc);
            p.add((Component)new Label("Cloudiness"), gc);
            p.add((Component)new Label("Bump Height"), gc);
            p.add((Component)new Label("Displacement"), gc);
            gc.gridx = 1;
            gc.anchor = 17;
            this.transPanel = this.newTexture.transparency.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.transPanel, gc);
            this.specPanel = this.newTexture.specularity.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.specPanel, gc);
            this.shinPanel = this.newTexture.roughness.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.shinPanel, gc);
            this.clearPanel = this.newTexture.cloudiness.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.clearPanel, gc);
            this.bumpPanel = this.newTexture.bump.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.bumpPanel, gc);
            this.displacePanel = this.newTexture.displacement.getEditingPanel(this.parent, sc, this, this);
            p.add((Component)this.displacePanel, gc);
            this.add((Component)p, "East");
            this.nameField.addActionListener(this);
            this.tileXBox.addItemListener(this);
            this.tileYBox.addItemListener(this);
            this.mirrorXBox.addItemListener(this);
            this.mirrorYBox.addItemListener(this);
            this.pack();
            this.setResizable(false);
            ModellingApp.centerWindow(this);
            this.show();
        }

        public void actionPerformed(ActionEvent e) {
            if (!e.getActionCommand().equals("cancel")) {
                ImageMapTexture.this.transparency.copy(this.newTexture.transparency);
                ImageMapTexture.this.specularity.copy(this.newTexture.specularity);
                ImageMapTexture.this.roughness.copy(this.newTexture.roughness);
                ImageMapTexture.this.cloudiness.copy(this.newTexture.cloudiness);
                ImageMapTexture.this.bump.copy(this.newTexture.bump);
                ImageMapTexture.this.displacement.copy(this.newTexture.displacement);
                ImageMapTexture.this.name = this.nameField.getText();
                ImageMapTexture.this.diffuseColor.copy(this.newTexture.diffuseColor);
                ImageMapTexture.this.specularColor.copy(this.newTexture.specularColor);
                ImageMapTexture.this.transparentColor.copy(this.newTexture.transparentColor);
                ImageMapTexture.this.emissiveColor.copy(this.newTexture.emissiveColor);
                ImageMapTexture.this.tileX = this.newTexture.tileX;
                ImageMapTexture.this.tileY = this.newTexture.tileY;
                ImageMapTexture.this.mirrorX = this.newTexture.mirrorX;
                ImageMapTexture.this.mirrorY = this.newTexture.mirrorY;
            }
            this.dispose();
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.preview.render();
        }

        public void itemStateChanged(ItemEvent e) {
            this.newTexture.tileX = this.tileXBox.getState();
            this.newTexture.tileY = this.tileYBox.getState();
            this.newTexture.mirrorX = this.mirrorXBox.getState();
            this.newTexture.mirrorY = this.mirrorYBox.getState();
            this.preview.render();
        }
    }
}

