/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ColorChooser;
import artofillusion.ImageMap;
import artofillusion.ImagesDialog;
import artofillusion.RGBColor;
import artofillusion.Scene;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ImageOrColor {
    ImageMap map;
    RGBColor color;

    public ImageOrColor(RGBColor theColor) {
        this.color = theColor.duplicate();
    }

    public ImageMap getImage() {
        return this.map;
    }

    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            theColor.copy(this.color);
        } else {
            this.map.getColor(theColor, wrapx, wrapy, x, y, xsize, ysize);
            theColor.multiply(this.color);
        }
    }

    public void getAverageColor(RGBColor theColor) {
        if (this.map == null) {
            theColor.copy(this.color);
        } else {
            theColor.setRGB(this.map.getAverageComponent(0), this.map.getAverageComponent(1), this.map.getAverageComponent(2));
            theColor.multiply(this.color);
        }
    }

    public ImageOrColor duplicate() {
        ImageOrColor copy = new ImageOrColor(this.color);
        copy.map = this.map;
        return copy;
    }

    public void copy(ImageOrColor obj) {
        this.map = obj.map;
        this.color.copy(obj.color);
    }

    public ImageOrColor(DataInputStream in, Scene theScene) throws IOException {
        Vector images = theScene.getImages();
        int index = in.readInt();
        if (index > -1) {
            this.map = (ImageMap)images.elementAt(index);
        }
        this.color = new RGBColor(in);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        Vector images = theScene.getImages();
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(images.lastIndexOf(this.map));
        }
        this.color.writeToFile(out);
    }

    public Panel getEditingPanel(Frame parent, Scene theScene, AdjustmentListener adjust) {
        return new EditingPanel(parent, theScene, adjust);
    }

    class EditingPanel
    extends Panel
    implements MouseListener {
        Frame fr;
        Scene sc;
        Canvas preview;
        Panel colorPatch;
        AdjustmentListener adjust;

        public EditingPanel(Frame parent, Scene theScene, AdjustmentListener adjust) {
            this.fr = parent;
            this.sc = theScene;
            this.adjust = adjust;
            this.preview = new Canvas(this){
                private final /* synthetic */ EditingPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(50, 50);
                }

                public void paint(Graphics g) {
                    if (EditingPanel.access$000((EditingPanel)this.this$1).map != null) {
                        g.drawImage(EditingPanel.access$000((EditingPanel)this.this$1).map.getPreview(), 0, 0, null);
                    } else {
                        g.drawRect(1, 1, 48, 48);
                    }
                }
            };
            this.preview.addMouseListener(this);
            this.colorPatch = ImageOrColor.this.color.getSample(50, 50);
            this.colorPatch.addMouseListener(this);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            this.add((Component)this.preview, gc);
            this.add((Component)this.colorPatch, gc);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == this.preview) {
                ImagesDialog dlg = new ImagesDialog(this.fr, this.sc, ImageOrColor.this.map);
                ImageOrColor.this.map = dlg.getSelection();
                this.preview.repaint();
            } else if (e.getSource() == this.colorPatch) {
                new ColorChooser(this.fr, "Color", ImageOrColor.this.color);
                this.colorPatch.setBackground(ImageOrColor.this.color.getColor());
                this.colorPatch.repaint();
            }
            if (this.adjust != null) {
                this.adjust.adjustmentValueChanged(null);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        static /* synthetic */ ImageOrColor access$000(EditingPanel x0) {
            return x0.ImageOrColor.this;
        }
    }
}

