/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.TIFFEncoder;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueSlider;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;

public class ImageSaver {
    private int format;
    private int index;
    private String name;
    private String directory;
    private boolean ok;
    private boolean premultiply;
    private double quality;
    private Frame parent;
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_TIFF = 1;
    private static boolean premultiplyDefault = true;
    private static double qualityDefault = 50.0;

    public ImageSaver(Frame parent, boolean animate) {
        this.parent = parent;
        this.index = animate ? 1 : -1;
        CheckboxGroup formatGroup = new CheckboxGroup();
        final Checkbox jpegBox = new Checkbox("JPEG", true, formatGroup);
        Checkbox tiffBox = new Checkbox("TIFF", false, formatGroup);
        Checkbox premultBox = new Checkbox("Premultiply Transparency", premultiplyDefault);
        ValueSlider qualitySlider = new ValueSlider(0.0, 100.0, 100, qualityDefault);
        final CardLayout card = new CardLayout();
        Panel mainPanel = new Panel();
        final Panel options = new Panel();
        Panel p = new Panel();
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (jpegBox.getState()) {
                    card.show(options, "jpeg");
                } else {
                    card.show(options, "tiff");
                }
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        mainPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        mainPanel.add((Component)jpegBox, gc);
        mainPanel.add((Component)tiffBox, gc);
        mainPanel.add((Component)options, gc);
        options.setLayout(card);
        p.setLayout(new GridBagLayout());
        p.add((Component)new Label("Quality"), gc);
        gc.gridx = 1;
        gc.insets = new Insets(0, 5, 0, 0);
        p.add((Component)qualitySlider, gc);
        options.add((Component)p, "jpeg");
        options.add((Component)premultBox, "tiff");
        premultBox.setEnabled(true);
        jpegBox.addItemListener(il);
        tiffBox.addItemListener(il);
        il.itemStateChanged(null);
        PanelDialog dlg = new PanelDialog(parent, "Select Format For Output File:", mainPanel);
        if (dlg.clickedOk()) {
            this.premultiply = premultiplyDefault = premultBox.getState();
            this.quality = qualityDefault = qualitySlider.getValue();
            this.format = jpegBox.getState() ? 0 : 1;
            FileDialog fd = new FileDialog(parent, "Save Image", 1);
            String sep = System.getProperty("file.separator");
            if (jpegBox.getState()) {
                fd.setFile("Untitled.jpg");
            } else {
                fd.setFile("Untitled.tif");
            }
            if (ModellingApp.currentDirectory != null) {
                fd.setDirectory(ModellingApp.currentDirectory);
            }
            fd.show();
            this.name = fd.getFile();
            this.directory = fd.getDirectory();
            this.ok = this.name != null;
        }
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public boolean saveImage(Image im) {
        if (this.format == 0 || this.premultiply) {
            im = ImageSaver.premultiplyTransparency(im);
        }
        String filename = this.name;
        if (this.index > -1) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setGroupingUsed(false);
            int i = this.name.lastIndexOf(46);
            filename = i == -1 || i == this.name.length() - 1 ? filename + nf.format(this.index++) : this.name.substring(0, i) + nf.format(this.index++) + this.name.substring(i);
        }
        try {
            return ImageSaver.saveImage(im, new File(this.directory, filename), this.format, (int)this.quality);
        }
        catch (Exception ex) {
            new MessageDialog(this.parent, new String[]{"An error occurred while saving the image.", ex.getMessage()});
            return false;
        }
    }

    public static boolean saveImage(Image im, File f, int format, int quality) throws IOException, InterruptedException {
        FileOutputStream fos = new FileOutputStream(f);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        if (format == 0) {
            JpegEncoder jpg = new JpegEncoder(im, quality, bos);
            jpg.Compress();
            bos.close();
            return true;
        }
        if (format == 1) {
            DataOutputStream dos = new DataOutputStream(bos);
            TIFFEncoder tiff = new TIFFEncoder(im);
            tiff.writeImage(dos);
            dos.close();
            return true;
        }
        return false;
    }

    private static Image premultiplyTransparency(Image im) {
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return im;
        }
        int i = 0;
        while (i < data.length && (data[i] & 0xFF000000) == -16777216) {
            ++i;
        }
        if (i == data.length) {
            return im;
        }
        i = 0;
        while (i < data.length) {
            int alpha = data[i] >> 24 & 0xFF;
            int red = data[i] >> 16 & 0xFF;
            int green = data[i] >> 8 & 0xFF;
            int blue = data[i] & 0xFF;
            red = red * (alpha + 1) >> 8;
            green = green * (alpha + 1) >> 8;
            blue = blue * (alpha + 1) >> 8;
            data[i] = (alpha << 24) + (red << 16) + (green << 8) + blue;
            ++i;
        }
        MemoryImageSource source = new MemoryImageSource(im.getWidth(null), im.getHeight(null), data, 0, im.getWidth(null));
        return Toolkit.getDefaultToolkit().createImage(source);
    }
}

