/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class JarClassLoader
extends ClassLoader {
    ZipFile zf;
    Hashtable cache = new Hashtable();

    public JarClassLoader(ZipFile zf) {
        this.zf = zf;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.cache.get(name);
        if (c == null) {
            byte[] data;
            try {
                return this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                ZipEntry ze = this.zf.getEntry(name.replace('.', '/') + ".class");
                if (ze == null) {
                    throw new ClassNotFoundException(name);
                }
                int size = (int)ze.getSize();
                data = new byte[size];
                try {
                    BufferedInputStream in = new BufferedInputStream(this.zf.getInputStream(ze));
                    int i = 0;
                    while (i < size) {
                        data[i] = (byte)((InputStream)in).read();
                        ++i;
                    }
                    ((InputStream)in).close();
                }
                catch (IOException e2) {
                    throw new ClassNotFoundException(name);
                }
            }
            c = this.defineClass(name, data, 0, data.length);
            this.cache.put(name, c);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

