/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ProjectionMapping;
import artofillusion.RGBColor;
import artofillusion.RenderingTriangle;
import artofillusion.Texture2D;
import artofillusion.TextureSpec;

public class Linear2DTriangle
extends RenderingTriangle {
    double x1;
    double x2;
    double x3;
    double y1;
    double y2;
    double y3;
    boolean bumpMapped;

    public Linear2DTriangle(int v1, int v2, int v3, int n1, int n2, int n3, double t1x, double t1y, double t2x, double t2y, double t3x, double t3y, ProjectionMapping mapping) {
        super(v1, v2, v3, n1, n2, n3, mapping);
        this.x1 = t1x;
        this.y1 = t1y;
        this.x2 = t2x;
        this.y2 = t2y;
        this.x3 = t3x;
        this.y3 = t3y;
        this.bumpMapped = mapping.getTexture().bumpMapped();
    }

    public void setParameters(double[] p1, double[] p2, double[] p3) {
        ProjectionMapping map = (ProjectionMapping)this.mapping;
        if (!map.coordsFromParams || p1[map.numTextureParams] == Double.MAX_VALUE) {
            return;
        }
        double x = p1[map.numTextureParams];
        double y = p1[map.numTextureParams + 1];
        double z = p1[map.numTextureParams + 2];
        this.x1 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y1 = x * map.ay + y * map.by + z * map.cy - map.dy;
        x = p2[map.numTextureParams];
        y = p2[map.numTextureParams + 1];
        z = p2[map.numTextureParams + 2];
        this.x2 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y2 = x * map.ay + y * map.by + z * map.cy - map.dy;
        x = p3[map.numTextureParams];
        y = p3[map.numTextureParams + 1];
        z = p3[map.numTextureParams + 2];
        this.x3 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y3 = x * map.ay + y * map.by + z * map.cy - map.dy;
    }

    public void getTextureSpec(TextureSpec spec, boolean front, double u, double v, double w, double size, double time) {
        ProjectionMapping map = (ProjectionMapping)this.mapping;
        if (!this.mapping.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        ((Texture2D)map.getTexture()).getTextureSpec(spec, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, size * map.matScaleX, size * map.matScaleY, time, this.getParameters(u, v, w));
        if (this.bumpMapped) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s * map.sgrad.x - t * map.tgrad.x, s * map.sgrad.y - t * map.tgrad.y, s * map.sgrad.z - t * map.tgrad.z);
        }
    }

    public void getTransparency(RGBColor trans, boolean front, double u, double v, double w, double size, double time) {
        if (!this.mapping.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        ProjectionMapping map = (ProjectionMapping)this.mapping;
        ((Texture2D)map.getTexture()).getTransparency(trans, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, size * map.matScaleX, size * map.matScaleY, time, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        ProjectionMapping map = (ProjectionMapping)this.mapping;
        return ((Texture2D)map.getTexture()).getDisplacement(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, size * map.matScaleX, size * map.matScaleY, time, this.getParameters(u, v, w));
    }
}

