/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LinearMapping3D;
import artofillusion.RGBColor;
import artofillusion.RenderingTriangle;
import artofillusion.Texture3D;
import artofillusion.TextureMapping;
import artofillusion.TextureSpec;

public class Linear3DTriangle
extends RenderingTriangle {
    double x1;
    double x2;
    double x3;
    double y1;
    double y2;
    double y3;
    double z1;
    double z2;
    double z3;

    public Linear3DTriangle(int v1, int v2, int v3, int n1, int n2, int n3, double t1x, double t1y, double t1z, double t2x, double t2y, double t2z, double t3x, double t3y, double t3z, TextureMapping theMapping) {
        super(v1, v2, v3, n1, n2, n3, theMapping);
        this.x1 = t1x;
        this.y1 = t1y;
        this.z1 = t1z;
        this.x2 = t2x;
        this.y2 = t2y;
        this.z2 = t2z;
        this.x3 = t3x;
        this.y3 = t3y;
        this.z3 = t3z;
    }

    public void setParameters(double[] p1, double[] p2, double[] p3) {
        LinearMapping3D map = (LinearMapping3D)this.mapping;
        if (!map.coordsFromParams || p1[map.numTextureParams] == Double.MAX_VALUE) {
            return;
        }
        double x = p1[map.numTextureParams];
        double y = p1[map.numTextureParams + 1];
        double z = p1[map.numTextureParams + 2];
        this.x1 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y1 = x * map.ay + y * map.by + z * map.cy - map.dy;
        this.z1 = x * map.az + y * map.bz + z * map.cz - map.dz;
        x = p2[map.numTextureParams];
        y = p2[map.numTextureParams + 1];
        z = p2[map.numTextureParams + 2];
        this.x2 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y2 = x * map.ay + y * map.by + z * map.cy - map.dy;
        this.z2 = x * map.az + y * map.bz + z * map.cz - map.dz;
        x = p3[map.numTextureParams];
        y = p3[map.numTextureParams + 1];
        z = p3[map.numTextureParams + 2];
        this.x3 = x * map.ax + y * map.bx + z * map.cx - map.dx;
        this.y3 = x * map.ay + y * map.by + z * map.cy - map.dy;
        this.z3 = x * map.az + y * map.bz + z * map.cz - map.dz;
    }

    public void getTextureSpec(TextureSpec spec, boolean front, double u, double v, double w, double size, double time) {
        LinearMapping3D map = (LinearMapping3D)this.mapping;
        if (!this.mapping.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        ((Texture3D)this.mapping.getTexture()).getTextureSpec(spec, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w, size * map.matScaleX, size * map.matScaleY, size * map.matScaleZ, time, this.getParameters(u, v, w));
    }

    public void getTransparency(RGBColor trans, boolean front, double u, double v, double w, double size, double time) {
        LinearMapping3D map = (LinearMapping3D)this.mapping;
        if (!this.mapping.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        ((Texture3D)this.mapping.getTexture()).getTransparency(trans, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w, size * map.matScaleX, size * map.matScaleY, size * map.matScaleZ, time, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        LinearMapping3D map = (LinearMapping3D)this.mapping;
        return ((Texture3D)this.mapping.getTexture()).getDisplacement(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w, size * map.matScaleX, size * map.matScaleY, size * map.matScaleZ, time, this.getParameters(u, v, w));
    }
}

