/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.Linear3DTriangle;
import artofillusion.Mapping3D;
import artofillusion.Mat4;
import artofillusion.MaterialPreviewer;
import artofillusion.Mesh;
import artofillusion.Object3D;
import artofillusion.RGBColor;
import artofillusion.RenderingTriangle;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureParameter;
import artofillusion.TextureSpec;
import artofillusion.Vec3;
import artofillusion.animation.Actor;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LinearMapping3D
extends Mapping3D {
    CoordinateSystem coords;
    double ax;
    double bx;
    double cx;
    double dx;
    double ay;
    double by;
    double cy;
    double dy;
    double az;
    double bz;
    double cz;
    double dz;
    double xscale;
    double yscale;
    double zscale;
    double matScaleX;
    double matScaleY;
    double matScaleZ;
    Mat4 fromLocal;
    boolean transform;
    boolean coordsFromParams;
    int numTextureParams;

    public LinearMapping3D(Texture theTexture) {
        super(theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dz = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Linear";
    }

    void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.az = zdir.x / this.zscale;
        this.bz = zdir.y / this.zscale;
        this.cz = zdir.z / this.zscale;
        this.matScaleX = 1.0 / this.xscale;
        this.matScaleY = 1.0 / this.yscale;
        this.matScaleZ = 1.0 / this.zscale;
        this.fromLocal = this.coords.fromLocal();
        this.transform = this.fromLocal.m11 != 1.0 || this.fromLocal.m22 != 1.0 || this.fromLocal.m33 != 1.0;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = vert[v1];
        Vec3 c2 = vert[v2];
        Vec3 c3 = vert[v3];
        return new Linear3DTriangle(v1, v2, v3, n1, n2, n3, c1.x * this.ax + c1.y * this.bx + c1.z * this.cx - this.dx, c1.x * this.ay + c1.y * this.by + c1.z * this.cy - this.dy, c1.x * this.az + c1.y * this.bz + c1.z * this.cz - this.dz, c2.x * this.ax + c2.y * this.bx + c2.z * this.cx - this.dx, c2.x * this.ay + c2.y * this.by + c2.z * this.cy - this.dy, c2.x * this.az + c2.y * this.bz + c2.z * this.cz - this.dz, c3.x * this.ax + c3.y * this.bx + c3.z * this.cx - this.dx, c3.x * this.ay + c3.y * this.by + c3.z * this.cy - this.dy, c3.x * this.az + c3.y * this.bz + c3.z * this.cz - this.dz, this);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTextureSpec(spec, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        } else {
            this.texture.getTextureSpec(spec, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        }
        if (this.transform && this.texture.bumpMapped()) {
            this.fromLocal.transform(spec.bumpGrad);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTransparency(trans, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        } else {
            this.texture.getTransparency(trans, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            return this.texture.getDisplacement(x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        }
        return this.texture.getDisplacement(pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        LinearMapping3D map = new LinearMapping3D(tex);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.dz = this.dz;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.zscale = this.zscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public void copy(TextureMapping mapping) {
        LinearMapping3D map = (LinearMapping3D)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.dz = map.dz;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.zscale = map.zscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.setAppliesTo(map.appliesTo());
    }

    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        p[this.numTextureParams] = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams + 1] = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams + 2] = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams].type = 1;
        p[this.numTextureParams + 1].type = 2;
        p[this.numTextureParams + 2].type = 3;
        return p;
    }

    public Panel getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public LinearMapping3D(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.dz = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.dz);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends Panel
    implements ItemListener,
    TextListener {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField zscaleField;
        ValueField xtransField;
        ValueField ytransField;
        ValueField ztransField;
        Checkbox coordsFromParamsBox;
        Choice applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            this.theObject = obj;
            this.preview = preview;
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gc.gridwidth = 6;
            gc.insets = new Insets(0, 0, 0, 5);
            gc.gridy = 0;
            this.add((Component)new Label("Scale:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 1;
            this.add((Component)new Label("X"), gc);
            this.xscaleField = new ValueField((double)Math.round(LinearMapping3D.this.xscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.xscaleField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yscaleField = new ValueField((double)Math.round(LinearMapping3D.this.yscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.yscaleField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zscaleField = new ValueField((double)Math.round(LinearMapping3D.this.zscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.zscaleField, gc);
            gc.gridwidth = 6;
            gc.gridy = 2;
            this.add((Component)new Label("Center:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 3;
            this.add((Component)new Label("X"), gc);
            this.xtransField = new ValueField((double)Math.round(LinearMapping3D.this.dx * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xtransField, gc);
            this.add((Component)new Label("Y"), gc);
            this.ytransField = new ValueField((double)Math.round(LinearMapping3D.this.dy * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.ytransField, gc);
            this.add((Component)new Label("Z"), gc);
            this.ztransField = new ValueField((double)Math.round(LinearMapping3D.this.dz * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.ztransField, gc);
            gc.gridwidth = 6;
            gc.gridy = 4;
            this.add((Component)new Label("Rotation:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 5;
            double[] angles = LinearMapping3D.this.coords.getRotationAngles();
            this.add((Component)new Label("X"), gc);
            this.xrotField = new ValueField((double)Math.round(angles[0] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xrotField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yrotField = new ValueField((double)Math.round(angles[1] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.yrotField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zrotField = new ValueField((double)Math.round(angles[2] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.zrotField, gc);
            gc.gridwidth = 6;
            gc.gridy = 6;
            Panel p = new Panel();
            this.add((Component)p, gc);
            p.add(new Label("Apply To:"));
            this.applyToChoice = new Choice();
            p.add(this.applyToChoice);
            this.applyToChoice.add("Front and Back Faces");
            this.applyToChoice.add("Front Faces Only");
            this.applyToChoice.add("Back Faces Only");
            this.applyToChoice.select(LinearMapping3D.this.appliesTo());
            gc.gridy = 7;
            this.coordsFromParamsBox = new Checkbox("Bind Texture Coordinates to Surface", LinearMapping3D.this.coordsFromParams);
            this.add((Component)this.coordsFromParamsBox, gc);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof Mesh || this.theObject instanceof Actor);
            this.xscaleField.addTextListener(this);
            this.yscaleField.addTextListener(this);
            this.zscaleField.addTextListener(this);
            this.xtransField.addTextListener(this);
            this.ytransField.addTextListener(this);
            this.ztransField.addTextListener(this);
            this.xrotField.addTextListener(this);
            this.yrotField.addTextListener(this);
            this.zrotField.addTextListener(this);
            this.coordsFromParamsBox.addItemListener(this);
            this.applyToChoice.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            LinearMapping3D.this.coordsFromParams = this.coordsFromParamsBox.getState();
            LinearMapping3D.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(LinearMapping3D.this.getTexture(), LinearMapping3D.this);
            this.preview.render();
        }

        public void textValueChanged(TextEvent e) {
            LinearMapping3D.this.xscale = this.xscaleField.getValue();
            LinearMapping3D.this.yscale = this.yscaleField.getValue();
            LinearMapping3D.this.zscale = this.zscaleField.getValue();
            LinearMapping3D.this.dx = this.xtransField.getValue();
            LinearMapping3D.this.dy = this.ytransField.getValue();
            LinearMapping3D.this.dz = this.ztransField.getValue();
            LinearMapping3D.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            LinearMapping3D.this.findCoefficients();
            this.preview.render();
        }
    }
}

