/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Vec2;
import artofillusion.Vec3;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Mat4 {
    public final double m11;
    public final double m12;
    public final double m13;
    public final double m14;
    public final double m21;
    public final double m22;
    public final double m23;
    public final double m24;
    public final double m31;
    public final double m32;
    public final double m33;
    public final double m34;
    public final double m41;
    public final double m42;
    public final double m43;
    public final double m44;

    public Mat4(double e11, double e12, double e13, double e14, double e21, double e22, double e23, double e24, double e31, double e32, double e33, double e34, double e41, double e42, double e43, double e44) {
        this.m11 = e11;
        this.m12 = e12;
        this.m13 = e13;
        this.m14 = e14;
        this.m21 = e21;
        this.m22 = e22;
        this.m23 = e23;
        this.m24 = e24;
        this.m31 = e31;
        this.m32 = e32;
        this.m33 = e33;
        this.m34 = e34;
        this.m41 = e41;
        this.m42 = e42;
        this.m43 = e43;
        this.m44 = e44;
    }

    public final Mat4 times(Mat4 a) {
        return new Mat4(this.m11 * a.m11 + this.m12 * a.m21 + this.m13 * a.m31 + this.m14 * a.m41, this.m11 * a.m12 + this.m12 * a.m22 + this.m13 * a.m32 + this.m14 * a.m42, this.m11 * a.m13 + this.m12 * a.m23 + this.m13 * a.m33 + this.m14 * a.m43, this.m11 * a.m14 + this.m12 * a.m24 + this.m13 * a.m34 + this.m14 * a.m44, this.m21 * a.m11 + this.m22 * a.m21 + this.m23 * a.m31 + this.m24 * a.m41, this.m21 * a.m12 + this.m22 * a.m22 + this.m23 * a.m32 + this.m24 * a.m42, this.m21 * a.m13 + this.m22 * a.m23 + this.m23 * a.m33 + this.m24 * a.m43, this.m21 * a.m14 + this.m22 * a.m24 + this.m23 * a.m34 + this.m24 * a.m44, this.m31 * a.m11 + this.m32 * a.m21 + this.m33 * a.m31 + this.m34 * a.m41, this.m31 * a.m12 + this.m32 * a.m22 + this.m33 * a.m32 + this.m34 * a.m42, this.m31 * a.m13 + this.m32 * a.m23 + this.m33 * a.m33 + this.m34 * a.m43, this.m31 * a.m14 + this.m32 * a.m24 + this.m33 * a.m34 + this.m34 * a.m44, this.m41 * a.m11 + this.m42 * a.m21 + this.m43 * a.m31 + this.m44 * a.m41, this.m41 * a.m12 + this.m42 * a.m22 + this.m43 * a.m32 + this.m44 * a.m42, this.m41 * a.m13 + this.m42 * a.m23 + this.m43 * a.m33 + this.m44 * a.m43, this.m41 * a.m14 + this.m42 * a.m24 + this.m43 * a.m34 + this.m44 * a.m44);
    }

    public final Vec3 times(Vec3 v) {
        double w = this.m41 * v.x + this.m42 * v.y + this.m43 * v.z + this.m44;
        return new Vec3((this.m11 * v.x + this.m12 * v.y + this.m13 * v.z + this.m14) / w, (this.m21 * v.x + this.m22 * v.y + this.m23 * v.z + this.m24) / w, (this.m31 * v.x + this.m32 * v.y + this.m33 * v.z + this.m34) / w);
    }

    public final Vec3 timesDirection(Vec3 v) {
        return new Vec3(this.m11 * v.x + this.m12 * v.y + this.m13 * v.z, this.m21 * v.x + this.m22 * v.y + this.m23 * v.z, this.m31 * v.x + this.m32 * v.y + this.m33 * v.z);
    }

    public final Vec2 timesXY(Vec3 v) {
        double w = this.m41 * v.x + this.m42 * v.y + this.m43 * v.z + this.m44;
        return new Vec2((this.m11 * v.x + this.m12 * v.y + this.m13 * v.z + this.m14) / w, (this.m21 * v.x + this.m22 * v.y + this.m23 * v.z + this.m24) / w);
    }

    public final double timesZ(Vec3 v) {
        double w = this.m41 * v.x + this.m42 * v.y + this.m43 * v.z + this.m44;
        return (this.m31 * v.x + this.m32 * v.y + this.m33 * v.z + this.m34) / w;
    }

    public final void transform(Vec3 v) {
        double w = this.m41 * v.x + this.m42 * v.y + this.m43 * v.z + this.m44;
        v.set((this.m11 * v.x + this.m12 * v.y + this.m13 * v.z + this.m14) / w, (this.m21 * v.x + this.m22 * v.y + this.m23 * v.z + this.m24) / w, (this.m31 * v.x + this.m32 * v.y + this.m33 * v.z + this.m34) / w);
    }

    public final void transformDirection(Vec3 v) {
        v.set(this.m11 * v.x + this.m12 * v.y + this.m13 * v.z, this.m21 * v.x + this.m22 * v.y + this.m23 * v.z, this.m31 * v.x + this.m32 * v.y + this.m33 * v.z);
    }

    public static final Mat4 identity() {
        return new Mat4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 scale(double sx, double sy, double sz) {
        return new Mat4(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 translation(double dx, double dy, double dz) {
        return new Mat4(1.0, 0.0, 0.0, dx, 0.0, 1.0, 0.0, dy, 0.0, 0.0, 1.0, dz, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 xrotation(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        return new Mat4(1.0, 0.0, 0.0, 0.0, 0.0, c, -s, 0.0, 0.0, s, c, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 yrotation(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        return new Mat4(c, 0.0, s, 0.0, 0.0, 1.0, 0.0, 0.0, -s, 0.0, c, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 zrotation(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        return new Mat4(c, -s, 0.0, 0.0, s, c, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 axisRotation(Vec3 axis, double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double t = 1.0 - c;
        return new Mat4(t * axis.x * axis.x + c, t * axis.x * axis.y - s * axis.z, t * axis.x * axis.z + s * axis.y, 0.0, t * axis.x * axis.y + s * axis.z, t * axis.y * axis.y + c, t * axis.y * axis.z - s * axis.x, 0.0, t * axis.x * axis.z - s * axis.y, t * axis.y * axis.z + s * axis.x, t * axis.z * axis.z + c, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 viewTransform(Vec3 orig, Vec3 zdir, Vec3 updir) {
        Vec3 rz = zdir.times(1.0 / zdir.length());
        Vec3 rx = updir.cross(zdir);
        rx.normalize();
        Vec3 ry = rz.cross(rx);
        return new Mat4(rx.x, rx.y, rx.z, -(rx.x * orig.x + rx.y * orig.y + rx.z * orig.z), ry.x, ry.y, ry.z, -(ry.x * orig.x + ry.y * orig.y + ry.z * orig.z), rz.x, rz.y, rz.z, -(rz.x * orig.x + rz.y * orig.y + rz.z * orig.z), 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 objectTransform(Vec3 orig, Vec3 zdir, Vec3 updir) {
        Vec3 rz = zdir.times(1.0 / zdir.length());
        Vec3 rx = updir.cross(zdir);
        rx.normalize();
        Vec3 ry = rz.cross(rx);
        return new Mat4(rx.x, ry.x, rz.x, orig.x, rx.y, ry.y, rz.y, orig.y, rx.z, ry.z, rz.z, orig.z, 0.0, 0.0, 0.0, 1.0);
    }

    public static final Mat4 perspective(double d) {
        double e33 = 1.0 / ((d + 1.0) * (d + 1.0));
        return new Mat4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, e33, 1.0 - e33, 0.0, 0.0, e33, 1.0 - e33);
    }

    public String toString() {
        return "Mat4: {" + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m14 + "}, {" + this.m21 + ", " + this.m22 + ", " + this.m23 + ", " + this.m24 + "}, {" + this.m31 + ", " + this.m32 + ", " + this.m33 + ", " + this.m34 + "}, {" + this.m41 + ", " + this.m42 + ", " + this.m43 + ", " + this.m44 + "}";
    }

    public Mat4(DataInputStream in) throws IOException {
        this.m11 = in.readDouble();
        this.m12 = in.readDouble();
        this.m13 = in.readDouble();
        this.m14 = in.readDouble();
        this.m21 = in.readDouble();
        this.m22 = in.readDouble();
        this.m23 = in.readDouble();
        this.m24 = in.readDouble();
        this.m31 = in.readDouble();
        this.m32 = in.readDouble();
        this.m33 = in.readDouble();
        this.m34 = in.readDouble();
        this.m41 = in.readDouble();
        this.m42 = in.readDouble();
        this.m43 = in.readDouble();
        this.m44 = in.readDouble();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeDouble(this.m11);
        out.writeDouble(this.m12);
        out.writeDouble(this.m13);
        out.writeDouble(this.m14);
        out.writeDouble(this.m21);
        out.writeDouble(this.m22);
        out.writeDouble(this.m23);
        out.writeDouble(this.m24);
        out.writeDouble(this.m31);
        out.writeDouble(this.m32);
        out.writeDouble(this.m33);
        out.writeDouble(this.m34);
        out.writeDouble(this.m41);
        out.writeDouble(this.m42);
        out.writeDouble(this.m43);
        out.writeDouble(this.m44);
    }
}

