/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.DirectionalLight;
import artofillusion.EditingWindow;
import artofillusion.ImageMap;
import artofillusion.JarClassLoader;
import artofillusion.LayeredMapping;
import artofillusion.LayeredTexture;
import artofillusion.LayoutWindow;
import artofillusion.Material;
import artofillusion.ModellingTool;
import artofillusion.ObjectInfo;
import artofillusion.Plugin;
import artofillusion.RGBColor;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.SceneCamera;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TitleWindow;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.ui.MessageDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModellingApp {
    public static final String VERSION = "1.1";
    public static final double DIST_TO_SCREEN = 20.0;
    public static final Color APP_BACKGROUND_COLOR = new Color(228, 228, 243);
    public static final String APP_DIRECTORY;
    public static final String PLUGIN_DIRECTORY;
    public static Font defaultFont;
    private static ObjectInfo[] clipboardObject;
    private static Texture[] clipboardTexture;
    private static Material[] clipboardMaterial;
    private static ImageMap[] clipboardImage;
    public static String currentDirectory;
    static Vector windows;
    static JarClassLoader[] pluginLoader;
    static Vector renderers;
    static Vector translators;
    static Vector modellingTools;
    static Vector textures;
    static Vector materials;
    static Vector textureMappings;
    static Vector materialMappings;
    static Vector plugins;
    static Renderer preview;

    public static void main(String[] args) {
        TitleWindow title = new TitleWindow();
        try {
            textures.addElement(Class.forName("artofillusion.UniformTexture"));
            textures.addElement(Class.forName("artofillusion.ImageMapTexture"));
            textures.addElement(Class.forName("artofillusion.procedural.ProceduralTexture2D"));
            textures.addElement(Class.forName("artofillusion.procedural.ProceduralTexture3D"));
            materials.addElement(Class.forName("artofillusion.UniformMaterial"));
            materials.addElement(Class.forName("artofillusion.procedural.ProceduralMaterial3D"));
            textureMappings.addElement(Class.forName("artofillusion.UniformMapping"));
            textureMappings.addElement(Class.forName("artofillusion.ProjectionMapping"));
            textureMappings.addElement(Class.forName("artofillusion.CylindricalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.SphericalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.LinearMapping3D"));
            materialMappings.addElement(Class.forName("artofillusion.LinearMaterialMapping"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (pluginLoader == null) {
            ModellingApp.scanPlugins();
        }
        if (renderers.size() > 0) {
            preview = (Renderer)renderers.elementAt(renderers.size() - 1);
        }
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(0, new Object[0]);
            ++i;
        }
        ModellingApp.newWindow();
        title.dispose();
    }

    public static Renderer[] getRenderers() {
        Renderer[] r = new Renderer[renderers.size()];
        int i = 0;
        while (i < renderers.size()) {
            r[i] = (Renderer)renderers.elementAt(i);
            ++i;
        }
        return r;
    }

    public static Renderer previewRenderer() {
        return preview;
    }

    public static Plugin[] getPlugins() {
        Plugin[] p = new Plugin[plugins.size()];
        int i = 0;
        while (i < plugins.size()) {
            p[i] = (Plugin)plugins.elementAt(i);
            ++i;
        }
        return p;
    }

    public static Translator[] getTranslators() {
        Translator[] t = new Translator[translators.size()];
        int i = 0;
        while (i < translators.size()) {
            t[i] = (Translator)translators.elementAt(i);
            ++i;
        }
        return t;
    }

    public static ModellingTool[] getModellingTools() {
        ModellingTool[] t = new ModellingTool[modellingTools.size()];
        int i = 0;
        while (i < modellingTools.size()) {
            t[i] = (ModellingTool)modellingTools.elementAt(i);
            ++i;
        }
        return t;
    }

    public static Class[] getTextureTypes() {
        Class[] t = new Class[textures.size()];
        int i = 0;
        while (i < textures.size()) {
            t[i] = (Class)textures.elementAt(i);
            ++i;
        }
        return t;
    }

    public static Class[] getMaterialTypes() {
        Class[] m = new Class[materials.size()];
        int i = 0;
        while (i < materials.size()) {
            m[i] = (Class)materials.elementAt(i);
            ++i;
        }
        return m;
    }

    public static Class[] getTextureMappings() {
        Class[] t = new Class[textureMappings.size()];
        int i = 0;
        while (i < textureMappings.size()) {
            t[i] = (Class)textureMappings.elementAt(i);
            ++i;
        }
        return t;
    }

    public static Class[] getMaterialMappings() {
        Class[] m = new Class[materialMappings.size()];
        int i = 0;
        while (i < materialMappings.size()) {
            m[i] = (Class)materialMappings.elementAt(i);
            ++i;
        }
        return m;
    }

    public static boolean dragBoundingBoxes() {
        return false;
    }

    public static void newWindow() {
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo(new SceneCamera(), coords, "Camera 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        LayoutWindow fr = new LayoutWindow(theScene);
        windows.addElement(fr);
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(2, new Object[]{fr});
            ++i;
        }
        fr.show();
    }

    public static void newWindow(Scene theScene) {
        LayoutWindow fr = new LayoutWindow(theScene);
        windows.addElement(fr);
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(2, new Object[]{fr});
            ++i;
        }
        fr.show();
        int i2 = windows.size() - 2;
        while (i2 >= 0) {
            LayoutWindow win;
            if (windows.elementAt(i2) instanceof LayoutWindow && (win = (LayoutWindow)windows.elementAt(i2)).getScene().getName() == null && !win.modified) {
                ModellingApp.closeWindow(win);
            }
            --i2;
        }
    }

    public static void addWindow(EditingWindow win) {
        windows.addElement(win);
    }

    public static void closeWindow(EditingWindow win) {
        if (win.confirmClose()) {
            windows.removeElement(win);
            if (win instanceof LayoutWindow) {
                int i = 0;
                while (i < plugins.size()) {
                    ((Plugin)plugins.elementAt(i)).processMessage(3, new Object[]{win});
                    ++i;
                }
            }
        }
        if (windows.size() == 0) {
            ModellingApp.quit();
        }
    }

    public static void quit() {
        int i = windows.size() - 1;
        while (i >= 0) {
            EditingWindow win = (EditingWindow)windows.elementAt(i);
            ModellingApp.closeWindow(win);
            if (windows.contains(win)) {
                return;
            }
            --i;
        }
        int i2 = 0;
        while (i2 < plugins.size()) {
            ((Plugin)plugins.elementAt(i2)).processMessage(1, new Object[0]);
            ++i2;
        }
        System.exit(0);
    }

    static void scanPlugins() {
        File dir = new File(PLUGIN_DIRECTORY);
        ZipFile zf = null;
        if (!dir.exists()) {
            Frame fr = new Frame();
            new MessageDialog(fr, new String[]{"Unable to locate Plugins directory.  Make sure that", "Art of Illusion is properly installed, and that you", "launch it exactly as described in the instructions."});
            fr.dispose();
            pluginLoader = new JarClassLoader[0];
            return;
        }
        String[] files = dir.list();
        pluginLoader = new JarClassLoader[files.length];
        int j = 0;
        int i = 0;
        while (i < files.length) {
            block19: {
                try {
                    zf = new ZipFile(PLUGIN_DIRECTORY + files[i]);
                }
                catch (IOException ex) {
                    break block19;
                }
                try {
                    ModellingApp.pluginLoader[j++] = new JarClassLoader(zf);
                    ZipEntry ze = zf.getEntry("plugins");
                    if (ze == null) break block19;
                    BufferedReader in = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    String name = in.readLine();
                    while (name != null) {
                        try {
                            Object instance = pluginLoader[j - 1].loadClass(name).newInstance();
                            if (instance instanceof Plugin) {
                                plugins.addElement(instance);
                            }
                            if (instance instanceof Renderer) {
                                renderers.addElement(instance);
                            }
                            if (instance instanceof Translator) {
                                translators.addElement(instance);
                            }
                            if (instance instanceof ModellingTool) {
                                modellingTools.addElement(instance);
                            }
                            if (instance instanceof Texture) {
                                textures.addElement(instance.getClass());
                            }
                            if (instance instanceof Material) {
                                materials.addElement(instance.getClass());
                            }
                        }
                        catch (ClassNotFoundException ex) {
                        }
                        catch (IllegalAccessException ex) {
                        }
                        catch (InstantiationException ex) {
                            // empty catch block
                        }
                        name = in.readLine();
                    }
                }
                catch (IOException ex) {
                    System.out.println("Error reading plugin file " + files[i]);
                }
            }
            ++i;
        }
        if (j < files.length) {
            JarClassLoader[] temp = new JarClassLoader[j];
            i = 0;
            while (i < j) {
                temp[i] = pluginLoader[i];
                ++i;
            }
            pluginLoader = temp;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            i = 0;
            ** while (i < ModellingApp.pluginLoader.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return ModellingApp.pluginLoader[i].loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                if (i == ModellingApp.pluginLoader.length - 1) {
                    throw ex;
                }
                ++i;
            }
            continue;
        }
lbl13:
        // 1 sources

        return null;
    }

    public static void centerWindow(Window win) {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = win.getSize();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        ((Component)win).setLocation(x, y);
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        try {
            File f = new File(sc.getDirectory(), sc.getName());
            DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(f))));
            sc.writeToFile(out);
            out.close();
            int i = 0;
            while (i < plugins.size()) {
                ((Plugin)plugins.elementAt(i)).processMessage(4, new Object[]{f, fr});
                ++i;
            }
        }
        catch (IOException ex) {
            new MessageDialog((Frame)fr, new String[]{"An error occurred while attempting to save the scene.", ex.getMessage()});
            return false;
        }
        return true;
    }

    public static void openScene(Frame fr) {
        FileDialog fd = new FileDialog(fr, "Open Scene", 0);
        if (currentDirectory != null) {
            fd.setDirectory(currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        currentDirectory = fd.getDirectory();
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            Scene sc = new Scene(in, true);
            sc.setName(fd.getFile());
            sc.setDirectory(fd.getDirectory());
            ModellingApp.newWindow(sc);
            in.close();
            if (sc.errorsLoading) {
                new MessageDialog(fr, new String[]{"Errors occurred while reading the file.  As a result, some elements", "of the scene could not be loaded correctly.  The file may have", "been created with a later version of Art of Illusion."});
            }
        }
        catch (InvalidObjectException ex) {
            new MessageDialog(fr, new String[]{"An error occurred while reading the file.  This file may", "have been created with a later version of Art of Illusion."});
        }
        catch (IOException ex) {
            new MessageDialog(fr, new String[]{"An error occurred while reading the file.", ex.getMessage()});
        }
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        Vector<Texture> textures = new Vector<Texture>();
        int i = 0;
        while (i < obj.length) {
            Texture tex = obj[i].object.getTexture();
            if (tex instanceof LayeredTexture) {
                LayeredMapping map = (LayeredMapping)obj[i].object.getTextureMapping();
                Texture[] layer = map.getLayers();
                int j = 0;
                while (j < layer.length) {
                    Texture dup = layer[j].duplicate();
                    dup.setID(layer[j].getID());
                    TextureMapping dupMap = map.getLayerMapping(j);
                    textures.addElement(dup);
                    map.setLayer(j, dup);
                    map.setLayerMapping(j, map.getLayerMapping(j).duplicate(dup));
                    ++j;
                }
            } else if (tex != null) {
                Texture dup = tex.duplicate();
                dup.setID(tex.getID());
                textures.addElement(dup);
                obj[i].object.setTexture(dup);
                obj[i].object.setTextureMapping(obj[i].object.getTextureMapping().duplicate(dup));
            }
            ++i;
        }
        Vector<Material> materials = new Vector<Material>();
        int i2 = 0;
        while (i2 < obj.length) {
            Material mat = obj[i2].object.getMaterial();
            if (mat != null) {
                Material dup = mat.duplicate();
                dup.setID(mat.getID());
                materials.addElement(dup);
                obj[i2].object.setMaterial(dup);
                obj[i2].object.setMaterialMapping(obj[i2].object.getMaterialMapping().duplicate(dup));
            }
            ++i2;
        }
        Vector<ImageMap> images = new Vector<ImageMap>();
        Vector allImages = scene.getImages();
        int i3 = 0;
        while (i3 < allImages.size()) {
            ImageMap map = (ImageMap)allImages.elementAt(i3);
            boolean used = false;
            int j = 0;
            while (j < textures.size() && !used) {
                used = ((Texture)textures.elementAt(j)).usesImage(map);
                ++j;
            }
            int j2 = 0;
            while (j2 < materials.size() && !used) {
                used = ((Material)materials.elementAt(j2)).usesImage(map);
                ++j2;
            }
            if (used) {
                images.addElement(map);
            }
            ++i3;
        }
        clipboardObject = obj;
        clipboardTexture = new Texture[textures.size()];
        textures.copyInto(clipboardTexture);
        clipboardMaterial = new Material[materials.size()];
        materials.copyInto(clipboardMaterial);
        clipboardImage = new ImageMap[images.size()];
        images.copyInto(clipboardImage);
    }

    public static void pasteClipboard(LayoutWindow win) {
        int j;
        if (clipboardObject == null) {
            return;
        }
        Scene scene = win.getScene();
        UndoRecord undo = new UndoRecord(win, false);
        win.setUndoRecord(undo);
        Vector v = scene.getImages();
        int i = 0;
        while (i < clipboardImage.length) {
            int j2 = 0;
            while (j2 < v.size() && clipboardImage[i].getID() != ((ImageMap)v.elementAt(j2)).getID()) {
                ++j2;
            }
            if (j2 == v.size()) {
                scene.addImage(clipboardImage[i]);
            }
            ++i;
        }
        v = scene.getTextures();
        int i2 = 0;
        while (i2 < clipboardTexture.length) {
            Texture newtex;
            j = 0;
            while (j < v.size() && clipboardTexture[i2].getID() != ((Texture)v.elementAt(j)).getID()) {
                ++j;
            }
            if (j == v.size()) {
                newtex = clipboardTexture[i2].duplicate();
                newtex.id = ModellingApp.clipboardTexture[i2].id;
                scene.addTexture(newtex);
            } else {
                newtex = (Texture)v.elementAt(j);
            }
            j = 0;
            while (j < clipboardObject.length) {
                Texture current = ModellingApp.clipboardObject[j].object.getTexture();
                if (current == clipboardTexture[i2]) {
                    clipboardObject[j].setTexture(newtex, ModellingApp.clipboardObject[j].object.getTextureMapping().duplicate(newtex));
                } else if (current instanceof LayeredTexture) {
                    LayeredMapping map = (LayeredMapping)ModellingApp.clipboardObject[j].object.getTextureMapping();
                    map = (LayeredMapping)map.duplicate();
                    clipboardObject[j].setTexture(new LayeredTexture(map), map);
                    Texture[] layer = map.getLayers();
                    int k = 0;
                    while (k < layer.length) {
                        if (layer[k] == clipboardTexture[i2]) {
                            map.setLayer(k, newtex);
                            map.setLayerMapping(k, map.getLayerMapping(k).duplicate(newtex));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        v = scene.getMaterials();
        int i3 = 0;
        while (i3 < clipboardMaterial.length) {
            j = 0;
            while (j < v.size() && clipboardMaterial[i3].getID() != ((Material)v.elementAt(j)).getID()) {
                ++j;
            }
            if (j == v.size()) {
                Material newmat = clipboardMaterial[i3].duplicate();
                newmat.id = ModellingApp.clipboardMaterial[i3].id;
                scene.addMaterial(newmat);
            }
            ++i3;
        }
        ObjectInfo[] obj = ObjectInfo.duplicateAll(clipboardObject);
        int i4 = 0;
        while (i4 < obj.length) {
            win.addObject(obj[i4], undo);
            ++i4;
        }
    }

    public static int getClipboardSize() {
        if (clipboardObject == null) {
            return 0;
        }
        return clipboardObject.length;
    }

    static {
        windows = new Vector();
        renderers = new Vector();
        translators = new Vector();
        modellingTools = new Vector();
        textures = new Vector();
        materials = new Vector();
        textureMappings = new Vector();
        materialMappings = new Vector();
        plugins = new Vector();
        String sep = System.getProperty("file.separator");
        String dir = System.getProperty("user.dir");
        APP_DIRECTORY = dir.endsWith(sep) ? dir : dir + sep;
        PLUGIN_DIRECTORY = APP_DIRECTORY + "Plugins" + sep;
    }
}

