/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.Mat4;
import artofillusion.ObjectInfo;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class MoveViewTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Mat4 viewToWorld;
    Vec3 clickPos;
    boolean controlDown;
    CoordinateSystem oldCoords;

    public MoveViewTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("moveView.gif");
        selectedIcon = this.loadImage("selected/moveView.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText("Drag to move viewpoint.  Shift-drag to constrain movement, control-drag to zoom.");
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return !(this.theWindow instanceof LayoutWindow);
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.clickPos = cam.convertScreenToWorld(this.clickPoint, cam.getDistToScreen());
        this.oldCoords = cam.getCameraCoordinates().duplicate();
        this.viewToWorld = cam.getViewToWorld();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Vec3 move;
        Camera cam = view.getCamera();
        Graphics g = view.getGraphics();
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        cam.setCameraCoordinates(c);
        if (this.controlDown) {
            move = cam.findDragVector(this.clickPos, 0, dy);
            double dist = dy > 0 ? -move.length() : move.length();
            move = this.viewToWorld.timesDirection(Vec3.vz()).times(dist * 2.0);
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            move = cam.findDragVector(this.clickPos, dx, dy);
        }
        Mat4 m = Mat4.translation(-move.x, -move.y, -move.z);
        c.transformOrigin(m);
        cam.setCameraCoordinates(c);
        view.updateImage();
        view.drawImage(g);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        this.theWindow.updateImage();
        ObjectInfo bound = view.getBoundCamera();
        if (bound != null) {
            this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 1, new Object[]{bound.coords, this.oldCoords}));
        }
    }
}

