/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Vec3;
import java.util.Random;

public class Noise {
    static short[] permute;
    static Vec3[] grad;
    static final int TABLE_SIZE = 256;

    public static double value(double x, double y, double z) {
        double xi = Math.floor(x);
        double yi = Math.floor(y);
        double zi = Math.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        return Noise.getWavelet(i, j, k, u1, v1, w1) + Noise.getWavelet(i + 1, j, k, u2, v1, w1) + Noise.getWavelet(i, j + 1, k, u1, v2, w1) + Noise.getWavelet(i + 1, j + 1, k, u2, v2, w1) + Noise.getWavelet(i, j, k + 1, u1, v1, w2) + Noise.getWavelet(i + 1, j, k + 1, u2, v1, w2) + Noise.getWavelet(i, j + 1, k + 1, u1, v2, w2) + Noise.getWavelet(i + 1, j + 1, k + 1, u2, v2, w2);
    }

    private static final double getWavelet(int i, int j, int k, double u, double v, double w) {
        Vec3 g = grad[permute[permute[permute[i] + j] + k]];
        double drop = u > 0.0 ? 1.0 + u * u * (2.0 * u - 3.0) : 1.0 - u * u * (2.0 * u + 3.0);
        drop = v > 0.0 ? (drop *= 1.0 + v * v * (2.0 * v - 3.0)) : (drop *= 1.0 - v * v * (2.0 * v + 3.0));
        drop = w > 0.0 ? (drop *= 1.0 + w * w * (2.0 * w - 3.0)) : (drop *= 1.0 - w * w * (2.0 * w + 3.0));
        return drop * (g.x * u + g.y * v + g.z * w);
    }

    public static void calcGradient(Vec3 gradient, double x, double y, double z) {
        double xi = Math.floor(x);
        double yi = Math.floor(y);
        double zi = Math.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        gradient.set(0.0, 0.0, 0.0);
        Noise.addWaveletGradient(gradient, i, j, k, u1, v1, w1);
        Noise.addWaveletGradient(gradient, i + 1, j, k, u2, v1, w1);
        Noise.addWaveletGradient(gradient, i, j + 1, k, u1, v2, w1);
        Noise.addWaveletGradient(gradient, i + 1, j + 1, k, u2, v2, w1);
        Noise.addWaveletGradient(gradient, i, j, k + 1, u1, v1, w2);
        Noise.addWaveletGradient(gradient, i + 1, j, k + 1, u2, v1, w2);
        Noise.addWaveletGradient(gradient, i, j + 1, k + 1, u1, v2, w2);
        Noise.addWaveletGradient(gradient, i + 1, j + 1, k + 1, u2, v2, w2);
    }

    private static final void addWaveletGradient(Vec3 gradient, int i, int j, int k, double u, double v, double w) {
        Vec3 g = grad[permute[permute[permute[i] + j] + k]];
        double uabs = Math.abs(u);
        double vabs = Math.abs(v);
        double wabs = Math.abs(w);
        double dropu = 1.0 + uabs * uabs * (2.0 * uabs - 3.0);
        double dropv = 1.0 + vabs * vabs * (2.0 * vabs - 3.0);
        double dropw = 1.0 + wabs * wabs * (2.0 * wabs - 3.0);
        double product = dropu * dropv * dropw;
        double dot = 6.0 * (g.x * u + g.y * v + g.z * w);
        gradient.x += dropv * dropw * uabs * (uabs - 1.0) * dot + product * g.x;
        gradient.y += dropu * dropw * vabs * (vabs - 1.0) * dot + product * g.y;
        gradient.z += dropu * dropv * wabs * (wabs - 1.0) * dot + product * g.z;
    }

    public static void calcVector(Vec3 v, double x, double y, double z) {
        double xi = Math.floor(x);
        double yi = Math.floor(y);
        double zi = Math.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        v.set(0.0, 0.0, 0.0);
        Noise.addVectorWavelet(v, i, j, k, u1, v1, w1);
        Noise.addVectorWavelet(v, i + 1, j, k, u2, v1, w1);
        Noise.addVectorWavelet(v, i, j + 1, k, u1, v2, w1);
        Noise.addVectorWavelet(v, i + 1, j + 1, k, u2, v2, w1);
        Noise.addVectorWavelet(v, i, j, k + 1, u1, v1, w2);
        Noise.addVectorWavelet(v, i + 1, j, k + 1, u2, v1, w2);
        Noise.addVectorWavelet(v, i, j + 1, k + 1, u1, v2, w2);
        Noise.addVectorWavelet(v, i + 1, j + 1, k + 1, u2, v2, w2);
    }

    private static final void addVectorWavelet(Vec3 vec, int i, int j, int k, double u, double v, double w) {
        Vec3 g = grad[permute[permute[permute[i] + j] + k]];
        double drop = u > 0.0 ? 1.0 + u * u * (2.0 * u - 3.0) : 1.0 - u * u * (2.0 * u + 3.0);
        drop = v > 0.0 ? (drop *= 1.0 + v * v * (2.0 * v - 3.0)) : (drop *= 1.0 - v * v * (2.0 * v + 3.0));
        drop = w > 0.0 ? (drop *= 1.0 + w * w * (2.0 * w - 3.0)) : (drop *= 1.0 - w * w * (2.0 * w + 3.0));
        vec.x += drop * g.x;
        vec.y += drop * g.y;
        vec.z += drop * g.z;
    }

    static {
        Random random = new Random();
        random.setSeed(0L);
        permute = new short[512];
        int i = 0;
        while (i < 256) {
            Noise.permute[i] = (short)i;
            ++i;
        }
        i = 0;
        while (i < 256) {
            int j = Math.abs(random.nextInt()) % 256;
            short temp = permute[i];
            Noise.permute[i] = permute[j];
            Noise.permute[j] = temp;
            ++i;
        }
        grad = new Vec3[512];
        i = 0;
        while (i < 256) {
            Vec3 v;
            double len;
            while ((len = (v = new Vec3(2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0)).length2()) > 1.0) {
            }
            v.scale(1.0 / Math.sqrt(len));
            Noise.grad[i] = v;
            ++i;
        }
        i = 0;
        while (i < 256) {
            Noise.permute[256 + i] = permute[i];
            Noise.grad[256 + i] = grad[i];
            ++i;
        }
    }
}

