/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.EditingWindow;
import artofillusion.LayeredMapping;
import artofillusion.LayeredTexture;
import artofillusion.Material;
import artofillusion.MaterialMapping;
import artofillusion.ObjectInfo;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TriangleMesh;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.ui.MessageDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.util.Vector;

public abstract class Object3D {
    Texture theTexture;
    Material theMaterial;
    TextureMapping texMapping;
    MaterialMapping matMapping;
    public static final int CANT_CONVERT = 0;
    public static final int EXACTLY = 1;
    public static final int APPROXIMATELY = 2;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$artofillusion$Material;
    static /* synthetic */ Class class$artofillusion$Texture;

    public Object3D() {
    }

    public abstract Object3D duplicate();

    public abstract void copyObject(Object3D var1);

    public abstract BoundingBox getBounds();

    public abstract void setSize(double var1, double var3, double var5);

    public static void draw(Graphics g, Camera cam, WireframeMesh mesh, BoundingBox bounds) {
        int vis = cam.visibility(bounds);
        int[] from = mesh.from;
        int[] to = mesh.to;
        int last = -1;
        Vec3[] vert = mesh.vert;
        if (vis == 0) {
            return;
        }
        if (vis == 1) {
            int i = 0;
            while (i < mesh.from.length) {
                if (from[i] == last) {
                    last = to[i];
                    cam.drawClippedLineTo(g, vert[last]);
                } else {
                    last = to[i];
                    cam.drawClippedLine(g, vert[from[i]], vert[last]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < mesh.from.length) {
                if (from[i] == last) {
                    last = to[i];
                    cam.drawLineTo(g, vert[last]);
                } else {
                    last = to[i];
                    cam.drawLine(g, vert[from[i]], vert[last]);
                }
                ++i;
            }
        }
    }

    public boolean isClosed() {
        return true;
    }

    public int canConvertToTriangleMesh() {
        return 0;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        return null;
    }

    public boolean editable() {
        return false;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Callback cb, ObjectInfo realObject) {
        this.edit(parent, info, cb);
    }

    public boolean canSetMaterial() {
        return true;
    }

    public void setTexture(Texture tex) {
        this.theTexture = tex;
    }

    public Texture getTexture() {
        return this.theTexture;
    }

    public void setMaterial(Material mat) {
        this.theMaterial = mat;
    }

    public Material getMaterial() {
        return this.theMaterial;
    }

    public void setTextureMapping(TextureMapping mapping) {
        this.texMapping = mapping;
        if (mapping instanceof LayeredMapping) {
            this.setTexture(((LayeredMapping)mapping).getTexture());
        }
    }

    public TextureMapping getTextureMapping() {
        return this.texMapping;
    }

    public void setMaterialMapping(MaterialMapping mapping) {
        this.matMapping = mapping;
    }

    public MaterialMapping getMaterialMapping() {
        return this.matMapping;
    }

    public Skeleton getSkeleton() {
        return null;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return null;
    }

    public abstract WireframeMesh getWireframeMesh();

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        Vector materials = theScene.getMaterials();
        Vector textures = theScene.getTextures();
        out.writeShort(0);
        if (this.canSetMaterial()) {
            if (this.theMaterial == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(materials.lastIndexOf(this.theMaterial));
                out.writeUTF(this.matMapping.getClass().getName());
                this.matMapping.writeToFile(out);
            }
            if (this.theTexture instanceof LayeredTexture) {
                out.writeInt(-1);
                ((LayeredMapping)this.texMapping).writeToFile(out, theScene.getTextures());
            } else {
                out.writeInt(textures.lastIndexOf(this.theTexture));
                out.writeUTF(this.texMapping.getClass().getName());
                this.texMapping.writeToFile(out);
            }
        }
    }

    public Object3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        Constructor<?> con;
        Class<?> mapClass;
        short version = in.readShort();
        Vector materials = theScene.getMaterials();
        Vector textures = theScene.getTextures();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        if (!this.canSetMaterial()) {
            return;
        }
        int i = in.readInt();
        if (i > -1) {
            this.setMaterial((Material)materials.elementAt(i));
            try {
                mapClass = Class.forName(in.readUTF());
                con = mapClass.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Object3D.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$Material == null ? (class$artofillusion$Material = Object3D.class$("artofillusion.Material")) : class$artofillusion$Material);
                this.setMaterialMapping((MaterialMapping)con.newInstance(in, this.theMaterial));
            }
            catch (Exception ex) {
                throw new IOException();
            }
        }
        if ((i = in.readInt()) > -1) {
            this.setTexture((Texture)textures.elementAt(i));
            try {
                mapClass = Class.forName(in.readUTF());
                con = mapClass.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Object3D.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$Texture == null ? (class$artofillusion$Texture = Object3D.class$("artofillusion.Texture")) : class$artofillusion$Texture);
                this.setTextureMapping((TextureMapping)con.newInstance(in, this.theTexture));
            }
            catch (Exception ex) {
                throw new IOException();
            }
        } else {
            LayeredTexture tex = new LayeredTexture();
            LayeredMapping map = (LayeredMapping)tex.getDefaultMapping();
            map.readFromFile(in, theScene.getTextures());
            this.setTexture(tex);
            this.setTextureMapping(map);
        }
    }

    public abstract Keyframe getPoseKeyframe();

    public abstract void applyPoseKeyframe(Keyframe var1);

    public String[] getPoseValueNames() {
        return new String[0];
    }

    public double[] getDefaultPoseValues() {
        return new double[this.getPoseValueNames().length];
    }

    public double[][] getPoseValueRange() {
        double[][] range = new double[this.getPoseValueNames().length][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
            ++i;
        }
        return range;
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        new MessageDialog((Frame)((Object)parent), "This keyframe has no editable parameters.");
    }

    public Object3D getPosableObject() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

