/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.LayeredMapping;
import artofillusion.LayeredTexture;
import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ObjectTextureDialog
extends Dialog
implements ActionListener,
ItemListener,
ListChangeListener {
    Frame fr;
    Scene sc;
    ObjectInfo[] obj;
    ObjectInfo editObj;
    Vector textures;
    List texList;
    List layerList;
    Button mapButton;
    Button addLayerButton;
    Button deleteLayerButton;
    Button moveUpButton;
    Button moveDownButton;
    Panel contentPanel;
    MaterialPreviewer preview;
    Choice typeChoice;
    Choice blendChoice;
    Checkbox[] paramPerVertexBox;
    ValueField[] paramValueField;
    ValueSlider[] paramValueSlider;
    int[] fieldParamIndex;
    ScrollPane paramsScroller;
    Panel paramsPanel;
    Label paramsLabel;
    Callback callback;
    Texture oldTexture;
    TextureMapping oldMapping;
    LayeredTexture layeredTex;
    LayeredMapping layeredMap;

    public ObjectTextureDialog(Frame parent, Scene theScene, ObjectInfo[] objects) {
        super(parent, "Object Texture", false);
        this.fr = parent;
        this.sc = theScene;
        this.obj = objects;
        this.editObj = this.obj[0].duplicate();
        this.editObj.object = this.editObj.object.duplicate();
        this.textures = theScene.getTextures();
        this.oldTexture = this.editObj.object.getTexture();
        this.oldMapping = this.editObj.object.getTextureMapping();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layeredMap = (LayeredMapping)this.oldMapping;
            this.layeredTex = (LayeredTexture)this.oldTexture;
        } else {
            this.layeredTex = new LayeredTexture();
            this.layeredMap = (LayeredMapping)this.layeredTex.getDefaultMapping();
        }
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridwidth = 4;
        if (this.obj.length == 1) {
            p.add((Component)new Label("Choose texture for '" + this.obj[0].name + "':"), gc);
        } else {
            p.add((Component)new Label("Choose texture for selected objects:"), gc);
        }
        gc.gridwidth = 1;
        this.typeChoice = new Choice();
        this.typeChoice.add("Simple Texture");
        this.typeChoice.add("Layered Texture");
        this.typeChoice.select(this.oldTexture instanceof LayeredTexture ? 1 : 0);
        this.typeChoice.addItemListener(this);
        if (this.obj.length == 1) {
            gc.gridx = 0;
            p.add((Component)new Label("Type "), gc);
            gc.gridx = 1;
            p.add((Component)this.typeChoice, gc);
        }
        this.add((Component)p, "North");
        this.contentPanel = new Panel();
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new GridBagLayout());
        this.texList = new List();
        this.buildList();
        this.texList.addItemListener(this);
        this.layerList = new List(){

            public Dimension getPreferredSize() {
                return ObjectTextureDialog.this.texList.getPreferredSize();
            }
        };
        this.layerList.addItemListener(this);
        int i = 0;
        while (i < this.layeredMap.getLayers().length) {
            this.layerList.addItem(this.layeredMap.getLayers()[i].getName());
            ++i;
        }
        this.addLayerButton = new Button("Add >>");
        this.deleteLayerButton = new Button("Delete Layer");
        this.moveUpButton = new Button("Move Up");
        this.moveDownButton = new Button("Move Down");
        this.addLayerButton.addActionListener(this);
        this.deleteLayerButton.addActionListener(this);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.addLayerButton.setActionCommand("add");
        this.deleteLayerButton.setActionCommand("delete");
        this.moveUpButton.setActionCommand("moveup");
        this.moveDownButton.setActionCommand("movedown");
        this.blendChoice = new Choice();
        this.blendChoice.add("Blend");
        this.blendChoice.add("Overlay");
        this.blendChoice.add("Overlay (bumps add)");
        this.blendChoice.addItemListener(this);
        if (this.oldTexture instanceof LayeredTexture) {
            this.preview = new MaterialPreviewer(this.layeredTex, this.editObj.object.getMaterial(), 160, 160);
            this.preview.setTexture(this.layeredTex, this.layeredMap);
        } else {
            this.preview = new MaterialPreviewer(this.oldTexture, this.editObj.object.getMaterial(), 160, 160);
            this.preview.setTexture(this.oldTexture, this.oldMapping);
        }
        this.preview.setMaterialMapping(this.editObj.object.getMaterialMapping());
        this.preview.getObject().texParamValue = this.editObj.texParamValue;
        p = new Panel();
        this.add((Component)p, "South");
        this.mapButton = new Button("Edit Mapping...");
        p.add(this.mapButton);
        this.mapButton.setActionCommand("map");
        this.mapButton.addActionListener(this);
        Button b = new Button("Textures...");
        p.add(b);
        b.setActionCommand("textures");
        b.addActionListener(this);
        b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.paramsScroller = new ScrollPane();
        this.paramsPanel = new Panel();
        this.paramsScroller.add(this.paramsPanel);
        this.buildParamList();
        if (this.oldTexture instanceof LayeredTexture) {
            this.layoutLayered();
        } else {
            this.layoutSimple();
        }
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.updateComponents();
        this.sc.addTextureListener(this);
        this.show();
    }

    public void dispose() {
        this.sc.removeTextureListener(this);
        super.dispose();
    }

    public void setCallback(Callback cb) {
        this.callback = cb;
    }

    private void layoutSimple() {
        GridBagConstraints gc = new GridBagConstraints();
        this.remove(this.contentPanel);
        this.contentPanel = new Panel();
        this.contentPanel.setLayout(new GridBagLayout());
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.gridy = 0;
        this.contentPanel.add((Component)this.texList, gc);
        gc.weightx = 0.0;
        this.contentPanel.add((Component)this.preview, gc);
        gc.gridy = 1;
        gc.gridwidth = 2;
        this.paramsLabel = new Label("Texture Parameters");
        this.contentPanel.add((Component)this.paramsLabel, gc);
        gc.gridy = 2;
        this.contentPanel.add((Component)this.paramsScroller, gc);
        this.add((Component)this.contentPanel, "Center");
    }

    private void layoutLayered() {
        GridBagConstraints gc = new GridBagConstraints();
        this.remove(this.contentPanel);
        this.contentPanel = new Panel();
        this.contentPanel.setLayout(new GridBagLayout());
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridheight = 5;
        this.contentPanel.add((Component)this.texList, gc);
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridheight = 1;
        gc.gridx = 1;
        this.contentPanel.add((Component)this.addLayerButton, gc);
        this.contentPanel.add((Component)this.deleteLayerButton, gc);
        this.contentPanel.add((Component)this.moveUpButton, gc);
        this.contentPanel.add((Component)this.moveDownButton, gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.gridheight = 5;
        gc.gridx = 2;
        this.contentPanel.add((Component)this.layerList, gc);
        gc.gridheight = 1;
        gc.gridx = 3;
        this.contentPanel.add((Component)new Label("Blending mode:"), gc);
        this.contentPanel.add((Component)this.blendChoice, gc);
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.gridy = 5;
        this.paramsLabel = new Label("Texture Parameters");
        this.contentPanel.add((Component)this.paramsLabel, gc);
        gc.gridy = 6;
        this.contentPanel.add((Component)this.paramsScroller, gc);
        gc.gridx = 3;
        gc.insets.left = 5;
        this.contentPanel.add((Component)this.preview, gc);
        this.add((Component)this.contentPanel, "Center");
    }

    private void buildList() {
        this.texList.removeAll();
        int i = 0;
        while (i < this.textures.size()) {
            this.texList.add(((Texture)this.textures.elementAt(i)).getName());
            if (this.editObj.object.getTexture() == (Texture)this.textures.elementAt(i)) {
                this.texList.select(i);
            }
            ++i;
        }
    }

    private void buildParamList() {
        int index;
        TextureParameter[] params = this.editObj.object.getTexture() instanceof LayeredTexture ? ((index = this.layerList.getSelectedIndex()) == -1 ? new TextureParameter[]{} : ((LayeredMapping)this.editObj.object.getTextureMapping()).getLayerParameters(index)) : this.editObj.texParam;
        this.paramPerVertexBox = new Checkbox[params.length];
        this.paramValueField = new ValueField[params.length];
        this.paramValueSlider = new ValueSlider[params.length];
        this.fieldParamIndex = new int[params.length];
        this.paramsPanel.removeAll();
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.anchor = 18;
        int i = 0;
        while (i < params.length) {
            if (params[i].type == 0) {
                gc.gridy = i;
                gc.insets.left = 10;
                this.paramsPanel.add((Component)new Label(params[i].name), gc);
                double val = params[i].defaultVal;
                boolean perVertex = false;
                int j = 0;
                while (j < this.editObj.texParam.length) {
                    if (params[i].equals(this.editObj.texParam[j])) {
                        val = this.editObj.texParamValue[j];
                        perVertex = this.editObj.texParamPerVertex[j];
                        break;
                    }
                    ++j;
                }
                final int whichParam = j;
                final int whichField = i;
                this.fieldParamIndex[i] = j;
                if (Double.isInfinite(params[i].minVal) || Double.isInfinite(params[i].maxVal)) {
                    final TextureParameter p = params[i];
                    this.paramValueField[i] = new ValueField(val, 0, 5);
                    this.paramValueField[i].setEnabled(!perVertex);
                    this.paramValueField[i].setValueChecker(new ValueChecker(){

                        public boolean isValid(double v) {
                            return v >= p.minVal && v <= p.maxVal;
                        }
                    });
                    this.paramValueField[i].addTextListener(new TextListener(){

                        public void textValueChanged(TextEvent ev) {
                            if (whichParam >= ObjectTextureDialog.this.editObj.texParamValue.length) {
                                return;
                            }
                            ObjectTextureDialog.this.editObj.texParamValue[whichParam] = ObjectTextureDialog.this.preview.getObject().texParamValue[whichParam] = ObjectTextureDialog.this.paramValueField[whichField].getValue();
                            ObjectTextureDialog.this.preview.render();
                        }
                    });
                    this.paramsPanel.add((Component)this.paramValueField[i], gc);
                } else {
                    this.paramValueSlider[i] = new ValueSlider(params[i].minVal, params[i].maxVal, 50, val);
                    this.paramValueSlider[i].setEnabled(!perVertex);
                    this.paramValueSlider[i].addAdjustmentListener(new AdjustmentListener(){

                        public void adjustmentValueChanged(AdjustmentEvent ev) {
                            if (whichParam >= ObjectTextureDialog.this.editObj.texParamValue.length) {
                                return;
                            }
                            ObjectTextureDialog.this.editObj.texParamValue[whichParam] = ObjectTextureDialog.this.preview.getObject().texParamValue[whichParam] = ObjectTextureDialog.this.paramValueSlider[whichField].getValue();
                            ObjectTextureDialog.this.preview.render();
                        }
                    });
                    this.paramsPanel.add((Component)this.paramValueSlider[i], gc);
                }
                gc.insets.left = 10;
                this.paramPerVertexBox[i] = new Checkbox("Per Vertex", perVertex);
                this.paramsPanel.add((Component)this.paramPerVertexBox[i], gc);
                this.paramPerVertexBox[i].addItemListener(this);
            }
            ++i;
        }
        this.paramsPanel.validate();
        this.paramsScroller.validate();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        boolean layered = this.typeChoice.getSelectedIndex() == 1;
        int index = this.layerList.getSelectedIndex();
        Texture tex = null;
        if (command.equals("map")) {
            new TextureMappingDialog(this.fr, this.editObj.object, index);
            this.editObj.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
            this.preview.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
            this.preview.render();
            return;
        }
        if (command.equals("textures")) {
            this.sc.showTexturesDialog(this.fr);
            this.buildList();
            this.preview.render();
            return;
        }
        if (command.equals("add")) {
            this.preview.cancelRendering();
            tex = (Texture)this.textures.elementAt(this.texList.getSelectedIndex());
            this.layeredMap.addLayer(tex);
            this.layerList.addItem(tex.getName(), 0);
            this.layerList.select(0);
            this.resetParameters();
            this.updateComponents();
            return;
        }
        if (command.equals("delete")) {
            this.preview.cancelRendering();
            this.layeredMap.deleteLayer(index);
            this.layerList.delItem(index);
            this.resetParameters();
            this.updateComponents();
            return;
        }
        if (command.equals("moveup")) {
            this.preview.cancelRendering();
            String label = this.layerList.getItem(index);
            this.layeredMap.moveLayer(index, index - 1);
            this.layerList.delItem(index);
            this.layerList.addItem(label, index - 1);
            this.layerList.select(index - 1);
            this.resetParameters();
            this.updateComponents();
            return;
        }
        if (command.equals("movedown")) {
            this.preview.cancelRendering();
            String label = this.layerList.getItem(index);
            this.layeredMap.moveLayer(index, index + 1);
            this.layerList.delItem(index);
            this.layerList.addItem(label, index + 1);
            this.layerList.select(index + 1);
            this.resetParameters();
            this.updateComponents();
            return;
        }
        if (command.equals("cancel")) {
            this.dispose();
            if (this.callback != null) {
                this.callback.execute();
            }
            return;
        }
        int i = 0;
        while (i < this.obj.length) {
            if (this.editObj.object.getTexture() instanceof LayeredTexture) {
                LayeredMapping m = (LayeredMapping)this.editObj.object.getTextureMapping().duplicate();
                this.obj[i].setTexture(new LayeredTexture(m), m);
            } else {
                this.obj[i].setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping().duplicate());
            }
            System.arraycopy(this.editObj.texParamValue, 0, this.obj[i].texParamValue, 0, this.editObj.texParamValue.length);
            System.arraycopy(this.editObj.texParamPerVertex, 0, this.obj[i].texParamPerVertex, 0, this.editObj.texParamPerVertex.length);
            ++i;
        }
        if (this.fr instanceof LayoutWindow) {
            ((LayoutWindow)this.fr).updateImage();
            ((LayoutWindow)this.fr).getScore().tracksModified(false);
        }
        if (this.callback != null) {
            this.callback.execute();
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        boolean anyselection;
        Object src = e.getSource();
        boolean layered = this.typeChoice.getSelectedIndex() == 1;
        int i = 0;
        while (i < this.paramPerVertexBox.length) {
            if (src == this.paramPerVertexBox[i]) {
                boolean state = this.paramPerVertexBox[i].getState();
                int index = this.fieldParamIndex[i];
                if (this.paramValueField[i] != null) {
                    this.paramValueField[i].setEnabled(!state);
                }
                if (this.paramValueSlider[i] != null) {
                    this.paramValueSlider[i].setEnabled(!state);
                }
                this.editObj.texParamPerVertex[index] = state;
                this.preview.render();
                return;
            }
            ++i;
        }
        if (src == this.typeChoice) {
            if (!layered) {
                this.texList.select(0);
                this.updateComponents();
                this.layoutSimple();
                this.pack();
                ModellingApp.centerWindow(this);
                this.resetParameters();
            } else {
                this.preview.cancelRendering();
                this.editObj.setTexture(this.layeredTex, this.layeredMap);
                this.preview.setTexture(this.layeredTex, this.layeredMap);
                this.updateComponents();
                this.layoutLayered();
                this.pack();
                ModellingApp.centerWindow(this);
                this.resetParameters();
                return;
            }
        }
        if (src == this.blendChoice) {
            this.layeredMap.setLayerMode(this.layerList.getSelectedIndex(), this.blendChoice.getSelectedIndex());
            this.preview.render();
            return;
        }
        if (layered) {
            anyselection = this.layerList.getSelectedIndex() > -1;
        } else {
            boolean bl = anyselection = this.texList.getSelectedIndex() > -1;
        }
        if (!anyselection) {
            this.updateComponents();
            return;
        }
        Texture tex = layered ? this.layeredMap.getLayer(this.layerList.getSelectedIndex()) : (Texture)this.textures.elementAt(this.texList.getSelectedIndex());
        if (!layered) {
            if (tex == this.oldTexture) {
                this.editObj.setTexture(tex, this.oldMapping.duplicate());
            } else {
                this.editObj.setTexture(tex, tex.getDefaultMapping());
            }
            this.preview.setTexture(tex, this.editObj.object.getTextureMapping());
        }
        this.preview.render();
        this.updateComponents();
    }

    private void resetParameters() {
        this.preview.cancelRendering();
        this.editObj.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
        this.preview.getObject().setTexture(this.preview.getObject().object.getTexture(), this.preview.getObject().object.getTextureMapping());
        this.preview.render();
    }

    private void updateComponents() {
        boolean layered = this.typeChoice.getSelectedIndex() == 1;
        boolean anyselection = this.texList.getSelectedIndex() > -1;
        this.buildParamList();
        if (layered) {
            this.addLayerButton.setEnabled(anyselection);
            int index = this.layerList.getSelectedIndex();
            if (index == -1) {
                this.mapButton.setEnabled(false);
                this.deleteLayerButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.blendChoice.setEnabled(false);
                return;
            }
            Texture tex = this.layeredMap.getLayer(index);
            this.mapButton.setEnabled(true);
            this.deleteLayerButton.setEnabled(true);
            this.moveUpButton.setEnabled(index > 0);
            this.moveDownButton.setEnabled(index < this.layeredMap.getLayers().length - 1);
            this.blendChoice.setEnabled(true);
            this.blendChoice.select(this.layeredMap.getLayerMode(index));
        } else if (anyselection) {
            this.mapButton.setEnabled(true);
            Texture tex = (Texture)this.textures.elementAt(this.texList.getSelectedIndex());
        } else {
            this.mapButton.setEnabled(false);
        }
    }

    public void itemAdded(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.add(tex.getName(), index);
    }

    public void itemRemoved(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.remove(index);
        if (this.editObj.object.getTextureMapping() instanceof LayeredMapping) {
            Texture[] layers = this.layeredMap.getLayers();
            int i = layers.length - 1;
            while (i >= 0) {
                if (layers[i] == tex) {
                    this.layeredMap.deleteLayer(i);
                    this.layerList.remove(i);
                }
                --i;
            }
            this.preview.render();
            this.updateComponents();
        } else if (this.editObj.object.getTexture() == tex) {
            this.editObj.setTexture(this.sc.getDefaultTexture(), this.sc.getDefaultTexture().getDefaultMapping());
            this.preview.setTexture(this.editObj.object.getTexture(), this.editObj.object.getTextureMapping());
            this.preview.render();
            this.updateComponents();
        }
    }

    public void itemChanged(int index, Object obj) {
        Texture tex = (Texture)obj;
        this.texList.replaceItem(tex.getName(), index);
    }
}

