/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.DirectionalLight;
import artofillusion.ModellingApp;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.RenderingDialog;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;

public abstract class ObjectViewer
extends ViewerCanvas {
    boolean showScene;
    boolean useWorldCoords;
    boolean draggingBox;
    boolean squareBox;
    boolean sentClick;
    Point clickPoint;
    Point dragPoint;
    Object3D theObject;
    ObjectInfo objInfo;
    ObjectInfo thisObjectInScene;
    Scene theScene;
    static int lastRenderMode = 3;
    static boolean lastShowScene;
    static boolean lastUseWorldCoords;
    static boolean lastShowGrid;
    static boolean lastSnapToGrid;
    static int lastGridSubdivisions;
    static double lastGridSpacing;
    static final RGBColor surfaceRGB;
    static final Color surfaceColor;

    public ObjectViewer(ObjectInfo obj, Panel p) {
        if (obj != null) {
            this.theObject = obj.object;
            this.objInfo = obj.duplicate();
            this.objInfo.coords.setOrigin(new Vec3());
            this.objInfo.coords.setOrientation(Vec3.vz(), Vec3.vy());
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.buildChoices(p);
        this.setRenderMode(lastRenderMode);
        this.setSceneVisible(lastShowScene);
        this.setUseWorldCoords(lastUseWorldCoords);
        this.setGrid(lastGridSpacing, lastGridSubdivisions, lastShowGrid, lastSnapToGrid);
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.theObject = obj;
        if (this.objInfo == null) {
            this.objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        } else {
            this.objInfo.object = obj;
        }
        this.objInfo.clearCachedMeshes();
    }

    public synchronized void updateImage() {
        Dimension dim = this.getSize();
        this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
        super.updateImage();
        if (this.theImage == null || this.objInfo == null) {
            return;
        }
        if (this.gr != null) {
            this.gr.setColor(Color.black);
        }
        if (this.showScene && this.theScene != null) {
            Vector objects = this.theScene.getObjects();
            int i = 0;
            while (i < objects.size()) {
                ObjectInfo obj = (ObjectInfo)objects.elementAt(i);
                if (obj != this.thisObjectInScene && obj.visible) {
                    if (this.useWorldCoords) {
                        this.theCamera.setObjectTransform(obj.coords.fromLocal());
                    } else {
                        this.theCamera.setObjectTransform(this.thisObjectInScene.coords.toLocal().times(obj.coords.fromLocal()));
                    }
                    if (this.theCamera.visibility(obj.getBounds()) != 0) {
                        if (this.renderMode == 0) {
                            Object3D.draw(this.gr, this.theCamera, obj.getWireframePreview(), obj.getBounds());
                        } else {
                            RenderingMesh mesh = obj.getPreviewMesh();
                            if (mesh == null) {
                                this.renderWireframe(obj.getWireframePreview(), this.theCamera);
                            } else if (this.renderMode == 1) {
                                this.renderFlat(mesh, this.theCamera, obj.coords.toLocal().timesDirection(Vec3.vz()), obj.object.isClosed(), surfaceRGB);
                            } else if (this.renderMode == 2) {
                                this.renderSmooth(mesh, this.theCamera, obj.coords.toLocal().timesDirection(Vec3.vz()), obj.object.isClosed(), surfaceRGB);
                            } else {
                                this.renderFlatTransparent(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (this.useWorldCoords && this.thisObjectInScene != null) {
            this.theCamera.setObjectTransform(this.thisObjectInScene.coords.fromLocal());
        } else {
            this.theCamera.setObjectTransform(this.objInfo.coords.fromLocal());
        }
        this.drawObject(this.gr);
        this.drawBorder();
        if (this.renderMode != 0) {
            this.imageSource.newPixels();
        }
    }

    abstract void drawObject(Graphics var1);

    public CoordinateSystem getDisplayCoordinates() {
        if (this.useWorldCoords && this.thisObjectInScene != null) {
            return this.thisObjectInScene.coords;
        }
        return this.objInfo.coords;
    }

    public void setRenderMode(int mode) {
        super.setRenderMode(mode);
        lastRenderMode = mode;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setScene(Scene sc, ObjectInfo thisObject) {
        this.theScene = sc;
        this.thisObjectInScene = thisObject;
    }

    public boolean getSceneVisible() {
        return this.showScene;
    }

    public void setSceneVisible(boolean visible) {
        lastShowScene = this.showScene = visible;
    }

    public boolean getUseWorldCoords() {
        return this.useWorldCoords;
    }

    public void setUseWorldCoords(boolean use) {
        lastUseWorldCoords = this.useWorldCoords = use;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        super.setGrid(spacing, subdivisions, show, snap);
        lastGridSpacing = spacing;
        lastGridSubdivisions = subdivisions;
        lastShowGrid = show;
        lastSnapToGrid = snap;
    }

    public void beginDraggingBox(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
    }

    public void mouseDragged(MouseEvent e) {
        Graphics g = this.getGraphics();
        this.moveToGrid(e);
        if (this.draggingBox) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            if (this.dragPoint != null) {
                g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        g.dispose();
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    public void previewObject() {
        Scene sc = new Scene();
        Container parent = this.getParent();
        double dist = this.theCamera.getDistToScreen();
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), this.theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.objInfo, null);
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        this.adjustCamera(true);
        ModellingApp.previewRenderer().configurePreview();
        new RenderingDialog((Frame)parent, ModellingApp.previewRenderer(), sc, this.theCamera, dist / 2.0, dist);
        this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
    }

    static {
        lastGridSubdivisions = 10;
        lastGridSpacing = 1.0;
        surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
        surfaceColor = new Color(0.8f, 0.8f, 1.0f);
    }
}

