/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.ColorChooser;
import artofillusion.EditingWindow;
import artofillusion.Light;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class PointLight
extends Light {
    double radius;
    static BoundingBox bounds;
    static WireframeMesh mesh;

    public PointLight(RGBColor theColor, float theIntensity, double theRadius) {
        this.setParameters(theColor, theIntensity, false, 0.25f);
        this.setRadius(theRadius);
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public Object3D duplicate() {
        return new PointLight(this.color, this.intensity, this.radius);
    }

    public void copyObject(Object3D obj) {
        PointLight lt = (PointLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.ambient, lt.decayRate);
        this.setRadius(lt.radius);
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetMaterial() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        Panel patch = this.color.getSample(50, 30);
        ValueField intensityField = new ValueField(this.intensity, 0);
        ValueField radiusField = new ValueField(this.radius, 1);
        ValueField decayField = new ValueField(this.decayRate, 1);
        Checkbox ambientBox = new Checkbox("Ambient", this.ambient);
        RGBColor oldColor = this.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", PointLight.this.color);
                ((Component)e.getSource()).setBackground(PointLight.this.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, "Parameters for point light:", new Component[]{patch, intensityField, radiusField, decayField, ambientBox}, new String[]{"Color", "Intensity", "Radius", "Decay Rate", ""});
        if (!dlg.clickedOk()) {
            this.color.copy(oldColor);
            return;
        }
        this.setParameters(this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
        this.setRadius(radiusField.getValue());
        cb.execute();
    }

    public PointLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), in.readBoolean(), in.readFloat());
        this.setRadius(in.readDouble());
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeBoolean(this.ambient);
        out.writeFloat(this.decayRate);
        out.writeDouble(this.radius);
    }

    public Keyframe getPoseKeyframe() {
        return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
    }

    public void applyPoseKeyframe(Keyframe k) {
        PointLightKeyframe key = (PointLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.ambient, key.decayRate);
        this.setRadius(key.radius);
    }

    public String[] getPoseValueNames() {
        return new String[]{"Intensity", "Decay Rate", "Radius"};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{this.intensity, this.decayRate, this.radius};
    }

    public double[][] getPoseValueRange() {
        return new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final PointLightKeyframe key = (PointLightKeyframe)k;
        Panel patch = key.color.getSample(50, 30);
        ValueField intensityField = new ValueField(key.intensity, 0);
        ValueField radiusField = new ValueField(key.radius, 1);
        ValueField decayField = new ValueField(key.decayRate, 1);
        RGBColor oldColor = key.color.duplicate();
        final Frame parentFrame = (Frame)((Object)parent);
        patch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                new ColorChooser(parentFrame, "Light Color", key.color);
                ((Component)e.getSource()).setBackground(key.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, "Parameters for point light:", new Component[]{patch, intensityField, radiusField, decayField}, new String[]{"Color", "Intensity", "Radius", "Decay Rate"});
        if (!dlg.clickedOk()) {
            key.color.copy(oldColor);
            return;
        }
        key.intensity = (float)intensityField.getValue();
        key.decayRate = (float)decayField.getValue();
        key.radius = radiusField.getValue();
    }

    static {
        double r1 = 0.05;
        double r2 = 0.25;
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
        Vec3[] vert = new Vec3[28];
        int[] from = new int[14];
        int[] to = new int[14];
        vert[0] = new Vec3(r1, 0.0, 0.0);
        vert[1] = new Vec3(r2, 0.0, 0.0);
        from[0] = 0;
        to[0] = 1;
        vert[2] = new Vec3(-r1, 0.0, 0.0);
        vert[3] = new Vec3(-r2, 0.0, 0.0);
        from[1] = 2;
        to[1] = 3;
        vert[4] = new Vec3(0.0, r1, 0.0);
        vert[5] = new Vec3(0.0, r2, 0.0);
        from[2] = 4;
        to[2] = 5;
        vert[6] = new Vec3(0.0, -r1, 0.0);
        vert[7] = new Vec3(0.0, -r2, 0.0);
        from[3] = 6;
        to[3] = 7;
        vert[8] = new Vec3(0.0, 0.0, r1);
        vert[9] = new Vec3(0.0, 0.0, r2);
        from[4] = 8;
        to[4] = 9;
        vert[10] = new Vec3(0.0, 0.0, -r1);
        vert[11] = new Vec3(0.0, 0.0, -r2);
        from[5] = 10;
        to[5] = 11;
        r1 *= 0.57735;
        r2 *= 0.57735;
        int ind1 = 12;
        int ind2 = 6;
        double i = -1.0;
        while (i < 2.0) {
            double j = -1.0;
            while (j < 2.0) {
                double k = -1.0;
                while (k < 2.0) {
                    vert[ind1++] = new Vec3(r1 * i, r1 * j, r1 * k);
                    vert[ind1++] = new Vec3(r2 * i, r2 * j, r2 * k);
                    from[ind2] = ind1 - 2;
                    to[ind2++] = ind1 - 1;
                    k += 2.0;
                }
                j += 2.0;
            }
            i += 2.0;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class PointLightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public float decayRate;
        public double radius;

        public PointLightKeyframe(RGBColor color, float intensity, float decayRate, double radius) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.decayRate = decayRate;
            this.radius = radius;
        }

        public Keyframe duplicate() {
            return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
        }

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public double[] getGraphValues() {
            return new double[]{this.intensity, this.decayRate, this.radius};
        }

        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.decayRate = (float)values[1];
            this.radius = values[2];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate), weight1 * this.radius + weight2 * k2.radius);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            PointLightKeyframe k3 = (PointLightKeyframe)o3;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            PointLightKeyframe k3 = (PointLightKeyframe)o3;
            PointLightKeyframe k4 = (PointLightKeyframe)o4;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed() + weight4 * (double)k4.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen() + weight4 * (double)k4.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue() + weight4 * (double)k4.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity + weight4 * (double)k4.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate + weight4 * (double)k4.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof PointLightKeyframe)) {
                return false;
            }
            PointLightKeyframe key = (PointLightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.decayRate == this.decayRate && key.radius == this.radius;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
            out.writeDouble(this.radius);
        }

        public PointLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat(), in.readDouble());
        }
    }
}

