/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.RGBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Panel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RGBColor {
    float red;
    float green;
    float blue;

    public RGBColor() {
    }

    public RGBColor(float r, float g, float b) {
        this.setRGB(r, g, b);
    }

    public RGBColor(double r, double g, double b) {
        this.setRGB(r, g, b);
    }

    public final void setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public final void setRGB(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public final float getRed() {
        return this.red;
    }

    public final float getGreen() {
        return this.green;
    }

    public final float getBlue() {
        return this.blue;
    }

    public final boolean equals(RGBColor c) {
        return c.red == this.red && c.green == this.green && c.blue == this.blue;
    }

    public final RGBColor duplicate() {
        return new RGBColor(this.red, this.green, this.blue);
    }

    public final void copy(RGBColor color) {
        this.setRGB(color.red, color.green, color.blue);
    }

    public final Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public Panel getSample(int width, int height) {
        class Sample
        extends Panel {
            int w;
            int h;
            private final /* synthetic */ RGBColor this$0;

            public Sample(RGBColor this$0, int wid, int ht) {
                this.this$0 = this$0;
                this.w = wid;
                this.h = ht;
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.w, this.h);
            }
        }
        Sample p = new Sample(this, width, height);
        p.setBackground(this.getColor());
        return p;
    }

    public final int getARGB() {
        int r = (int)((double)this.red * 255.0);
        int g = (int)((double)this.green * 255.0);
        int b = (int)((double)this.blue * 255.0);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public final void setARGB(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        this.setRGB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public final void add(RGBColor color) {
        this.red += color.red;
        this.green += color.green;
        this.blue += color.blue;
    }

    public final void subtract(RGBColor color) {
        this.red -= color.red;
        this.green -= color.green;
        this.blue -= color.blue;
    }

    public final void multiply(RGBColor color) {
        this.red *= color.red;
        this.green *= color.green;
        this.blue *= color.blue;
    }

    public final void add(float r, float g, float b) {
        this.red += r;
        this.green += g;
        this.blue += b;
    }

    public final void subtract(float r, float g, float b) {
        this.red -= r;
        this.green -= g;
        this.blue -= b;
    }

    public final void multiple(float r, float g, float b) {
        this.red *= r;
        this.green *= g;
        this.blue *= b;
    }

    public final void scale(float s) {
        this.red *= s;
        this.green *= s;
        this.blue *= s;
    }

    public final void scale(double s) {
        float f = (float)s;
        this.red *= f;
        this.green *= f;
        this.blue *= f;
    }

    public final float getBrightness() {
        return 0.2125f * this.red + 0.7154f * this.green + 0.0721f * this.blue;
    }

    public final void setHSV(float h, float s, float v) {
        if (s == 0.0f) {
            this.setRGB(v, v, v);
            return;
        }
        h = h == 360.0f ? 0.0f : (h /= 60.0f);
        int i = (int)h;
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                this.setRGB(v, t, p);
                break;
            }
            case 1: {
                this.setRGB(q, v, p);
                break;
            }
            case 2: {
                this.setRGB(p, v, t);
                break;
            }
            case 3: {
                this.setRGB(p, q, v);
                break;
            }
            case 4: {
                this.setRGB(t, p, v);
                break;
            }
            case 5: {
                this.setRGB(v, p, q);
            }
        }
    }

    public final float[] getHSV() {
        float min;
        float max = Math.max(this.red, Math.max(this.blue, this.green));
        if (max == (min = Math.min(this.red, Math.min(this.blue, this.green)))) {
            return new float[]{0.0f, 0.0f, max};
        }
        float h = this.red == max ? (this.green - this.blue) / (max - min) : (this.green == max ? 2.0f + (this.blue - this.red) / (max - min) : 4.0f + (this.red - this.green) / (max - min));
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        return new float[]{h, (max - min) / max, max};
    }

    public final void setHLS(float h, float l, float s) {
        float m2 = l <= 0.5f ? l + l * s : l + s - l * s;
        float m1 = 2.0f * l - m2;
        if (s == 0.0f) {
            this.setRGB(l, l, l);
        } else {
            this.setRGB(RGBColor.value(m1, m2, h + 120.0f), RGBColor.value(m1, m2, h), RGBColor.value(m1, m2, h - 120.0f));
        }
    }

    static final float value(float n1, float n2, float hue) {
        if (hue > 360.0f) {
            hue -= 360.0f;
        } else if (hue < 0.0f) {
            hue += 360.0f;
        }
        if (hue < 60.0f) {
            return n1 + (n2 - n1) * hue / 60.0f;
        }
        if (hue < 180.0f) {
            return n2;
        }
        if (hue < 240.0f) {
            return n1 + (n2 - n1) * (240.0f - hue) / 60.0f;
        }
        return n1;
    }

    public final float[] getHLS() {
        float min;
        float max = Math.max(this.red, Math.max(this.blue, this.green));
        if (max == (min = Math.min(this.red, Math.min(this.blue, this.green)))) {
            return new float[]{0.0f, max, 0.0f};
        }
        float l = (max + min) / 2.0f;
        float delta = max - min;
        float h = this.red == max ? (this.green - this.blue) / delta : (this.green == max ? 2.0f + (this.blue - this.red) / delta : 4.0f + (this.red - this.green) / delta);
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        if (l < 0.5f) {
            return new float[]{h, l, delta / (max + min)};
        }
        return new float[]{h, l, delta / (2.0f - max - min)};
    }

    public final float[] getYCrCb() {
        float Y = 0.257f * this.red + 0.504f * this.green + 0.098f * this.blue + 0.0625f;
        float Cr = 0.439f * this.red - 0.368f * this.green - 0.071f * this.blue + 0.5f;
        float Cb = -(0.148f * this.red) - 0.291f * this.green + 0.439f * this.blue + 0.5f;
        Y = Math.max(0.0f, Math.min(1.0f, Y));
        Cr = Math.max(0.0f, Math.min(1.0f, Cr));
        Cb = Math.max(0.0f, Math.min(1.0f, Cb));
        return new float[]{Y, Cr, Cb};
    }

    public final void setYCrCb(float Y, float Cr, float Cb) {
        Y = 1.164f * (Y - 0.0625f);
        this.red = Y + 1.596f * (Cr -= 0.5f);
        this.green = Y - 0.813f * Cr - 0.391f * (Cb -= 0.5f);
        this.blue = Y + 2.018f * Cb;
        this.red = Math.max(0.0f, Math.min(1.0f, this.red));
        this.green = Math.max(0.0f, Math.min(1.0f, this.green));
        this.blue = Math.max(0.0f, Math.min(1.0f, this.blue));
    }

    public RGBColor(DataInputStream in) throws IOException {
        this.red = in.readFloat();
        this.green = in.readFloat();
        this.blue = in.readFloat();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeFloat(this.red);
        out.writeFloat(this.green);
        out.writeFloat(this.blue);
    }

    public String toString() {
        return "RGBColor: " + this.red + ", " + this.green + ", " + this.blue;
    }
}

