/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.RenderingTriangle;
import artofillusion.Vec3;

public class RenderingMesh {
    public Vec3[] vert;
    public Vec3[] norm;
    public Vec3[] faceNorm;
    public double[][] param;
    public double[] paramTemp;
    public RenderingTriangle[] triangle;

    public RenderingMesh(Vec3[] vert, Vec3[] norm, RenderingTriangle[] triangle) {
        this.vert = vert;
        this.norm = norm;
        this.triangle = triangle;
        this.faceNorm = new Vec3[triangle.length];
        int i = 0;
        while (i < triangle.length) {
            this.faceNorm[i] = vert[triangle[i].v2].minus(vert[triangle[i].v1]).cross(vert[triangle[i].v3].minus(vert[triangle[i].v1]));
            double length = this.faceNorm[i].length();
            if (length > 0.0) {
                this.faceNorm[i].scale(1.0 / length);
            }
            triangle[i].setMesh(this);
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < triangle.length) {
            if (norm[triangle[i].n1] == null || norm[triangle[i].n2] == null || norm[triangle[i].n3] == null) {
                ++j;
            }
            ++i;
        }
        if (j == 0) {
            return;
        }
        Vec3[] newNorm = new Vec3[norm.length + j];
        i = 0;
        while (i < norm.length) {
            newNorm[i] = norm[i];
            ++i;
        }
        i = 0;
        j = norm.length;
        while (i < triangle.length) {
            if (norm[triangle[i].n1] == null || norm[triangle[i].n2] == null || norm[triangle[i].n3] == null) {
                newNorm[j] = this.faceNorm[i];
                if (norm[triangle[i].n1] == null) {
                    triangle[i].n1 = j;
                }
                if (norm[triangle[i].n2] == null) {
                    triangle[i].n2 = j;
                }
                if (norm[triangle[i].n3] == null) {
                    triangle[i].n3 = j;
                }
                ++j;
            }
            ++i;
        }
        this.norm = newNorm;
    }

    public void setParameters(double[][] param) {
        this.param = param;
        this.paramTemp = new double[param[0].length];
        int i = 0;
        while (i < this.triangle.length) {
            this.triangle[i].setParameters(param[this.triangle[i].v1], param[this.triangle[i].v2], param[this.triangle[i].v3]);
            ++i;
        }
    }

    public void setParameters(double[] p) {
        this.param = new double[this.vert.length][];
        int i = 0;
        while (i < this.param.length) {
            this.param[i] = p;
            ++i;
        }
        this.setParameters(this.param);
    }
}

