/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.TextureMapping;
import artofillusion.TextureSpec;

public abstract class RenderingTriangle {
    public int v1;
    public int v2;
    public int v3;
    public int n1;
    public int n2;
    public int n3;
    public TextureMapping mapping;
    public RenderingMesh theMesh;

    public RenderingTriangle(int v1, int v2, int v3, int n1, int n2, int n3, TextureMapping theMapping) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.n1 = n1;
        this.n2 = n2;
        this.n3 = n3;
        this.mapping = theMapping;
    }

    public abstract void getTextureSpec(TextureSpec var1, boolean var2, double var3, double var5, double var7, double var9, double var11);

    public abstract void getTransparency(RGBColor var1, boolean var2, double var3, double var5, double var7, double var9, double var11);

    public abstract double getDisplacement(double var1, double var3, double var5, double var7, double var9);

    public void setMesh(RenderingMesh mesh) {
        this.theMesh = mesh;
    }

    public void setParameters(double[] p1, double[] p2, double[] p3) {
    }

    public double[] getParameters(double u, double v, double w) {
        double[] param = this.theMesh.paramTemp;
        if (param == null) {
            return null;
        }
        double[] p1 = this.theMesh.param[this.v1];
        double[] p2 = this.theMesh.param[this.v2];
        double[] p3 = this.theMesh.param[this.v3];
        int i = param.length - 1;
        while (i >= 0) {
            param[i] = u * p1[i] + v * p2[i] + w * p3[i];
            --i;
        }
        return param;
    }
}

