/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.Mat4;
import artofillusion.Mesh;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshVertex;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.Vec2;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RotateMeshTool
extends EditingTool {
    boolean noSelection;
    boolean notOnHandle;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Point centerPoint;
    Vec3 rotCenter;
    int hdirection;
    int vdirection;
    int whichAxis;
    BoundingBox bounds;
    public static final int HANDLE_SIZE = 5;
    static final double DRAG_SCALE = Math.PI / 360;
    static final int XAXIS = 0;
    static final int YAXIS = 1;
    static final int ZAXIS = 2;
    static final String helpText = "Drag a handle to rotate selected points.  Control-click to move center of rotation.";

    public RotateMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("rotatePoints.gif");
        selectedIcon = this.loadImage("selected/rotatePoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = ((MeshEditorWindow)this.theFrame).theView;
        Mesh mesh = (Mesh)((Object)view.getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                this.theWindow.setHelpText(helpText);
                this.bounds = this.findSelectionBounds(v, cam, view);
                this.rotCenter = new Vec3((this.bounds.minx + this.bounds.maxx) / 2.0, (this.bounds.miny + this.bounds.maxy) / 2.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
                this.rotCenter = cam.getViewToWorld().times(this.rotCenter);
                return;
            }
            ++i;
        }
        this.theWindow.setHelpText("No points are selected to rotate.");
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        Vec2 p = cam.getWorldToScreen().timesXY(this.rotCenter);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y, 5, 5);
            g.fillRect(b.x, b.y + (b.height - 5) / 2, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + (b.height - 5) / 2, 5, 5);
            int px = (int)p.x;
            int py = (int)p.y;
            g.drawLine(px - 5, py - 5, px + 5, py + 5);
            g.drawLine(px - 5, py + 5, px + 5, py - 5);
        }
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        if (e.isControlDown()) {
            this.rotCenter = cam.convertScreenToWorld(this.clickPoint, this.rotCenter.z);
            view.repaint();
            this.notOnHandle = true;
            return;
        }
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        this.notOnHandle = false;
        if (!b.contains(this.clickPoint)) {
            this.notOnHandle = true;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + (b.width - 5) / 2 && this.clickPoint.x <= b.x + (b.width - 5) / 2 + 5 ? 1 : (this.clickPoint.x >= b.x + b.width - 5 ? 2 : -1));
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + (b.height - 5) / 2 && this.clickPoint.y <= b.y + (b.height - 5) / 2 + 5 ? 1 : (this.clickPoint.y >= b.y + b.height - 5 ? 2 : -1));
        if (j == -1 || k == -1 || j == 1 && k == 1) {
            this.notOnHandle = true;
            return;
        }
        this.notOnHandle = false;
        if (j == 1) {
            this.whichAxis = 0;
            this.hdirection = 0;
            this.vdirection = -1;
        } else if (k == 1) {
            this.whichAxis = 1;
            this.vdirection = 0;
            this.hdirection = 1;
        } else {
            this.whichAxis = 2;
            this.vdirection = j == 0 ? -1 : 1;
            this.hdirection = k == 0 ? 1 : -1;
        }
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        Graphics g = view.getGraphics();
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        Vec3[] v = this.findRotatedPositions(vert, angle, (MeshViewer)view);
        view.drawImage(g);
        g.setColor(Color.gray);
        int i = 0;
        while (i < v.length) {
            if (selectDist[i] > -1) {
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - vertSize / 2, (int)p.y - vertSize / 2, vertSize, vertSize);
            }
            ++i;
        }
        ((MeshViewer)view).drawDraggedSelection(g, cam, v);
        this.theWindow.setHelpText("Rotation angle: " + (double)Math.round(angle * 100000.0 * 180.0 / Math.PI) / 100000.0 + " degrees");
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        Vec3[] v = this.findRotatedPositions(vert, angle, (MeshViewer)view);
        mesh.setVertices(v);
        this.theWindow.updateImage();
        this.theWindow.setHelpText(helpText);
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        int i = 0;
        while (i < vert.length) {
            if (selected[i] == 0) {
                Vec3 v = cam.getObjectToView().times(vert[i].r);
                if (v.x < minx) {
                    minx = v.x;
                }
                if (v.x > maxx) {
                    maxx = v.x;
                }
                if (v.y < miny) {
                    miny = v.y;
                }
                if (v.y > maxy) {
                    maxy = v.y;
                }
                if (v.z < minz) {
                    minz = v.z;
                }
                if (v.z > maxz) {
                    maxz = v.z;
                }
            }
            ++i;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        return r;
    }

    Vec3[] findRotatedPositions(MeshVertex[] vert, double angle, MeshViewer view) {
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        CoordinateSystem coords = view.getDisplayCoordinates();
        Mat4 m = coords.fromLocal();
        m = Mat4.translation(-this.rotCenter.x, -this.rotCenter.y, -this.rotCenter.z).times(m);
        Vec3 axis = this.whichAxis == 0 ? cam.getViewToWorld().timesDirection(Vec3.vx()) : (this.whichAxis == 1 ? cam.getViewToWorld().timesDirection(Vec3.vy()) : cam.getViewToWorld().timesDirection(Vec3.vz()));
        m = Mat4.axisRotation(axis, angle).times(m);
        m = Mat4.translation(this.rotCenter.x, this.rotCenter.y, this.rotCenter.z).times(m);
        m = coords.toLocal().times(m);
        int i = 0;
        while (i < vert.length) {
            v[i] = selected[i] == 0 ? m.times(vert[i].r).minus(vert[i].r) : new Vec3();
            ++i;
        }
        ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        i = 0;
        while (i < vert.length) {
            v[i].add(vert[i].r);
            ++i;
        }
        return v;
    }
}

