/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.Mat4;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EventProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class RotateObjectTool
extends EditingTool {
    static final int X_ONLY = 1;
    static final int Y_ONLY = 2;
    static final int Z_ONLY = 3;
    static final int ALL_AXES = 4;
    static final int OBJECT_CENTER = 0;
    static final int PARENT_CENTER = 1;
    static final int SELECTION_CENTER = 2;
    static final double DRAG_SCALE = Math.PI / 360;
    static final String helpText = "Drag to rotate selected objects.  Drag a handle to constrain rotation.  Double-click icon for options.";
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vector toMove;
    ObjectInfo clickedObject;
    int whichAxes;
    int rotateAround = 1;
    boolean dragged;
    boolean applyToChildren = true;
    Vec3 rotAxis;
    Vec3[] rotationCenter;
    CoordinateSystem[] objectCoords;
    EventProcessor process;

    public RotateObjectTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("rotate.gif");
        selectedIcon = this.loadImage("selected/rotate.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(helpText);
    }

    public int whichClicks() {
        return 3;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressedOnObject(MouseEvent e, ViewerCanvas view, int obj) {
        Scene theScene = this.theWindow.getScene();
        int numSelected = 0;
        Vec3 center = new Vec3();
        this.toMove = new Vector();
        Vector objects = theScene.getObjects();
        this.clickedObject = (ObjectInfo)objects.elementAt(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(objects.elementAt(sel[i]));
            ++i;
        }
        this.objectCoords = new CoordinateSystem[this.toMove.size()];
        this.rotationCenter = new Vec3[this.toMove.size()];
        i = 0;
        while (i < this.objectCoords.length) {
            ObjectInfo info;
            ObjectInfo parent = info = (ObjectInfo)this.toMove.elementAt(i);
            this.objectCoords[i] = info.coords.duplicate();
            if (this.rotateAround == 2) {
                this.rotationCenter[i] = center;
                if (info.selected) {
                    center.add(info.coords.getOrigin());
                    ++numSelected;
                }
            } else {
                this.rotationCenter[i] = info.coords.getOrigin();
            }
            if (this.rotateAround == 1) {
                while (parent.parent != null) {
                    parent = parent.parent;
                    if (!parent.selected) continue;
                    this.rotationCenter[i] = parent.coords.getOrigin();
                }
            }
            ++i;
        }
        if (numSelected > 0) {
            center.scale(1.0 / (double)numSelected);
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
        this.whichAxes = 4;
        this.process = new EventProcessor();
    }

    public void mousePressedOnHandle(MouseEvent e, ViewerCanvas view, int obj, int handle) {
        this.mousePressedOnObject(e, view, obj);
        if (handle == 1 || handle == 6) {
            this.whichAxes = 1;
            this.rotAxis = new Vec3(1.0, 0.0, 0.0);
        } else if (handle == 3 || handle == 4) {
            this.whichAxes = 2;
            this.rotAxis = new Vec3(0.0, -1.0, 0.0);
        } else {
            this.whichAxes = 3;
            this.rotAxis = handle < 4 ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 0.0, -1.0);
        }
        this.rotAxis = view.getCamera().getViewToWorld().timesDirection(this.rotAxis);
    }

    public void mouseDragged(final MouseEvent e, final ViewerCanvas view) {
        Callback c = new Callback(){

            public void execute() {
                double angle;
                CoordinateSystem c;
                ObjectInfo info;
                int i;
                Scene theScene = RotateObjectTool.this.theWindow.getScene();
                Point dragPoint = e.getPoint();
                if (!RotateObjectTool.this.dragged) {
                    UndoRecord undo = new UndoRecord(RotateObjectTool.this.theWindow, false);
                    RotateObjectTool.this.theWindow.setUndoRecord(undo);
                    i = 0;
                    while (i < RotateObjectTool.this.toMove.size()) {
                        info = (ObjectInfo)RotateObjectTool.this.toMove.elementAt(i);
                        c = info.coords;
                        undo.addCommand(1, new Object[]{c, c.duplicate()});
                        ++i;
                    }
                    RotateObjectTool.this.dragged = true;
                }
                if (RotateObjectTool.this.whichAxes == 1) {
                    angle = (double)(RotateObjectTool.this.clickPoint.y - dragPoint.y) * (Math.PI / 360);
                } else if (RotateObjectTool.this.whichAxes == 2) {
                    angle = (double)(RotateObjectTool.this.clickPoint.x - dragPoint.x) * (Math.PI / 360);
                } else if (RotateObjectTool.this.whichAxes == 3) {
                    angle = (double)(dragPoint.x - RotateObjectTool.this.clickPoint.x) * (Math.PI / 360);
                } else {
                    RotateObjectTool.this.rotAxis = new Vec3((double)(RotateObjectTool.this.clickPoint.y - dragPoint.y) * (Math.PI / 360), (double)(dragPoint.x - RotateObjectTool.this.clickPoint.x) * (Math.PI / 360), 0.0);
                    angle = RotateObjectTool.this.rotAxis.length();
                    RotateObjectTool.this.rotAxis = RotateObjectTool.this.rotAxis.times(1.0 / angle);
                    RotateObjectTool.this.rotAxis = view.getCamera().getViewToWorld().timesDirection(RotateObjectTool.this.rotAxis);
                }
                if (angle != 0.0) {
                    i = 0;
                    while (i < RotateObjectTool.this.toMove.size()) {
                        info = (ObjectInfo)RotateObjectTool.this.toMove.elementAt(i);
                        c = info.coords;
                        Vec3 origin = RotateObjectTool.this.rotationCenter[i];
                        Mat4 rotMatrix = Mat4.translation(origin.x, origin.y, origin.z).times(Mat4.axisRotation(RotateObjectTool.this.rotAxis, angle)).times(Mat4.translation(-origin.x, -origin.y, -origin.z));
                        c.copyCoords(RotateObjectTool.this.objectCoords[i]);
                        c.transformCoordinates(rotMatrix);
                        ++i;
                    }
                }
                RotateObjectTool.this.theWindow.updateImage();
                RotateObjectTool.this.theWindow.setHelpText("Rotation angle: " + (double)Math.round(angle * 100000.0 * 180.0 / Math.PI) / 100000.0 + " degrees");
            }
        };
        this.process.addEvent(c);
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        if (this.process != null) {
            this.process.stopProcessing();
        }
        this.process = null;
        this.theWindow.setHelpText(helpText);
        this.toMove = null;
        this.objectCoords = null;
        this.rotationCenter = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(KeyEvent e, ViewerCanvas view) {
        Scene theScene = this.theWindow.getScene();
        Vec3 center = new Vec3();
        int key = e.getKeyCode();
        int numSelected = 0;
        Vector objects = theScene.getObjects();
        if (e.isControlDown()) {
            if (key == 38 || key == 39) {
                this.rotAxis = new Vec3(0.0, 0.0, 1.0);
            } else {
                if (key != 40 && key != 37) return;
                this.rotAxis = new Vec3(0.0, 0.0, -1.0);
            }
        } else if (key == 38) {
            this.rotAxis = new Vec3(1.0, 0.0, 0.0);
        } else if (key == 40) {
            this.rotAxis = new Vec3(-1.0, 0.0, 0.0);
        } else if (key == 37) {
            this.rotAxis = new Vec3(0.0, -1.0, 0.0);
        } else {
            if (key != 39) return;
            this.rotAxis = new Vec3(0.0, 1.0, 0.0);
        }
        this.rotAxis = view.getCamera().getViewToWorld().timesDirection(this.rotAxis);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        this.toMove = new Vector();
        int i = 0;
        while (i < sel.length) {
            this.toMove.addElement(objects.elementAt(sel[i]));
            ++i;
        }
        this.rotationCenter = new Vec3[this.toMove.size()];
        int i2 = 0;
        while (i2 < this.rotationCenter.length) {
            ObjectInfo info;
            ObjectInfo parent = info = (ObjectInfo)this.toMove.elementAt(i2);
            if (this.rotateAround == 2) {
                this.rotationCenter[i2] = center;
                if (info.selected) {
                    center.add(info.coords.getOrigin());
                    ++numSelected;
                }
            } else {
                this.rotationCenter[i2] = info.coords.getOrigin();
            }
            if (this.rotateAround == 1) {
                while (parent.parent != null) {
                    parent = parent.parent;
                    if (!parent.selected) continue;
                    this.rotationCenter[i2] = parent.coords.getOrigin();
                }
            }
            ++i2;
        }
        if (numSelected > 0) {
            center.scale(1.0 / (double)numSelected);
        }
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        int i3 = 0;
        while (i3 < this.toMove.size()) {
            ObjectInfo info = (ObjectInfo)this.toMove.elementAt(i3);
            CoordinateSystem c = info.coords;
            Vec3 origin = this.rotationCenter[i3];
            Mat4 rotMatrix = Mat4.translation(origin.x, origin.y, origin.z).times(Mat4.axisRotation(this.rotAxis, Math.PI / 360)).times(Mat4.translation(-origin.x, -origin.y, -origin.z));
            undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.transformCoordinates(rotMatrix);
            ++i3;
        }
        this.theWindow.updateImage();
        this.theWindow.setHelpText(helpText);
        this.toMove = null;
        this.rotationCenter = null;
    }

    public void iconDoubleClicked() {
        Checkbox childrenBox = new Checkbox("Apply to unselected children of selected objects", this.applyToChildren);
        Choice centerChoice = new Choice();
        Panel p = new Panel();
        centerChoice.add("Individual Object Origins");
        centerChoice.add("Parent Object");
        centerChoice.add("Center of Selection");
        centerChoice.select(this.rotateAround);
        p.add(new Label("Rotate Around"));
        p.add(centerChoice);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, "Options for Rotate Tool:", new Component[]{childrenBox, p}, new String[]{"", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
        this.rotateAround = centerChoice.getSelectedIndex();
    }
}

