/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import Jama.Matrix;
import Jama.SingularValueDecomposition;

public class SVD {
    public static void solve(double[][] a, double[] b) {
        SVD.solve(a, b, 1.0E-8);
    }

    public static void solve(double[][] a, double[] b, double tol) {
        int j;
        double d;
        int m = a.length;
        int n = a[0].length;
        Matrix mat = new Matrix(a, m, n);
        SingularValueDecomposition svd = mat.svd();
        double[][] u = svd.getU().getArray();
        double[][] v = svd.getV().getArray();
        double[] s = svd.getSingularValues();
        double cutoff = s[0] * tol;
        double[] temp = new double[n];
        int i = 0;
        while (i < n && s[i] > cutoff) {
            d = 0.0;
            j = 0;
            while (j < m) {
                d += u[j][i] * b[j];
                ++j;
            }
            temp[i] = d / s[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            d = 0.0;
            j = 0;
            while (j < n) {
                d += v[i][j] * temp[j];
                ++j;
            }
            b[i] = d;
            ++i;
        }
    }
}

