/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.Mat4;
import artofillusion.Mesh;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshVertex;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.Vec2;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ScaleMeshTool
extends EditingTool {
    boolean noSelection;
    boolean notOnHandle;
    boolean scaleX;
    boolean scaleY;
    boolean scaleAll;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    double clickX;
    double clickY;
    double centerX;
    double centerY;
    Vec3 scaleCenter;
    BoundingBox bounds;
    public static final int HANDLE_SIZE = 5;
    static final String helpText = "Drag a handle to scale selected points.  Control-drag to scale about center.  Shift-drag to scale uniformly.";

    public ScaleMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("scalePoints.gif");
        selectedIcon = this.loadImage("selected/scalePoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = ((MeshEditorWindow)this.theFrame).theView;
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                this.theWindow.setHelpText(helpText);
                return;
            }
            ++i;
        }
        this.theWindow.setHelpText("No points are selected to scale.");
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y, 5, 5);
            g.fillRect(b.x, b.y + (b.height - 5) / 2, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + (b.height - 5) / 2, 5, 5);
        }
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        if (!b.contains(this.clickPoint)) {
            this.notOnHandle = true;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + (b.width - 5) / 2 && this.clickPoint.x <= b.x + (b.width - 5) / 2 + 5 ? 1 : (this.clickPoint.x >= b.x + b.width - 5 ? 2 : -1));
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + (b.height - 5) / 2 && this.clickPoint.y <= b.y + (b.height - 5) / 2 + 5 ? 1 : (this.clickPoint.y >= b.y + b.height - 5 ? 2 : -1));
        if (j == -1 || k == -1 || j == 1 && k == 1) {
            this.notOnHandle = true;
            return;
        }
        this.notOnHandle = false;
        this.clickX = this.clickPoint.x;
        this.clickY = this.clickPoint.y;
        this.scaleCenter = new Vec3(0.0, 0.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
        if (j == 0) {
            this.scaleX = true;
            this.centerX = b.x + b.width;
            this.scaleCenter.x = this.bounds.minx;
        } else if (j == 2) {
            this.scaleX = true;
            this.centerX = b.x;
            this.scaleCenter.x = this.bounds.maxx;
        } else {
            this.scaleX = false;
            this.scaleCenter.x = this.bounds.minx + this.bounds.maxx;
        }
        if (k == 0) {
            this.scaleY = true;
            this.centerY = b.y + b.height;
            this.scaleCenter.y = this.bounds.miny;
        } else if (k == 2) {
            this.scaleY = true;
            this.centerY = b.y;
            this.scaleCenter.y = this.bounds.maxy;
        } else {
            this.scaleY = false;
            this.scaleCenter.y = this.bounds.miny + this.bounds.maxy;
        }
        if (e.isControlDown()) {
            this.centerX = b.x + b.width / 2;
            this.centerY = b.y + b.height / 2;
            this.scaleCenter.x = (this.bounds.minx + this.bounds.maxx) / 2.0;
            this.scaleCenter.y = (this.bounds.miny + this.bounds.maxy) / 2.0;
        }
        this.scaleAll = e.isShiftDown();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        double zscale;
        double size;
        double xscale;
        double yscale;
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        Graphics g = view.getGraphics();
        if (this.scaleAll) {
            yscale = 0.0;
            xscale = 0.0;
        } else {
            yscale = 1.0;
            xscale = 1.0;
        }
        if (this.scaleX && (xscale = (size = (double)dragPoint.x - this.centerX) / (this.clickX - this.centerX)) <= 0.0) {
            xscale = Math.abs(1.0 / (this.clickX - this.centerX));
        }
        if (this.scaleY && (yscale = (size = (double)dragPoint.y - this.centerY) / (this.clickY - this.centerY)) <= 0.0) {
            yscale = Math.abs(1.0 / (this.clickY - this.centerY));
        }
        if (this.scaleAll) {
            yscale = zscale = Math.max(xscale, yscale);
            xscale = zscale;
        } else {
            zscale = 1.0;
        }
        Vec3[] v = this.findScaledPositions(vert, xscale, yscale, zscale, (MeshViewer)view);
        view.drawImage(g);
        g.setColor(Color.gray);
        int i = 0;
        while (i < v.length) {
            if (selectDist[i] > -1) {
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - vertSize / 2, (int)p.y - vertSize / 2, vertSize, vertSize);
            }
            ++i;
        }
        ((MeshViewer)view).drawDraggedSelection(g, cam, v);
        if (this.scaleAll) {
            this.theWindow.setHelpText("Scale factor: " + (double)Math.round(xscale * 100000.0) / 100000.0);
        } else if (this.scaleX && !this.scaleY) {
            this.theWindow.setHelpText("Scale factor: " + (double)Math.round(xscale * 100000.0) / 100000.0);
        } else if (this.scaleY && !this.scaleX) {
            this.theWindow.setHelpText("Scale factor: " + (double)Math.round(yscale * 100000.0) / 100000.0);
        } else {
            this.theWindow.setHelpText("Scale factors: " + (double)Math.round(xscale * 100000.0) / 100000.0 + ", " + (double)Math.round(yscale * 100000.0) / 100000.0);
        }
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        double zscale;
        double size;
        double xscale;
        double yscale;
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        if (this.scaleAll) {
            yscale = 0.0;
            xscale = 0.0;
        } else {
            yscale = 1.0;
            xscale = 1.0;
        }
        if (this.scaleX && (xscale = (size = (double)dragPoint.x - this.centerX) / (this.clickX - this.centerX)) <= 0.0) {
            xscale = Math.abs(1.0 / (this.clickX - this.centerX));
        }
        if (this.scaleY && (yscale = (size = (double)dragPoint.y - this.centerY) / (this.clickY - this.centerY)) <= 0.0) {
            yscale = Math.abs(1.0 / (this.clickY - this.centerY));
        }
        if (this.scaleAll) {
            yscale = zscale = Math.max(xscale, yscale);
            xscale = zscale;
        } else {
            zscale = 1.0;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        Vec3[] v = this.findScaledPositions(vert, xscale, yscale, zscale, (MeshViewer)view);
        mesh.setVertices(v);
        this.theWindow.updateImage();
        this.theWindow.setHelpText(helpText);
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        int i = 0;
        while (i < vert.length) {
            if (selected[i] == 0) {
                Vec3 v = cam.getObjectToView().times(vert[i].r);
                if (v.x < minx) {
                    minx = v.x;
                }
                if (v.x > maxx) {
                    maxx = v.x;
                }
                if (v.y < miny) {
                    miny = v.y;
                }
                if (v.y > maxy) {
                    maxy = v.y;
                }
                if (v.z < minz) {
                    minz = v.z;
                }
                if (v.z > maxz) {
                    maxz = v.z;
                }
            }
            ++i;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        return r;
    }

    Vec3[] findScaledPositions(MeshVertex[] vert, double xscale, double yscale, double zscale, MeshViewer view) {
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        Mat4 m = cam.getObjectToView();
        m = Mat4.translation(-this.scaleCenter.x, -this.scaleCenter.y, -this.scaleCenter.z).times(m);
        m = Mat4.scale(xscale, yscale, zscale).times(m);
        m = Mat4.translation(this.scaleCenter.x, this.scaleCenter.y, this.scaleCenter.z).times(m);
        m = cam.getViewToWorld().times(m);
        m = view.getDisplayCoordinates().toLocal().times(m);
        int i = 0;
        while (i < vert.length) {
            v[i] = selected[i] == 0 ? m.times(vert[i].r).minus(vert[i].r) : new Vec3();
            ++i;
        }
        ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        i = 0;
        while (i < vert.length) {
            v[i].add(vert[i].r);
            ++i;
        }
        return v;
    }
}

