/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.ImageMap;
import artofillusion.ListChangeListener;
import artofillusion.Material;
import artofillusion.MaterialsDialog;
import artofillusion.ModellingApp;
import artofillusion.NullObject;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureParameter;
import artofillusion.TexturesDialog;
import artofillusion.UndoRecord;
import artofillusion.UniformMaterial;
import artofillusion.UniformTexture;
import artofillusion.Vec3;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;

public class Scene {
    Vector objects;
    Vector materials;
    Vector textures;
    Vector images;
    Vector selection;
    Vector textureListeners;
    Vector materialListeners;
    RGBColor ambientColor;
    RGBColor environColor;
    RGBColor fogColor;
    Texture environTexture;
    TextureMapping environMapping;
    int gridSubdivisions;
    int environMode;
    int framesPerSecond;
    int nextID;
    double fogDist;
    double gridSpacing;
    double time;
    boolean fog;
    boolean showGrid;
    boolean snapToGrid;
    boolean errorsLoading;
    String name;
    String directory;
    TexturesDialog texDlg;
    MaterialsDialog matDlg;
    public static final int HANDLE_SIZE = 4;
    public static final int ENVIRON_SOLID = 0;
    public static final int ENVIRON_DIFFUSE = 1;
    public static final int ENVIRON_EMISSIVE = 2;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$artofillusion$Scene;
    static /* synthetic */ Class class$artofillusion$Texture;
    static /* synthetic */ Class class$java$lang$Object;

    public Scene() {
        UniformTexture defTex = new UniformTexture();
        this.objects = new Vector();
        this.materials = new Vector();
        this.textures = new Vector();
        this.images = new Vector();
        this.selection = new Vector();
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
        defTex.setName("Default Texture");
        this.textures.addElement(defTex);
        this.ambientColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.environTexture = defTex;
        this.environMapping = defTex.getDefaultMapping();
        this.environMode = 0;
        this.fogColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.fogDist = 20.0;
        this.fog = false;
        this.framesPerSecond = 30;
        this.nextID = 1;
        this.snapToGrid = false;
        this.showGrid = false;
        this.gridSpacing = 1.0;
        this.gridSubdivisions = 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String newDir) {
        this.directory = newDir;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
        boolean[] changed = new boolean[this.objects.size()];
        int i = 0;
        while (i < this.objects.size()) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.parent == null) {
                this.applyTracksToObject(info, changed, i);
            }
            ++i;
        }
    }

    public void applyTracksToObject(ObjectInfo info) {
        this.applyTracksToObject(info, null, 0);
    }

    private void applyTracksToObject(ObjectInfo info, boolean[] changed, int index) {
        int i;
        if (changed != null) {
            if (changed[index]) {
                return;
            }
            changed[index] = true;
        }
        boolean hasPos = false;
        boolean hasRot = false;
        boolean hasPose = false;
        int j = 0;
        while (j < info.tracks.length) {
            if (!info.tracks[j].isNullTrack() && info.tracks[j].isEnabled()) {
                if (changed != null) {
                    ObjectInfo[] depends = info.tracks[j].getDependencies();
                    i = 0;
                    while (i < depends.length) {
                        int k = this.objects.indexOf(depends[i]);
                        if (!changed[k]) {
                            this.applyTracksToObject(depends[i], changed, k);
                        }
                        ++i;
                    }
                }
                if (info.tracks[j] instanceof PositionTrack) {
                    hasPos = true;
                } else if (info.tracks[j] instanceof RotationTrack) {
                    hasRot = true;
                } else if (info.tracks[j] instanceof PoseTrack) {
                    hasPose = true;
                }
            }
            ++j;
        }
        if (hasPos) {
            Vec3 orig = info.coords.getOrigin();
            orig.set(0.0, 0.0, 0.0);
            info.coords.setOrigin(orig);
        }
        if (hasRot) {
            info.coords.setOrientation(0.0, 0.0, 0.0);
        }
        if (hasPose) {
            info.clearCachedMeshes();
        }
        info.pose = null;
        int j2 = info.tracks.length - 1;
        while (j2 >= 0) {
            if (info.tracks[j2].isEnabled()) {
                info.tracks[j2].apply(this.time);
            }
            --j2;
        }
        if (info.pose != null) {
            info.object.applyPoseKeyframe(info.pose);
        }
        i = 0;
        while (i < info.children.length) {
            this.applyTracksToObject(info.children[i]);
            ++i;
        }
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(int n) {
        this.framesPerSecond = n;
    }

    public RGBColor getAmbientColor() {
        return this.ambientColor;
    }

    public void setAmbientColor(RGBColor color) {
        this.ambientColor = color;
    }

    public int getEnvironmentMode() {
        return this.environMode;
    }

    public void setEnvironmentMode(int mode) {
        this.environMode = mode;
    }

    public Texture getEnvironmentTexture() {
        return this.environTexture;
    }

    public void setEnvironmentTexture(Texture tex) {
        this.environTexture = tex;
    }

    public TextureMapping getEnvironmentMapping() {
        return this.environMapping;
    }

    public void setEnvironmentMapping(TextureMapping map) {
        this.environMapping = map;
    }

    public RGBColor getEnvironmentColor() {
        return this.environColor;
    }

    public void setEnvironmentColor(RGBColor color) {
        this.environColor = color;
    }

    public RGBColor getFogColor() {
        return this.fogColor;
    }

    public void setFogColor(RGBColor color) {
        this.fogColor = color;
    }

    public boolean getFogState() {
        return this.fog;
    }

    public double getFogDistance() {
        return this.fogDist;
    }

    public void setFog(boolean state, double dist) {
        this.fog = state;
        this.fogDist = dist;
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
        this.updateSelectionInfo();
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.addObject(info, this.objects.size(), undo);
        this.updateSelectionInfo();
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        info.id = this.nextID++;
        this.objects.insertElementAt(info, index);
        if (undo != null) {
            undo.addCommandAtBeginning(5, new Object[]{new Integer(index)});
        }
        this.updateSelectionInfo();
    }

    public void removeObject(int which, UndoRecord undo) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        this.objects.removeElementAt(which);
        if (undo != null) {
            undo.addCommandAtBeginning(4, new Object[]{info, new Integer(which)});
        }
        if (info.parent != null) {
            int j = 0;
            while (info.parent.children[j] != info) {
                ++j;
            }
            if (undo != null) {
                undo.addCommandAtBeginning(7, new Object[]{info.parent, info, new Integer(j)});
            }
            info.parent.removeChild(j);
        }
        int i = 0;
        while (i < this.objects.size()) {
            ObjectInfo obj = (ObjectInfo)this.objects.elementAt(i);
            int j = 0;
            while (j < obj.tracks.length) {
                Track tr = obj.tracks[j];
                ObjectInfo[] depends = tr.getDependencies();
                int k = 0;
                while (k < depends.length) {
                    if (depends[k] == info) {
                        if (undo != null) {
                            undo.addCommandAtBeginning(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                        }
                        obj.tracks[j].deleteDependencies(info);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.clearSelection();
    }

    public void addMaterial(Material mat) {
        this.materials.addElement(mat);
        int i = 0;
        while (i < this.materialListeners.size()) {
            ((ListChangeListener)this.materialListeners.elementAt(i)).itemAdded(this.materials.size() - 1, mat);
            ++i;
        }
    }

    public void removeMaterial(int which) {
        Material mat = (Material)this.materials.elementAt(which);
        this.materials.removeElementAt(which);
        int i = 0;
        while (i < this.materialListeners.size()) {
            ((ListChangeListener)this.materialListeners.elementAt(i)).itemRemoved(which, mat);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.objects.size()) {
            Object3D obj = ((ObjectInfo)this.objects.elementAt((int)i2)).object;
            if (obj.getMaterial() == mat) {
                obj.setMaterial((Material)this.materials.elementAt(0));
            }
            ++i2;
        }
    }

    public void addTexture(Texture tex) {
        this.textures.addElement(tex);
        int i = 0;
        while (i < this.textureListeners.size()) {
            ((ListChangeListener)this.textureListeners.elementAt(i)).itemAdded(this.textures.size() - 1, tex);
            ++i;
        }
    }

    public void removeTexture(int which) {
        Texture tex = (Texture)this.textures.elementAt(which);
        this.textures.removeElementAt(which);
        int i = 0;
        while (i < this.textureListeners.size()) {
            ((ListChangeListener)this.textureListeners.elementAt(i)).itemRemoved(which, tex);
            ++i;
        }
        if (this.textures.size() == 0) {
            UniformTexture defTex = new UniformTexture();
            defTex.setName("Default Texture");
            this.textures.addElement(defTex);
            int i2 = 0;
            while (i2 < this.textureListeners.size()) {
                ((ListChangeListener)this.textureListeners.elementAt(i2)).itemAdded(0, defTex);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.objects.size()) {
            Object3D obj = ((ObjectInfo)this.objects.elementAt((int)i3)).object;
            if (obj.getTexture() == tex) {
                obj.setTexture((Texture)this.textures.elementAt(0));
            }
            ++i3;
        }
    }

    public void changeMaterial(int which) {
        Material mat = (Material)this.materials.elementAt(which);
        int i = 0;
        while (i < this.objects.size()) {
            Object3D obj = ((ObjectInfo)this.objects.elementAt((int)i)).object;
            if (obj.getMaterial() == mat) {
                obj.setMaterial(mat);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.materialListeners.size()) {
            ((ListChangeListener)this.materialListeners.elementAt(i2)).itemChanged(which, mat);
            ++i2;
        }
    }

    public void changeTexture(int which) {
        Texture tex = (Texture)this.textures.elementAt(which);
        int i = 0;
        while (i < this.objects.size()) {
            Object3D obj = ((ObjectInfo)this.objects.elementAt((int)i)).object;
            if (obj.getTexture() == tex) {
                obj.setTexture(tex);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.textureListeners.size()) {
            ((ListChangeListener)this.textureListeners.elementAt(i2)).itemChanged(which, tex);
            ++i2;
        }
    }

    public void addMaterialListener(ListChangeListener ls) {
        this.materialListeners.addElement(ls);
    }

    public void removeMaterialListener(ListChangeListener ls) {
        this.materialListeners.removeElement(ls);
    }

    public void addTextureListener(ListChangeListener ls) {
        this.textureListeners.addElement(ls);
    }

    public void removeTextureListener(ListChangeListener ls) {
        this.textureListeners.removeElement(ls);
    }

    public void showTexturesDialog(Frame parent) {
        if (this.texDlg == null) {
            this.texDlg = new TexturesDialog(parent, this);
        } else {
            Rectangle r = this.texDlg.getBounds();
            this.texDlg.dispose();
            this.texDlg = new TexturesDialog(parent, this);
            ((Component)this.texDlg).setBounds(r);
        }
        this.texDlg.show();
    }

    public void showMaterialsDialog(Frame parent) {
        if (this.matDlg == null) {
            this.matDlg = new MaterialsDialog(parent, this);
        } else {
            Rectangle r = this.matDlg.getBounds();
            this.matDlg.dispose();
            this.matDlg = new MaterialsDialog(parent, this);
            ((Component)this.matDlg).setBounds(r);
        }
        this.matDlg.show();
    }

    public void addImage(ImageMap im) {
        this.images.addElement(im);
    }

    public boolean removeImage(int which) {
        ImageMap image = (ImageMap)this.images.elementAt(which);
        int i = 0;
        while (i < this.textures.size()) {
            if (((Texture)this.textures.elementAt(i)).usesImage(image)) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.materials.size()) {
            if (((Material)this.materials.elementAt(i2)).usesImage(image)) {
                return false;
            }
            ++i2;
        }
        this.images.removeElementAt(which);
        return true;
    }

    public void replaceObject(Object3D original, Object3D replaceWith, UndoRecord undo) {
        int i = 0;
        while (i < this.objects.size()) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.object == original) {
                if (undo != null) {
                    undo.addCommand(3, new Object[]{info, original});
                }
                info.object = replaceWith;
                info.clearCachedMeshes();
            }
            ++i;
        }
    }

    public void objectModified(Object3D obj) {
        int i = 0;
        while (i < this.objects.size()) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.object == obj) {
                info.clearCachedMeshes();
                info.pose = null;
            }
            ++i;
        }
    }

    public void markSelection(Graphics g, Camera cam) {
        if (this.selection.size() == 0) {
            return;
        }
        g.setColor(Color.red);
        int i = 0;
        while (i < this.selection.size()) {
            int j = (Integer)this.selection.elementAt(i);
            cam.setObjectTransform(((ObjectInfo)this.objects.elementAt((int)j)).coords.fromLocal());
            Rectangle bounds = cam.findScreenBounds(((ObjectInfo)this.objects.elementAt(j)).getBounds());
            if (bounds != null) {
                g.fillRect(bounds.x, bounds.y, 4, 4);
                g.fillRect(bounds.x + bounds.width - 4 + 1, bounds.y, 4, 4);
                g.fillRect(bounds.x, bounds.y + bounds.height - 4 + 1, 4, 4);
                g.fillRect(bounds.x + bounds.width - 4 + 1, bounds.y + bounds.height - 4 + 1, 4, 4);
                g.fillRect(bounds.x + (bounds.width - 4) / 2, bounds.y, 4, 4);
                g.fillRect(bounds.x, bounds.y + (bounds.height - 4) / 2, 4, 4);
                g.fillRect(bounds.x + (bounds.width - 4) / 2, bounds.y + bounds.height - 4 + 1, 4, 4);
                g.fillRect(bounds.x + bounds.width - 4 + 1, bounds.y + (bounds.height - 4) / 2, 4, 4);
            }
            ++i;
        }
    }

    public void setCoordinates(int obj, CoordinateSystem coords) {
        ((ObjectInfo)this.objects.elementAt((int)obj)).coords = coords;
    }

    public void setSelection(int which) {
        this.clearSelection();
        this.addToSelection(which);
        this.updateSelectionInfo();
    }

    public void setSelection(int[] which) {
        this.clearSelection();
        int i = 0;
        while (i < which.length) {
            this.addToSelection(which[i]);
            ++i;
        }
        this.updateSelectionInfo();
    }

    public void addToSelection(int which) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        if (!info.selected) {
            this.selection.addElement(new Integer(which));
        }
        info.selected = true;
        this.updateSelectionInfo();
    }

    public void clearSelection() {
        this.selection.removeAllElements();
        int i = 0;
        while (i < this.objects.size()) {
            ((ObjectInfo)this.objects.elementAt((int)i)).selected = false;
            ++i;
        }
        this.updateSelectionInfo();
    }

    public void removeFromSelection(int which) {
        ObjectInfo info = (ObjectInfo)this.objects.elementAt(which);
        this.selection.removeElement(new Integer(which));
        info.selected = false;
        this.updateSelectionInfo();
    }

    private void updateSelectionInfo() {
        int i = this.objects.size() - 1;
        while (i >= 0) {
            ((ObjectInfo)this.objects.elementAt((int)i)).parentSelected = false;
            --i;
        }
        int i2 = this.objects.size() - 1;
        while (i2 >= 0) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i2);
            ObjectInfo parent = info.parent;
            while (parent != null) {
                if (parent.selected || parent.parentSelected) {
                    info.parentSelected = true;
                    break;
                }
                parent = parent.parent;
            }
            --i2;
        }
    }

    public Vector getObjects() {
        return this.objects;
    }

    public Vector getMaterials() {
        return this.materials;
    }

    public Vector getTextures() {
        return this.textures;
    }

    public Texture getDefaultTexture() {
        return (Texture)this.textures.elementAt(0);
    }

    public Vector getImages() {
        return this.images;
    }

    public int[] getSelection() {
        int[] sel = new int[this.selection.size()];
        int i = 0;
        while (i < sel.length) {
            sel[i] = (Integer)this.selection.elementAt(i);
            ++i;
        }
        return sel;
    }

    public int[] getSelectionWithChildren() {
        int count = 0;
        int i = this.objects.size() - 1;
        while (i >= 0) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            if (info.selected || info.parentSelected) {
                ++count;
            }
            --i;
        }
        int[] sel = new int[count];
        count = 0;
        int i2 = this.objects.size() - 1;
        while (i2 >= 0) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i2);
            if (info.selected || info.parentSelected) {
                sel[count++] = i2;
            }
            --i2;
        }
        return sel;
    }

    public Scene(DataInputStream in, boolean fullScene) throws IOException, InvalidObjectException {
        Constructor<Object> con;
        int j;
        Class cls;
        byte[] bytes;
        int len;
        String classname;
        short version = in.readShort();
        Class[] textureTypes = ModellingApp.getTextureTypes();
        Class[] materialTypes = ModellingApp.getMaterialTypes();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.ambientColor = new RGBColor(in);
        this.fogColor = new RGBColor(in);
        this.fog = in.readBoolean();
        this.fogDist = in.readDouble();
        this.showGrid = in.readBoolean();
        this.snapToGrid = in.readBoolean();
        this.gridSpacing = in.readDouble();
        this.gridSubdivisions = in.readInt();
        this.framesPerSecond = in.readInt();
        this.nextID = 1;
        int count = in.readInt();
        this.images = new Vector(count);
        int i = 0;
        while (i < count) {
            this.images.addElement(new ImageMap(in));
            ++i;
        }
        count = in.readInt();
        this.materials = new Vector(count);
        i = 0;
        while (i < count) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = null;
                j = 0;
                while (j < materialTypes.length) {
                    if (materialTypes[j].getName().equals(classname)) {
                        cls = materialTypes[j];
                        break;
                    }
                    ++j;
                }
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$artofillusion$Scene == null ? Scene.class$("artofillusion.Scene") : class$artofillusion$Scene);
                    this.materials.addElement(con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UniformMaterial m = new UniformMaterial();
                    m.setName("<unreadable>");
                    this.materials.addElement(m);
                    this.errorsLoading = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
            ++i;
        }
        count = in.readInt();
        this.textures = new Vector(count);
        i = 0;
        while (i < count) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = null;
                j = 0;
                while (j < textureTypes.length) {
                    if (textureTypes[j].getName().equals(classname)) {
                        cls = textureTypes[j];
                        break;
                    }
                    ++j;
                }
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$artofillusion$Scene == null ? Scene.class$("artofillusion.Scene") : class$artofillusion$Scene);
                    this.textures.addElement(con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UniformTexture t = new UniformTexture();
                    t.setName("<unreadable>");
                    this.textures.addElement(t);
                    this.errorsLoading = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
            ++i;
        }
        count = in.readInt();
        this.objects = new Vector(count);
        Hashtable table = new Hashtable(count);
        i = 0;
        while (i < count) {
            this.objects.addElement(this.readObjectFromFile(in, table));
            ++i;
        }
        this.selection = new Vector();
        i = 0;
        while (i < this.objects.size()) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            int num = in.readInt();
            j = 0;
            while (j < num) {
                ObjectInfo child = (ObjectInfo)this.objects.elementAt(in.readInt());
                info.addChild(child, j);
                ++j;
            }
            ++i;
        }
        this.environMode = in.readShort();
        if (this.environMode == 0) {
            this.environColor = new RGBColor(in);
            this.environTexture = (Texture)this.textures.elementAt(0);
            this.environMapping = this.environTexture.getDefaultMapping();
        } else {
            this.environTexture = (Texture)this.textures.elementAt(in.readInt());
            try {
                Class<?> mapClass = Class.forName(in.readUTF());
                con = mapClass.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Scene.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$Texture == null ? (class$artofillusion$Texture = Scene.class$("artofillusion.Texture")) : class$artofillusion$Texture);
                this.environMapping = (TextureMapping)con.newInstance(in, this.environTexture);
            }
            catch (Exception ex) {
                throw new IOException();
            }
            this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
        }
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
    }

    private ObjectInfo readObjectFromFile(DataInputStream in, Hashtable table) throws IOException, InvalidObjectException {
        int i;
        Constructor con;
        Class cls;
        ObjectInfo info = new ObjectInfo(null, new CoordinateSystem(in), in.readUTF());
        info.id = in.readInt();
        if (info.id >= this.nextID) {
            this.nextID = info.id + 1;
        }
        info.visible = in.readBoolean();
        Integer key = new Integer(in.readInt());
        Object3D obj = (Object3D)table.get(key);
        if (obj == null) {
            try {
                String classname = in.readUTF();
                int len = in.readInt();
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                try {
                    cls = ModellingApp.getClass(classname);
                    con = cls.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Scene.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$Scene == null ? (class$artofillusion$Scene = Scene.class$("artofillusion.Scene")) : class$artofillusion$Scene);
                    obj = (Object3D)con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this);
                }
                catch (Exception ex) {
                    if (ex instanceof InvocationTargetException) {
                        ((InvocationTargetException)ex).getTargetException().printStackTrace();
                    } else {
                        ex.printStackTrace();
                    }
                    obj = new NullObject();
                    info.name = "<unreadable> " + info.name;
                    this.errorsLoading = true;
                }
                table.put(key, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        info.object = obj;
        if (obj.getTexture() == null) {
            info.texParam = new TextureParameter[0];
            info.texParamValue = new double[0];
            info.texParamPerVertex = new boolean[0];
        } else {
            info.texParam = obj.getTextureMapping().getParameters();
            info.texParamValue = new double[info.texParam.length];
            int i2 = 0;
            while (i2 < info.texParamValue.length) {
                info.texParamValue[i2] = in.readDouble();
                ++i2;
            }
            info.texParamPerVertex = new boolean[info.texParam.length];
            i = 0;
            while (i < info.texParamValue.length) {
                info.texParamPerVertex[i] = in.readBoolean();
                ++i;
            }
        }
        int tracks = in.readInt();
        try {
            i = 0;
            while (i < tracks) {
                cls = ModellingApp.getClass(in.readUTF());
                con = cls.getConstructor(class$java$io$DataInputStream == null ? Scene.class$("java.io.DataInputStream") : class$java$io$DataInputStream, class$java$lang$Object == null ? Scene.class$("java.lang.Object") : class$java$lang$Object, class$artofillusion$Scene == null ? Scene.class$("artofillusion.Scene") : class$artofillusion$Scene);
                info.addTrack((Track)con.newInstance(in, info, this), i);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        return info;
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream bos;
        int index = 0;
        Hashtable table = new Hashtable(this.objects.size());
        out.writeShort(0);
        this.ambientColor.writeToFile(out);
        this.fogColor.writeToFile(out);
        out.writeBoolean(this.fog);
        out.writeDouble(this.fogDist);
        out.writeBoolean(this.showGrid);
        out.writeBoolean(this.snapToGrid);
        out.writeDouble(this.gridSpacing);
        out.writeInt(this.gridSubdivisions);
        out.writeInt(this.framesPerSecond);
        out.writeInt(this.images.size());
        int i = 0;
        while (i < this.images.size()) {
            ((ImageMap)this.images.elementAt(i)).writeToFile(out);
            ++i;
        }
        out.writeInt(this.materials.size());
        i = 0;
        while (i < this.materials.size()) {
            Material mat = (Material)this.materials.elementAt(i);
            out.writeUTF(mat.getClass().getName());
            bos = new ByteArrayOutputStream();
            mat.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
            ++i;
        }
        out.writeInt(this.textures.size());
        i = 0;
        while (i < this.textures.size()) {
            Texture tex = (Texture)this.textures.elementAt(i);
            out.writeUTF(tex.getClass().getName());
            bos = new ByteArrayOutputStream();
            tex.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
            ++i;
        }
        out.writeInt(this.objects.size());
        i = 0;
        while (i < this.objects.size()) {
            index = this.writeObjectToFile(out, (ObjectInfo)this.objects.elementAt(i), table, index);
            ++i;
        }
        i = 0;
        while (i < this.objects.size()) {
            ObjectInfo info = (ObjectInfo)this.objects.elementAt(i);
            out.writeInt(info.children.length);
            int j = 0;
            while (j < info.children.length) {
                out.writeInt(this.objects.indexOf(info.children[j]));
                ++j;
            }
            ++i;
        }
        out.writeShort((short)this.environMode);
        if (this.environMode == 0) {
            this.environColor.writeToFile(out);
        } else {
            out.writeInt(this.textures.lastIndexOf(this.environTexture));
            out.writeUTF(this.environMapping.getClass().getName());
            this.environMapping.writeToFile(out);
        }
    }

    private int writeObjectToFile(DataOutputStream out, ObjectInfo info, Hashtable table, int index) throws IOException {
        info.coords.writeToFile(out);
        out.writeUTF(info.name);
        out.writeInt(info.id);
        out.writeBoolean(info.visible);
        Integer key = (Integer)table.get(info.object);
        if (key == null) {
            out.writeInt(index);
            out.writeUTF(info.object.getClass().getName());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            info.object.writeToFile(new DataOutputStream(bos), this);
            byte[] bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
            key = new Integer(index++);
            table.put(info.object, key);
        } else {
            out.writeInt(key);
        }
        int i = 0;
        while (i < info.texParamValue.length) {
            out.writeDouble(info.texParamValue[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < info.texParamPerVertex.length) {
            out.writeBoolean(info.texParamPerVertex[i2]);
            ++i2;
        }
        out.writeInt(info.tracks.length);
        int i3 = 0;
        while (i3 < info.tracks.length) {
            out.writeUTF(info.tracks[i3].getClass().getName());
            info.tracks[i3].writeToStream(out, this);
            ++i3;
        }
        return index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

