/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Callback;
import artofillusion.EditingWindow;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Component;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SceneCamera
extends Object3D {
    double fov;
    double depthOfField;
    double focalDist;
    static BoundingBox bounds;
    static WireframeMesh mesh;
    static final int SEGMENTS = 8;

    public SceneCamera() {
        this.fov = 30.0;
        this.depthOfField = 10.0;
        this.focalDist = 20.0;
    }

    public double getFieldOfView() {
        return this.fov;
    }

    public double getDepthOfField() {
        return this.depthOfField;
    }

    public double getFocalDistance() {
        return this.focalDist;
    }

    public Object3D duplicate() {
        SceneCamera sc = new SceneCamera();
        sc.fov = this.fov;
        sc.depthOfField = this.depthOfField;
        sc.focalDist = this.focalDist;
        return sc;
    }

    public void copyObject(Object3D obj) {
        SceneCamera sc = (SceneCamera)obj;
        this.fov = sc.fov;
        this.depthOfField = sc.depthOfField;
        this.focalDist = sc.focalDist;
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetMaterial() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        ValueSlider fovSlider = new ValueSlider(0.0, 180.0, 90, this.fov);
        ValueField dofField = new ValueField(this.depthOfField, 3);
        ValueField fdField = new ValueField(this.focalDist, 3);
        ComponentsDialog dlg = new ComponentsDialog((Frame)((Object)parent), "Set camera parameters:", new Component[]{fovSlider, dofField, fdField}, new String[]{"Field of View", "Depth of Field", "Focal Distance"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.fov = fovSlider.getValue();
        this.depthOfField = dofField.getValue();
        this.focalDist = fdField.getValue();
        cb.execute();
    }

    public SceneCamera(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.fov = in.readDouble();
        this.depthOfField = in.readDouble();
        this.focalDist = in.readDouble();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.fov);
        out.writeDouble(this.depthOfField);
        out.writeDouble(this.focalDist);
    }

    public Keyframe getPoseKeyframe() {
        return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
    }

    public void applyPoseKeyframe(Keyframe k) {
        CameraKeyframe key = (CameraKeyframe)k;
        this.fov = key.fov;
        this.depthOfField = key.depthOfField;
        this.focalDist = key.focalDist;
    }

    public String[] getPoseValueNames() {
        return new String[]{"Field of View", "Depth of Field", "Focal Distance"};
    }

    public double[] getDefaultPoseValues() {
        return new double[]{this.fov, this.depthOfField, this.focalDist};
    }

    public double[][] getPoseValueRange() {
        return new double[][]{{0.0, 180.0}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}};
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        CameraKeyframe key = (CameraKeyframe)k;
        ValueSlider fovSlider = new ValueSlider(0.0, 180.0, 90, key.fov);
        ValueField dofField = new ValueField(key.depthOfField, 3);
        ValueField fdField = new ValueField(key.focalDist, 3);
        ComponentsDialog dlg = new ComponentsDialog((Frame)((Object)parent), "Set camera parameters:", new Component[]{fovSlider, dofField, fdField}, new String[]{"Field of View", "Depth of Field", "Focal Distance"});
        if (!dlg.clickedOk()) {
            return;
        }
        key.fov = fovSlider.getValue();
        key.depthOfField = dofField.getValue();
        key.focalDist = fdField.getValue();
    }

    static {
        int index = 0;
        bounds = new BoundingBox(-0.25, 0.25, -0.15, 0.2, -0.2, 0.2);
        double[] sine = new double[8];
        double[] cosine = new double[8];
        int i = 0;
        while (i < 8) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
            ++i;
        }
        Vec3[] vert = new Vec3[40];
        int[] from = new int[58];
        int[] to = new int[58];
        vert[0] = new Vec3(-0.25, -0.15, -0.2);
        vert[1] = new Vec3(0.25, -0.15, -0.2);
        vert[2] = new Vec3(0.25, 0.15, -0.2);
        vert[3] = new Vec3(-0.25, 0.15, -0.2);
        vert[4] = new Vec3(-0.25, -0.15, 0.0);
        vert[5] = new Vec3(0.25, -0.15, 0.0);
        vert[6] = new Vec3(0.25, 0.15, 0.0);
        vert[7] = new Vec3(-0.25, 0.15, 0.0);
        int[] f = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3};
        int[] t = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 4, 5, 6, 7};
        i = 0;
        while (i < f.length) {
            from[index] = f[i];
            to[index] = t[i];
            ++i;
            ++index;
        }
        vert[8] = new Vec3(-0.25, 0.15, -0.15);
        vert[9] = new Vec3(-0.2, 0.15, -0.15);
        vert[10] = new Vec3(-0.2, 0.2, -0.15);
        vert[11] = new Vec3(-0.25, 0.2, -0.15);
        vert[12] = new Vec3(-0.25, 0.15, -0.1);
        vert[13] = new Vec3(-0.2, 0.15, -0.1);
        vert[14] = new Vec3(-0.2, 0.2, -0.1);
        vert[15] = new Vec3(-0.25, 0.2, -0.1);
        i = 0;
        while (i < f.length) {
            from[index] = f[i] + 8;
            to[index] = t[i] + 8;
            ++i;
            ++index;
        }
        vert[16] = new Vec3(-0.2, 0.15, 0.0);
        vert[17] = new Vec3(-0.05, 0.2, 0.0);
        vert[18] = new Vec3(0.05, 0.2, 0.0);
        vert[19] = new Vec3(0.2, 0.15, 0.0);
        vert[20] = new Vec3(0.2, 0.15, -0.2);
        vert[21] = new Vec3(0.05, 0.2, -0.2);
        vert[22] = new Vec3(-0.05, 0.2, -0.2);
        vert[23] = new Vec3(-0.2, 0.15, -0.2);
        f = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 17, 18};
        t = new int[]{17, 18, 19, 20, 21, 22, 23, 16, 22, 21};
        i = 0;
        while (i < f.length) {
            from[index] = f[i];
            to[index] = t[i];
            ++i;
            ++index;
        }
        i = 0;
        while (i < 8) {
            vert[24 + i] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.0);
            vert[24 + i + 8] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.2);
            from[index] = 24 + i;
            to[index] = 24 + (i + 1) % 8;
            from[index + 8] = 24 + i;
            to[index + 8] = 24 + i + 8;
            from[index + 16] = 24 + i + 8;
            to[index + 16] = 24 + (i + 1) % 8 + 8;
            ++i;
            ++index;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class CameraKeyframe
    implements Keyframe {
        public double fov;
        public double depthOfField;
        public double focalDist;

        public CameraKeyframe(double fov, double depthOfField, double focalDist) {
            this.fov = fov;
            this.depthOfField = depthOfField;
            this.focalDist = focalDist;
        }

        public Keyframe duplicate() {
            return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
        }

        public Keyframe duplicate(Object owner) {
            return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
        }

        public double[] getGraphValues() {
            return new double[]{this.fov, this.depthOfField, this.focalDist};
        }

        public void setGraphValues(double[] values) {
            this.fov = values[0];
            this.depthOfField = values[1];
            this.focalDist = values[2];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            CameraKeyframe k3 = (CameraKeyframe)o3;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov + weight3 * k3.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField + weight3 * k3.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist + weight3 * k3.focalDist);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            CameraKeyframe k3 = (CameraKeyframe)o3;
            CameraKeyframe k4 = (CameraKeyframe)o4;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov + weight3 * k3.fov + weight4 * k4.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField + weight3 * k3.depthOfField + weight4 * k4.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist + weight3 * k3.focalDist + weight4 * k4.focalDist);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof CameraKeyframe)) {
                return false;
            }
            CameraKeyframe key = (CameraKeyframe)k;
            return key.fov == this.fov && key.depthOfField == this.depthOfField && key.focalDist == this.focalDist;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.fov);
            out.writeDouble(this.depthOfField);
            out.writeDouble(this.focalDist);
        }

        public CameraKeyframe(DataInputStream in, Object parent) throws IOException {
            this(in.readDouble(), in.readDouble(), in.readDouble());
        }
    }
}

