/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.SceneCamera;
import artofillusion.TextureSpec;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class SceneViewer
extends ViewerCanvas {
    Scene theScene;
    EditingWindow parentFrame;
    Vector cameras;
    boolean draggingBox;
    boolean draggingSelectionBox;
    boolean squareBox;
    boolean sentClick;
    boolean dragging;
    Point clickPoint;
    Point dragPoint;
    int deselect;

    public SceneViewer(Scene s, Panel p, EditingWindow fr) {
        this.theScene = s;
        this.parentFrame = fr;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        this.cameras = new Vector();
        this.buildChoices(p);
        this.rebuildCameraList();
        this.setRenderMode(2);
    }

    public void rebuildCameraList() {
        Vector objects = this.theScene.getObjects();
        int i = this.viewChoice.getItemCount() - 2;
        int selected = this.viewChoice.getSelectedIndex();
        while (i > 5) {
            this.viewChoice.remove(i--);
        }
        this.cameras.removeAllElements();
        i = 0;
        while (i < objects.size()) {
            ObjectInfo obj = (ObjectInfo)objects.elementAt(i);
            if (obj.object instanceof SceneCamera) {
                this.cameras.addElement(obj);
                this.viewChoice.insert(obj.name, this.viewChoice.getItemCount() - 1);
                if (obj == this.boundCamera) {
                    selected = this.viewChoice.getItemCount() - 2;
                }
            }
            ++i;
        }
        if (selected < this.viewChoice.getItemCount()) {
            this.viewChoice.select(selected);
        } else {
            this.viewChoice.select(this.viewChoice.getItemCount() - 1);
        }
        if (this.viewChoice.getParent() != null) {
            this.viewChoice.invalidate();
            this.viewChoice.getParent().validate();
        }
    }

    public void selectOrientation(int which) {
        super.selectOrientation(which);
        if (which > 5 && which < this.viewChoice.getItemCount() - 1) {
            this.boundCamera = (ObjectInfo)this.cameras.elementAt(which - 6);
            CoordinateSystem coords = this.theCamera.getCameraCoordinates();
            coords.copyCoords(this.boundCamera.coords);
            this.theCamera.setCameraCoordinates(coords);
        } else {
            this.boundCamera = null;
        }
    }

    public int getOrientationChoice() {
        return this.viewChoice.getSelectedIndex();
    }

    public void updateImage() {
        boolean render;
        block13: {
            ObjectInfo obj;
            int i;
            Dimension dim = this.getSize();
            render = this.renderMode != 0;
            Vector objects = this.theScene.getObjects();
            this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
            super.updateImage();
            if (this.theImage == null) {
                return;
            }
            if (!render) {
                this.gr.setColor(Color.black);
                i = 0;
                while (i < objects.size()) {
                    obj = (ObjectInfo)objects.elementAt(i);
                    if (obj != this.boundCamera && obj.visible) {
                        this.theCamera.setObjectTransform(obj.coords.fromLocal());
                        Object3D.draw(this.gr, this.theCamera, obj.getWireframePreview(), obj.getBounds());
                    }
                    ++i;
                }
            } else {
                Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
                i = 0;
                while (i < objects.size()) {
                    obj = (ObjectInfo)objects.elementAt(i);
                    if (obj != this.boundCamera) {
                        this.theCamera.setObjectTransform(obj.coords.fromLocal());
                        this.renderObject(obj, viewdir);
                    }
                    ++i;
                }
            }
            if (!this.currentTool.hilightSelection()) break block13;
            i = 0;
            while (i < objects.size()) {
                block16: {
                    Color col;
                    int hsize;
                    block15: {
                        block14: {
                            obj = (ObjectInfo)objects.elementAt(i);
                            if (!obj.selected) break block14;
                            hsize = 4;
                            col = Color.red;
                            break block15;
                        }
                        if (!obj.parentSelected) break block16;
                        hsize = 2;
                        col = Color.magenta;
                    }
                    this.theCamera.setObjectTransform(obj.coords.fromLocal());
                    Rectangle bounds = this.theCamera.findScreenBounds(obj.getBounds());
                    if (bounds != null) {
                        this.drawBox(bounds.x, bounds.y, hsize, hsize, Color.red);
                        this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y, hsize, hsize, col);
                        this.drawBox(bounds.x, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                        this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                        this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y, hsize, hsize, col);
                        this.drawBox(bounds.x, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
                        this.drawBox(bounds.x + (bounds.width - hsize) / 2, bounds.y + bounds.height - hsize + 1, hsize, hsize, col);
                        this.drawBox(bounds.x + bounds.width - hsize + 1, bounds.y + (bounds.height - hsize) / 2, hsize, hsize, col);
                    }
                }
                ++i;
            }
        }
        this.drawBorder();
        if (render) {
            this.imageSource.newPixels();
        }
    }

    private void renderObject(ObjectInfo obj, Vec3 viewdir) {
        if (!obj.visible) {
            return;
        }
        if (this.theCamera.visibility(obj.getBounds()) == 0) {
            return;
        }
        RenderingMesh mesh = obj.getPreviewMesh();
        if (mesh != null) {
            TextureSpec spec = new TextureSpec();
            obj.object.getTexture().getAverageSpec(spec, this.theScene.getTime(), obj.texParamValue);
            RGBColor col = new RGBColor((double)spec.diffuse.getRed() + 0.5 * (double)spec.specular.getRed(), (double)spec.diffuse.getGreen() + 0.5 * (double)spec.specular.getGreen(), (double)spec.diffuse.getBlue() + 0.5 * (double)spec.specular.getBlue());
            if (this.renderMode == 1) {
                this.renderFlat(mesh, this.theCamera, obj.coords.toLocal().timesDirection(viewdir), obj.object.isClosed(), col);
            } else {
                this.renderSmooth(mesh, this.theCamera, obj.coords.toLocal().timesDirection(viewdir), obj.object.isClosed(), col);
            }
        } else {
            this.renderWireframe(obj.getWireframePreview(), this.theCamera);
        }
    }

    public void beginDraggingBox(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
    }

    public void mousePressed(MouseEvent e) {
        ObjectInfo info;
        Rectangle bounds = null;
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = true;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.moveToGrid(e);
            this.activeTool.mousePressed(e, this);
            return;
        }
        Point p = e.getPoint();
        Vector obj = this.theScene.getObjects();
        int[] sel = this.theScene.getSelection();
        int i = 0;
        while (i < sel.length) {
            info = (ObjectInfo)obj.elementAt(sel[i]);
            this.theCamera.setObjectTransform(info.coords.fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds != null && bounds.x <= p.x && bounds.y <= p.y && bounds.x + bounds.width >= p.x && bounds.y + bounds.height >= p.y) break;
            ++i;
        }
        if (i < sel.length) {
            if (e.isShiftDown()) {
                this.deselect = sel[i];
            }
            if ((this.activeTool.whichClicks() & 2) != 0) {
                int j = p.x <= bounds.x + 4 ? 0 : (p.x >= bounds.x + (bounds.width - 4) / 2 && p.x <= bounds.x + (bounds.width - 4) / 2 + 4 ? 1 : (p.x >= bounds.x + bounds.width - 4 ? 2 : -1));
                int k = p.y <= bounds.y + 4 ? 0 : (p.y >= bounds.y + (bounds.height - 4) / 2 && p.y <= bounds.y + (bounds.height - 4) / 2 + 4 ? 1 : (p.y >= bounds.y + bounds.height - 4 ? 2 : -1));
                if (k == 0) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j);
                    return;
                }
                if (j == 0 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 3);
                    return;
                }
                if (j == 2 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 4);
                    return;
                }
                if (k == 2) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j + 5);
                    return;
                }
            }
            this.moveToGrid(e);
            this.dragging = false;
            if ((this.activeTool.whichClicks() & 1) != 0) {
                this.activeTool.mousePressedOnObject(e, this, sel[i]);
            } else {
                this.sentClick = false;
            }
            return;
        }
        int j = -1;
        int minarea = Integer.MAX_VALUE;
        i = 0;
        while (i < obj.size()) {
            info = (ObjectInfo)obj.elementAt(i);
            if (info.visible) {
                this.theCamera.setObjectTransform(info.coords.fromLocal());
                bounds = this.theCamera.findScreenBounds(info.getBounds());
                if (bounds != null && bounds.contains(p) && bounds.width * bounds.height < minarea) {
                    j = i;
                    minarea = bounds.width * bounds.height;
                }
            }
            ++i;
        }
        if (j > -1) {
            info = (ObjectInfo)obj.elementAt(j);
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
            }
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).addToSelection(j);
            } else {
                this.theScene.addToSelection(j);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
            this.moveToGrid(e);
            if ((this.activeTool.whichClicks() & 1) != 0 && !e.isShiftDown()) {
                this.activeTool.mousePressedOnObject(e, this, j);
            } else {
                this.sentClick = false;
            }
            return;
        }
        this.moveToGrid(e);
        this.draggingSelectionBox = true;
        this.beginDraggingBox(p, false);
        this.sentClick = false;
    }

    public void mouseDragged(MouseEvent e) {
        this.moveToGrid(e);
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        Graphics g = this.getGraphics();
        if (this.draggingBox) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            if (this.dragPoint != null) {
                g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        g.dispose();
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    public void mouseReleased(MouseEvent e) {
        ObjectInfo info;
        Graphics g = this.getGraphics();
        Vector obj = this.theScene.getObjects();
        int[] sel = this.theScene.getSelection();
        this.moveToGrid(e);
        if (this.draggingBox && this.dragPoint != null) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        if (this.draggingSelectionBox) {
            this.dragPoint = e.getPoint();
            Rectangle r = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
                this.parentFrame.updateMenus();
            }
            int i = 0;
            while (i < obj.size()) {
                info = (ObjectInfo)obj.elementAt(i);
                if (info.visible) {
                    this.theCamera.setObjectTransform(info.coords.fromLocal());
                    Rectangle b = this.theCamera.findScreenBounds(info.getBounds());
                    if (b != null && b.intersects(r)) {
                        if (!e.isShiftDown()) {
                            if (this.parentFrame instanceof LayoutWindow) {
                                ((LayoutWindow)this.parentFrame).addToSelection(i);
                            } else {
                                this.theScene.addToSelection(i);
                            }
                            this.parentFrame.updateMenus();
                        } else {
                            int j = 0;
                            while (j < sel.length && sel[j] != i) {
                                ++j;
                            }
                            if (j == sel.length) {
                                if (this.parentFrame instanceof LayoutWindow) {
                                    ((LayoutWindow)this.parentFrame).addToSelection(i);
                                } else {
                                    this.theScene.addToSelection(i);
                                }
                                this.parentFrame.updateMenus();
                            }
                        }
                    }
                }
                ++i;
            }
            if (this.currentTool.hilightSelection()) {
                this.parentFrame.updateImage();
            }
        }
        g.dispose();
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            info = (ObjectInfo)obj.elementAt(this.deselect);
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).removeFromSelection(this.deselect);
            } else {
                this.theScene.removeFromSelection(this.deselect);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.snapToGrid) {
            this.theCamera.setGrid(this.gridSpacing / (double)this.gridSubdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
        super.itemStateChanged(e);
    }
}

