/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.Mat4;
import artofillusion.MaterialPreviewer;
import artofillusion.Mesh;
import artofillusion.Nonlinear2DTriangle;
import artofillusion.NonlinearMapping2D;
import artofillusion.Object3D;
import artofillusion.RGBColor;
import artofillusion.RenderingTriangle;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureParameter;
import artofillusion.TextureSpec;
import artofillusion.Vec3;
import artofillusion.animation.Actor;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SphericalMapping
extends NonlinearMapping2D {
    CoordinateSystem coords;
    double xscale;
    double yscale;
    double offset;
    double ax;
    double ay;
    double dy;
    Mat4 toLocal;
    Mat4 fromLocal;
    boolean transform;

    public SphericalMapping(Texture theTexture) {
        super(theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.xscale = 360.0;
        this.yscale = 180.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Spherical";
    }

    void findCoefficients() {
        this.ax = -180.0 / (Math.PI * this.xscale);
        this.ay = -180.0 / (Math.PI * this.yscale);
        this.dy = this.offset * 180.0 / Math.PI;
        this.toLocal = this.coords.toLocal();
        this.fromLocal = this.coords.fromLocal();
        this.transform = this.fromLocal.m11 != 1.0 || this.fromLocal.m22 != 1.0 || this.fromLocal.m33 != 1.0;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = this.toLocal.timesDirection(vert[v1]);
        Vec3 c2 = this.toLocal.timesDirection(vert[v2]);
        Vec3 c3 = this.toLocal.timesDirection(vert[v3]);
        return new Nonlinear2DTriangle(v1, v2, v3, n1, n2, n3, c1, c2, c3, this);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (!this.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTextureSpec(spec, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
        if (this.texture.bumpMapped()) {
            double s = spec.bumpGrad.x * this.ax / r1;
            double t = spec.bumpGrad.y * this.ay / (r1 * r2);
            spec.bumpGrad.set(-s * z + t * x * y, -t * r1 * r1, s * x + t * z * y);
            if (this.transform) {
                this.fromLocal.transform(spec.bumpGrad);
            }
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        return this.texture.getDisplacement(theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (!this.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.coordsFromParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTransparency(trans, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    public Mat4 getPreTransform() {
        return this.toLocal;
    }

    public void getSpecIntermed(TextureSpec spec, double x, double y, double z, double size, double time, double[] param) {
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTextureSpec(spec, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
        if (this.texture.bumpMapped()) {
            double s = spec.bumpGrad.x * this.ax / r1;
            double t = spec.bumpGrad.y * this.ay / (r1 * r2);
            spec.bumpGrad.set(-s * z + t * x * y, -t * r1 * r1, s * x + t * z * y);
            if (this.transform) {
                this.fromLocal.transform(spec.bumpGrad);
            }
        }
    }

    public void getTransIntermed(RGBColor trans, double x, double y, double z, double size, double time, double[] param) {
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTransparency(trans, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    public double getDisplaceIntermed(double x, double y, double z, double size, double time, double[] param) {
        double theta = Math.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        return this.texture.getDisplacement(theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        SphericalMapping map = new SphericalMapping(tex);
        map.coords = this.coords.duplicate();
        map.offset = this.offset;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.setAppliesTo(this.appliesTo());
        return map;
    }

    public void copy(TextureMapping mapping) {
        SphericalMapping map = (SphericalMapping)mapping;
        this.coords = map.coords.duplicate();
        this.offset = map.offset;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.setAppliesTo(map.appliesTo());
    }

    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        p[this.numTextureParams] = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams + 1] = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams + 2] = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        p[this.numTextureParams].type = 1;
        p[this.numTextureParams + 1].type = 2;
        p[this.numTextureParams + 2].type = 3;
        return p;
    }

    public Panel getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public SphericalMapping(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.offset = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.offset);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends Panel
    implements ItemListener,
    TextListener {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField ytransField;
        Checkbox coordsFromParamsBox;
        Choice applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            this.theObject = obj;
            this.preview = preview;
            GridBagConstraints gc = new GridBagConstraints();
            Panel p = new Panel();
            this.setLayout(new GridBagLayout());
            gc.insets = new Insets(0, 0, 0, 5);
            gc.gridy = 0;
            p.setLayout(new GridBagLayout());
            p.add((Component)new Label("Width"), gc);
            this.xscaleField = new ValueField((double)Math.round(SphericalMapping.this.xscale * 1000.0) / 1000.0, 2, 5);
            p.add((Component)this.xscaleField, gc);
            p.add((Component)new Label("(degrees)"), gc);
            gc.gridy = 1;
            p.add((Component)new Label("Height"), gc);
            this.yscaleField = new ValueField((double)Math.round(SphericalMapping.this.yscale * 1000.0) / 1000.0, 2, 5);
            p.add((Component)this.yscaleField, gc);
            p.add((Component)new Label("(degrees)"), gc);
            gc.gridy = 2;
            p.add((Component)new Label("Offset"), gc);
            this.ytransField = new ValueField((double)Math.round(SphericalMapping.this.offset * 1000.0) / 1000.0, 0, 5);
            p.add((Component)this.ytransField, gc);
            p.add((Component)new Label("(degrees)"), gc);
            gc.gridwidth = 6;
            gc.gridy = 0;
            this.add((Component)p, gc);
            gc.gridy = 1;
            this.add((Component)new Label("Rotation:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 2;
            double[] angles = SphericalMapping.this.coords.getRotationAngles();
            this.add((Component)new Label("X"), gc);
            this.xrotField = new ValueField((double)Math.round(angles[0] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xrotField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yrotField = new ValueField((double)Math.round(angles[1] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.yrotField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zrotField = new ValueField((double)Math.round(angles[2] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.zrotField, gc);
            gc.gridwidth = 6;
            gc.gridy = 3;
            p = new Panel();
            this.add((Component)p, gc);
            p.add(new Label("Apply To:"));
            this.applyToChoice = new Choice();
            p.add(this.applyToChoice);
            this.applyToChoice.add("Front and Back Faces");
            this.applyToChoice.add("Front Faces Only");
            this.applyToChoice.add("Back Faces Only");
            this.applyToChoice.select(SphericalMapping.this.appliesTo());
            gc.gridy = 4;
            this.coordsFromParamsBox = new Checkbox("Bind Texture Coordinates to Surface", SphericalMapping.this.coordsFromParams);
            this.add((Component)this.coordsFromParamsBox, gc);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof Mesh || this.theObject instanceof Actor);
            this.xscaleField.addTextListener(this);
            this.yscaleField.addTextListener(this);
            this.ytransField.addTextListener(this);
            this.xrotField.addTextListener(this);
            this.yrotField.addTextListener(this);
            this.zrotField.addTextListener(this);
            this.coordsFromParamsBox.addItemListener(this);
            this.applyToChoice.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            SphericalMapping.this.coordsFromParams = this.coordsFromParamsBox.getState();
            SphericalMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(SphericalMapping.this.getTexture(), SphericalMapping.this);
            this.preview.render();
        }

        public void textValueChanged(TextEvent e) {
            SphericalMapping.this.xscale = this.xscaleField.getValue();
            SphericalMapping.this.yscale = this.yscaleField.getValue();
            SphericalMapping.this.offset = this.ytransField.getValue();
            SphericalMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            SphericalMapping.this.findCoefficients();
            this.preview.render();
        }
    }
}

