/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.CoordinateSystem;
import artofillusion.Curve;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.GenericTool;
import artofillusion.LayoutWindow;
import artofillusion.Mesh;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshVertex;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ObjectInfo;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMesh;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.ThickenMeshTool;
import artofillusion.ToolPalette;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueSlider;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class SplineMeshEditorWindow
extends MeshEditorWindow
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    ToolPalette modes;
    Menu editMenu;
    Menu meshMenu;
    Menu skeletonMenu;
    MenuItem[] editMenuItem;
    MenuItem[] meshMenuItem;
    MenuItem[] skeletonMenuItem;
    CheckboxMenuItem[] smoothItem;
    CheckboxMenuItem[] closedItem;
    Callback onClose;
    boolean topology;

    public SplineMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Callback onClose, boolean allowTopology) {
        super(parent, title, (Mesh)((Object)obj.object));
        ObjectInfo info = obj.duplicate(obj.object.duplicate());
        this.onClose = onClose;
        this.topology = allowTopology;
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new SplineMeshViewer(info, p3);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        Button btn = new Button("OK");
        p3.add(btn);
        btn.setActionCommand("ok");
        btn.addActionListener(this);
        btn = new Button("Cancel");
        p3.add(btn);
        btn.setActionCommand("cancel");
        btn.addActionListener(this);
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 9);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        this.tools.addTool(new ThickenMeshTool(this));
        this.tools.addTool(new SkeletonTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.modes = new ToolPalette(1, 2);
        p4.add((Component)this.modes, "South");
        this.modes.addTool(new GenericTool(this, "point.gif", "selected/point.gif"));
        this.modes.addTool(new GenericTool(this, "curve.gif", "selected/curve.gif"));
        ((SplineMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createMeshMenu((SplineMesh)obj.object);
        this.createSkeletonMenu((SplineMesh)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        this.oldMesh = (SplineMesh)obj.object;
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.updateMenus();
    }

    void createEditMenu() {
        this.editMenu = new Menu("Edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[1];
        this.undoItem = new MenuItem("Undo", new MenuShortcut(90));
        this.editMenu.add(this.undoItem);
        this.undoItem.setActionCommand("undo");
        this.undoItem.addActionListener(this);
        this.undoItem.setEnabled(false);
        MenuItem item = new MenuItem("Select All", new MenuShortcut(65));
        this.editMenu.add(item);
        item.setActionCommand("selectAll");
        item.addActionListener(this);
        this.editMenuItem[0] = new MenuItem("Extend Selection", new MenuShortcut(88));
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[0].setActionCommand("extendSelection");
        this.editMenuItem[0].addActionListener(this);
        this.editMenu.addSeparator();
        item = new MenuItem("Mesh Tension...", new MenuShortcut(77));
        this.editMenu.add(item);
        item.setActionCommand("setTension");
        item.addActionListener(this);
    }

    void createMeshMenu(SplineMesh obj) {
        this.meshMenu = new Menu("Mesh");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new MenuItem[8];
        this.meshMenuItem[0] = new MenuItem("Delete Selected Curves");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[0].setActionCommand("delete");
        this.meshMenuItem[0].addActionListener(this);
        this.meshMenuItem[1] = new MenuItem("Subdivide Selection");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[1].setActionCommand("subdivide");
        this.meshMenuItem[1].addActionListener(this);
        this.meshMenuItem[2] = new MenuItem("Edit Points...", new MenuShortcut(69));
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[2].setActionCommand("setPoints");
        this.meshMenuItem[2].addActionListener(this);
        this.meshMenuItem[3] = new MenuItem("Transform Points...", new MenuShortcut(84));
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[3].setActionCommand("transformPoints");
        this.meshMenuItem[3].addActionListener(this);
        this.meshMenuItem[4] = new MenuItem("Randomize Points...");
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[4].setActionCommand("randomize");
        this.meshMenuItem[4].addActionListener(this);
        this.meshMenuItem[5] = new MenuItem("Texture Parameters...", new MenuShortcut(80));
        this.meshMenu.add(this.meshMenuItem[5]);
        this.meshMenuItem[5].setActionCommand("parameters");
        this.meshMenuItem[5].addActionListener(this);
        MenuItem item = new MenuItem("Center Mesh");
        this.meshMenu.add(item);
        this.meshMenuItem[6] = new MenuItem("Extract Selected Curve");
        this.meshMenu.add(this.meshMenuItem[6]);
        this.meshMenuItem[6].setActionCommand("extractCurve");
        this.meshMenuItem[6].addActionListener(this);
        item.setActionCommand("center");
        item.addActionListener(this);
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = new MenuItem("Set Smoothness...", new MenuShortcut(83));
        this.meshMenu.add(this.meshMenuItem[7]);
        this.meshMenuItem[7].setActionCommand("smooth");
        this.meshMenuItem[7].addActionListener(this);
        Menu smoothMenu = new Menu("Smoothing Method");
        this.meshMenu.add(smoothMenu);
        this.smoothItem = new CheckboxMenuItem[2];
        this.smoothItem[0] = new CheckboxMenuItem("Interpolating", obj.getSmoothingMethod() == 2);
        smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[0].addItemListener(this);
        this.smoothItem[1] = new CheckboxMenuItem("Approximating", obj.getSmoothingMethod() == 3);
        smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[1].addItemListener(this);
        Menu closedMenu = new Menu("Closed");
        if (this.topology) {
            this.meshMenu.add(closedMenu);
        }
        this.closedItem = new CheckboxMenuItem[4];
        this.closedItem[0] = new CheckboxMenuItem("U Direction", obj.uclosed && !obj.vclosed);
        closedMenu.add(this.closedItem[0]);
        this.closedItem[0].addItemListener(this);
        this.closedItem[1] = new CheckboxMenuItem("V Direction", !obj.uclosed && obj.vclosed);
        closedMenu.add(this.closedItem[1]);
        this.closedItem[1].addItemListener(this);
        this.closedItem[2] = new CheckboxMenuItem("Both", obj.uclosed && obj.vclosed);
        closedMenu.add(this.closedItem[2]);
        this.closedItem[2].addItemListener(this);
        this.closedItem[3] = new CheckboxMenuItem("Neither", !obj.uclosed && !obj.vclosed);
        closedMenu.add(this.closedItem[3]);
        this.closedItem[3].addItemListener(this);
        if (this.topology) {
            item = new MenuItem("Invert Surface Normals");
            this.meshMenu.add(item);
            item.setActionCommand("reverseNormals");
            item.addActionListener(this);
        }
        if (ModellingApp.previewRenderer() != null) {
            this.meshMenu.addSeparator();
            item = new MenuItem("Render Preview...", new MenuShortcut(82));
            this.meshMenu.add(item);
            item.setActionCommand("render");
            item.addActionListener(this);
        }
    }

    void createSkeletonMenu(SplineMesh obj) {
        this.skeletonMenu = new Menu("Skeleton");
        this.menubar.add(this.skeletonMenu);
        this.skeletonMenuItem = new MenuItem[4];
        this.skeletonMenuItem[0] = new MenuItem("Edit Bone...", new MenuShortcut(68));
        this.skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenuItem[0].setActionCommand("editJoint");
        this.skeletonMenuItem[0].addActionListener(this);
        this.skeletonMenuItem[1] = new MenuItem("Delete Bone...");
        this.skeletonMenu.add(this.skeletonMenuItem[1]);
        this.skeletonMenuItem[1].setActionCommand("deleteJoint");
        this.skeletonMenuItem[1].addActionListener(this);
        this.skeletonMenuItem[2] = new MenuItem("Bind Points to Skeleton...");
        this.skeletonMenu.add(this.skeletonMenuItem[2]);
        this.skeletonMenuItem[2].setActionCommand("bindSkeleton");
        this.skeletonMenuItem[2].addActionListener(this);
        this.skeletonMenu.addSeparator();
        this.skeletonMenuItem[3] = new CheckboxMenuItem("Temporarily Detach Skeleton");
        this.skeletonMenu.add(this.skeletonMenuItem[3]);
        ((CheckboxMenuItem)this.skeletonMenuItem[3]).addItemListener(this);
    }

    public void setTool(EditingTool tool) {
        if (tool instanceof GenericTool) {
            ((SplineMeshViewer)this.theView).setSelectionMode(this.modes.getSelection());
        } else {
            this.theView.setTool(tool);
            this.currentTool = tool;
        }
    }

    public void updateMenus() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        boolean curvemode = ((SplineMeshViewer)this.theView).selectMode == 1;
        int count = 0;
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            this.editMenuItem[0].setEnabled(true);
            this.meshMenuItem[0].setEnabled(curvemode);
            this.meshMenuItem[1].setEnabled(curvemode);
            this.meshMenuItem[2].setEnabled(true);
            this.meshMenuItem[3].setEnabled(true);
            this.meshMenuItem[4].setEnabled(true);
            this.meshMenuItem[5].setEnabled(true);
            this.meshMenuItem[6].setEnabled(curvemode && count == 1);
            this.meshMenuItem[7].setEnabled(curvemode);
        } else {
            this.editMenuItem[0].setEnabled(false);
            i = 0;
            while (i < this.meshMenuItem.length) {
                this.meshMenuItem[i].setEnabled(false);
                ++i;
            }
        }
        Skeleton s = theMesh.getSkeleton();
        Joint selJoint = s.getJoint(this.theView.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
        this.skeletonMenuItem[1].setEnabled(selJoint != null && selJoint.children.length == 0);
        this.skeletonMenuItem[2].setEnabled(count > 0);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            if (this.theView.getCurrentTool() instanceof SkeletonTool) {
                this.deleteJointCommand();
            } else {
                this.deleteCommand();
            }
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
            if (((SplineMesh)this.oldMesh).getMaterial() != null) {
                if (!theMesh.isClosed()) {
                    MessageDialog dlg = new MessageDialog((Frame)this, new String[]{"You have modified this object so that it is no longer a closed surface.", "This means that it can no longer have a material assigned to it.  Are", "you sure you want to continue?"}, new String[]{"OK", "Cancel"});
                    if (dlg.getChoice() == 1) {
                        return;
                    }
                } else {
                    theMesh.setMaterial(((SplineMesh)this.oldMesh).getMaterial());
                    theMesh.setMaterialMapping(((SplineMesh)this.oldMesh).getMaterialMapping());
                }
            }
            this.oldMesh.copyObject(theMesh);
            this.oldMesh = null;
            this.dispose();
            this.onClose.execute();
        } else if (command.equals("cancel")) {
            this.oldMesh = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("extendSelection")) {
            this.extendSelectionCommand();
        } else if (command.equals("delete")) {
            this.deleteCommand();
        } else if (command.equals("subdivide")) {
            this.subdivideCommand();
        } else if (command.equals("setPoints")) {
            this.setPointsCommand();
        } else if (command.equals("transformPoints")) {
            this.transformPointsCommand();
        } else if (command.equals("randomize")) {
            this.randomizeCommand();
        } else if (command.equals("parameters")) {
            this.setParametersCommand();
        } else if (command.equals("center")) {
            this.centerCommand();
        } else if (command.equals("extractCurve")) {
            this.extractCurveCommand();
        } else if (command.equals("smooth")) {
            this.setSmoothnessCommand();
        } else if (command.equals("reverseNormals")) {
            this.reverseNormalsCommand();
        } else if (command.equals("setTension")) {
            this.setTensionCommand();
        } else if (command.equals("render")) {
            this.theView.previewObject();
        } else if (command.equals("editJoint")) {
            this.editJointCommand();
        } else if (command.equals("deleteJoint")) {
            this.deleteJointCommand();
        } else if (command.equals("bindSkeleton")) {
            this.bindSkeletonCommand();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.skeletonMenuItem[3]) {
            ((SplineMeshViewer)this.theView).setSkeletonDetached(((CheckboxMenuItem)this.skeletonMenuItem[3]).getState());
            return;
        }
        int i = 0;
        while (i < this.smoothItem.length) {
            if (source == this.smoothItem[i]) {
                this.setSmoothingMethod(i + 2);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.closedItem.length) {
            if (source == this.closedItem[i]) {
                this.setClosed(i);
                return;
            }
            ++i;
        }
        super.itemStateChanged(e);
    }

    void selectAllCommand() {
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ((SplineMeshViewer)this.theView).setSelection(selected);
    }

    void extendSelectionCommand() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        if (((SplineMeshViewer)this.theView).getSelectionMode() == 0) {
            int oldDist = MeshEditorWindow.tensionDistance;
            MeshEditorWindow.tensionDistance = 1;
            int[] dist = ((SplineMeshViewer)this.theView).getSelectionDistance();
            boolean[] selected = new boolean[dist.length];
            MeshEditorWindow.tensionDistance = oldDist;
            int i = 0;
            while (i < dist.length) {
                selected[i] = dist[i] == 0 || dist[i] == 1;
                ++i;
            }
            ((SplineMeshViewer)this.theView).setSelection(selected);
        } else {
            boolean[] oldSelection = ((SplineMeshViewer)this.theView).getSelection();
            boolean[] selected = new boolean[oldSelection.length];
            int usize = theMesh.usize;
            int vsize = theMesh.vsize;
            int i = 0;
            while (i < usize - 1) {
                if (oldSelection[i] || oldSelection[i + 1]) {
                    selected[i + 1] = true;
                    selected[i] = true;
                }
                ++i;
            }
            if (theMesh.uclosed && (oldSelection[0] || oldSelection[usize - 1])) {
                selected[usize - 1] = true;
                selected[0] = true;
            }
            int i2 = 0;
            while (i2 < vsize - 1) {
                if (oldSelection[usize + i2] || oldSelection[usize + i2 + 1]) {
                    selected[usize + i2 + 1] = true;
                    selected[usize + i2] = true;
                }
                ++i2;
            }
            if (theMesh.vclosed && (oldSelection[usize] || oldSelection[usize + vsize - 1])) {
                selected[usize + vsize - 1] = true;
                selected[usize] = true;
            }
            ((SplineMeshViewer)this.theView).setSelection(selected);
        }
    }

    void deleteCommand() {
        int unum = 0;
        int vnum = 0;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        float[] us = theMesh.usmoothness;
        float[] vs = theMesh.vsmoothness;
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        MeshVertex[] vt = theMesh.getVertices();
        int usize = theMesh.usize;
        int vsize = theMesh.vsize;
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (i < usize) {
            if (selected[i]) {
                ++unum;
            }
            ++i;
        }
        i = 0;
        while (i < vsize) {
            if (selected[i + usize]) {
                ++vnum;
            }
            ++i;
        }
        if (unum == 0 && vnum == 0) {
            return;
        }
        if (usize - unum < 2 || vsize - vnum < 2) {
            new MessageDialog((Frame)this, "A curve must have at least two points.");
            return;
        }
        if (theMesh.uclosed && usize - unum < 3 || theMesh.vclosed && vsize - vnum < 3) {
            new MessageDialog((Frame)this, "A closed curve must have at least three points.");
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        MeshVertex[][] v = new MeshVertex[usize - unum][vsize - vnum];
        float[] newus = new float[usize - unum];
        float[] newvs = new float[vsize - vnum];
        i = 0;
        int j = 0;
        while (i < usize) {
            if (!selected[i]) {
                int k = 0;
                int m = 0;
                while (k < vsize) {
                    if (!selected[k + usize]) {
                        newvs[m] = vs[k];
                        v[j][m++] = vt[i + k * usize];
                    }
                    ++k;
                }
                newus[j++] = us[i];
            }
            ++i;
        }
        theMesh.setShape(v, newus, newvs);
        this.theView.setMesh(theMesh);
        this.updateImage();
    }

    void subdivideCommand() {
        int j;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        float[] us = theMesh.usmoothness;
        float[] vs = theMesh.vsmoothness;
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int usplitcount = 0;
        int vsplitcount = 0;
        int method = theMesh.getSmoothingMethod();
        int usize = theMesh.usize;
        int vsize = theMesh.vsize;
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (!selected[i] && i < selected.length) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        boolean[] splitu = theMesh.uclosed ? new boolean[usize] : new boolean[usize - 1];
        i = 0;
        while (i < splitu.length) {
            if (selected[i] && selected[(i + 1) % usize]) {
                splitu[i] = true;
                ++usplitcount;
            }
            ++i;
        }
        boolean[] splitv = theMesh.vclosed ? new boolean[vsize] : new boolean[vsize - 1];
        i = 0;
        while (i < splitv.length) {
            if (selected[i + usize] && selected[(i + 1) % vsize + usize]) {
                splitv[i] = true;
                ++vsplitcount;
            }
            ++i;
        }
        float[] newus = new float[usize + usplitcount];
        float[] newvs = new float[vsize + vsplitcount];
        boolean[] newsel = new boolean[selected.length + usplitcount + vsplitcount];
        MeshVertex[][] v = new MeshVertex[vsize][usize];
        i = 0;
        while (i < usize) {
            j = 0;
            while (j < vsize) {
                v[j][i] = vt[i + j * usize];
                ++j;
            }
            ++i;
        }
        MeshVertex[][] newv = new MeshVertex[vsize][usize + usplitcount];
        this.splitOneAxis(v, newv, us, newus, splitu, theMesh.uclosed);
        v = new MeshVertex[usize + usplitcount][vsize];
        i = 0;
        while (i < v.length) {
            j = 0;
            while (j < v[i].length) {
                v[i][j] = newv[j][i];
                ++j;
            }
            ++i;
        }
        newv = new MeshVertex[usize + usplitcount][vsize + vsplitcount];
        this.splitOneAxis(v, newv, vs, newvs, splitv, theMesh.vclosed);
        i = 0;
        j = 0;
        while (i < usize) {
            if (selected[i]) {
                newsel[j] = true;
            }
            if (i < splitu.length && splitu[i]) {
                newsel[++j] = true;
            }
            ++j;
            ++i;
        }
        i = 0;
        j = 0;
        while (i < vsize) {
            if (selected[i + usize]) {
                newsel[j + usize + usplitcount] = true;
            }
            if (i < splitv.length && splitv[i]) {
                newsel[++j + usize + usplitcount] = true;
            }
            ++j;
            ++i;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.setShape(newv, newus, newvs);
        this.theView.setMesh(theMesh);
        ((SplineMeshViewer)this.theView).setSelection(newsel);
    }

    private void splitOneAxis(MeshVertex[][] v, MeshVertex[][] newv, float[] s, float[] news, boolean[] split, boolean closed) {
        int k;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        int method = theMesh.getSmoothingMethod();
        int i = 0;
        int j = 0;
        while (i < split.length) {
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = closed ? v[0].length - 1 : 0;
            }
            int p3 = i < v[0].length - 1 ? i + 1 : (closed ? 0 : v[0].length - 1);
            if ((split[i] || split[p1]) && method == 3) {
                k = 0;
                while (k < v.length) {
                    newv[k][j] = SplineMesh.calcApproxPoint(v[k], s, p1, i, p3);
                    ++k;
                }
            } else {
                k = 0;
                while (k < v.length) {
                    newv[k][j] = v[k][i];
                    ++k;
                }
            }
            news[j] = split[i] || split[p1] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
            } else {
                if (method == 0) {
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                        ++k;
                    }
                } else if (method == 2) {
                    int p4 = i < v[0].length - 2 ? i + 2 : (closed ? (i + 2) % v[0].length : v[0].length - 1);
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = SplineMesh.calcInterpPoint(v[k], s, p1, i, p3, p4);
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < v.length) {
                        newv[k][j + 1] = MeshVertex.blend(v[k][i], v[k][p3], 0.5, 0.5);
                        ++k;
                    }
                }
                news[j + 1] = 1.0f;
                j += 2;
            }
            ++i;
        }
        if (!closed) {
            k = 0;
            while (k < v.length) {
                newv[k][0] = v[k][0];
                newv[k][j] = v[k][i];
                ++k;
            }
            news[j] = s[i];
        }
    }

    void extractCurveCommand() {
        Vec3[] v;
        boolean closed;
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        int usize = theMesh.usize;
        int vsize = theMesh.vsize;
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int which = 0;
        while (which < selected.length && !selected[which]) {
            ++which;
        }
        if (which == selected.length) {
            return;
        }
        if (which < usize) {
            closed = theMesh.vclosed;
            v = new Vec3[vsize];
        } else {
            closed = theMesh.uclosed;
            v = new Vec3[usize];
        }
        float[] smoothness = new float[v.length];
        int i = 0;
        while (i < v.length) {
            if (which < usize) {
                v[i] = vt[which + i * usize].r;
                smoothness[i] = theMesh.vsmoothness[i];
            } else {
                v[i] = vt[(which - usize) * usize + i].r;
                smoothness[i] = theMesh.usmoothness[i];
            }
            ++i;
        }
        Curve cv = new Curve(v, smoothness, theMesh.getSmoothingMethod(), closed);
        Component parent = (Component)((Object)this.parentWindow);
        while (parent != null && !(parent instanceof LayoutWindow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            ((LayoutWindow)parent).addObject(cv, new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0)), "Extracted Curve", null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    void setSmoothnessCommand() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        MeshVertex[] vt = theMesh.getVertices();
        boolean[] selected = ((SplineMeshViewer)this.theView).getSelection();
        float[] usmoothness = theMesh.usmoothness;
        float[] vsmoothness = theMesh.vsmoothness;
        if (((SplineMeshViewer)this.theView).getSelectionMode() != 1) {
            return;
        }
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        float value = i < theMesh.usize ? usmoothness[i] : vsmoothness[i - theMesh.usize];
        ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value = 0.001f * (float)Math.round(value * 1000.0f));
        ComponentsDialog dlg = new ComponentsDialog((Frame)this, "Set Smoothness for Selected Curves", new Component[]{smoothness}, new String[]{"Smoothness"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                if (i < theMesh.usize) {
                    usmoothness[i] = (float)smoothness.getValue();
                } else {
                    vsmoothness[i - theMesh.usize] = (float)smoothness.getValue();
                }
            }
            ++i;
        }
        theMesh.setSmoothness(usmoothness, vsmoothness);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void reverseNormalsCommand() {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseOrientation();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setSmoothingMethod(int method) {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        int i = 0;
        while (i < this.smoothItem.length) {
            this.smoothItem[i].setState(false);
            ++i;
        }
        this.smoothItem[method - 2].setState(true);
        theMesh.setSmoothingMethod(method);
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setClosed(int item) {
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        int i = 0;
        while (i < this.closedItem.length) {
            this.closedItem[i].setState(i == item);
            ++i;
        }
        theMesh.setClosed(item == 0 || item == 2, item == 1 || item == 2);
        this.theView.setMesh(theMesh);
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void adjustDeltas(Vec3[] delta) {
        int[] dist = this.theView.getSelectionDistance();
        int[] count = new int[delta.length];
        SplineMesh theMesh = (SplineMesh)this.theView.getObject().object;
        int maxDistance = MeshEditorWindow.getTensionDistance();
        int usize = theMesh.usize;
        int vsize = theMesh.vsize;
        double tension = MeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        int i = 0;
        while (i < delta.length) {
            if (dist[i] != 0) {
                delta[i].set(0.0, 0.0, 0.0);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < maxDistance) {
            int j = 0;
            while (j < count.length) {
                count[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < usize) {
                int k = 0;
                while (k < vsize) {
                    if (dist[j2 + k * usize] == i2) {
                        if (j2 == 0) {
                            if (theMesh.uclosed && dist[usize - 1 + k * usize] == i2 + 1) {
                                int n = usize - 1 + k * usize;
                                count[n] = count[n] + 1;
                                delta[usize - 1 + k * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 - 1 + k * usize] == i2 + 1) {
                            int n = j2 - 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[j2 - 1 + k * usize].add(delta[j2 + k * usize]);
                        }
                        if (j2 == usize - 1) {
                            if (theMesh.uclosed && dist[k * usize] == i2 + 1) {
                                int n = k * usize;
                                count[n] = count[n] + 1;
                                delta[k * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + 1 + k * usize] == i2 + 1) {
                            int n = j2 + 1 + k * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + 1 + k * usize].add(delta[j2 + k * usize]);
                        }
                        if (k == 0) {
                            if (theMesh.vclosed && dist[j2 + (vsize - 1) * usize] == i2 + 1) {
                                int n = j2 + (vsize - 1) * usize;
                                count[n] = count[n] + 1;
                                delta[j2 + (vsize - 1) * usize].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + (k - 1) * usize] == i2 + 1) {
                            int n = j2 + (k - 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + (k - 1) * usize].add(delta[j2 + k * usize]);
                        }
                        if (k == vsize - 1) {
                            if (theMesh.vclosed && dist[j2] == i2 + 1) {
                                dist[j2 + k * usize] = i2 + 1;
                                int n = j2;
                                count[n] = count[n] + 1;
                                delta[j2].add(delta[j2 + k * usize]);
                            }
                        } else if (dist[j2 + (k + 1) * usize] == i2 + 1) {
                            int n = j2 + (k + 1) * usize;
                            count[n] = count[n] + 1;
                            delta[j2 + (k + 1) * usize].add(delta[j2 + k * usize]);
                        }
                    }
                    ++k;
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < count.length) {
                if (count[j3] > 1) {
                    delta[j3].scale(1.0 / (double)count[j3]);
                }
                ++j3;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < scale.length) {
            scale[i3] = Math.pow(((double)(maxDistance - i3) + 1.0) / ((double)maxDistance + 1.0), tension);
            ++i3;
        }
        int i4 = 0;
        while (i4 < delta.length) {
            if (dist[i4] > 0) {
                delta[i4].scale(scale[dist[i4]]);
            }
            ++i4;
        }
    }
}

