/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.Mesh;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshVertex;
import artofillusion.MeshViewer;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.SplineMesh;
import artofillusion.Vec2;
import artofillusion.Vec3;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SplineMeshViewer
extends MeshViewer {
    boolean[] selected;
    boolean[] visible;
    boolean draggingSelectionBox;
    boolean dragging;
    int[] selectionDistance;
    int maxDistance;
    int deselect;
    int selectMode;
    Point[] screenVert;
    double[] screenZ;
    public static final int POINT_MODE = 0;
    public static final int CURVE_MODE = 1;
    static final RGBColor surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
    static final Color surfaceColor = new Color(0.8f, 0.8f, 1.0f);

    public SplineMeshViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
        SplineMesh mesh = (SplineMesh)obj.object;
        this.selected = new boolean[mesh.getVertices().length];
        this.visible = new boolean[mesh.getVertices().length];
        this.findSelectionDistance();
    }

    void drawObject(Graphics g) {
        int j;
        RenderingMesh mesh;
        MeshVertex[] v = ((SplineMesh)this.theObject).getVertices();
        Dimension dim = this.getSize();
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        boolean uclosed = ((SplineMesh)this.theObject).uclosed;
        boolean vclosed = ((SplineMesh)this.theObject).vclosed;
        if (this.renderMode == 0) {
            g.setColor(surfaceColor);
            Object3D.draw(g, this.theCamera, this.theObject.getWireframeMesh(), this.theObject.getBounds());
        } else if (this.renderMode == 3) {
            mesh = this.theObject.getRenderingMesh(0.05, true, this.objInfo);
            this.renderFlatTransparent(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB);
        } else if (this.renderMode == 1) {
            mesh = this.theObject.getRenderingMesh(0.05, true, this.objInfo);
            this.renderFlat(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), surfaceRGB);
        } else {
            mesh = this.theObject.getRenderingMesh(0.05, true, this.objInfo);
            this.renderSmooth(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), surfaceRGB);
        }
        if (((SplineMesh)this.theObject).getSkeleton() != null) {
            ((SplineMesh)this.theObject).getSkeleton().draw(this, this.getSelectedJoint(), this.getBaseJoint());
        }
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        Vec2[] p = new Vec2[v.length];
        int i = 0;
        while (i < v.length) {
            p[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.visible[i] = this.screenZ[i] > this.theCamera.getClipDistance();
            ++i;
        }
        Color col = Color.black;
        if (this.renderMode == 1 || this.renderMode == 2) {
            if (this.selectMode == 0) {
                i = 0;
                while (i < usize) {
                    j = 0;
                    while (j < vsize - 1) {
                        this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + (j + 1) * usize], this.screenZ[i + (j + 1) * usize], this.theCamera, col.getRGB());
                        ++j;
                    }
                    if (vclosed) {
                        this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i], this.screenZ[i], this.theCamera, col.getRGB());
                    }
                    ++i;
                }
                j = 0;
                while (j < vsize) {
                    i = 0;
                    while (i < usize - 1) {
                        this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + 1 + j * usize], this.screenZ[i + 1 + j * usize], this.theCamera, col.getRGB());
                        ++i;
                    }
                    if (uclosed) {
                        this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[j * usize], this.screenZ[j * usize], this.theCamera, col.getRGB());
                    }
                    ++j;
                }
                i = 0;
                while (i < v.length) {
                    if (!this.selected[i] && this.visible[i]) {
                        this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i], col);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < usize) {
                    if (!this.selected[i]) {
                        j = 0;
                        while (j < vsize - 1) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + (j + 1) * usize], this.screenZ[i + (j + 1) * usize], this.theCamera, col.getRGB());
                            ++j;
                        }
                        if (vclosed) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i], this.screenZ[i], this.theCamera, col.getRGB());
                        }
                    }
                    ++i;
                }
                j = 0;
                while (j < vsize) {
                    if (!this.selected[j + usize]) {
                        i = 0;
                        while (i < usize - 1) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + 1 + j * usize], this.screenZ[i + 1 + j * usize], this.theCamera, col.getRGB());
                            ++i;
                        }
                        if (uclosed) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[j * usize], this.screenZ[j * usize], this.theCamera, col.getRGB());
                        }
                    }
                    ++j;
                }
            }
        } else if (this.selectMode == 0) {
            i = 0;
            while (i < usize) {
                j = 0;
                while (j < vsize - 1) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], col);
                    ++j;
                }
                if (vclosed) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], col);
                }
                ++i;
            }
            j = 0;
            while (j < vsize) {
                i = 0;
                while (i < usize - 1) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], col);
                    ++i;
                }
                if (uclosed) {
                    this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], col);
                }
                ++j;
            }
            i = 0;
            while (i < v.length) {
                if (!this.selected[i] && this.visible[i]) {
                    this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, col);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < usize) {
                if (!this.selected[i]) {
                    j = 0;
                    while (j < vsize - 1) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], col);
                        ++j;
                    }
                    if (vclosed) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], col);
                    }
                }
                ++i;
            }
            j = 0;
            while (j < vsize) {
                if (!this.selected[j + usize]) {
                    i = 0;
                    while (i < usize - 1) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], col);
                        ++i;
                    }
                    if (uclosed) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], col);
                    }
                }
                ++j;
            }
        }
        if (this.currentTool.hilightSelection()) {
            col = Color.magenta;
        }
        if (this.renderMode == 1 || this.renderMode == 2) {
            if (this.selectMode == 0) {
                i = 0;
                while (i < v.length) {
                    if (this.selected[i] && this.visible[i]) {
                        this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i], col);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < usize) {
                    if (this.selected[i]) {
                        j = 0;
                        while (j < vsize - 1) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + (j + 1) * usize], this.screenZ[i + (j + 1) * usize], this.theCamera, col.getRGB());
                            ++j;
                        }
                        if (vclosed) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i], this.screenZ[i], this.theCamera, col.getRGB());
                        }
                    }
                    ++i;
                }
                j = 0;
                while (j < vsize) {
                    if (this.selected[j + usize]) {
                        i = 0;
                        while (i < usize - 1) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[i + 1 + j * usize], this.screenZ[i + 1 + j * usize], this.theCamera, col.getRGB());
                            ++i;
                        }
                        if (uclosed) {
                            this.renderLine(p[i + j * usize], this.screenZ[i + j * usize], p[j * usize], this.screenZ[j * usize], this.theCamera, col.getRGB());
                        }
                    }
                    ++j;
                }
            }
        } else if (this.selectMode == 0) {
            i = 0;
            while (i < v.length) {
                if (this.selected[i] && this.visible[i]) {
                    this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, col);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < usize) {
                if (this.selected[i]) {
                    j = 0;
                    while (j < vsize - 1) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + (j + 1) * usize], col);
                        ++j;
                    }
                    if (vclosed) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i], col);
                    }
                }
                ++i;
            }
            j = 0;
            while (j < vsize) {
                if (this.selected[j + usize]) {
                    i = 0;
                    while (i < usize - 1) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[i + 1 + j * usize], col);
                        ++i;
                    }
                    if (uclosed) {
                        this.drawLine(this.screenVert[i + j * usize], this.screenVert[j * usize], col);
                    }
                }
                ++j;
            }
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v) {
        int j;
        MeshVertex[] vert = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        boolean uclosed = ((SplineMesh)this.theObject).uclosed;
        boolean vclosed = ((SplineMesh)this.theObject).vclosed;
        int i = 0;
        while (i < usize) {
            j = 0;
            while (j < vsize - 1) {
                if (vert[i + j * usize].r != v[i + j * usize] || vert[i + (j + 1) * usize].r != v[i + (j + 1) * usize]) {
                    cam.drawClippedLine(g, v[i + j * usize], v[i + (j + 1) * usize]);
                }
                ++j;
            }
            if (vclosed && (vert[i + j * usize].r != v[i + j * usize] || vert[i].r != v[i])) {
                cam.drawClippedLine(g, v[i + j * usize], v[i]);
            }
            ++i;
        }
        j = 0;
        while (j < vsize) {
            i = 0;
            while (i < usize - 1) {
                if (vert[i + j * usize].r != v[i + j * usize] || vert[i + 1 + j * usize].r != v[i + 1 + j * usize]) {
                    cam.drawClippedLine(g, v[i + j * usize], v[i + 1 + j * usize]);
                }
                ++i;
            }
            if (uclosed && (vert[i + j * usize].r != v[i + j * usize] || vert[j * usize].r != v[j * usize])) {
                cam.drawClippedLine(g, v[i + j * usize], v[j * usize]);
            }
            ++j;
        }
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        MeshVertex[] vert = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        boolean uclosed = ((SplineMesh)this.theObject).uclosed;
        boolean vclosed = ((SplineMesh)this.theObject).vclosed;
        if (mode == this.selectMode) {
            return;
        }
        if (mode == 0) {
            int j;
            newSel = new boolean[vert.length];
            int i = 0;
            while (i < usize) {
                if (this.selected[i]) {
                    j = 0;
                    while (j < vsize) {
                        newSel[i + j * usize] = true;
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < vsize) {
                if (this.selected[i + usize]) {
                    j = 0;
                    while (j < usize) {
                        newSel[j + i * usize] = true;
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            newSel = new boolean[usize + vsize];
            int i = 0;
            while (i < newSel.length) {
                newSel[i++] = true;
            }
            i = 0;
            while (i < usize) {
                int j = 0;
                while (j < vsize) {
                    if (!this.selected[i + j * usize]) {
                        newSel[j + usize] = false;
                        newSel[i] = false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.selectMode = mode;
        this.setSelection(newSel);
    }

    public int getSelectionMode() {
        return this.selectMode;
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != MeshEditorWindow.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        int j;
        int i;
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        boolean uclosed = ((SplineMesh)this.theObject).uclosed;
        boolean vclosed = ((SplineMesh)this.theObject).vclosed;
        int[] dist = new int[((SplineMesh)this.theObject).getVertices().length];
        this.maxDistance = MeshEditorWindow.getTensionDistance();
        if (this.selectMode == 0) {
            i = 0;
            while (i < dist.length) {
                dist[i] = this.selected[i] ? 0 : -1;
                ++i;
            }
        } else {
            i = 0;
            while (i < usize) {
                j = 0;
                while (j < vsize) {
                    dist[i + j * usize] = this.selected[i] || this.selected[j + usize] ? 0 : -1;
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.maxDistance) {
            j = 0;
            while (j < usize) {
                int k = 0;
                while (k < vsize) {
                    if (dist[j + k * usize] == -1) {
                        if (j == 0) {
                            if (uclosed && dist[usize - 1 + k * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j - 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (j == usize - 1) {
                            if (uclosed && dist[k * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j + 1 + k * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (k == 0) {
                            if (vclosed && dist[j + (vsize - 1) * usize] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j + (k - 1) * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                        if (k == vsize - 1) {
                            if (vclosed && dist[j] == i) {
                                dist[j + k * usize] = i + 1;
                            }
                        } else if (dist[j + (k + 1) * usize] == i) {
                            dist[j + k * usize] = i + 1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        SplineMesh obj = (SplineMesh)mesh;
        this.setObject(obj);
        if (this.selectMode == 0 && this.selected.length != obj.getVertices().length) {
            this.selected = new boolean[obj.getVertices().length];
            this.visible = new boolean[obj.getVertices().length];
        }
        if (this.selectMode == 1 && this.selected.length != obj.usize + obj.vsize) {
            this.selected = new boolean[obj.usize + obj.vsize];
            this.visible = new boolean[obj.getVertices().length];
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
    }

    public void mousePressed(MouseEvent e) {
        int k;
        int j;
        MeshVertex[] v = ((SplineMesh)this.theObject).getVertices();
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        Point pos = e.getPoint();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingBox(pos, false);
            this.sentClick = false;
            return;
        }
        if (this.selectMode == 1) {
            int dist;
            j = 0;
            int closest = Integer.MAX_VALUE;
            if (i < usize) {
                k = 0;
                while (k < vsize) {
                    dist = Math.abs(pos.x - this.screenVert[i + usize * k].x) + Math.abs(pos.y - this.screenVert[i + usize * k].y);
                    if (dist < closest) {
                        j = i + usize * k;
                    }
                    ++k;
                }
            } else {
                k = 0;
                while (k < usize) {
                    dist = Math.abs(pos.x - this.screenVert[k + usize * (i - usize)].x) + Math.abs(pos.y - this.screenVert[k + usize * (i - usize)].y);
                    if (dist < closest) {
                        j = k + usize * (i - usize);
                    }
                    ++k;
                }
            }
        } else {
            j = i;
        }
        if (this.selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            return;
        }
        if (!e.isShiftDown()) {
            k = 0;
            while (k < this.selected.length) {
                this.selected[k] = false;
                ++k;
            }
        }
        this.selected[i] = true;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        Graphics g = this.getGraphics();
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        this.moveToGrid(e);
        if (this.draggingBox && this.dragPoint != null) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        if (this.draggingSelectionBox) {
            boolean newsel;
            int i;
            this.dragPoint = e.getPoint();
            Rectangle r = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            if (!e.isShiftDown() && !e.isControlDown()) {
                i = 0;
                while (i < this.selected.length) {
                    this.selected[i] = false;
                    ++i;
                }
            }
            boolean bl = newsel = !e.isControlDown();
            if (this.selectMode == 0) {
                i = 0;
                while (i < this.selected.length) {
                    if (r.contains(this.screenVert[i])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            } else {
                int j;
                i = 0;
                while (i < usize) {
                    j = 0;
                    while (j < vsize && r.contains(this.screenVert[i + j * usize])) {
                        ++j;
                    }
                    if (j == vsize) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
                i = 0;
                while (i < vsize) {
                    j = 0;
                    while (j < usize && r.contains(this.screenVert[j + i * usize])) {
                        ++j;
                    }
                    if (j == usize) {
                        this.selected[i + usize] = newsel;
                    }
                    ++i;
                }
            }
            this.findSelectionDistance();
            this.currentTool.getWindow().updateMenus();
            this.updateImage();
            this.repaint();
        }
        g.dispose();
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
            this.findSelectionDistance();
            this.currentTool.getWindow().updateMenus();
            this.updateImage();
            this.repaint();
        }
    }

    int findClickTarget(Point pos) {
        MeshVertex[] vt = ((SplineMesh)this.theObject).getVertices();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        boolean uclosed = ((SplineMesh)this.theObject).uclosed;
        boolean vclosed = ((SplineMesh)this.theObject).vclosed;
        int usize = ((SplineMesh)this.theObject).usize;
        int vsize = ((SplineMesh)this.theObject).vsize;
        if (this.selectMode == 0) {
            int i = 0;
            while (i < vt.length) {
                if (this.visible[i] && (!sel || this.selected[i])) {
                    double z;
                    Point v1 = this.screenVert[i];
                    if (pos.x >= v1.x - 2 && pos.x <= v1.x + 2 && pos.y >= v1.y - 2 && pos.y <= v1.y + 2 && (z = this.theCamera.getObjectToView().timesZ(vt[i].r)) < closestz) {
                        which = i;
                        closestz = z;
                        sel = this.selected[i];
                    }
                }
                ++i;
            }
        } else {
            double z;
            int j;
            int i = 0;
            while (i < usize) {
                if (!sel || this.selected[i]) {
                    j = 1;
                    while (j < vsize) {
                        z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i + j * usize);
                        if (z < closestz) {
                            which = i;
                            closestz = z;
                            sel = this.selected[i];
                        }
                        ++j;
                    }
                    if (vclosed && (z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i)) < closestz) {
                        which = i;
                        closestz = z;
                        sel = this.selected[i];
                    }
                }
                ++i;
            }
            i = 0;
            while (i < vsize) {
                if (!sel || this.selected[i + usize]) {
                    j = 1;
                    while (j < usize) {
                        z = this.lineClickDepth(pos, vt, j - 1 + i * usize, j + i * usize);
                        if (z < closestz) {
                            which = i + usize;
                            closestz = z;
                            sel = this.selected[i + usize];
                        }
                        ++j;
                    }
                    if (vclosed && (z = this.lineClickDepth(pos, vt, j - 1 + i * usize, i * usize)) < closestz) {
                        which = i + usize;
                        closestz = z;
                        sel = this.selected[i + usize];
                    }
                }
                ++i;
            }
        }
        return which;
    }

    private double lineClickDepth(Point pos, MeshVertex[] vt, int p1, int p2) {
        double w;
        double u;
        double v;
        if (!this.visible[p1] || !this.visible[p2]) {
            return Double.MAX_VALUE;
        }
        Point v1 = this.screenVert[p1];
        Point v2 = this.screenVert[p2];
        if (pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2) {
            return Double.MAX_VALUE;
        }
        if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
            if (v2.x > v1.x) {
                v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                u = 1.0 - v;
            } else {
                u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                v = 1.0 - u;
            }
            w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
        } else {
            if (v2.y > v1.y) {
                v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                u = 1.0 - v;
            } else {
                u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                v = 1.0 - u;
            }
            w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
        }
        if (Math.abs(w) > 2.0) {
            return Double.MAX_VALUE;
        }
        return u * this.theCamera.getObjectToView().timesZ(vt[p1].r) + v * this.theCamera.getObjectToView().timesZ(vt[p2].r);
    }
}

