/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.Object3D;
import artofillusion.RGBColor;
import artofillusion.RenderingTriangle;
import artofillusion.Texture;
import artofillusion.TextureParameter;
import artofillusion.TextureSpec;
import artofillusion.Vec3;
import java.awt.Panel;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class TextureMapping {
    private boolean twoSided = true;
    private boolean applyToFront = true;
    public static final short FRONT_AND_BACK = 0;
    public static final short FRONT_ONLY = 1;
    public static final short BACK_ONLY = 2;

    public abstract void writeToFile(DataOutputStream var1) throws IOException;

    public abstract Texture getTexture();

    public static String getName() {
        return "";
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return null;
    }

    public abstract void getTextureSpec(Vec3 var1, TextureSpec var2, boolean var3, double var4, double var6, double[] var8);

    public abstract void getTransparency(Vec3 var1, RGBColor var2, boolean var3, double var4, double var6, double[] var8);

    public abstract double getDisplacement(Vec3 var1, double var2, double var4, double[] var6);

    public abstract TextureMapping duplicate();

    public abstract TextureMapping duplicate(Texture var1);

    public abstract void copy(TextureMapping var1);

    public TextureParameter[] getParameters() {
        return this.getTexture().getParameters();
    }

    public short appliesTo() {
        if (this.twoSided) {
            return 0;
        }
        return this.applyToFront ? (short)1 : 2;
    }

    public final boolean appliesToFace(boolean front) {
        return this.twoSided || front == this.applyToFront;
    }

    public void setAppliesTo(short whichFaces) {
        if (whichFaces == 0) {
            this.twoSided = true;
        } else {
            this.twoSided = false;
            this.applyToFront = whichFaces == 1;
        }
    }

    public abstract Panel getEditingPanel(Object3D var1, MaterialPreviewer var2);
}

