/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayeredMapping;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Object3D;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class TextureMappingDialog
extends Dialog
implements ActionListener,
ItemListener {
    Frame fr;
    Object3D obj;
    Vector mappings;
    Choice mapChoice;
    MaterialPreviewer preview;
    TextureMapping map;
    TextureMapping oldMapping;
    Panel editingPanel;
    boolean layered;
    int layer;
    static /* synthetic */ Class class$artofillusion$Object3D;
    static /* synthetic */ Class class$artofillusion$Texture;

    public TextureMappingDialog(Frame parent, Object3D obj, int layer) {
        super(parent, "Texture Mapping", true);
        this.fr = parent;
        this.obj = obj;
        this.layer = layer;
        this.map = obj.getTextureMapping();
        this.layered = this.map instanceof LayeredMapping;
        if (this.layered) {
            this.map = ((LayeredMapping)this.map).getLayerMapping(layer);
        }
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Class[] allMappings = ModellingApp.getTextureMappings();
        int i = 0;
        while (i < allMappings.length) {
            try {
                Method mtd = allMappings[i].getMethod("legalMapping", class$artofillusion$Object3D == null ? TextureMappingDialog.class$("artofillusion.Object3D") : class$artofillusion$Object3D, class$artofillusion$Texture == null ? TextureMappingDialog.class$("artofillusion.Texture") : class$artofillusion$Texture);
                Texture tex = this.layered ? ((LayeredMapping)obj.getTextureMapping()).getLayer(layer) : obj.getTexture();
                Boolean result = (Boolean)mtd.invoke(null, obj, tex);
                if (result.booleanValue()) {
                    this.mappings.addElement(allMappings[i]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gc.gridwidth = 2;
        this.preview = new MaterialPreviewer(obj.getTexture(), obj.getMaterial(), obj.duplicate(), 161, 160);
        this.add((Component)this.preview, gc);
        this.preview.setTexture(obj.getTexture(), obj.getTextureMapping());
        gc.gridwidth = 1;
        gc.gridy = 1;
        this.add((Component)new Label("Mapping:"), gc);
        this.mapChoice = new Choice();
        this.add((Component)this.mapChoice, gc);
        int i2 = 0;
        while (i2 < this.mappings.size()) {
            try {
                Method mtd = ((Class)this.mappings.elementAt(i2)).getMethod("getName", null);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.elementAt(i2) == this.map.getClass()) {
                    this.mapChoice.select(i2);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            ++i2;
        }
        this.mapChoice.addItemListener(this);
        gc.gridwidth = 2;
        gc.gridy = 2;
        this.editingPanel = this.map.getEditingPanel(obj, this.preview);
        this.add((Component)this.editingPanel, gc);
        Panel p = new Panel();
        gc.gridwidth = 2;
        gc.gridy = 3;
        this.add((Component)p, gc);
        Button b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (command.equals("cancel")) {
            this.setMapping(this.oldMapping);
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        try {
            Class cls = (Class)this.mappings.elementAt(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(class$artofillusion$Texture == null ? (class$artofillusion$Texture = TextureMappingDialog.class$("artofillusion.Texture")) : class$artofillusion$Texture);
            Texture tex = this.layered ? ((LayeredMapping)this.obj.getTextureMapping()).getLayer(this.layer) : this.obj.getTexture();
            this.setMapping((TextureMapping)con.newInstance(tex));
            this.remove(this.editingPanel);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridwidth = 2;
            gc.gridy = 2;
            this.editingPanel = this.map.getEditingPanel(this.obj, this.preview);
            this.add((Component)this.editingPanel, gc);
            this.pack();
            this.preview.render();
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    private void setMapping(TextureMapping newmap) {
        this.map = newmap;
        if (this.layered) {
            ((LayeredMapping)this.obj.getTextureMapping()).setLayerMapping(this.layer, newmap);
        } else {
            this.obj.setTextureMapping(newmap);
            this.preview.setTexture(this.obj.getTexture(), newmap);
        }
        this.preview.render();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

