/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.EditingTool;
import artofillusion.ModellingApp;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ToolPalette
extends Canvas
implements MouseListener {
    int width;
    int height;
    int numTools;
    int selected;
    EditingTool[] tool;
    Dimension maxsize;

    public ToolPalette(int w, int h) {
        this.width = w;
        this.height = h;
        this.tool = new EditingTool[w * h];
        this.numTools = 0;
        this.selected = 0;
        this.maxsize = new Dimension(0, 0);
        this.addMouseListener(this);
        this.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
    }

    public void addTool(EditingTool t) {
        this.tool[this.numTools++] = t;
        int w = t.getIcon().getWidth(this);
        int h = t.getIcon().getHeight(this);
        if (w > this.maxsize.width) {
            this.maxsize.width = w;
        }
        if (h > this.maxsize.height) {
            this.maxsize.height = h;
        }
        if (this.numTools == 1) {
            t.activate();
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.numTools) {
            if (i == this.selected) {
                g.drawImage(this.tool[i].getSelectedIcon(), i % this.width * this.maxsize.width, i / this.width * this.maxsize.height, this);
            } else {
                g.drawImage(this.tool[i].getIcon(), i % this.width * this.maxsize.width, i / this.width * this.maxsize.height, this);
            }
            ++i;
        }
        g.drawLine(0, 0, this.width * this.maxsize.width, 0);
        g.drawLine(0, this.height * this.maxsize.height, this.width * this.maxsize.width, this.height * this.maxsize.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width * this.maxsize.width, this.height * this.maxsize.height + 2);
    }

    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        int i = p.x / this.maxsize.width + (p.y - 1) / this.maxsize.height * this.width;
        if (i < this.numTools) {
            if (e.getClickCount() == 2) {
                this.tool[i].iconDoubleClicked();
            } else {
                if (this.selected < this.tool.length) {
                    this.tool[this.selected].deactivate();
                }
                this.selected = i;
                this.repaint();
                this.tool[i].activate();
            }
        }
    }

    public void selectTool(EditingTool which) {
        int i = 0;
        while (i < this.numTools) {
            if (this.tool[i] == which) {
                this.tool[this.selected].deactivate();
                this.selected = i;
                this.repaint();
                this.tool[i].activate();
            }
            ++i;
        }
    }

    public void selectNextTool() {
        this.tool[this.selected].deactivate();
        this.selected = (this.selected + 1) % this.numTools;
        this.repaint();
        this.tool[this.selected].activate();
    }

    public void selectPreviousTool() {
        this.tool[this.selected].deactivate();
        --this.selected;
        if (this.selected < 0) {
            this.selected = this.numTools - 1;
        }
        this.repaint();
        this.tool[this.selected].activate();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

