/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.TriangleMesh;
import artofillusion.Vec3;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TriMeshSimplifier
extends Thread {
    TriangleMesh mesh;
    VertexInfo[] vertex;
    MeshEdge[] edge;
    MeshFace[] face;
    Vec3 temp1;
    Vec3 temp2;
    Vec3 temp3;
    int faces;
    Dialog dial;
    Button cancelButton;
    Label status;
    Label numLabel;
    boolean cancel;
    double tol;

    public TriMeshSimplifier(TriangleMesh theMesh, boolean[] selection, double tolerance, Frame fr) {
        this.mesh = theMesh;
        this.tol = tolerance * tolerance;
        this.buildDataStructures(selection);
        if (fr == null) {
            this.start();
        } else {
            this.createDialog(fr);
            this.start();
            Thread update = new Thread(){

                public void run() {
                    try {
                        while (!TriMeshSimplifier.this.cancel) {
                            Thread.sleep(200L);
                            TriMeshSimplifier.this.status.setText(String.valueOf(TriMeshSimplifier.this.faces));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            update.start();
            this.dial.show();
        }
    }

    public void run() {
        this.doSimplification();
        if (!this.cancel) {
            this.buildMesh();
        }
        this.cancel = true;
        if (this.numLabel != null) {
            this.numLabel.setText("Final:");
            this.status.setText(String.valueOf(this.faces));
            this.cancelButton.setLabel("Done");
        }
    }

    void createDialog(Frame fr) {
        GridBagConstraints c = new GridBagConstraints();
        Panel p = new Panel();
        this.dial = new Dialog(fr, true){

            public Insets getInsets() {
                Insets in = super.getInsets();
                return new Insets(in.top + 10, in.left + 10, in.bottom + 10, in.right + 10);
            }
        };
        this.dial.setLayout(new GridBagLayout());
        c.gridwidth = 2;
        this.dial.add((Component)new Label("Number of triangles in mesh:"), c);
        c.gridwidth = 1;
        c.gridx = 0;
        this.dial.add((Component)new Label("Original:"), c);
        this.numLabel = new Label("Current:");
        this.dial.add((Component)this.numLabel, c);
        c.gridx = 1;
        this.dial.add((Component)new Label(String.valueOf(this.faces)), c);
        this.status = new Label(String.valueOf(this.faces));
        this.dial.add((Component)this.status, c);
        c.gridx = 0;
        c.gridwidth = 2;
        this.dial.add((Component)p, c);
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriMeshSimplifier.this.cancel = true;
                TriMeshSimplifier.this.dial.dispose();
            }
        });
        this.dial.pack();
        this.dial.setResizable(false);
        ModellingApp.centerWindow(this.dial);
    }

    void buildMesh() {
        int j;
        int[] index = new int[this.vertex.length];
        int[][] f = new int[this.faces][];
        int i = 0;
        int k = 0;
        while (i < this.vertex.length) {
            index[i] = k++;
            j = 0;
            while (j < i) {
                if (this.vertex[i] == this.vertex[j]) {
                    index[i] = index[j];
                    --k;
                    break;
                }
                ++j;
            }
            ++i;
        }
        TriangleMesh.Vertex[] vert = new TriangleMesh.Vertex[k];
        i = 0;
        while (i < this.vertex.length) {
            vert[index[i]] = this.mesh.new TriangleMesh.Vertex(this.vertex[i].theVert);
            vert[index[i]].smoothness = this.vertex[i].smoothness;
            vert[index[i]].edges = 0;
            vert[index[i]].firstEdge = -1;
            ++i;
        }
        i = 0;
        while (i < this.faces) {
            f[i] = new int[]{index[this.face[i].v1], index[this.face[i].v2], index[this.face[i].v3]};
            ++i;
        }
        this.mesh.setShape(vert, f);
        TriangleMesh.Edge[] ed = this.mesh.getEdges();
        i = 0;
        while (i < ed.length) {
            j = 0;
            while (j < this.edge.length) {
                if (index[this.edge[j].v1] == ed[i].v1 && index[this.edge[j].v2] == ed[i].v2 || index[this.edge[j].v2] == ed[i].v1 && index[this.edge[j].v1] == ed[i].v2) {
                    ed[i].smoothness = this.edge[j].smoothness;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    void buildDataStructures(boolean[] selection) {
        Constraint con;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.vertex = new VertexInfo[v.length];
        this.edge = new MeshEdge[e.length];
        this.face = new MeshFace[f.length];
        int[] edgeCount = new int[v.length];
        int[] faceCount = new int[v.length];
        this.faces = f.length;
        this.temp1 = new Vec3();
        this.temp2 = new Vec3();
        this.temp3 = new Vec3();
        int i = 0;
        while (i < e.length) {
            int n = e[i].v1;
            edgeCount[n] = edgeCount[n] + 1;
            int n2 = e[i].v2;
            edgeCount[n2] = edgeCount[n2] + 1;
            ++i;
        }
        i = 0;
        while (i < f.length) {
            int n = f[i].v1;
            faceCount[n] = faceCount[n] + 1;
            int n3 = f[i].v2;
            faceCount[n3] = faceCount[n3] + 1;
            int n4 = f[i].v3;
            faceCount[n4] = faceCount[n4] + 1;
            ++i;
        }
        i = 0;
        while (i < v.length) {
            this.vertex[i] = new VertexInfo();
            this.vertex[i].theVert = v[i];
            this.vertex[i].pos = v[i].r;
            this.vertex[i].smoothness = v[i].smoothness;
            this.vertex[i].star = new MeshEdge[edgeCount[i]];
            this.vertex[i].crown = new MeshFace[faceCount[i]];
            this.vertex[i].zone = new Zone();
            this.vertex[i].zone.con = faceCount[i] == edgeCount[i] ? new Constraint[faceCount[i]] : new Constraint[faceCount[i] + 2];
            ++i;
        }
        i = 0;
        while (i < e.length) {
            this.edge[i] = new MeshEdge();
            this.edge[i].v1 = e[i].v1;
            this.edge[i].v2 = e[i].v2;
            this.edge[i].smoothness = e[i].smoothness;
            VertexInfo v1 = this.vertex[e[i].v1];
            VertexInfo v2 = this.vertex[e[i].v2];
            v1.star[v1.edges++] = this.edge[i];
            v2.star[v2.edges++] = this.edge[i];
            this.edge[i].selected = selection[i];
            ++i;
        }
        i = 0;
        while (i < f.length) {
            this.face[i] = new MeshFace();
            this.face[i].v1 = f[i].v1;
            this.face[i].v2 = f[i].v2;
            this.face[i].v3 = f[i].v3;
            this.face[i].e1 = this.edge[f[i].e1];
            this.face[i].e2 = this.edge[f[i].e2];
            this.face[i].e3 = this.edge[f[i].e3];
            this.face[i].index = i;
            this.face[i].normal = new Vec3();
            this.findNormal(this.vertex[f[i].v1].pos, this.vertex[f[i].v2].pos, this.vertex[f[i].v3].pos, this.face[i].normal);
            this.vertex[f[i].v1].crown[this.vertex[f[i].v1].faces++] = this.face[i];
            this.vertex[f[i].v2].crown[this.vertex[f[i].v2].faces++] = this.face[i];
            this.vertex[f[i].v3].crown[this.vertex[f[i].v3].faces++] = this.face[i];
            con = new Constraint();
            con.a = this.face[i].normal.x;
            con.b = this.face[i].normal.y;
            con.c = this.face[i].normal.z;
            con.d = -(con.a * v[f[i].v1].r.x + con.b * v[f[i].v1].r.y + con.c * v[f[i].v1].r.z);
            this.vertex[f[i].v1].zone.con[this.vertex[f[i].v1].zone.constraints++] = con;
            this.vertex[f[i].v2].zone.con[this.vertex[f[i].v2].zone.constraints++] = con;
            this.vertex[f[i].v3].zone.con[this.vertex[f[i].v3].zone.constraints++] = con;
            if (this.edge[f[i].e1].f1 == null) {
                this.edge[f[i].e1].f1 = this.face[i];
            } else {
                this.edge[f[i].e1].f2 = this.face[i];
            }
            if (this.edge[f[i].e2].f1 == null) {
                this.edge[f[i].e2].f1 = this.face[i];
            } else {
                this.edge[f[i].e2].f2 = this.face[i];
            }
            if (this.edge[f[i].e3].f1 == null) {
                this.edge[f[i].e3].f1 = this.face[i];
            } else {
                this.edge[f[i].e3].f2 = this.face[i];
            }
            ++i;
        }
        i = 0;
        while (i < e.length) {
            if (this.edge[i].f2 == null) {
                this.temp1.set(v[this.edge[i].v1].r);
                this.temp1.subtract(v[this.edge[i].v2].r);
                this.temp2.set(this.edge[i].f1.normal);
                con = new Constraint();
                con.a = this.temp1.y * this.temp2.z - this.temp1.z * this.temp2.y;
                con.b = this.temp1.z * this.temp2.x - this.temp1.x * this.temp2.z;
                con.c = this.temp1.x * this.temp2.y - this.temp1.y * this.temp2.x;
                con.d = -(con.a * v[this.edge[i].v1].r.x + con.b * v[this.edge[i].v1].r.y + con.c * v[this.edge[i].v1].r.z);
                this.vertex[this.edge[i].v1].zone.con[this.vertex[this.edge[i].v1].zone.constraints++] = con;
                this.vertex[this.edge[i].v2].zone.con[this.vertex[this.edge[i].v2].zone.constraints++] = con;
            }
            ++i;
        }
        i = 0;
        while (i < e.length) {
            this.updateCost(this.edge[i]);
            ++i;
        }
        int j = 0;
        i = 0;
        while (i < e.length) {
            if (this.edge[i].cost < this.edge[j].cost) {
                j = i;
            }
            ++i;
        }
        MeshEdge tempEdge = this.edge[j];
        this.edge[j] = this.edge[0];
        this.edge[0] = tempEdge;
    }

    void doSimplification() {
        int i = 0;
        while (i < this.edge.length) {
            Zone zone1;
            MeshEdge rem2;
            MeshEdge rep2;
            MeshEdge rep1;
            MeshEdge rem1;
            int k;
            MeshEdge e = this.edge[i];
            if (e.cost >= this.tol || this.cancel) {
                return;
            }
            VertexInfo v1 = this.vertex[e.v1];
            VertexInfo v2 = this.vertex[e.v2];
            boolean boundary = e.f2 == null;
            v1.pos = v2.pos;
            MeshEdge[] star = v1.star;
            int j = 0;
            while (j < v1.edges) {
                VertexInfo tempVert = this.vertex[star[j].v1] == v1 ? this.vertex[star[j].v2] : this.vertex[star[j].v1];
                k = 0;
                while (k < tempVert.edges) {
                    tempVert.star[k].cost = -1.0;
                    ++k;
                }
                ++j;
            }
            star = v2.star;
            j = 0;
            while (j < v2.edges) {
                star[j].cost = -1.0;
                ++j;
            }
            if (e.f1.e1 == e) {
                if (this.vertex[e.f1.e2.v1] == v2 || this.vertex[e.f1.e2.v2] == v2) {
                    rem1 = e.f1.e2;
                    rep1 = e.f1.e3;
                } else {
                    rem1 = e.f1.e3;
                    rep1 = e.f1.e2;
                }
            } else if (e.f1.e2 == e) {
                if (this.vertex[e.f1.e3.v1] == v2 || this.vertex[e.f1.e3.v2] == v2) {
                    rem1 = e.f1.e3;
                    rep1 = e.f1.e1;
                } else {
                    rem1 = e.f1.e1;
                    rep1 = e.f1.e3;
                }
            } else if (this.vertex[e.f1.e1.v1] == v2 || this.vertex[e.f1.e1.v2] == v2) {
                rem1 = e.f1.e1;
                rep1 = e.f1.e2;
            } else {
                rem1 = e.f1.e2;
                rep1 = e.f1.e1;
            }
            if (boundary) {
                rep2 = null;
                rem2 = null;
            } else if (e.f2.e1 == e) {
                if (this.vertex[e.f2.e2.v1] == v2 || this.vertex[e.f2.e2.v2] == v2) {
                    rem2 = e.f2.e2;
                    rep2 = e.f2.e3;
                } else {
                    rem2 = e.f2.e3;
                    rep2 = e.f2.e2;
                }
            } else if (e.f2.e2 == e) {
                if (this.vertex[e.f2.e3.v1] == v2 || this.vertex[e.f2.e3.v2] == v2) {
                    rem2 = e.f2.e3;
                    rep2 = e.f2.e1;
                } else {
                    rem2 = e.f2.e1;
                    rep2 = e.f2.e3;
                }
            } else if (this.vertex[e.f2.e1.v1] == v2 || this.vertex[e.f2.e1.v2] == v2) {
                rem2 = e.f2.e1;
                rep2 = e.f2.e2;
            } else {
                rem2 = e.f2.e2;
                rep2 = e.f2.e1;
            }
            VertexInfo v3 = this.vertex[rep1.v1] == v1 ? this.vertex[rep1.v2] : this.vertex[rep1.v1];
            VertexInfo v4 = boundary ? null : (this.vertex[rep2.v1] == v1 ? this.vertex[rep2.v2] : this.vertex[rep2.v1]);
            MeshFace[] tempCrown = boundary && v1.faces + v2.faces - 2 > v1.crown.length ? new MeshFace[v1.faces + v2.faces - 2] : (v1.faces + v2.faces - 4 > v1.crown.length ? new MeshFace[v1.faces + v2.faces - 4] : v1.crown);
            j = 0;
            k = 0;
            while (k < v1.faces) {
                if (v1.crown[k] != e.f1 && v1.crown[k] != e.f2) {
                    tempCrown[j++] = v1.crown[k];
                }
                ++k;
            }
            k = 0;
            while (k < v2.faces) {
                if (v2.crown[k] != e.f1 && v2.crown[k] != e.f2) {
                    tempCrown[j++] = v2.crown[k];
                }
                ++k;
            }
            v1.crown = tempCrown;
            v1.faces = boundary ? v1.faces + v2.faces - 2 : v1.faces + v2.faces - 4;
            star = v1.edges + v2.edges - 2 > v1.star.length ? new MeshEdge[v1.edges + v2.edges - 2] : v1.star;
            j = 0;
            k = 0;
            while (k < v1.edges) {
                if (v1.star[k] != e) {
                    star[j++] = v1.star[k];
                }
                ++k;
            }
            k = 0;
            while (k < v2.edges) {
                if (v2.star[k] != e) {
                    star[j++] = v2.star[k];
                }
                ++k;
            }
            v1.star = star;
            v1.edges = v1.edges + v2.edges - 2;
            j = 0;
            k = 0;
            while (k < v3.faces) {
                if (v3.crown[k] != e.f1) {
                    v3.crown[j++] = v3.crown[k];
                }
                ++k;
            }
            --v3.faces;
            if (!boundary) {
                j = 0;
                k = 0;
                while (k < v4.faces) {
                    if (v4.crown[k] != e.f2) {
                        v4.crown[j++] = v4.crown[k];
                    }
                    ++k;
                }
                --v4.faces;
            }
            j = 0;
            k = 0;
            while (k < v3.edges) {
                if (v3.star[k] != rem1) {
                    v3.star[j++] = v3.star[k];
                }
                ++k;
            }
            --v3.edges;
            if (!boundary) {
                j = 0;
                k = 0;
                while (k < v4.edges) {
                    if (v4.star[k] != rem2) {
                        v4.star[j++] = v4.star[k];
                    }
                    ++k;
                }
                --v4.edges;
            }
            if (boundary) {
                j = e.f1.index;
                this.face[j] = this.face[this.faces - 1];
                this.face[j].index = j;
                --this.faces;
            } else {
                j = e.f1.index;
                k = e.f2.index;
                if (j < this.faces - 2 && k < this.faces - 2) {
                    this.face[j] = this.face[this.faces - 1];
                    this.face[k] = this.face[this.faces - 2];
                } else {
                    this.face[Math.min((int)j, (int)k)] = j != this.faces - 1 && k != this.faces - 1 ? this.face[this.faces - 1] : this.face[this.faces - 2];
                }
                this.face[j].index = j;
                this.face[k].index = k;
                this.faces -= 2;
            }
            Zone zone2 = v2.zone;
            while (zone2 != null) {
                zone1 = v1.zone;
                while (zone1 != null) {
                    j = 0;
                    while (j < zone2.constraints) {
                        k = 0;
                        while (k < zone1.constraints) {
                            if (zone2.con[j] == zone1.con[k]) {
                                zone2.con[j] = zone2.con[--zone2.constraints];
                            }
                            ++k;
                        }
                        ++j;
                    }
                    zone1 = zone1.next;
                }
                zone2 = zone2.next;
            }
            zone2 = v2.zone;
            while (zone2.next != null) {
                if (zone2.next.constraints == 0) {
                    zone2.next = zone2.next.next;
                    continue;
                }
                zone2 = zone2.next;
            }
            zone2 = v2.zone;
            zone1 = v1.zone;
            while (zone1.next != null) {
                zone1 = zone1.next;
            }
            zone1.next = zone2.constraints == 0 ? zone2.next : zone2;
            j = 0;
            while (j < v2.faces) {
                if (v2.crown[j].e1 == rem1) {
                    v2.crown[j].e1 = rep1;
                } else if (v2.crown[j].e2 == rem1) {
                    v2.crown[j].e2 = rep1;
                } else if (v2.crown[j].e3 == rem1) {
                    v2.crown[j].e3 = rep1;
                }
                ++j;
            }
            if (!boundary) {
                j = 0;
                while (j < v2.faces) {
                    if (v2.crown[j].e1 == rem2) {
                        v2.crown[j].e1 = rep2;
                    } else if (v2.crown[j].e2 == rem2) {
                        v2.crown[j].e2 = rep2;
                    } else if (v2.crown[j].e3 == rem2) {
                        v2.crown[j].e3 = rep2;
                    }
                    ++j;
                }
            }
            if (rem1.f1 == e.f1) {
                if (rep1.f1 == e.f1) {
                    rep1.f1 = rem1.f2;
                } else {
                    rep1.f2 = rem1.f2;
                }
            } else if (rep1.f1 == e.f1) {
                rep1.f1 = rem1.f1;
            } else {
                rep1.f2 = rem1.f1;
            }
            if (rep1.f1 == null) {
                rep1.f1 = rep1.f2;
                rep1.f2 = null;
            }
            if (!boundary) {
                if (rem2.f1 == e.f2) {
                    if (rep2.f1 == e.f2) {
                        rep2.f1 = rem2.f2;
                    } else {
                        rep2.f2 = rem2.f2;
                    }
                } else if (rep2.f1 == e.f2) {
                    rep2.f1 = rem2.f1;
                } else {
                    rep2.f2 = rem2.f1;
                }
                if (rep2.f1 == null) {
                    rep2.f1 = rep2.f2;
                    rep2.f2 = null;
                }
            }
            j = 0;
            while (j < this.vertex.length) {
                if (this.vertex[j] == v2) {
                    this.vertex[j] = v1;
                }
                ++j;
            }
            v1.smoothness = Math.min(v1.smoothness, v2.smoothness);
            rep1.smoothness = Math.min(rep1.smoothness, rem1.smoothness);
            if (!boundary) {
                rep2.smoothness = Math.min(rep2.smoothness, rem2.smoothness);
            }
            j = this.edge.length - 1;
            k = this.edge.length - 1;
            while (j > i) {
                if (this.edge[j] != rem1 && this.edge[j] != rem2) {
                    this.edge[k--] = this.edge[j];
                }
                --j;
            }
            int skip = boundary ? 2 : 3;
            k = i + skip;
            j = i + skip;
            while (j < this.edge.length) {
                if (this.edge[j].cost == -1.0) {
                    this.updateCost(this.edge[j]);
                }
                if (this.edge[j].cost < this.edge[k].cost) {
                    k = j;
                }
                ++j;
            }
            MeshEdge tempEdge = this.edge[i + skip];
            this.edge[i + skip] = this.edge[k];
            this.edge[k] = tempEdge;
            i += skip;
        }
    }

    void updateCost(MeshEdge ed) {
        double cost = this.findCost(ed);
        int i = ed.v1;
        ed.v1 = ed.v2;
        ed.v2 = i;
        ed.cost = this.findCost(ed);
        if (ed.cost > cost) {
            ed.v2 = ed.v1;
            ed.v1 = i;
            ed.cost = cost;
        }
    }

    double findCost(MeshEdge ed) {
        double cost;
        MeshFace f;
        VertexInfo v1 = this.vertex[ed.v1];
        VertexInfo v2 = this.vertex[ed.v2];
        Zone zone = v2.zone;
        double max = 0.0;
        if (!ed.selected) {
            return this.tol;
        }
        int i = 0;
        while (i < v2.faces) {
            if (v2.crown[i] != ed.f1 && v2.crown[i] != ed.f2) {
                f = v2.crown[i];
                if (this.vertex[f.v1] == v2) {
                    this.findNormal(v1.pos, this.vertex[f.v2].pos, this.vertex[f.v3].pos, this.temp3);
                } else if (this.vertex[f.v2] == v2) {
                    this.findNormal(this.vertex[f.v1].pos, v1.pos, this.vertex[f.v3].pos, this.temp3);
                } else {
                    this.findNormal(this.vertex[f.v1].pos, this.vertex[f.v2].pos, v1.pos, this.temp3);
                }
                cost = this.tol * (1.0 - this.temp3.dot(f.normal));
                if (cost >= this.tol || Double.isNaN(cost)) {
                    return this.tol;
                }
                if (cost > max) {
                    max = cost;
                }
            }
            ++i;
        }
        while (zone != null) {
            i = 0;
            while (i < zone.constraints) {
                cost = zone.con[i].a * v1.pos.x + zone.con[i].b * v1.pos.y + zone.con[i].c * v1.pos.z + zone.con[i].d;
                if ((cost *= cost) >= this.tol) {
                    return this.tol;
                }
                if (cost > max) {
                    max = cost;
                }
                ++i;
            }
            zone = zone.next;
        }
        f = ed.f1;
        if (!(f.e1 != ed && f.e1.f2 != null || f.e2 != ed && f.e2.f2 != null || f.e3 != ed && f.e3.f2 != null)) {
            return this.tol;
        }
        f = ed.f2;
        if (!(f == null || f.e1 != ed && f.e1.f2 != null || f.e2 != ed && f.e2.f2 != null || f.e3 != ed && f.e3.f2 != null)) {
            return this.tol;
        }
        return max;
    }

    void findNormal(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 normal) {
        this.temp1.set(v2.x, v2.y, v2.z);
        this.temp1.subtract(v1);
        this.temp2.set(v3.x, v3.y, v3.z);
        this.temp2.subtract(v1);
        normal.set(this.temp1.y * this.temp2.z - this.temp1.z * this.temp2.y, this.temp1.z * this.temp2.x - this.temp1.x * this.temp2.z, this.temp1.x * this.temp2.y - this.temp1.y * this.temp2.x);
        normal.normalize();
    }

    class VertexInfo {
        TriangleMesh.Vertex theVert;
        Vec3 pos;
        int faces;
        int edges;
        float smoothness;
        MeshEdge[] star;
        MeshFace[] crown;
        Zone zone;

        VertexInfo() {
        }
    }

    class MeshFace {
        int v1;
        int v2;
        int v3;
        int index;
        MeshEdge e1;
        MeshEdge e2;
        MeshEdge e3;
        Vec3 normal;

        MeshFace() {
        }
    }

    class MeshEdge {
        int v1;
        int v2;
        MeshFace f1;
        MeshFace f2;
        float smoothness;
        double cost;
        boolean selected;

        MeshEdge() {
        }
    }

    class Zone {
        int constraints;
        Constraint[] con;
        Zone next;

        Zone() {
        }
    }

    class Constraint {
        double a;
        double b;
        double c;
        double d;

        Constraint() {
        }
    }
}

