/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CoordinateSystem;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.animation.Track;
import java.util.Vector;

public class UndoRecord {
    Vector command;
    Vector data;
    boolean redo;
    EditingWindow theWindow;
    public static final int COPY_OBJECT = 0;
    public static final int COPY_COORDS = 1;
    public static final int COPY_OBJECT_INFO = 2;
    public static final int SET_OBJECT = 3;
    public static final int ADD_OBJECT = 4;
    public static final int DELETE_OBJECT = 5;
    public static final int RENAME_OBJECT = 6;
    public static final int ADD_TO_GROUP = 7;
    public static final int REMOVE_FROM_GROUP = 8;
    public static final int SET_GROUP_CONTENTS = 9;
    public static final int SET_TRACK = 10;
    public static final int SET_TRACK_LIST = 11;
    public static final int COPY_TRACK = 12;

    public UndoRecord(EditingWindow win, boolean isRedo) {
        this.theWindow = win;
        this.redo = isRedo;
        this.command = new Vector();
        this.data = new Vector();
    }

    public UndoRecord(EditingWindow win, boolean isRedo, int theCommand, Object[] commandData) {
        this(win, isRedo);
        this.addCommand(theCommand, commandData);
    }

    public boolean isRedo() {
        return this.redo;
    }

    public void addCommand(int theCommand, Object[] commandData) {
        this.command.addElement(new Integer(theCommand));
        this.data.addElement(commandData);
    }

    public void addCommandAtBeginning(int theCommand, Object[] commandData) {
        this.command.insertElementAt(new Integer(theCommand), 0);
        this.data.insertElementAt(commandData, 0);
    }

    public UndoRecord execute() {
        UndoRecord redoRecord = new UndoRecord(this.theWindow, !this.redo);
        int i = 0;
        while (i < this.command.size()) {
            int c = (Integer)this.command.elementAt(i);
            Object[] d = (Object[])this.data.elementAt(i);
            switch (c) {
                case 0: {
                    Object3D obj1 = (Object3D)d[0];
                    Object3D obj2 = (Object3D)d[1];
                    redoRecord.addCommandAtBeginning(0, new Object[]{obj1, obj1.duplicate()});
                    obj1.copyObject(obj2);
                    if (this.theWindow.getScene() == null) break;
                    this.theWindow.getScene().objectModified(obj1);
                    break;
                }
                case 1: {
                    CoordinateSystem coords1 = (CoordinateSystem)d[0];
                    CoordinateSystem coords2 = (CoordinateSystem)d[1];
                    redoRecord.addCommandAtBeginning(1, new Object[]{coords1, coords1.duplicate()});
                    coords1.copyCoords(coords2);
                    break;
                }
                case 2: {
                    ObjectInfo info1 = (ObjectInfo)d[0];
                    ObjectInfo info2 = (ObjectInfo)d[1];
                    redoRecord.addCommandAtBeginning(2, new Object[]{info1, info1.duplicate()});
                    info1.copyInfo(info2);
                    break;
                }
                case 3: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    Object3D obj = (Object3D)d[1];
                    redoRecord.addCommandAtBeginning(3, new Object[]{info, info.object});
                    info.object = obj;
                    break;
                }
                case 4: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    win.addObject(info, (Integer)d[1], redoRecord);
                    break;
                }
                case 5: {
                    int which = (Integer)d[0];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    win.removeObject(which, redoRecord);
                    break;
                }
                case 6: {
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    int which = (Integer)d[0];
                    String oldName = ((ObjectInfo)win.getScene().getObjects().elementAt((int)which)).name;
                    redoRecord.addCommandAtBeginning(6, new Object[]{d[0], oldName});
                    win.setObjectName(which, (String)d[1]);
                    break;
                }
                case 7: {
                    int pos = (Integer)d[2];
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo child = (ObjectInfo)d[1];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    redoRecord.addCommandAtBeginning(8, new Object[]{group, child});
                    group.addChild(child, pos);
                    break;
                }
                case 8: {
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo child = (ObjectInfo)d[1];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    int pos = 0;
                    while (pos < group.children.length && group.children[pos] != child) {
                        ++pos;
                    }
                    redoRecord.addCommandAtBeginning(7, new Object[]{group, child, new Integer(pos)});
                    group.removeChild(child);
                    break;
                }
                case 9: {
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo[] oldobj = group.children;
                    ObjectInfo[] newobj = (ObjectInfo[])d[1];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    redoRecord.addCommandAtBeginning(9, new Object[]{group, oldobj});
                    int j = 0;
                    while (j < oldobj.length) {
                        oldobj[j].parent = null;
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < newobj.length) {
                        newobj[j2].parent = group;
                        ++j2;
                    }
                    group.children = newobj;
                    break;
                }
                case 10: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    int which = (Integer)d[1];
                    redoRecord.addCommandAtBeginning(10, new Object[]{info, d[1], info.tracks[which]});
                    info.tracks[which] = (Track)d[2];
                    break;
                }
                case 11: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    redoRecord.addCommandAtBeginning(11, new Object[]{info, info.tracks});
                    info.tracks = (Track[])d[1];
                    break;
                }
                case 12: {
                    Track tr1 = (Track)d[0];
                    Track tr2 = (Track)d[1];
                    redoRecord.addCommandAtBeginning(12, new Object[]{tr1, tr1.duplicate(tr1.getParent())});
                    tr1.copy(tr2);
                    break;
                }
            }
            ++i;
        }
        return redoRecord;
    }
}

