/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ColorChooser;
import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.RGBColor;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.TextureMapping;
import artofillusion.TextureSpec;
import artofillusion.UniformMapping;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformTexture
extends Texture {
    RGBColor diffuseColor;
    RGBColor specularColor;
    RGBColor transparentColor;
    RGBColor emissiveColor;
    double roughness;
    double cloudiness;
    float transparency;
    float specularity;

    public UniformTexture() {
        this.diffuseColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.specularColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.transparentColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.emissiveColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.transparency = 0.0f;
        this.specularity = 0.0f;
        this.roughness = 0.2;
        this.cloudiness = 0.0;
        this.name = "";
    }

    public static UniformTexture invisibleTexture() {
        UniformTexture tex = new UniformTexture();
        tex.diffuseColor.setRGB(0.0f, 0.0f, 0.0f);
        tex.specularColor.setRGB(0.0f, 0.0f, 0.0f);
        tex.transparency = 1.0f;
        return tex;
    }

    public static String getTypeName() {
        return "Uniform";
    }

    public void getTextureSpec(TextureSpec spec) {
        float frac = (1.0f - this.transparency) * (1.0f - this.specularity);
        spec.diffuse.setRGB(this.diffuseColor.red * frac, this.diffuseColor.green * frac, this.diffuseColor.blue * frac);
        frac = (1.0f - this.transparency) * this.specularity;
        spec.specular.setRGB(this.specularColor.red * frac, this.specularColor.green * frac, this.specularColor.blue * frac);
        spec.transparent.setRGB(this.transparentColor.red * this.transparency, this.transparentColor.green * this.transparency, this.transparentColor.blue * this.transparency);
        spec.emissive.copy(this.emissiveColor);
        spec.roughness = this.roughness;
        spec.cloudiness = this.cloudiness;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
    }

    public void getTransparency(RGBColor trans) {
        trans.setRGB(this.transparentColor.red * this.transparency, this.transparentColor.green * this.transparency, this.transparentColor.blue * this.transparency);
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.getTextureSpec(spec);
    }

    public TextureMapping getDefaultMapping() {
        return new UniformMapping(this);
    }

    public Texture duplicate() {
        UniformTexture m = new UniformTexture();
        m.name = this.name;
        m.diffuseColor.copy(this.diffuseColor);
        m.specularColor.copy(this.specularColor);
        m.transparentColor.copy(this.transparentColor);
        m.emissiveColor.copy(this.emissiveColor);
        m.transparency = this.transparency;
        m.specularity = this.specularity;
        m.roughness = this.roughness;
        m.cloudiness = this.cloudiness;
        return m;
    }

    public void edit(Frame fr, Scene sc) {
        new Editor(fr);
    }

    public UniformTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.diffuseColor = new RGBColor(in);
        this.specularColor = new RGBColor(in);
        this.transparentColor = new RGBColor(in);
        this.emissiveColor = new RGBColor(in);
        this.roughness = in.readDouble();
        this.cloudiness = in.readDouble();
        this.transparency = in.readFloat();
        this.specularity = in.readFloat();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        this.diffuseColor.writeToFile(out);
        this.specularColor.writeToFile(out);
        this.transparentColor.writeToFile(out);
        this.emissiveColor.writeToFile(out);
        out.writeDouble(this.roughness);
        out.writeDouble(this.cloudiness);
        out.writeFloat(this.transparency);
        out.writeFloat(this.specularity);
    }

    class Editor
    extends Dialog
    implements MouseListener,
    ActionListener,
    AdjustmentListener {
        TextField nameField;
        ValueSlider transSlider;
        ValueSlider specSlider;
        ValueSlider shinSlider;
        ValueSlider clearSlider;
        Panel diffPatch;
        Panel specPatch;
        Panel transPatch;
        Panel emissPatch;
        MaterialPreviewer preview;
        UniformTexture newTexture;
        Frame parent;

        public Editor(Frame fr) {
            super(fr, true);
            GridBagConstraints gc = new GridBagConstraints();
            this.parent = fr;
            this.newTexture = (UniformTexture)UniformTexture.this.duplicate();
            Panel p = new Panel();
            Button b = new Button("Ok");
            p.add(b);
            b.setActionCommand("ok");
            b.addActionListener(this);
            b = new Button("Cancel");
            p.add(b);
            b.setActionCommand("cancel");
            b.addActionListener(this);
            this.add((Component)p, "South");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridwidth = 2;
            gc.anchor = 10;
            this.preview = new MaterialPreviewer(this.newTexture, null, 200, 160);
            p.add((Component)this.preview, gc);
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.anchor = 13;
            gc.insets = new Insets(0, 0, 0, 5);
            p.add((Component)new Label("Name"), gc);
            p.add((Component)new Label("Diffuse Color"), gc);
            p.add((Component)new Label("Specular Color"), gc);
            p.add((Component)new Label("Transparent Color"), gc);
            p.add((Component)new Label("Emissive Color"), gc);
            p.add((Component)new Label("Transparency"), gc);
            p.add((Component)new Label("Specularity"), gc);
            p.add((Component)new Label("Roughness"), gc);
            p.add((Component)new Label("Cloudiness"), gc);
            gc.gridx = 1;
            gc.gridwidth = 2;
            gc.fill = 2;
            this.nameField = new TextField(UniformTexture.this.name, 15);
            p.add((Component)this.nameField, gc);
            gc.gridwidth = 1;
            this.diffPatch = UniformTexture.this.diffuseColor.getSample(50, 30);
            p.add((Component)this.diffPatch, gc);
            this.specPatch = UniformTexture.this.specularColor.getSample(50, 30);
            p.add((Component)this.specPatch, gc);
            this.transPatch = UniformTexture.this.transparentColor.getSample(50, 30);
            p.add((Component)this.transPatch, gc);
            this.emissPatch = UniformTexture.this.emissiveColor.getSample(50, 30);
            p.add((Component)this.emissPatch, gc);
            gc.gridwidth = 2;
            this.transSlider = new ValueSlider(0.0, 1.0, 100, UniformTexture.this.transparency);
            p.add((Component)this.transSlider, gc);
            this.transSlider.addAdjustmentListener(this);
            this.specSlider = new ValueSlider(0.0, 1.0, 100, UniformTexture.this.specularity);
            p.add((Component)this.specSlider, gc);
            this.specSlider.addAdjustmentListener(this);
            this.shinSlider = new ValueSlider(0.0, 1.0, 100, UniformTexture.this.roughness);
            p.add((Component)this.shinSlider, gc);
            this.shinSlider.addAdjustmentListener(this);
            this.clearSlider = new ValueSlider(0.0, 1.0, 100, UniformTexture.this.cloudiness);
            p.add((Component)this.clearSlider, gc);
            this.clearSlider.addAdjustmentListener(this);
            gc.gridwidth = 1;
            this.add((Component)p, "Center");
            this.nameField.addActionListener(this);
            this.transSlider.addActionListener(this);
            this.specSlider.addActionListener(this);
            this.shinSlider.addActionListener(this);
            this.clearSlider.addActionListener(this);
            this.diffPatch.addMouseListener(this);
            this.specPatch.addMouseListener(this);
            this.transPatch.addMouseListener(this);
            this.emissPatch.addMouseListener(this);
            this.pack();
            this.setResizable(false);
            ModellingApp.centerWindow(this);
            this.show();
        }

        public void actionPerformed(ActionEvent e) {
            if (!e.getActionCommand().equals("cancel")) {
                UniformTexture.this.transparency = (float)this.transSlider.getValue();
                UniformTexture.this.specularity = (float)this.specSlider.getValue();
                UniformTexture.this.roughness = this.shinSlider.getValue();
                UniformTexture.this.cloudiness = this.clearSlider.getValue();
                UniformTexture.this.name = this.nameField.getText();
                UniformTexture.this.diffuseColor.copy(this.newTexture.diffuseColor);
                UniformTexture.this.specularColor.copy(this.newTexture.specularColor);
                UniformTexture.this.transparentColor.copy(this.newTexture.transparentColor);
                UniformTexture.this.emissiveColor.copy(this.newTexture.emissiveColor);
            }
            this.dispose();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == this.diffPatch) {
                new ColorChooser(this.parent, "Diffuse Color", this.newTexture.diffuseColor);
                this.diffPatch.setBackground(this.newTexture.diffuseColor.getColor());
                this.diffPatch.repaint();
                this.preview.render();
            } else if (e.getSource() == this.specPatch) {
                new ColorChooser(this.parent, "Specular Color", this.newTexture.specularColor);
                this.specPatch.setBackground(this.newTexture.specularColor.getColor());
                this.specPatch.repaint();
                this.preview.render();
            } else if (e.getSource() == this.transPatch) {
                new ColorChooser(this.parent, "Transparent Color", this.newTexture.transparentColor);
                this.transPatch.setBackground(this.newTexture.transparentColor.getColor());
                this.transPatch.repaint();
                this.preview.render();
            } else if (e.getSource() == this.emissPatch) {
                new ColorChooser(this.parent, "Emissive Color", this.newTexture.emissiveColor);
                this.emissPatch.setBackground(this.newTexture.emissiveColor.getColor());
                this.emissPatch.repaint();
                this.preview.render();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.newTexture.transparency = (float)this.transSlider.getValue();
            this.newTexture.specularity = (float)this.specSlider.getValue();
            this.newTexture.roughness = this.shinSlider.getValue();
            this.newTexture.cloudiness = this.clearSlider.getValue();
            this.preview.render();
        }
    }
}

