/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.BoundingBox;
import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.Mat4;
import artofillusion.ObjectInfo;
import artofillusion.RGBColor;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.SceneCamera;
import artofillusion.Vec2;
import artofillusion.Vec3;
import artofillusion.WireframeMesh;
import artofillusion.ui.PopupMenuManager;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;

public abstract class ViewerCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
ItemListener {
    Image theImage;
    Camera theCamera;
    ObjectInfo boundCamera;
    EditingTool currentTool;
    EditingTool activeTool;
    EditingTool metaTool;
    EditingTool altTool;
    Choice viewChoice;
    Choice perspectiveChoice;
    Choice sizeChoice;
    PopupMenuManager popupManager;
    MemoryImageSource imageSource;
    int renderMode;
    int gridSubdivisions;
    int[] pixel;
    int[] zbuffer;
    double gridSpacing;
    Graphics gr;
    boolean hideBackfaces;
    boolean showGrid;
    boolean snapToGrid;
    boolean drawFocus;
    int prefWidth = 10;
    int prefHeight = 10;
    public static final int RENDER_WIREFRAME = 0;
    public static final int RENDER_FLAT = 1;
    public static final int RENDER_SMOOTH = 2;
    public static final int RENDER_TRANSPARENT = 3;

    public ViewerCanvas() {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        this.theCamera = new Camera();
        this.theCamera.setCameraCoordinates(coords);
        this.setBackground(Color.white);
        this.hideBackfaces = true;
    }

    void buildChoices(Panel p) {
        p.setLayout(new FlowLayout(0));
        this.viewChoice = new Choice();
        p.add(this.viewChoice);
        this.viewChoice.add("Front");
        this.viewChoice.add("Back");
        this.viewChoice.add("Left");
        this.viewChoice.add("Right");
        this.viewChoice.add("Top");
        this.viewChoice.add("Bottom");
        this.viewChoice.add("Other");
        this.viewChoice.select(0);
        this.viewChoice.addItemListener(this);
        this.perspectiveChoice = new Choice();
        p.add(this.perspectiveChoice);
        this.perspectiveChoice.add("Perspective");
        this.perspectiveChoice.add("Parallel");
        this.perspectiveChoice.select(1);
        this.perspectiveChoice.addItemListener(this);
        this.sizeChoice = new Choice();
        p.add(this.sizeChoice);
        this.sizeChoice.add("10");
        this.sizeChoice.add("20");
        this.sizeChoice.add("30");
        this.sizeChoice.add("40");
        this.sizeChoice.add("50");
        this.sizeChoice.add("75");
        this.sizeChoice.add("100");
        this.sizeChoice.add("150");
        this.sizeChoice.add("200");
        this.sizeChoice.add("250");
        this.sizeChoice.add("300");
        this.sizeChoice.add("400");
        this.sizeChoice.add("500");
        this.sizeChoice.select(6);
        this.sizeChoice.addItemListener(this);
    }

    public Camera getCamera() {
        return this.theCamera;
    }

    public void setTool(EditingTool tool) {
        this.currentTool = tool;
        this.updateImage();
        this.repaint();
    }

    public EditingTool getCurrentTool() {
        return this.currentTool;
    }

    public void setMetaTool(EditingTool tool) {
        this.metaTool = tool;
    }

    public void setAltTool(EditingTool tool) {
        this.altTool = tool;
    }

    public void setPerspective(boolean perspective) {
        this.perspectiveChoice.select(perspective ? 0 : 1);
    }

    public void setPreferredSize(int width, int height) {
        this.prefWidth = width;
        this.prefHeight = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public void setDrawFocus(boolean draw) {
        this.drawFocus = draw;
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    protected void showPopupIfNeeded(MouseEvent ev) {
        if (!ev.isPopupTrigger() || this.popupManager == null) {
            return;
        }
        Graphics g = this.getGraphics();
        this.update(g);
        g.dispose();
        Point pos = ev.getPoint();
        this.popupManager.showPopupMenu(this, pos.x, pos.y);
    }

    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        Dimension dim = this.getSize();
        if (this.theImage == null || this.theImage.getWidth(this) != dim.width || this.theImage.getHeight(this) != dim.height) {
            this.updateImage();
        }
        g.drawImage(this.theImage, 0, 0, this);
        this.currentTool.drawOverlay(g, this);
        Toolkit.getDefaultToolkit().sync();
    }

    public void drawImage(Graphics g) {
        Dimension dim = this.getSize();
        if (this.theImage == null || this.theImage.getWidth(this) != dim.width || this.theImage.getHeight(this) != dim.height) {
            this.updateImage();
        }
        g.drawImage(this.theImage, 0, 0, this);
    }

    public void adjustCamera(boolean perspective) {
        double scale;
        Dimension dim = this.getSize();
        try {
            scale = Double.valueOf(this.sizeChoice.getSelectedItem());
        }
        catch (NumberFormatException ex) {
            scale = 100.0;
        }
        if (perspective) {
            this.theCamera.setScreenParams(0.0, scale, dim.width, dim.height);
        } else {
            this.theCamera.setScreenParamsParallel(scale, dim.width, dim.height);
        }
    }

    public ObjectInfo getBoundCamera() {
        return this.boundCamera;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        this.gridSpacing = spacing;
        this.gridSubdivisions = subdivisions;
        this.showGrid = show;
        this.snapToGrid = snap;
        if (snap) {
            this.theCamera.setGrid(spacing / (double)subdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
    }

    public void frameBox(BoundingBox bb) {
        double scale;
        if (this.boundCamera != null) {
            return;
        }
        Dimension dim = this.getSize();
        if (this.perspectiveChoice.getSelectedIndex() == 0) {
            this.theCamera.setScreenParams(0.0, 100.0, dim.width, dim.height);
        } else {
            this.theCamera.setScreenParamsParallel(100.0, dim.width, dim.height);
        }
        double startDist = 20.0 + Math.max(Math.max(bb.maxx - bb.minx, bb.maxy - bb.miny), bb.maxz - bb.minz);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        Vec3 boxCenter = bb.getCenter();
        coords.setOrigin(boxCenter.minus(coords.getZDirection().times(startDist)));
        this.theCamera.setCameraCoordinates(coords);
        this.theCamera.setObjectTransform(Mat4.identity());
        Rectangle screenBounds = this.theCamera.findScreenBounds(bb);
        double scalex = (double)dim.width / (double)screenBounds.width;
        double scaley = (double)dim.height / (double)screenBounds.height;
        double d = scale = scalex < scaley ? scalex : scaley;
        if (this.perspectiveChoice.getSelectedIndex() == 0) {
            coords.setOrigin(boxCenter.minus(coords.getZDirection().times(1.1 * startDist / scale)));
            this.sizeChoice.select("100");
        } else {
            try {
                int i = 0;
                while (i < this.sizeChoice.getItemCount() - 1) {
                    if (Double.valueOf(this.sizeChoice.getItem(i + 1)) > scale * 100.0) break;
                    ++i;
                }
                this.sizeChoice.select(i);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public synchronized void updateImage() {
        Dimension dim = this.getSize();
        if (dim.height <= 0) {
            return;
        }
        if (this.boundCamera != null) {
            this.boundCamera.coords.copyCoords(this.theCamera.getCameraCoordinates());
            this.theCamera.setDistToScreen((double)dim.height / 200.0 / Math.tan(((SceneCamera)this.boundCamera.object).getFieldOfView() * Math.PI / 360.0));
        } else {
            this.theCamera.setDistToScreen(20.0);
        }
        if (this.theImage == null || this.theImage.getWidth(this) != dim.width || this.theImage.getHeight(this) != dim.height) {
            if (this.gr != null) {
                this.gr.dispose();
            }
            if (dim.width < 0 || dim.height < 0) {
                dim.height = 0;
                dim.width = 0;
            }
            if (this.renderMode == 0) {
                this.theImage = this.createImage(dim.width, dim.height);
                if (this.theImage == null) {
                    return;
                }
                this.gr = this.theImage.getGraphics();
            } else {
                this.pixel = new int[dim.width * dim.height];
                this.zbuffer = new int[dim.width * dim.height];
                this.imageSource = new MemoryImageSource(dim.width, dim.height, this.pixel, 0, dim.width);
                this.imageSource.setAnimated(true);
                this.theImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
                this.gr = null;
            }
        }
        if (this.renderMode == 0) {
            this.gr.clearRect(0, 0, dim.width, dim.height);
        } else {
            int i = 0;
            while (i < this.pixel.length) {
                this.pixel[i] = -1;
                this.zbuffer[i] = Integer.MAX_VALUE;
                ++i;
            }
        }
        if (this.showGrid && this.perspectiveChoice.getSelectedIndex() == 1) {
            Vec2 v1 = this.theCamera.getViewToScreen().timesXY(new Vec3());
            Vec2 v2 = this.theCamera.getViewToScreen().timesXY(new Vec3(this.gridSpacing, this.gridSpacing, 1.0));
            Vec2 v3 = this.theCamera.getWorldToScreen().timesXY(new Vec3());
            double space = Math.abs(v1.x - v2.x);
            double pos = Math.IEEEremainder(v3.x, space);
            if (pos < 0.0) {
                pos += space;
            }
            while ((int)pos < dim.width) {
                this.drawVRule((int)pos, Color.lightGray);
                pos += space;
            }
            space = Math.abs(v1.y - v2.y);
            pos = Math.IEEEremainder(v3.y, space);
            if (pos < 0.0) {
                pos += space;
            }
            while ((int)pos < dim.height) {
                this.drawHRule((int)pos, Color.lightGray);
                pos += space;
            }
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(int mode) {
        this.renderMode = mode;
        this.theImage = null;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    void moveToGrid(MouseEvent e) {
        Point pos = e.getPoint();
        if (!this.snapToGrid || this.perspectiveChoice.getSelectedIndex() == 0) {
            return;
        }
        Vec3 v = this.theCamera.convertScreenToWorld(pos, this.theCamera.getDistToScreen());
        Vec2 v2 = this.theCamera.getWorldToScreen().timesXY(v);
        e.translatePoint((int)v2.x - pos.x, (int)v2.y - pos.y);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.viewChoice) {
            this.selectOrientation(this.viewChoice.getSelectedIndex());
        }
        this.updateImage();
        this.repaint();
    }

    public void selectOrientation(int which) {
        double dist;
        this.viewChoice.select(which);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        boolean perspective = this.perspectiveChoice.getSelectedIndex() == 0;
        double d = dist = perspective ? coords.getOrigin().length() : 20.0;
        if (which == 0) {
            coords = new CoordinateSystem(new Vec3(0.0, 0.0, dist), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        } else if (which == 1) {
            coords = new CoordinateSystem(new Vec3(0.0, 0.0, -dist), Vec3.vz(), Vec3.vy());
        } else if (which == 2) {
            coords = new CoordinateSystem(new Vec3(-dist, 0.0, 0.0), Vec3.vx(), Vec3.vy());
        } else if (which == 3) {
            coords = new CoordinateSystem(new Vec3(dist, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), Vec3.vy());
        } else if (which == 4) {
            coords = new CoordinateSystem(new Vec3(0.0, dist, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0));
        } else if (which == 5) {
            coords = new CoordinateSystem(new Vec3(0.0, -dist, 0.0), Vec3.vy(), Vec3.vz());
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public void copyOrientationFromCamera() {
        if (this.boundCamera == null) {
            return;
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        coords.copyCoords(this.boundCamera.coords);
        this.theCamera.setCameraCoordinates(coords);
    }

    public void orientationChanged() {
        if (this.viewChoice != null && this.viewChoice.getSelectedIndex() < 6) {
            this.viewChoice.select(this.viewChoice.getItemCount() - 1);
        }
    }

    public void drawBorder() {
        Dimension dim = this.getSize();
        if (this.gr != null) {
            this.gr.setColor(Color.black);
            this.gr.drawRect(0, 0, dim.width - 1, dim.height - 1);
            if (this.drawFocus) {
                this.gr.drawRect(1, 1, dim.width - 2, dim.height - 2);
            }
            return;
        }
        int index1 = 0;
        int index2 = dim.width - 1;
        int i = 0;
        while (i < dim.height) {
            this.pixel[index2] = -16777216;
            this.pixel[index1] = -16777216;
            if (this.drawFocus) {
                this.pixel[index2 - 1] = -16777216;
                this.pixel[index1 + 1] = -16777216;
            }
            ++i;
            index1 += dim.width;
            index2 += dim.width;
        }
        index1 = dim.width * (dim.height - 1);
        i = 1;
        while (i < dim.width - 1) {
            this.pixel[index1 + i] = -16777216;
            this.pixel[i] = -16777216;
            if (this.drawFocus) {
                this.pixel[index1 + i - dim.width] = -16777216;
                this.pixel[i + dim.width] = -16777216;
            }
            ++i;
        }
    }

    public void drawHRule(int y, Color color) {
        Dimension dim = this.getSize();
        int index = y * dim.width;
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(1, y, dim.width - 1, y);
        } else {
            int col = color.getRGB();
            int i = 0;
            while (i < dim.width) {
                this.pixel[index] = col;
                ++i;
                ++index;
            }
        }
    }

    public void drawVRule(int x, Color color) {
        Dimension dim = this.getSize();
        int index = x;
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(x, 1, x, dim.height - 1);
        } else {
            int col = color.getRGB();
            int i = 0;
            while (i < dim.height) {
                this.pixel[index] = col;
                ++i;
                index += dim.width;
            }
        }
    }

    public void drawBox(int x, int y, int width, int height, Color color) {
        Dimension dim = this.getSize();
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.fillRect(x, y, width, height);
        } else {
            int col = color.getRGB();
            int maxx = x + width;
            int maxy = y + height;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (maxx > dim.width) {
                maxx = dim.width;
            }
            if (maxy > dim.height) {
                maxy = dim.height;
            }
            width = maxx - x;
            int i = y;
            int index = y * dim.width + x;
            while (i < maxy) {
                int j = 0;
                while (j < width) {
                    this.pixel[index + j] = col;
                    ++j;
                }
                ++i;
                index += dim.width;
            }
        }
    }

    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        Dimension dim = this.getSize();
        int col = color.getRGB();
        int z = (int)(depth * 65536.0);
        int maxx = x + width;
        int maxy = y + height;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (maxx > dim.width) {
            maxx = dim.width;
        }
        if (maxy > dim.height) {
            maxy = dim.height;
        }
        width = maxx - x;
        int i = y;
        int index = y * dim.width + x;
        while (i < maxy) {
            int j = 0;
            while (j < width) {
                if (z <= this.zbuffer[index + j]) {
                    this.pixel[index + j] = col;
                    this.zbuffer[index + j] = z;
                }
                ++j;
            }
            ++i;
            index += dim.width;
        }
    }

    public void drawLine(Point p1, Point p2, Color color) {
        if (this.gr != null) {
            this.gr.setColor(color);
            this.gr.drawLine(p1.x, p1.y, p2.x, p2.y);
            return;
        }
        Dimension dim = this.getSize();
        int col = color.getRGB();
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= dim.width && x2 >= dim.width) {
            return;
        }
        if (y1 >= dim.height && y2 >= dim.height) {
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                dy = (dy << 16) / dx;
                end = x2 < dim.width ? x2 : dim.width;
            } else {
                x = x2;
                y = y2 << 32784;
                dy = (dy << 16) / dx;
                int n = end = x1 < dim.width ? x1 : dim.width;
            }
            if (x < 0) {
                y -= dy * x;
                x = 0;
            }
            int edge = dim.height << 16;
            while (x < end) {
                if (y >= 0 && y < edge) {
                    int index = dim.width * (y >> 16) + x;
                    this.pixel[index] = col;
                }
                ++x;
                y += dy;
            }
        } else {
            int end;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                dx = (dx << 16) / dy;
                end = y2 < dim.height ? y2 : dim.height;
            } else {
                x = x2 << 32784;
                y = y2;
                dx = (dx << 16) / dy;
                int n = end = y1 < dim.height ? y1 : dim.height;
            }
            if (y < 0) {
                x -= dx * y;
                y = 0;
            }
            int edge = dim.width << 16;
            while (y < end) {
                if (x >= 0 && x < edge) {
                    int index = y * dim.width + (x >> 16);
                    this.pixel[index] = col;
                }
                x += dx;
                ++y;
            }
        }
    }

    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, int color) {
        int clip = (int)(cam.getClipDistance() * 65536.0);
        Dimension dim = this.getSize();
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int z1 = (int)(zf1 * 65536.0);
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int z2 = (int)(zf2 * 65536.0);
        if (x1 < 0 && x2 < 0) {
            return;
        }
        if (y1 < 0 && y2 < 0) {
            return;
        }
        if (x1 >= dim.width && x2 >= dim.width) {
            return;
        }
        if (y1 >= dim.height && y2 >= dim.height) {
            return;
        }
        if (z1 < clip && z2 < clip) {
            return;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            int end;
            int z;
            int y;
            int x;
            if (dx > 0) {
                x = x1;
                y = y1 << 32784;
                z = z1;
                dy = (dy << 16) / dx;
                dz /= dx;
                end = x2 < dim.width ? x2 : dim.width;
            } else {
                x = x2;
                y = y2 << 32784;
                z = z2;
                dy = (dy << 16) / dx;
                dz /= dx;
                int n = end = x1 < dim.width ? x1 : dim.width;
            }
            if (x < 0) {
                y -= dy * x;
                z -= dz * x;
                x = 0;
            }
            int edge = dim.height << 16;
            while (x < end) {
                int index;
                if (y >= 0 && y < edge && z > clip && z <= this.zbuffer[index = dim.width * (y >> 16) + x]) {
                    this.pixel[index] = color;
                    this.zbuffer[index] = z;
                }
                ++x;
                y += dy;
                z += dz;
            }
        } else {
            int end;
            int z;
            int y;
            int x;
            if (dy > 0) {
                x = x1 << 32784;
                y = y1;
                z = z1;
                dx = (dx << 16) / dy;
                dz /= dy;
                end = y2 < dim.height ? y2 : dim.height;
            } else {
                x = x2 << 32784;
                y = y2;
                z = z2;
                dx = (dx << 16) / dy;
                dz /= dy;
                int n = end = y1 < dim.height ? y1 : dim.height;
            }
            if (y < 0) {
                x -= dx * y;
                z -= dz * y;
                y = 0;
            }
            int edge = dim.width << 16;
            while (y < end) {
                int index;
                if (x >= 0 && x < edge && z > clip && z <= this.zbuffer[index = y * dim.width + (x >> 16)]) {
                    this.pixel[index] = color;
                    this.zbuffer[index] = z;
                }
                x += dx;
                ++y;
                z += dz;
            }
        }
    }

    public void renderWireframe(WireframeMesh mesh, Camera cam) {
        Vec2[] pos = new Vec2[mesh.vert.length];
        double[] z = new double[mesh.vert.length];
        int i = 0;
        while (i < pos.length) {
            pos[i] = cam.getObjectToScreen().timesXY(mesh.vert[i]);
            z[i] = cam.getObjectToView().timesZ(mesh.vert[i]);
            ++i;
        }
        int[] from = mesh.from;
        int[] to = mesh.to;
        int i2 = 0;
        while (i2 < from.length) {
            this.renderLine(pos[from[i2]], z[from[i2]], pos[to[i2]], z[to[i2]], cam, -16777216);
            ++i2;
        }
    }

    public void renderFlat(RenderingMesh mesh, Camera cam, Vec3 viewDir, boolean closed, RGBColor color) {
        Vec3[] vert = mesh.vert;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.getClipDistance();
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        Dimension dim = this.getSize();
        RGBColor faceColor = new RGBColor(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < vert.length) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
            ++i;
        }
        i = 0;
        while (i < mesh.triangle.length) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                faceColor.copy(color);
                faceColor.scale(0.1f + 0.8f * Math.abs((float)viewDir.dot(mesh.faceNorm[i])));
                if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                    Vec2[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                    int j = 0;
                    while (j < clipPos.length - 2) {
                        this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], dim.width, dim.height, clip, false, faceColor);
                        ++j;
                    }
                } else if (!(closed && this.hideBackfaces && (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0)) {
                    this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], dim.width, dim.height, clip, false, faceColor);
                }
            }
            ++i;
        }
    }

    private Vec2[] clipTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, double[] newz) {
        Vec3 u4;
        Vec3 u32;
        Vec3 u22;
        Vec3 u12;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u12 = v2;
            newz[0] = z2;
            u22 = v3;
            newz[1] = z3;
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u12 = v3;
            newz[0] = z3;
            u22 = v1;
            newz[1] = z1;
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u12 = v1;
            newz[0] = z1;
            u22 = v2;
            newz[1] = z2;
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32), toScreen.timesXY(u4)};
    }

    public void renderFlatTransparent(RenderingMesh mesh, Camera cam, Vec3 viewDir, RGBColor color) {
        Vec3[] vert = mesh.vert;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.getClipDistance();
        double[] clipz = new double[4];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        Dimension dim = this.getSize();
        RGBColor faceColor = new RGBColor(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < vert.length) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
            ++i;
        }
        i = 0;
        while (i < mesh.triangle.length) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                float dot = (float)viewDir.dot(mesh.faceNorm[i]);
                faceColor.setRGB(1.0f - color.red, 1.0f - color.green, 1.0f - color.blue);
                faceColor.scale(1.0f - 0.8f * Math.abs(dot));
                if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                    Vec2[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                    int j = 0;
                    while (j < clipPos.length - 2) {
                        this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], dim.width, dim.height, clip, true, faceColor);
                        ++j;
                    }
                } else {
                    this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], dim.width, dim.height, clip, true, faceColor);
                }
            }
            ++i;
        }
    }

    public void renderSmooth(RenderingMesh mesh, Camera cam, Vec3 viewDir, boolean closed, RGBColor color) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec2[] pos = new Vec2[vert.length];
        double[] z = new double[vert.length];
        double clip = cam.getClipDistance();
        double[] clipz = new double[4];
        float[] light = new float[norm.length];
        Mat4 toView = cam.getObjectToView();
        Mat4 toScreen = cam.getObjectToScreen();
        Dimension dim = this.getSize();
        RGBColor color1 = new RGBColor();
        RGBColor color2 = new RGBColor();
        RGBColor color3 = new RGBColor();
        RGBColor color4 = new RGBColor();
        RGBColor color5 = new RGBColor();
        RGBColor color6 = new RGBColor();
        RGBColor color7 = new RGBColor();
        int i = 0;
        while (i < vert.length) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = toView.timesZ(vert[i]);
            ++i;
        }
        i = 0;
        while (i < mesh.triangle.length) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                boolean backface;
                boolean bl = backface = closed && this.hideBackfaces && (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
                if (!backface) {
                    Vec2[] clipPos;
                    if (light[n1] == 0.0f) {
                        light[n1] = 0.1f + 0.8f * Math.abs((float)viewDir.dot(norm[n1]));
                    }
                    if (light[n2] == 0.0f) {
                        light[n2] = 0.1f + 0.8f * Math.abs((float)viewDir.dot(norm[n2]));
                    }
                    if (light[n3] == 0.0f) {
                        light[n3] = 0.1f + 0.8f * Math.abs((float)viewDir.dot(norm[n3]));
                    }
                    color1.copy(color);
                    color1.scale(light[n1]);
                    if (light[n1] == light[n2] && light[n1] == light[n3]) {
                        if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                            clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, clipz);
                            int j = 0;
                            while (j < clipPos.length - 2) {
                                this.renderFlatTriangle(clipPos[j], clipz[j], clipPos[j + 1], clipz[j + 1], clipPos[j + 2], clipz[j + 2], dim.width, dim.height, clip, false, color1);
                                ++j;
                            }
                        } else if (!backface) {
                            this.renderFlatTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], dim.width, dim.height, clip, false, color1);
                        }
                    } else {
                        color2.copy(color);
                        color2.scale(light[n2]);
                        color3.copy(color);
                        color3.scale(light[n3]);
                        if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                            clipPos = this.clipSmoothTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], cam, color1, color2, color3, color4, color5, color6, color7, clipz);
                            this.renderSmoothTriangle(clipPos[0], clipz[0], clipPos[1], clipz[1], clipPos[2], clipz[2], dim.width, dim.height, clip, color4, color5, color6);
                            if (clipPos.length == 4) {
                                this.renderSmoothTriangle(clipPos[1], clipz[1], clipPos[2], clipz[2], clipPos[3], clipz[3], dim.width, dim.height, clip, color5, color6, color7);
                            }
                        } else if (!backface) {
                            this.renderSmoothTriangle(pos[v1], z[v1], pos[v2], z[v2], pos[v3], z[v3], dim.width, dim.height, clip, color1, color2, color3);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private Vec2[] clipSmoothTriangle(Vec3 v1, Vec3 v2, Vec3 v3, double z1, double z2, double z3, Camera cam, RGBColor col1, RGBColor col2, RGBColor col3, RGBColor newc1, RGBColor newc2, RGBColor newc3, RGBColor newc4, double[] newz) {
        Vec3 u4;
        Vec3 u32;
        Vec3 u22;
        Vec3 u12;
        double clip = cam.getClipDistance();
        Mat4 toScreen = cam.getObjectToScreen();
        boolean c1 = z1 < clip;
        boolean c2 = z2 < clip;
        boolean c3 = z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                newc1.copy(col1);
                double f2 = (z1 - clip) / (z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col1.red + f2 * (double)col2.red, f1 * (double)col1.green + f2 * (double)col2.green, f1 * (double)col1.blue + f2 * (double)col2.blue);
                newz[1] = f1 * z1 + f2 * z2;
                f2 = (z1 - clip) / (z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col1.red + f2 * (double)col3.red, f1 * (double)col1.green + f2 * (double)col3.green, f1 * (double)col1.blue + f2 * (double)col3.blue);
                newz[2] = f1 * z1 + f2 * z3;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                newc2.copy(col2);
                double f2 = (z2 - clip) / (z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newc3.setRGB(f1 * (double)col2.red + f2 * (double)col3.red, f1 * (double)col2.green + f2 * (double)col3.green, f1 * (double)col2.blue + f2 * (double)col3.blue);
                newz[2] = f1 * z2 + f2 * z3;
                f2 = (z2 - clip) / (z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col2.red + f2 * (double)col3.red, f1 * (double)col2.green + f2 * (double)col3.green, f1 * (double)col2.blue + f2 * (double)col3.blue);
                newz[0] = f1 * z2 + f2 * z1;
            } else {
                u32 = v3;
                newz[2] = z3;
                newc3.copy(col3);
                double f2 = (z3 - clip) / (z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newc1.setRGB(f1 * (double)col3.red + f2 * (double)col1.red, f1 * (double)col3.green + f2 * (double)col1.green, f1 * (double)col3.blue + f2 * (double)col1.blue);
                newz[0] = f1 * z3 + f2 * z1;
                f2 = (z3 - clip) / (z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newc2.setRGB(f1 * (double)col3.red + f2 * (double)col2.red, f1 * (double)col3.green + f2 * (double)col2.green, f1 * (double)col3.blue + f2 * (double)col2.blue);
                newz[1] = f1 * z3 + f2 * z2;
            }
            return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32)};
        }
        if (c1) {
            u12 = v2;
            newz[0] = z2;
            newc1.copy(col2);
            u22 = v3;
            newz[1] = z3;
            newc2.copy(col3);
            double f1 = (z2 - clip) / (z2 - z1);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newc3.setRGB(f1 * (double)col1.red + f2 * (double)col2.red, f1 * (double)col1.green + f2 * (double)col2.green, f1 * (double)col1.blue + f2 * (double)col2.blue);
            newz[2] = f1 * z1 + f2 * z2;
            f1 = (z3 - clip) / (z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newc4.setRGB(f1 * (double)col1.red + f2 * (double)col3.red, f1 * (double)col1.green + f2 * (double)col3.green, f1 * (double)col1.blue + f2 * (double)col3.blue);
            newz[3] = f1 * z1 + f2 * z3;
        } else if (c2) {
            u12 = v3;
            newz[0] = z3;
            newc1.copy(col3);
            u22 = v1;
            newz[1] = z1;
            newc2.copy(col1);
            double f1 = (z3 - clip) / (z3 - z2);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newc3.setRGB(f1 * (double)col2.red + f2 * (double)col3.red, f1 * (double)col2.green + f2 * (double)col3.green, f1 * (double)col2.blue + f2 * (double)col3.blue);
            newz[2] = f1 * z2 + f2 * z3;
            f1 = (z1 - clip) / (z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newc4.setRGB(f1 * (double)col2.red + f2 * (double)col1.red, f1 * (double)col2.green + f2 * (double)col1.green, f1 * (double)col2.blue + f2 * (double)col1.blue);
            newz[3] = f1 * z2 + f2 * z1;
        } else {
            u12 = v1;
            newz[0] = z1;
            newc1.copy(col1);
            u22 = v2;
            newz[1] = z2;
            newc2.copy(col2);
            double f1 = (z1 - clip) / (z1 - z3);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newc3.setRGB(f1 * (double)col3.red + f2 * (double)col1.red, f1 * (double)col3.green + f2 * (double)col1.green, f1 * (double)col3.blue + f2 * (double)col1.blue);
            newz[2] = f1 * z3 + f2 * z1;
            f1 = (z2 - clip) / (z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newc4.setRGB(f1 * (double)col3.red + f2 * (double)col2.red, f1 * (double)col3.green + f2 * (double)col2.green, f1 * (double)col3.blue + f2 * (double)col2.blue);
            newz[3] = f1 * z3 + f2 * z2;
        }
        return new Vec2[]{toScreen.timesXY(u12), toScreen.timesXY(u22), toScreen.timesXY(u32), toScreen.timesXY(u4)};
    }

    public void renderFlatTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, boolean transparent, RGBColor color) {
        int b;
        int g;
        int r;
        int i;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mz2;
        int mx2;
        int zend;
        int xend;
        int z3;
        int y3;
        int x3;
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        int blue;
        int green;
        int red;
        int col;
        int clipDist = (int)(clip * 65536.0);
        if (transparent) {
            col = 0;
            red = (int)(color.red * 255.0f);
            green = (int)(color.green * 255.0f);
            blue = (int)(color.blue * 255.0f);
        } else {
            col = color.getARGB();
            blue = 0;
            green = 0;
            red = 0;
        }
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65536.0);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65536.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65536.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65536.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65536.0);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65536.0);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65536.0);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65536.0);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65536.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65536.0);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65536.0);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65536.0);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65536.0);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65536.0);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65536.0);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (transparent) {
                        i = left;
                        while (i < right) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                            ++i;
                        }
                    } else {
                        i = left;
                        while (i < right) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                            ++i;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            xend = x2;
            zend = z2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                }
                if (left != right) {
                    dz /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    if (transparent) {
                        i = left;
                        while (i < right) {
                            if (z > clipDist) {
                                r = ((this.pixel[index + i] & 0xFF0000) >> 16) - red;
                                g = ((this.pixel[index + i] & 0xFF00) >> 8) - green;
                                b = (this.pixel[index + i] & 0xFF) - blue;
                                if (r < 0) {
                                    r = 0;
                                }
                                if (g < 0) {
                                    g = 0;
                                }
                                if (b < 0) {
                                    b = 0;
                                }
                                this.pixel[index + i] = -16777216 + (r << 16) + (g << 8) + b;
                            }
                            z += dz;
                            ++i;
                        }
                    } else {
                        i = left;
                        while (i < right) {
                            if (z < this.zbuffer[index + i] && z > clipDist) {
                                this.pixel[index + i] = col;
                                this.zbuffer[index + i] = z;
                            }
                            z += dz;
                            ++i;
                        }
                    }
                }
                xstart += mx1;
                zstart += mz1;
                xend += mx2;
                zend += mz2;
                index += width;
                ++y;
            }
        }
    }

    public void renderSmoothTriangle(Vec2 pos1, double zf1, Vec2 pos2, double zf2, Vec2 pos3, double zf3, int width, int height, double clip, RGBColor color1, RGBColor color2, RGBColor color3) {
        int i;
        int dblue;
        int blue;
        int dgreen;
        int green;
        int dred;
        int red;
        int dz;
        int z;
        int right;
        int left;
        int index;
        int yend;
        int mblue2;
        int mgreen2;
        int mred2;
        int mz2;
        int mx2;
        int blueend;
        int greenend;
        int redend;
        int zend;
        int xend;
        int blue3;
        int green3;
        int red3;
        int z3;
        int y3;
        int x3;
        int blue2;
        int green2;
        int red2;
        int z2;
        int y2;
        int x2;
        int blue1;
        int green1;
        int red1;
        int z1;
        int y1;
        int x1;
        int clipDist = (int)(clip * 65536.0);
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = (int)pos1.x << 16;
            y1 = (int)pos1.y;
            z1 = (int)(zf1 * 65536.0);
            red1 = (int)(color1.red * 65536.0f);
            green1 = (int)(color1.green * 65536.0f);
            blue1 = (int)(color1.blue * 65536.0f);
            if (pos2.y < pos3.y) {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65536.0);
                red2 = (int)(color2.red * 65536.0f);
                green2 = (int)(color2.green * 65536.0f);
                blue2 = (int)(color2.blue * 65536.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65536.0);
                red3 = (int)(color3.red * 65536.0f);
                green3 = (int)(color3.green * 65536.0f);
                blue3 = (int)(color3.blue * 65536.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65536.0);
                red2 = (int)(color3.red * 65536.0f);
                green2 = (int)(color3.green * 65536.0f);
                blue2 = (int)(color3.blue * 65536.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65536.0);
                red3 = (int)(color2.red * 65536.0f);
                green3 = (int)(color2.green * 65536.0f);
                blue3 = (int)(color2.blue * 65536.0f);
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = (int)pos2.x << 16;
            y1 = (int)pos2.y;
            z1 = (int)(zf2 * 65536.0);
            red1 = (int)(color2.red * 65536.0f);
            green1 = (int)(color2.green * 65536.0f);
            blue1 = (int)(color2.blue * 65536.0f);
            if (pos1.y < pos3.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65536.0);
                red2 = (int)(color1.red * 65536.0f);
                green2 = (int)(color1.green * 65536.0f);
                blue2 = (int)(color1.blue * 65536.0f);
                x3 = (int)pos3.x << 16;
                y3 = (int)pos3.y;
                z3 = (int)(zf3 * 65536.0);
                red3 = (int)(color3.red * 65536.0f);
                green3 = (int)(color3.green * 65536.0f);
                blue3 = (int)(color3.blue * 65536.0f);
            } else {
                x2 = (int)pos3.x << 16;
                y2 = (int)pos3.y;
                z2 = (int)(zf3 * 65536.0);
                red2 = (int)(color3.red * 65536.0f);
                green2 = (int)(color3.green * 65536.0f);
                blue2 = (int)(color3.blue * 65536.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65536.0);
                red3 = (int)(color1.red * 65536.0f);
                green3 = (int)(color1.green * 65536.0f);
                blue3 = (int)(color1.blue * 65536.0f);
            }
        } else {
            x1 = (int)pos3.x << 16;
            y1 = (int)pos3.y;
            z1 = (int)(zf3 * 65536.0);
            red1 = (int)(color3.red * 65536.0f);
            green1 = (int)(color3.green * 65536.0f);
            blue1 = (int)(color3.blue * 65536.0f);
            if (pos1.y < pos2.y) {
                x2 = (int)pos1.x << 16;
                y2 = (int)pos1.y;
                z2 = (int)(zf1 * 65536.0);
                red2 = (int)(color1.red * 65536.0f);
                green2 = (int)(color1.green * 65536.0f);
                blue2 = (int)(color1.blue * 65536.0f);
                x3 = (int)pos2.x << 16;
                y3 = (int)pos2.y;
                z3 = (int)(zf2 * 65536.0);
                red3 = (int)(color2.red * 65536.0f);
                green3 = (int)(color2.green * 65536.0f);
                blue3 = (int)(color2.blue * 65536.0f);
            } else {
                x2 = (int)pos2.x << 16;
                y2 = (int)pos2.y;
                z2 = (int)(zf2 * 65536.0);
                red2 = (int)(color2.red * 65536.0f);
                green2 = (int)(color2.green * 65536.0f);
                blue2 = (int)(color2.blue * 65536.0f);
                x3 = (int)pos1.x << 16;
                y3 = (int)pos1.y;
                z3 = (int)(zf1 * 65536.0);
                red3 = (int)(color1.red * 65536.0f);
                green3 = (int)(color1.green * 65536.0f);
                blue3 = (int)(color1.blue * 65536.0f);
            }
        }
        int dx1 = x3 - x1;
        int dy1 = y3 - y1;
        int dz1 = z3 - z1;
        if (dy1 == 0) {
            return;
        }
        int dred1 = red3 - red1;
        int dgreen1 = green3 - green1;
        int dblue1 = blue3 - blue1;
        int dx2 = x2 - x1;
        int dy2 = y2 - y1;
        int dz2 = z2 - z1;
        int dred2 = red2 - red1;
        int dgreen2 = green2 - green1;
        int dblue2 = blue2 - blue1;
        int mx1 = dx1 / dy1;
        int mz1 = dz1 / dy1;
        int mred1 = dred1 / dy1;
        int mgreen1 = dgreen1 / dy1;
        int mblue1 = dblue1 / dy1;
        int xstart = xend = x1;
        int zstart = zend = z1;
        int redstart = redend = red1;
        int greenstart = greenend = green1;
        int bluestart = blueend = blue1;
        int y = y1;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            if (y2 < 0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart += mz1 * dy2;
                zend += mz2 * dy2;
                redstart += mred1 * dy2;
                redend += mred2 * dy2;
                greenstart += mgreen1 * dy2;
                greenend += mgreen2 * dy2;
                bluestart += mblue1 * dy2;
                blueend += mblue2 * dy2;
                y = y2;
            } else if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y2 < height ? y2 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    i = left;
                    while (i < right) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                        ++i;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        dred2 = red3 - red2;
        dgreen2 = green3 - green2;
        dblue2 = blue3 - blue2;
        if (dy2 != 0) {
            mx2 = dx2 / dy2;
            mz2 = dz2 / dy2;
            mred2 = dred2 / dy2;
            mgreen2 = dgreen2 / dy2;
            mblue2 = dblue2 / dy2;
            xend = x2;
            zend = z2;
            redend = red2;
            greenend = green2;
            blueend = blue2;
            if (y < 0) {
                xstart -= mx1 * y;
                xend -= mx2 * y;
                zstart -= mz1 * y;
                zend -= mz2 * y;
                redstart -= mred1 * y;
                redend -= mred2 * y;
                greenstart -= mgreen1 * y;
                greenend -= mgreen2 * y;
                bluestart -= mblue1 * y;
                blueend -= mblue2 * y;
                y = 0;
            }
            yend = y3 < height ? y3 : height;
            index = y * width;
            while (y < yend) {
                if (xstart < xend) {
                    left = xstart >> 16;
                    right = xend >> 16;
                    z = zstart;
                    dz = zend - zstart;
                    red = redstart;
                    dred = redend - redstart;
                    green = greenstart;
                    dgreen = greenend - greenstart;
                    blue = bluestart;
                    dblue = blueend - bluestart;
                } else {
                    left = xend >> 16;
                    right = xstart >> 16;
                    z = zend;
                    dz = zstart - zend;
                    red = redend;
                    dred = redstart - redend;
                    green = greenend;
                    dgreen = greenstart - greenend;
                    blue = blueend;
                    dblue = bluestart - blueend;
                }
                if (left != right) {
                    dz /= right - left;
                    dred /= right - left;
                    dgreen /= right - left;
                    dblue /= right - left;
                    if (left < 0) {
                        z -= left * dz;
                        red -= left * dred;
                        green -= left * dgreen;
                        blue -= left * dblue;
                        left = 0;
                    }
                    if (right > width) {
                        right = width;
                    }
                    i = left;
                    while (i < right) {
                        if (z < this.zbuffer[index + i] && z > clipDist) {
                            this.pixel[index + i] = -16777216 + ((red & 0xFF00) << 8) + (green & 0xFF00) + (blue >> 8);
                            this.zbuffer[index + i] = z;
                        }
                        z += dz;
                        red += dred;
                        green += dgreen;
                        blue += dblue;
                        ++i;
                    }
                }
                xstart += mx1;
                zstart += mz1;
                redstart += mred1;
                greenstart += mgreen1;
                bluestart += mblue1;
                xend += mx2;
                zend += mz2;
                redend += mred2;
                greenend += mgreen2;
                blueend += mblue2;
                index += width;
                ++y;
            }
        }
    }
}

