/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Vector;

public class EditKeyframesDialog
extends Dialog
implements ActionListener {
    LayoutWindow window;
    Scene theScene;
    Choice tracksChoice;
    ValueField startField;
    ValueField endField;
    ValueField extraField;
    Button okButton;
    Button cancelButton;
    int operation;
    public static final int MOVE = 0;
    public static final int COPY = 1;
    public static final int RESCALE = 2;
    public static final int LOOP = 3;
    public static final int DELETE = 4;
    private static final String[] opTitle = new String[]{"Move", "Copy", "Rescale", "Loop", "Delete"};

    public EditKeyframesDialog(LayoutWindow win, int operation) {
        super(win, opTitle[operation] + " Keyframes", true);
        this.window = win;
        this.operation = operation;
        this.theScene = this.window.getScene();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        Panel p = new Panel();
        this.add((Component)p, gc);
        p.add((Component)new Label("Apply to "), gc);
        this.tracksChoice = new Choice();
        p.add((Component)this.tracksChoice, gc);
        this.tracksChoice.add("All Tracks");
        this.tracksChoice.add("All Tracks of Selected Objects");
        this.tracksChoice.add("Selected Tracks");
        p = new Panel();
        this.add((Component)p, gc);
        p.add(new Label(opTitle[operation] + " keyframes between time "));
        this.startField = new ValueField(0.0, 0, 5);
        p.add(this.startField);
        p = new Panel();
        this.add((Component)p, gc);
        p.add(new Label(" and time "));
        this.endField = new ValueField(0.0, 0, 5);
        p.add(this.endField);
        p = new Panel();
        this.add((Component)p, gc);
        if (operation == 0 || operation == 1) {
            p.add(new Label("to time "));
        } else if (operation == 2) {
            p.add(new Label("by a factor of "));
        } else if (operation == 3) {
            p.add(new Label("Number of times to loop: "));
        }
        this.extraField = operation == 3 ? new ValueField(2.0, 7, 5) : new ValueField(1.0, 0, 5);
        if (operation != 4) {
            p.add(this.extraField);
        }
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10 && EditKeyframesDialog.this.doEdit()) {
                    EditKeyframesDialog.this.dispose();
                }
                if (ev.getKeyCode() == 27) {
                    EditKeyframesDialog.this.dispose();
                }
            }
        };
        this.tracksChoice.addKeyListener(listener);
        this.startField.addKeyListener(listener);
        this.endField.addKeyListener(listener);
        this.extraField.addKeyListener(listener);
        p = new Panel();
        this.add((Component)p, gc);
        this.okButton = new Button("OK");
        p.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton || this.doEdit()) {
            this.dispose();
        }
    }

    private boolean doEdit() {
        double targetEnd;
        double targetStart;
        int i;
        Track[] track;
        Vector obj;
        int whichTracks = this.tracksChoice.getSelectedIndex();
        double fps = this.theScene.getFramesPerSecond();
        if (whichTracks == 0) {
            obj = this.theScene.getObjects();
            Vector tracks = new Vector();
            int i2 = 0;
            while (i2 < obj.size()) {
                ObjectInfo info = (ObjectInfo)obj.elementAt(i2);
                int j = 0;
                while (j < info.tracks.length) {
                    this.addToVector(info.tracks[j], tracks);
                    ++j;
                }
                ++i2;
            }
            track = new Track[tracks.size()];
            i = 0;
            while (i < track.length) {
                track[i] = (Track)tracks.elementAt(i);
                ++i;
            }
        } else if (whichTracks == 1) {
            obj = this.theScene.getObjects();
            int[] sel = this.theScene.getSelection();
            Vector tracks = new Vector();
            i = 0;
            while (i < sel.length) {
                ObjectInfo info = (ObjectInfo)obj.elementAt(sel[i]);
                int j = 0;
                while (j < info.tracks.length) {
                    this.addToVector(info.tracks[j], tracks);
                    ++j;
                }
                ++i;
            }
            track = new Track[tracks.size()];
            int i3 = 0;
            while (i3 < track.length) {
                track[i3] = (Track)tracks.elementAt(i3);
                ++i3;
            }
        } else {
            track = this.window.getScore().getSelectedTracks();
        }
        double start = this.startField.getValue();
        double end = this.endField.getValue();
        double extra = this.extraField.getValue();
        double scaleStart = 0.0;
        double scaleFactor = 0.0;
        int numLoops = 0;
        if (start > end) {
            double temp = start;
            start = end;
            end = temp;
        }
        if (this.operation == 0 || this.operation == 1) {
            targetStart = extra;
            targetEnd = targetStart + (end - start);
            if (targetStart > start && targetStart < end) {
                targetStart = end;
            }
            if (targetEnd > start && targetEnd < end) {
                targetEnd = start;
            }
        } else if (this.operation == 2) {
            scaleFactor = extra;
            targetStart = end;
            targetEnd = start + Math.abs(scaleFactor) * (end - start);
            scaleStart = scaleFactor < 0.0 ? targetEnd : start;
            if (targetEnd < targetStart) {
                targetEnd = targetStart;
            }
        } else if (this.operation == 3) {
            numLoops = (int)extra;
            targetStart = end;
            targetEnd = start + (double)numLoops * (end - start);
        } else {
            targetStart = targetEnd = start;
        }
        boolean any = false;
        int i4 = 0;
        while (!any && i4 < track.length) {
            double[] t = track[i4].getKeyTimes();
            int j = 0;
            while (!any && j < t.length) {
                if (t[j] > targetStart && t[j] < targetEnd) {
                    any = true;
                }
                ++j;
            }
            ++i4;
        }
        if (any) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            MessageDialog dlg = new MessageDialog((Frame)this.window, new String[]{"There are existing keyframes in the target range for", "this operation (from time " + nf.format(targetStart) + " to time " + nf.format(targetEnd) + ").  If you continue,", "they will be deleted.  Do you want to continue?"}, new String[]{"Yes", "No"});
            if (dlg.getChoice() == 1) {
                return false;
            }
        }
        UndoRecord undo = new UndoRecord(this.window, false);
        int i5 = 0;
        while (i5 < track.length) {
            Object parent = track[i5].getParent();
            Track dup = parent instanceof ObjectInfo ? track[i5].duplicate((ObjectInfo)parent) : track[i5].duplicate(null);
            undo.addCommand(12, new Object[]{track[i5], dup});
            ++i5;
        }
        int i6 = 0;
        while (i6 < track.length) {
            double[] t = track[i6].getKeyTimes();
            int j = t.length - 1;
            while (j >= 0) {
                if (t[j] > targetStart && t[j] < targetEnd) {
                    track[i6].deleteKeyframe(j);
                }
                --j;
            }
            Timecourse tc = track[i6].getTimecourse();
            if (tc != null) {
                Keyframe[] key = tc.getValues();
                Smoothness[] s = tc.getSmoothness();
                t = track[i6].getKeyTimes();
                if (this.operation == 0 || this.operation == 2 || this.operation == 4) {
                    int j2 = t.length - 1;
                    while (j2 >= 0) {
                        if (t[j2] >= start && t[j2] <= end) {
                            track[i6].deleteKeyframe(j2);
                        }
                        --j2;
                    }
                }
                if (this.operation == 0 || this.operation == 1) {
                    int j3 = 0;
                    while (j3 < t.length) {
                        if (t[j3] >= start && t[j3] <= end) {
                            track[i6].setKeyframe(this.roundTime(t[j3] - start + extra, fps), key[j3].duplicate(), s[j3]);
                        }
                        ++j3;
                    }
                }
                if (this.operation == 2) {
                    int j4 = 0;
                    while (j4 < t.length) {
                        if (t[j4] >= start && t[j4] <= end) {
                            track[i6].setKeyframe(this.roundTime(scaleStart + scaleFactor * (t[j4] - start), fps), key[j4].duplicate(), s[j4]);
                        }
                        ++j4;
                    }
                }
                if (this.operation == 3) {
                    int j5 = 0;
                    while (j5 < t.length) {
                        if (t[j5] >= start && t[j5] <= end) {
                            int k = 1;
                            while (k < numLoops) {
                                track[i6].setKeyframe(this.roundTime(t[j5] + (double)k * (end - start), fps), key[j5].duplicate(), s[j5]);
                                ++k;
                            }
                        }
                        ++j5;
                    }
                }
            }
            ++i6;
        }
        this.window.getScore().rebuildList();
        this.window.setTime(this.window.getScene().getTime());
        this.window.setUndoRecord(undo);
        return true;
    }

    private void addToVector(Track tr, Vector v) {
        Track[] sub = tr.getSubtracks();
        v.addElement(tr);
        int i = 0;
        while (i < sub.length) {
            this.addToVector(sub[i], v);
            ++i;
        }
    }

    private double roundTime(double t, double fps) {
        return (double)Math.round(t * fps) / fps;
    }
}

