/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Callback;
import artofillusion.Mesh;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.Object3D;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.JointEditorDialog;
import artofillusion.animation.Skeleton;
import artofillusion.ui.EventProcessor;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class JointEditorDialog
extends Dialog
implements ActionListener {
    MeshEditorWindow window;
    MeshViewer theView;
    Mesh theMesh;
    Object3D oldMesh;
    Skeleton skeleton;
    Joint joint;
    TextField nameField;
    DOFPanel ang1Panel;
    DOFPanel ang2Panel;
    DOFPanel twistPanel;
    DOFPanel lengthPanel;
    Button okButton;
    Button cancelButton;
    boolean disableUpdating;

    public JointEditorDialog(MeshEditorWindow win, MeshViewer view, int jointID) {
        super(win, "Edit Bone", true);
        this.window = win;
        this.theView = view;
        this.theMesh = (Mesh)((Object)this.theView.getObject().object);
        this.oldMesh = ((Object3D)((Object)this.theMesh)).duplicate();
        this.skeleton = this.theMesh.getSkeleton();
        this.joint = this.skeleton.getJoint(jointID);
        Panel p = new Panel();
        p.add(new Label("Name"));
        this.nameField = new TextField(this.joint.name, 20);
        p.add(this.nameField);
        this.add((Component)p, "North");
        p = new Panel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        this.ang1Panel = new DOFPanel("X Bend", -180.0, 180.0, this.joint.angle1);
        p.add((Component)this.ang1Panel, gc);
        p.add((Component)this.ang1Panel.getGraph(), gc);
        gc.insets.left = 10;
        this.ang2Panel = new DOFPanel("Y Bend", -180.0, 180.0, this.joint.angle2);
        p.add((Component)this.ang2Panel, gc);
        p.add((Component)this.ang2Panel.getGraph(), gc);
        gc.insets.left = 0;
        gc.gridy = 1;
        gc.insets.top = 10;
        this.twistPanel = new DOFPanel("Twist", -180.0, 180.0, this.joint.twist);
        p.add((Component)this.twistPanel, gc);
        p.add((Component)this.twistPanel.getGraph(), gc);
        gc.insets.left = 10;
        this.lengthPanel = new DOFPanel("Length", 0.0, Double.MAX_VALUE, this.joint.length);
        p.add((Component)this.lengthPanel, gc);
        this.add((Component)p, "Center");
        if (this.joint.parent == null) {
            this.lengthPanel.setEnabled(false);
        }
        p = new Panel();
        this.okButton = new Button("OK");
        p.add(this.okButton);
        this.cancelButton = new Button("Cancel");
        p.add(this.cancelButton);
        this.add((Component)p, "South");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.cancelButton) {
            ((Object3D)((Object)this.theMesh)).copyObject(this.oldMesh);
            this.theView.updateImage();
        } else {
            this.valueChanged();
            this.joint.name = this.nameField.getText();
            this.window.setUndoRecord(new UndoRecord(this.window, false, 0, new Object[]{this.theMesh, this.oldMesh}));
        }
        this.dispose();
    }

    public void valueChanged() {
        boolean ok = this.ang1Panel.isValid() && this.ang2Panel.isValid() && this.twistPanel.isValid() && this.lengthPanel.isValid();
        this.okButton.setEnabled(ok);
        if (!ok) {
            return;
        }
        this.ang1Panel.recordValues();
        this.ang2Panel.recordValues();
        this.twistPanel.recordValues();
        this.lengthPanel.recordValues();
        this.joint.recalcCoords(true);
        if (!this.theView.getSkeletonDetached()) {
            Skeleton.adjustMesh((Mesh)((Object)this.oldMesh), this.theMesh);
        }
        this.theView.updateImage();
    }

    private class DOFGraph
    extends Canvas {
        private DOFPanel panel;
        private int dragging;
        private double lastAngle;
        private EventProcessor process;
        private static final int SIZE = 60;
        private static final int HANDLE_SIZE = 6;
        private static final int OFFSET = 3;

        public DOFGraph(DOFPanel dp) {
            this.panel = dp;
            this.dragging = -1;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ DOFGraph this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent ev) {
                    Point v;
                    DOFGraph.access$202(this.this$1, new EventProcessor());
                    DOFGraph.access$302(this.this$1, 0.0);
                    if (DOFGraph.access$400((DOFGraph)this.this$1).fixedBox.getState()) {
                        return;
                    }
                    Point c = ev.getPoint();
                    if (this.this$1.clicked(c, v = DOFGraph.access$500(this.this$1, DOFGraph.access$400((DOFGraph)this.this$1).valField.getValue()))) {
                        DOFGraph.access$602(this.this$1, 0);
                        DOFGraph.access$700((DOFGraph)this.this$1).disableUpdating = true;
                        return;
                    }
                    if (!DOFGraph.access$400((DOFGraph)this.this$1).rangeBox.getState()) {
                        return;
                    }
                    v = DOFGraph.access$500(this.this$1, DOFGraph.access$400((DOFGraph)this.this$1).maxField.getValue());
                    if (this.this$1.clicked(c, v)) {
                        DOFGraph.access$602(this.this$1, 2);
                    }
                    if (this.this$1.clicked(c, v = DOFGraph.access$500(this.this$1, DOFGraph.access$400((DOFGraph)this.this$1).minField.getValue()))) {
                        DOFGraph.access$602(this.this$1, 1);
                    }
                    if (DOFGraph.access$600(this.this$1) > -1) {
                        DOFGraph.access$700((DOFGraph)this.this$1).disableUpdating = true;
                    }
                    if (!DOFGraph.access$400((DOFGraph)this.this$1).comfortBox.getState()) {
                        return;
                    }
                    v = DOFGraph.access$500(this.this$1, DOFGraph.access$400((DOFGraph)this.this$1).maxComfortField.getValue());
                    if (this.this$1.clicked(c, v)) {
                        DOFGraph.access$602(this.this$1, 4);
                    }
                    if (this.this$1.clicked(c, v = DOFGraph.access$500(this.this$1, DOFGraph.access$400((DOFGraph)this.this$1).minComfortField.getValue()))) {
                        DOFGraph.access$602(this.this$1, 3);
                    }
                    if (DOFGraph.access$600(this.this$1) > -1) {
                        DOFGraph.access$700((DOFGraph)this.this$1).disableUpdating = true;
                    }
                }

                public void mouseReleased(MouseEvent ev) {
                    if (DOFGraph.access$200(this.this$1) != null) {
                        DOFGraph.access$200(this.this$1).stopProcessing();
                    }
                    DOFGraph.access$202(this.this$1, null);
                    DOFGraph.access$602(this.this$1, -1);
                    DOFGraph.access$700((DOFGraph)this.this$1).disableUpdating = false;
                    DOFGraph.access$700(this.this$1).valueChanged();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ DOFGraph this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseDragged(MouseEvent ev) {
                    DOFGraph.access$200(this.this$1).addEvent(new Callback(this, ev){
                        private final /* synthetic */ MouseEvent val$ev;
                        private final /* synthetic */ 8 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$ev = val$ev;
                        }

                        public void execute() {
                            DOFGraph.access$900(8.access$800(this.this$2), this.val$ev);
                        }
                    });
                }

                static /* synthetic */ DOFGraph access$800(8 x0) {
                    return x0.this$1;
                }
            });
        }

        private void dealWithDrag(MouseEvent ev) {
            if (this.dragging == -1) {
                return;
            }
            Point pos = ev.getPoint();
            double angle = Math.atan2(pos.x - 3 - 30, 33 - pos.y) * 180.0 / Math.PI;
            if (this.lastAngle - (angle = Math.rint(angle)) > 270.0) {
                angle += 360.0;
            } else if (angle - this.lastAngle > 270.0) {
                angle -= 360.0;
            }
            double val = this.panel.dof.pos;
            boolean range = this.panel.rangeBox.getState();
            double minv = range ? this.panel.dof.min : this.panel.min;
            double maxv = range ? this.panel.dof.max : this.panel.max;
            double minComfort = this.panel.dof.minComfort;
            double maxComfort = this.panel.dof.maxComfort;
            if (this.dragging != 1 && angle < minv) {
                angle = minv;
            }
            if (this.dragging != 2 && angle > maxv) {
                angle = maxv;
            }
            if (this.dragging == 1 && angle > val || this.dragging == 2 && angle < val) {
                angle = val;
            }
            if (this.dragging == 3 && angle > maxComfort) {
                angle = maxComfort;
            }
            if (this.dragging == 4 && angle < minComfort) {
                angle = minComfort;
            }
            if (this.panel.dof.comfort) {
                if (this.dragging == 1 && angle > minComfort) {
                    angle = minComfort;
                }
                if (this.dragging == 2 && angle < maxComfort) {
                    angle = maxComfort;
                }
            }
            if (this.dragging == 0) {
                this.panel.valField.setValue(angle);
            } else if (this.dragging == 1) {
                this.panel.minField.setValue(angle);
            } else if (this.dragging == 2) {
                this.panel.maxField.setValue(angle);
            } else if (this.dragging == 3) {
                this.panel.minComfortField.setValue(angle);
            } else if (this.dragging == 4) {
                this.panel.maxComfortField.setValue(angle);
            }
            this.lastAngle = angle;
            this.panel.recordValues();
        }

        public void paint(Graphics g) {
            if (this.panel.fixedBox.getState()) {
                g.setColor(Color.lightGray);
                g.fillOval(0, 0, 63, 63);
                g.setColor(Color.black);
                Point p = this.getAnglePosition(this.panel.valField.getValue());
                g.drawLine(33, 33, p.x, p.y);
                return;
            }
            int min = this.panel.rangeBox.getState() ? (int)this.panel.minField.getValue() : (int)this.panel.min;
            int max = this.panel.rangeBox.getState() ? (int)this.panel.maxField.getValue() : (int)this.panel.max;
            g.setColor(Color.black);
            g.fillArc(3, 3, 60, 60, 90 - min, 360 - max + min);
            if (this.panel.rangeBox.getState() && this.panel.comfortBox.getState()) {
                g.setColor(Color.lightGray);
                int minComfort = (int)this.panel.minComfortField.getValue();
                int maxComfort = (int)this.panel.maxComfortField.getValue();
                g.fillArc(3, 3, 60, 60, 90 - minComfort, minComfort - min);
                g.fillArc(3, 3, 60, 60, 90 - max, max - maxComfort);
                min = minComfort;
                max = maxComfort;
            }
            g.setColor(Color.white);
            g.fillArc(3, 3, 60, 60, 90 - max, max - min);
            g.setColor(Color.black);
            g.drawOval(3, 3, 60, 60);
            Point p = this.getAnglePosition(this.panel.valField.getValue());
            g.drawLine(33, 33, p.x, p.y);
            g.fillRect(p.x - 3, p.y - 3, 6, 6);
            if (this.panel.rangeBox.getState()) {
                p = this.getAnglePosition(this.panel.minField.getValue());
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
                p = this.getAnglePosition(this.panel.maxField.getValue());
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
            }
            if (this.panel.rangeBox.getState() && this.panel.comfortBox.getState()) {
                p = this.getAnglePosition(this.panel.minComfortField.getValue());
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
                p = this.getAnglePosition(this.panel.maxComfortField.getValue());
                g.fillRect(p.x - 3, p.y - 3, 6, 6);
            }
        }

        private Point getAnglePosition(double angle) {
            return new Point((int)(30.0 * (1.0 + Math.sin(angle * Math.PI / 180.0))) + 3, (int)(30.0 * (1.0 - Math.cos(angle * Math.PI / 180.0))) + 3);
        }

        public boolean clicked(Point clickPos, Point targetPos) {
            return clickPos.x >= targetPos.x - 3 && clickPos.x <= targetPos.x + 3 && clickPos.y >= targetPos.y - 3 && clickPos.y <= targetPos.y + 3;
        }

        public Dimension getPreferredSize() {
            return new Dimension(66, 66);
        }

        static /* synthetic */ EventProcessor access$202(DOFGraph x0, EventProcessor x1) {
            x0.process = x1;
            return x0.process;
        }

        static /* synthetic */ double access$302(DOFGraph x0, double x1) {
            x0.lastAngle = x1;
            return x0.lastAngle;
        }

        static /* synthetic */ DOFPanel access$400(DOFGraph x0) {
            return x0.panel;
        }

        static /* synthetic */ Point access$500(DOFGraph x0, double x1) {
            return x0.getAnglePosition(x1);
        }

        static /* synthetic */ int access$602(DOFGraph x0, int x1) {
            x0.dragging = x1;
            return x0.dragging;
        }

        static /* synthetic */ JointEditorDialog access$700(DOFGraph x0) {
            return x0.JointEditorDialog.this;
        }

        static /* synthetic */ int access$600(DOFGraph x0) {
            return x0.dragging;
        }

        static /* synthetic */ EventProcessor access$200(DOFGraph x0) {
            return x0.process;
        }

        static /* synthetic */ void access$900(DOFGraph x0, MouseEvent x1) {
            x0.dealWithDrag(x1);
        }
    }

    private class DOFPanel
    extends Panel
    implements ItemListener {
        public ValueField valField;
        public ValueField minField;
        public ValueField maxField;
        public ValueField minComfortField;
        public ValueField maxComfortField;
        public ValueSlider stiffnessSlider;
        public Checkbox fixedBox;
        public Checkbox rangeBox;
        public Checkbox comfortBox;
        public double min;
        public double max;
        public Joint.DOF dof;
        private DOFGraph graph;

        public DOFPanel(String name, double min, double max, Joint.DOF dof) {
            this.min = min;
            this.max = max;
            this.dof = dof;
            this.valField = new ValueField(dof.pos, 0, 5);
            this.minField = new ValueField(dof.min, 0, 5);
            this.maxField = new ValueField(dof.max == Double.MAX_VALUE ? Double.NaN : dof.max, 0, 5);
            this.minComfortField = new ValueField(dof.minComfort, 0, 5);
            this.maxComfortField = new ValueField(dof.maxComfort == Double.MAX_VALUE ? Double.NaN : dof.maxComfort, 0, 5);
            this.valField.setValueChecker(new ValueChecker(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isValid(double val) {
                    double lower = this.this$1.rangeBox.getState() ? this.this$1.minField.getValue() : this.this$1.min;
                    double upper = this.this$1.rangeBox.getState() ? this.this$1.maxField.getValue() : this.this$1.max;
                    return val >= lower && val <= upper;
                }
            });
            this.minField.setValueChecker(new ValueChecker(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isValid(double val) {
                    if (!this.this$1.rangeBox.getState()) {
                        return true;
                    }
                    if (this.this$1.comfortBox.getState() && val > this.this$1.minComfortField.getValue()) {
                        return false;
                    }
                    return val <= this.this$1.valField.getValue() && val >= this.this$1.min;
                }
            });
            this.maxField.setValueChecker(new ValueChecker(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isValid(double val) {
                    if (!this.this$1.rangeBox.getState()) {
                        return true;
                    }
                    if (this.this$1.comfortBox.getState() && val < this.this$1.maxComfortField.getValue()) {
                        return false;
                    }
                    return val >= this.this$1.valField.getValue() && val <= this.this$1.max;
                }
            });
            this.minComfortField.setValueChecker(new ValueChecker(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isValid(double val) {
                    if (!this.this$1.comfortBox.getState() || !this.this$1.rangeBox.getState()) {
                        return true;
                    }
                    double lower = this.this$1.minField.getValue();
                    double upper = Math.min(this.this$1.maxField.getValue(), this.this$1.maxComfortField.getValue());
                    return val >= lower && val <= upper;
                }
            });
            this.maxComfortField.setValueChecker(new ValueChecker(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isValid(double val) {
                    if (!this.this$1.comfortBox.getState() || !this.this$1.rangeBox.getState()) {
                        return true;
                    }
                    double lower = Math.max(this.this$1.minField.getValue(), this.this$1.minComfortField.getValue());
                    double upper = this.this$1.maxField.getValue();
                    return val >= lower && val <= upper;
                }
            });
            TextListener tl = new TextListener(this){
                private final /* synthetic */ DOFPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void textValueChanged(TextEvent e) {
                    this.this$1.valField.checkIfValid();
                    this.this$1.minField.checkIfValid();
                    this.this$1.maxField.checkIfValid();
                    this.this$1.minComfortField.checkIfValid();
                    this.this$1.maxComfortField.checkIfValid();
                    DOFPanel.access$000(this.this$1).valueChanged();
                    if (DOFPanel.access$100(this.this$1) != null) {
                        DOFPanel.access$100(this.this$1).repaint();
                    }
                }
            };
            this.valField.addTextListener(tl);
            this.minField.addTextListener(tl);
            this.maxField.addTextListener(tl);
            this.minComfortField.addTextListener(tl);
            this.maxComfortField.addTextListener(tl);
            this.valField.sendValidEventsOnly(false);
            this.minField.sendValidEventsOnly(false);
            this.maxField.sendValidEventsOnly(false);
            this.minComfortField.sendValidEventsOnly(false);
            this.maxComfortField.sendValidEventsOnly(false);
            this.stiffnessSlider = new ValueSlider(0.0, 1.0, 100, dof.stiffness);
            this.fixedBox = new Checkbox("Lock", dof.fixed);
            this.rangeBox = new Checkbox("Restrict Total Range", dof.min > min || dof.max < max || dof.comfort);
            this.comfortBox = new Checkbox("Restrict Comfort Range", dof.comfort);
            this.fixedBox.addItemListener(this);
            this.rangeBox.addItemListener(this);
            this.comfortBox.addItemListener(this);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            this.add((Component)new Label(name), gc);
            gc.gridx = 1;
            this.add((Component)this.valField, gc);
            gc.gridx = 2;
            this.add((Component)this.fixedBox, gc);
            gc.gridx = 0;
            gc.gridwidth = 3;
            this.add((Component)this.rangeBox, gc);
            gc.gridwidth = 1;
            this.add((Component)this.minField, gc);
            gc.gridx = 1;
            this.add((Component)new Label(" to "), gc);
            gc.gridx = 2;
            this.add((Component)this.maxField, gc);
            gc.gridx = 0;
            gc.gridwidth = 3;
            this.add((Component)this.comfortBox, gc);
            gc.gridwidth = 1;
            this.add((Component)this.minComfortField, gc);
            gc.gridx = 1;
            this.add((Component)new Label(" to "), gc);
            gc.gridx = 2;
            this.add((Component)this.maxComfortField, gc);
            gc.gridx = 0;
            gc.gridwidth = 3;
            this.add((Component)new Label("Stiffness"), gc);
            this.add((Component)this.stiffnessSlider, gc);
            this.updateComponents();
        }

        public void updateComponents() {
            boolean fixed = this.fixedBox.getState();
            boolean range = !fixed && this.rangeBox.getState();
            boolean comfort = range && this.comfortBox.getState();
            this.valField.setEnabled(!fixed);
            this.minField.setEnabled(range);
            this.maxField.setEnabled(range);
            this.minComfortField.setEnabled(comfort);
            this.maxComfortField.setEnabled(comfort);
            this.valField.setEditable(!fixed);
            this.minField.setEditable(range);
            this.maxField.setEditable(range);
            this.minComfortField.setEditable(comfort);
            this.maxComfortField.setEditable(comfort);
            this.stiffnessSlider.setEnabled(!fixed);
            this.rangeBox.setEnabled(!fixed);
            this.comfortBox.setEnabled(range);
        }

        public void itemStateChanged(ItemEvent ev) {
            if (ev.getSource() == this.comfortBox && this.comfortBox.getState()) {
                if (this.minComfortField.getValue() < this.minField.getValue()) {
                    this.minComfortField.setValue(this.minField.getValue());
                }
                if (this.maxComfortField.getValue() > this.maxField.getValue()) {
                    this.maxComfortField.setValue(this.maxField.getValue());
                }
            }
            this.updateComponents();
            this.valField.checkIfValid();
            this.minField.checkIfValid();
            this.maxField.checkIfValid();
            this.minComfortField.checkIfValid();
            this.maxComfortField.checkIfValid();
            if (this.graph != null) {
                this.graph.repaint();
            }
            JointEditorDialog.this.valueChanged();
        }

        public boolean isValid() {
            if (this.fixedBox.getState()) {
                return true;
            }
            return this.valField.isValid(this.valField.getValue()) && this.minField.isValid(this.minField.getValue()) && this.maxField.isValid(this.maxField.getValue()) && this.minComfortField.isValid(this.minComfortField.getValue()) && this.maxComfortField.isValid(this.maxComfortField.getValue());
        }

        public void recordValues() {
            this.dof.fixed = this.fixedBox.getState();
            boolean range = !this.dof.fixed && this.rangeBox.getState();
            this.dof.pos = this.valField.getValue();
            if (range) {
                this.dof.min = this.minField.getValue();
                this.dof.max = this.maxField.getValue();
                if (Double.isNaN(this.dof.max)) {
                    this.dof.max = Double.MAX_VALUE;
                }
            } else {
                this.dof.min = this.min;
                this.dof.max = this.max;
            }
            this.dof.minComfort = this.minComfortField.getValue();
            this.dof.maxComfort = this.maxComfortField.getValue();
            if (Double.isNaN(this.dof.maxComfort)) {
                this.dof.maxComfort = Double.MAX_VALUE;
            }
            this.dof.stiffness = this.stiffnessSlider.getValue();
            this.dof.comfort = range && this.comfortBox.getState();
            this.dof.loop = this.max - this.min == 360.0 && (!range || this.dof.max - this.dof.min == 360.0);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Component[] c = this.getComponents();
            int i = 0;
            while (i < c.length) {
                c[i].setEnabled(enabled);
                ++i;
            }
        }

        public DOFGraph getGraph() {
            if (this.graph == null) {
                this.graph = new DOFGraph(this);
            }
            return this.graph;
        }

        static /* synthetic */ JointEditorDialog access$000(DOFPanel x0) {
            return x0.JointEditorDialog.this;
        }

        static /* synthetic */ DOFGraph access$100(DOFPanel x0) {
            return x0.graph;
        }
    }
}

