/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.CoordinateSystem;
import artofillusion.Mat4;
import artofillusion.Vec3;
import artofillusion.animation.Keyframe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RotationKeyframe
implements Keyframe {
    public double x;
    public double y;
    public double z;
    private double[] q;
    private boolean useQuaternion;
    private static final double SCALE = Math.PI / 180;

    public RotationKeyframe(double xrot, double yrot, double zrot) {
        this.set(xrot, yrot, zrot);
    }

    public RotationKeyframe(CoordinateSystem coords) {
        double[] angle = coords.getRotationAngles();
        this.set(angle[0], angle[1], angle[2]);
    }

    public void set(double xrot, double yrot, double zrot) {
        this.x = xrot;
        this.y = yrot;
        this.z = zrot;
        this.q = null;
    }

    public double[] getGraphValues() {
        return new double[]{this.x, this.y, this.z};
    }

    public void setGraphValues(double[] values) {
        if (values.length == 3) {
            this.set(values[0], values[1], values[2]);
        }
    }

    public boolean getUseQuaternion() {
        return this.useQuaternion;
    }

    public void setUseQuaternion(boolean use) {
        this.useQuaternion = use;
        this.q = null;
    }

    public double[] getQuaternion() {
        this.makeQuaternion();
        return new double[]{this.q[0], this.q[1], this.q[2], this.q[3]};
    }

    public void applyToCoordinates(CoordinateSystem coords, double weight, Mat4 preTransform, Mat4 postTransform, boolean relative, boolean enablex, boolean enabley, boolean enablez) {
        Mat4 trans;
        double[] v = coords.getRotationAngles();
        if (preTransform != null) {
            coords.transformAxes(preTransform);
        }
        if (!relative) {
            double w = 1.0 - weight;
            if (enablex || this.useQuaternion) {
                v[0] = v[0] * w;
            }
            if (enabley || this.useQuaternion) {
                v[1] = v[1] * w;
            }
            if (enablez || this.useQuaternion) {
                v[2] = v[2] * w;
            }
            coords.setOrientation(v[0], v[1], v[2]);
        }
        if (this.useQuaternion) {
            this.makeQuaternion();
            double angle = 2.0 * Math.acos(this.q[3]);
            Vec3 axis = new Vec3(this.q[0], this.q[1], this.q[2]);
            if (axis.length2() > 1.0E-10) {
                axis.scale(1.0 / Math.sin(0.5 * angle));
                trans = Mat4.axisRotation(axis, -weight * angle);
            } else {
                if (preTransform == null && postTransform == null) {
                    return;
                }
                trans = Mat4.identity();
            }
        } else {
            double xt = enablex ? this.x : 0.0;
            double yt = enabley ? this.y : 0.0;
            double zt = enablez ? this.z : 0.0;
            trans = Mat4.yrotation(-yt * weight * (Math.PI / 180)).times(Mat4.xrotation(-xt * weight * (Math.PI / 180))).times(Mat4.zrotation(-zt * weight * (Math.PI / 180)));
        }
        coords.transformAxes(trans);
        if (postTransform != null) {
            coords.transformAxes(postTransform);
        }
    }

    private void makeQuaternion() {
        if (this.q != null) {
            return;
        }
        double[] qx = new double[]{Math.sin(Math.PI / 360 * this.x), 0.0, 0.0, Math.cos(Math.PI / 360 * this.x)};
        double[] qy = new double[]{0.0, Math.sin(Math.PI / 360 * this.y), 0.0, Math.cos(Math.PI / 360 * this.y)};
        double[] qz = new double[]{0.0, 0.0, Math.sin(Math.PI / 360 * this.z), Math.cos(Math.PI / 360 * this.z)};
        this.q = this.multiply(qz, this.multiply(qx, qy));
    }

    private double[] multiply(double[] q1, double[] q2) {
        double[] result = new double[]{q1[3] * q2[0] + q1[0] * q2[3] + q1[1] * q2[2] - q1[2] * q2[1], q1[3] * q2[1] + q1[1] * q2[3] + q1[2] * q2[0] - q1[0] * q2[2], q1[3] * q2[2] + q1[2] * q2[3] + q1[0] * q2[1] - q1[1] * q2[0], q1[3] * q2[3] - q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2]};
        return result;
    }

    public Keyframe duplicate() {
        RotationKeyframe f = new RotationKeyframe(this.x, this.y, this.z);
        f.setUseQuaternion(this.useQuaternion);
        return f;
    }

    public Keyframe duplicate(Object owner) {
        RotationKeyframe f = new RotationKeyframe(this.x, this.y, this.z);
        f.setUseQuaternion(this.useQuaternion);
        return f;
    }

    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        RotationKeyframe v2 = (RotationKeyframe)o2;
        RotationKeyframe r = new RotationKeyframe(weight1 * this.x + weight2 * v2.x, weight1 * this.y + weight2 * v2.y, weight1 * this.z + weight2 * v2.z);
        if (!this.useQuaternion) {
            return r;
        }
        this.makeQuaternion();
        v2.makeQuaternion();
        r.q = RotationKeyframe.slerp(this.q, v2.q, weight2);
        r.useQuaternion = true;
        return r;
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        RotationKeyframe v2 = (RotationKeyframe)o2;
        RotationKeyframe v3 = (RotationKeyframe)o3;
        RotationKeyframe r = new RotationKeyframe(weight1 * this.x + weight2 * v2.x + weight3 * v3.x, weight1 * this.y + weight2 * v2.y + weight3 * v3.y, weight1 * this.z + weight2 * v2.z + weight3 * v3.z);
        if (!this.useQuaternion) {
            return r;
        }
        this.makeQuaternion();
        v2.makeQuaternion();
        v3.makeQuaternion();
        if (weight2 == 1.0) {
            r.q = new double[]{v2.q[0], v2.q[1], v2.q[2], v2.q[3]};
        } else {
            double[] p1 = RotationKeyframe.slerp(this.q, v2.q, weight2);
            double[] p2 = RotationKeyframe.slerp(v3.q, v2.q, weight2);
            r.q = RotationKeyframe.slerp(p1, p2, weight3 / (1.0 - weight2));
        }
        r.useQuaternion = true;
        return r;
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        RotationKeyframe v2 = (RotationKeyframe)o2;
        RotationKeyframe v3 = (RotationKeyframe)o3;
        RotationKeyframe v4 = (RotationKeyframe)o4;
        RotationKeyframe r = new RotationKeyframe(weight1 * this.x + weight2 * v2.x + weight3 * v3.x + weight4 * v4.x, weight1 * this.y + weight2 * v2.y + weight3 * v3.y + weight4 * v4.y, weight1 * this.z + weight2 * v2.z + weight3 * v3.z + weight4 * v4.z);
        if (!this.useQuaternion) {
            return r;
        }
        this.makeQuaternion();
        v2.makeQuaternion();
        v3.makeQuaternion();
        v4.makeQuaternion();
        double[] p1 = RotationKeyframe.slerp(this.q, v2.q, weight2 / (weight1 + weight2));
        double[] p2 = RotationKeyframe.slerp(v3.q, v4.q, weight4 / (weight3 + weight4));
        r.q = RotationKeyframe.slerp(p1, p2, weight3 + weight4);
        r.useQuaternion = true;
        return r;
    }

    private static final double[] slerp(double[] q1, double[] q2, double t) {
        double sign;
        double dot = q1[0] * q2[0] + q1[1] * q2[1] + q1[2] * q2[2] + q1[3] * q2[3];
        if (dot < 0.0) {
            dot = -dot;
            sign = -1.0;
        } else {
            sign = 1.0;
        }
        if (dot >= 0.99999) {
            return new double[]{q1[0], q1[1], q1[2], q1[3]};
        }
        double angle = Math.acos(dot);
        double denom = Math.sin(angle);
        double weight1 = Math.sin((1.0 - t) * angle) / denom;
        double weight2 = sign * Math.sin(t * angle) / denom;
        return new double[]{weight1 * q1[0] + weight2 * q2[0], weight1 * q1[1] + weight2 * q2[1], weight1 * q1[2] + weight2 * q2[2], weight1 * q1[3] + weight2 * q2[3]};
    }

    public boolean equals(Keyframe k) {
        if (!(k instanceof RotationKeyframe)) {
            return false;
        }
        RotationKeyframe key = (RotationKeyframe)k;
        if (this.useQuaternion) {
            double[] q2;
            double[] q1 = this.getQuaternion();
            double dot = q1[0] * (q2 = key.getQuaternion())[0] + q1[1] * q2[1] + q1[2] * q2[2] + q1[3] * q2[3];
            return 1.0 - dot < 1.0E-10;
        }
        return key.x == this.x && key.y == this.y && key.z == this.z;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    public RotationKeyframe(DataInputStream in, Object parent) throws IOException {
        this(in.readDouble(), in.readDouble(), in.readDouble());
    }
}

