/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.GenericTool;
import artofillusion.LayoutWindow;
import artofillusion.Object3D;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.ToolPalette;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Marker;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.SelectionInfo;
import artofillusion.animation.TimeAxis;
import artofillusion.animation.Track;
import artofillusion.animation.TrackDisplay;
import artofillusion.animation.TrackGraph;
import artofillusion.animation.TrackTreeElement;
import artofillusion.animation.TracksPanel;
import artofillusion.ui.DividedPanel;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.Spacer;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeEvent;
import artofillusion.ui.TreeList;
import artofillusion.ui.TreeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Score
extends Panel
implements AdjustmentListener,
EditingWindow,
ItemListener,
TreeListener,
PopupMenuManager {
    LayoutWindow window;
    TreeList theList;
    TimeAxis theAxis;
    Vector graphs;
    Scrollbar scroll;
    ToolPalette viewTools;
    ToolPalette modeTools;
    Label helpText;
    Panel p1;
    Panel p2;
    PopupMenu popupMenu;
    MenuItem[] popupMenuItem;
    Marker timeMarker;
    SelectionInfo[] selection;
    int scrollPos;
    int mode;
    int view;
    ItemListener itemListeners;
    double startTime;
    double timeScale;
    int yoffset;
    public static final int TRACKS_MODE = 0;
    public static final int SINGLE_GRAPH_MODE = 1;
    public static final int MULTI_GRAPH_MODE = 2;
    public static final int SELECT_AND_MOVE = 0;
    public static final int SCROLL_AND_SCALE = 1;
    private static final String[] MODE_HELP_TEXT = new String[]{"Click and drag to select and move keyframes.  Shift-click adds to selection.", "Drag to scroll display.  Shift-drag to rescale axis."};
    static /* synthetic */ Class class$artofillusion$ObjectInfo;
    static /* synthetic */ Class class$artofillusion$animation$PoseTrack;

    public Score(LayoutWindow win) {
        this.window = win;
        this.setLayout(new BorderLayout());
        this.theList = new TreeList(win);
        this.theList.setPreferredSize(130, 0);
        this.theList.addItemListener(this);
        this.theList.addTreeListener(this);
        this.theList.setPopupMenuManager(this);
        this.selection = new SelectionInfo[0];
        int fps = this.window.getScene().getFramesPerSecond();
        this.timeScale = (double)fps * 5.0;
        this.theAxis = new TimeAxis(fps, this.timeScale, this);
        this.graphs = new Vector();
        this.timeMarker = new Marker(this.window.getScene().getTime(), "Time", Color.green);
        this.theAxis.addMarker(this.timeMarker);
        this.scroll = new Scrollbar(1, 0, 0, 0, 0);
        this.scroll.addAdjustmentListener(this);
        this.viewTools = new ToolPalette(1, 3);
        this.modeTools = new ToolPalette(1, 2);
        this.viewTools.addTool(new GenericTool(this, "trackMode.gif", "selected/trackMode.gif"));
        this.viewTools.addTool(new GenericTool(this, "singleMode.gif", "selected/singleMode.gif"));
        this.viewTools.addTool(new GenericTool(this, "multiMode.gif", "selected/multiMode.gif"));
        this.modeTools.addTool(new GenericTool(this, "moveKey.gif", "selected/moveKey.gif"));
        this.modeTools.addTool(new GenericTool(this, "panTrack.gif", "selected/panTrack.gif"));
        this.p1 = new Panel();
        this.p2 = new Panel();
        this.p1.setLayout(new BorderLayout());
        this.p1.add((Component)new Spacer(this.theList, this.theAxis), "North");
        this.p1.add((Component)this.theList, "Center");
        this.p2.setLayout(new GridBagLayout());
        this.layoutGraphs();
        DividedPanel div = new DividedPanel(this.p1, this.p2, 0.0f, 1.0f, false);
        div.setLiveValidate(true, true);
        this.add((Component)div, "Center");
        Panel p = new Panel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridheight = 3;
        gc.fill = 3;
        p.add((Component)this.scroll, gc);
        gc.gridx = 1;
        gc.gridheight = 1;
        gc.anchor = 11;
        gc.fill = 0;
        p.add((Component)this.viewTools, gc);
        gc.insets.top = 5;
        p.add((Component)this.modeTools, gc);
        gc.weighty = 1.0;
        p.add((Component)new Panel(), gc);
        this.add((Component)p, "East");
        this.helpText = new Label(MODE_HELP_TEXT[this.mode]);
        this.add((Component)this.helpText, "South");
        this.rebuildList();
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.popupMenu = new PopupMenu();
        this.popupMenuItem = new MenuItem[5];
        this.popupMenuItem[0] = new MenuItem("Edit Track...");
        this.popupMenu.add(this.popupMenuItem[0]);
        this.popupMenuItem[0].setActionCommand("editTrack");
        this.popupMenuItem[0].addActionListener(this.window);
        this.popupMenuItem[1] = new MenuItem("Duplicate Selected Tracks");
        this.popupMenu.add(this.popupMenuItem[1]);
        this.popupMenuItem[1].setActionCommand("duplicateTracks");
        this.popupMenuItem[1].addActionListener(this.window);
        this.popupMenuItem[2] = new MenuItem("Delete Selected Tracks");
        this.popupMenu.add(this.popupMenuItem[2]);
        this.popupMenuItem[2].setActionCommand("deleteTracks");
        this.popupMenuItem[2].addActionListener(this.window);
        this.popupMenuItem[3] = new MenuItem("Enable Selected Tracks");
        this.popupMenu.add(this.popupMenuItem[3]);
        this.popupMenuItem[3].setActionCommand("enableTracks");
        this.popupMenuItem[3].addActionListener(this.window);
        this.popupMenuItem[4] = new MenuItem("Disable Selected Tracks");
        this.popupMenu.add(this.popupMenuItem[4]);
        this.popupMenuItem[4].setActionCommand("disableTracks");
        this.popupMenuItem[4].addActionListener(this.window);
        this.add(this.popupMenu);
    }

    public void showPopupMenu(Component c, int x, int y) {
        Track[] selTrack = this.getSelectedTracks();
        boolean enable = false;
        boolean disable = false;
        int i = 0;
        while (i < selTrack.length) {
            if (selTrack[i].isEnabled()) {
                disable = true;
            } else {
                enable = true;
            }
            ++i;
        }
        this.popupMenuItem[0].setEnabled(selTrack.length == 1);
        this.popupMenuItem[1].setEnabled(selTrack.length > 0);
        this.popupMenuItem[2].setEnabled(selTrack.length > 0);
        this.popupMenuItem[3].setEnabled(enable);
        this.popupMenuItem[4].setEnabled(disable);
        this.popupMenu.show(c, x, y);
    }

    public PopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public Track[] getSelectedTracks() {
        Object[] obj = this.theList.getSelectedObjects();
        Track[] tr = new Track[obj.length];
        int i = 0;
        while (i < tr.length) {
            tr[i] = (Track)obj[i];
            ++i;
        }
        return tr;
    }

    public SelectionInfo[] getSelectedKeyframes() {
        return this.selection;
    }

    public void setSelectedKeyframes(SelectionInfo[] sel) {
        this.selection = sel;
        int i = 0;
        while (i < this.graphs.size()) {
            ((Component)this.graphs.elementAt(i)).repaint();
            ++i;
        }
        this.window.updateMenus();
    }

    public void addSelectedKeyframes(SelectionInfo[] newsel) {
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        int i = 0;
        while (i < this.selection.length) {
            v.addElement(this.selection[i]);
            ++i;
        }
        i = 0;
        while (i < newsel.length) {
            int j = 0;
            while (j < this.selection.length) {
                if (newsel[i].key == this.selection[j].key) {
                    int k = 0;
                    while (k < newsel[i].selected.length) {
                        int n = k;
                        this.selection[j].selected[n] = this.selection[j].selected[n] | newsel[i].selected[k];
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            if (j == this.selection.length) {
                v.addElement(newsel[i]);
            }
            ++i;
        }
        this.selection = new SelectionInfo[v.size()];
        i = 0;
        while (i < this.selection.length) {
            this.selection[i] = (SelectionInfo)v.elementAt(i);
            ++i;
        }
        this.window.updateMenus();
    }

    public void removeSelectedKeyframe(Keyframe key) {
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].key != key) {
                v.addElement(this.selection[i]);
            }
            ++i;
        }
        this.selection = new SelectionInfo[v.size()];
        int i2 = 0;
        while (i2 < this.selection.length) {
            this.selection[i2] = (SelectionInfo)v.elementAt(i2);
            ++i2;
        }
        this.window.updateMenus();
    }

    public boolean isKeyframeSelected(Keyframe k) {
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].key == k) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isKeyframeSelected(Keyframe k, int value) {
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].key == k) {
                return this.selection[i].selected.length > value && this.selection[i].selected[value];
            }
            ++i;
        }
        return false;
    }

    public void rebuildList() {
        TreeElement el;
        Vector objects = this.window.getScene().getObjects();
        TreeElement[] allEl = this.theList.getElements();
        this.theList.setUpdateEnabled(false);
        this.theList.removeAllElements();
        int i = 0;
        while (i < objects.size()) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(i);
            if (info.selected) {
                ObjectTreeElement el2 = new ObjectTreeElement(info, null, this.theList, false);
                this.theList.addElement(el2);
                el2.setExpanded(true);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < objects.size()) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(i2);
            if (info.selected && info.tracks.length != 0) {
                el = (ObjectTreeElement)this.theList.findElement(info);
                ((ObjectTreeElement)el).addTracks();
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < allEl.length) {
            el = this.theList.findElement(allEl[i3].getObject());
            if (el != null) {
                el.setExpanded(allEl[i3].isExpanded());
                el.setSelected(allEl[i3].isSelected());
            }
            ++i3;
        }
        allEl = this.theList.getElements();
        int i4 = 0;
        while (i4 < allEl.length) {
            allEl[i4].setSelectable(allEl[i4] instanceof TrackTreeElement);
            ++i4;
        }
        this.theList.setUpdateEnabled(true);
        this.selectedTracksChanged();
        this.updateScrollbar();
        this.repaintGraphs();
        this.setScrollPosition(this.scrollPos);
    }

    private void layoutGraphs() {
        Track[] tr = this.getSelectedTracks();
        this.p2.removeAll();
        this.graphs.removeAllElements();
        if (this.view == 0) {
            TracksPanel theTracks = new TracksPanel(this.window, this.theList, this, this.window.getScene().getFramesPerSecond(), this.timeScale);
            theTracks.setStartTime(this.startTime);
            theTracks.addMarker(this.timeMarker);
            theTracks.setMode(this.mode);
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.gridy = 0;
            gc.gridx = 0;
            gc.insets.bottom = 2;
            this.p2.add((Component)this.theAxis, gc);
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            gc.gridy = 1;
            gc.insets.bottom = 0;
            this.p2.add((Component)theTracks, gc);
            this.graphs.addElement(theTracks);
        } else if (this.view == 1 || tr.length == 0) {
            TrackGraph gr = new TrackGraph(this.window, this, this.theAxis);
            gr.setSubdivisions(this.window.getScene().getFramesPerSecond());
            gr.setStartTime(this.startTime);
            gr.setScale(this.timeScale);
            gr.addMarker(this.timeMarker);
            gr.setMode(this.mode);
            gr.setTracks(tr);
            gr.setBackground(Color.white);
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.gridx = 1;
            gc.gridy = 0;
            gc.insets.bottom = 2;
            this.p2.add((Component)this.theAxis, gc);
            gc.weighty = 1.0;
            gc.gridx = 0;
            gc.gridy = 1;
            gc.insets.bottom = 0;
            this.p2.add((Component)gr.getAxis(), gc);
            gc.weightx = 1.0;
            gc.gridx = 1;
            this.p2.add((Component)gr, gc);
            this.graphs.addElement(gr);
        } else if (this.view == 2) {
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 1;
            gc.gridx = 1;
            gc.gridy = 0;
            gc.insets.bottom = 2;
            this.p2.add((Component)this.theAxis, gc);
            gc.weighty = 1.0;
            gc.insets.bottom = 0;
            int i = 0;
            while (i < tr.length) {
                TrackGraph gr = new TrackGraph(this.window, this, this.theAxis);
                gr.setSubdivisions(this.window.getScene().getFramesPerSecond());
                gr.setStartTime(this.startTime);
                gr.setScale(this.timeScale);
                gr.addMarker(this.timeMarker);
                gr.setMode(this.mode);
                gr.setTracks(new Track[]{tr[i]});
                gr.setBackground(Color.white);
                gc.gridx = 0;
                gc.gridy = i + 1;
                gc.weightx = 0.0;
                this.p2.add((Component)gr.getAxis(), gc);
                gc.gridx = 1;
                gc.weightx = 1.0;
                this.p2.add((Component)gr, gc);
                this.graphs.addElement(gr);
                gc.insets.top = 4;
                ++i;
            }
        }
        this.p2.validate();
        this.repaintAll();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double time) {
        this.theAxis.setStartTime(time);
        int i = 0;
        while (i < this.graphs.size()) {
            ((TrackDisplay)this.graphs.elementAt(i)).setStartTime(time);
            ++i;
        }
        this.startTime = time;
        this.repaintGraphs();
    }

    public double getScale() {
        return this.timeScale;
    }

    public void setScale(double s) {
        this.theAxis.setScale(s);
        int i = 0;
        while (i < this.graphs.size()) {
            ((TrackDisplay)this.graphs.elementAt(i)).setScale(s);
            ++i;
        }
        this.timeScale = s;
        this.repaintGraphs();
    }

    public void setTime(double time) {
        this.timeMarker.position = time;
        this.repaintGraphs();
    }

    public void itemStateChanged(ItemEvent ev) {
        this.selectedTracksChanged();
        this.window.updateMenus();
    }

    private void selectedTracksChanged() {
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        Track[] sel = this.getSelectedTracks();
        int i = 0;
        while (i < this.selection.length) {
            int j = 0;
            while (j < sel.length) {
                if (this.selection[i].track == sel[j]) {
                    v.addElement(this.selection[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.selection = new SelectionInfo[v.size()];
        int i2 = 0;
        while (i2 < this.selection.length) {
            this.selection[i2] = (SelectionInfo)v.elementAt(i2);
            ++i2;
        }
        if (this.view == 1) {
            ((TrackGraph)this.graphs.elementAt(0)).setTracks(sel);
            this.repaintAll();
        }
        if (this.view == 2) {
            this.layoutGraphs();
        }
    }

    public void tracksModified(boolean updateScene) {
        int i = 0;
        while (i < this.graphs.size()) {
            if (this.graphs.elementAt(i) instanceof TrackGraph) {
                ((TrackGraph)this.graphs.elementAt(i)).tracksModified();
            } else {
                ((Component)this.graphs.elementAt(i)).repaint();
            }
            ++i;
        }
        if (!updateScene) {
            return;
        }
        Vector<Track> v = new Vector<Track>();
        int i2 = 0;
        while (i2 < this.selection.length) {
            if (!v.contains(this.selection[i2].track)) {
                v.addElement(this.selection[i2].track);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < v.size()) {
            Track tr = (Track)v.elementAt(i3);
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo) {
                this.window.getScene().applyTracksToObject((ObjectInfo)parent);
            }
            ++i3;
        }
        this.window.updateImage();
    }

    public void repaintGraphs() {
        int i = 0;
        while (i < this.graphs.size()) {
            Component gr = (Component)this.graphs.elementAt(i);
            gr.repaint();
            if (gr instanceof TrackGraph) {
                ((TrackGraph)gr).getAxis().repaint();
            }
            ++i;
        }
        this.theAxis.repaint();
    }

    public void repaintAll() {
        this.repaintGraphs();
        this.theList.repaint();
    }

    public void elementsMoved(TreeEvent ev) {
        this.repaintGraphs();
    }

    public void elementOpenedOrClosed(TreeEvent ev) {
        this.repaintGraphs();
        this.updateScrollbar();
    }

    public void elementDoubleClicked(TreeEvent ev) {
        TreeElement el = ev.getElement();
        if (el != null && el.getObject() instanceof Track) {
            Track tr = (Track)el.getObject();
            tr.edit(this.window);
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo) {
                this.window.getScene().applyTracksToObject((ObjectInfo)parent);
            }
            this.window.updateImage();
            this.selectedTracksChanged();
            this.repaintAll();
        }
    }

    public void setScrollPosition(int pos) {
        Dimension size = this.theList.getSize();
        Dimension prefSize = this.theList.getPreferredSize();
        if (pos > prefSize.height - size.height) {
            pos = prefSize.height - size.height;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos == this.scrollPos) {
            return;
        }
        this.theList.setYOffset(-pos);
        int i = 0;
        while (i < this.graphs.size()) {
            ((TrackDisplay)this.graphs.elementAt(i)).setYOffset(-pos);
            ++i;
        }
        this.yoffset = -pos;
        this.theList.repaint();
        this.repaintGraphs();
        this.scrollPos = pos;
        this.updateScrollbar();
    }

    public void adjustmentValueChanged(AdjustmentEvent ev) {
        this.setScrollPosition(ev.getValue());
    }

    private void updateScrollbar() {
        int height = this.theList.getPreferredSize().height;
        int showing = this.theList.getSize().height;
        this.scroll.setMaximum(height);
        this.scroll.setVisibleAmount(showing);
        this.scroll.setValue(this.scrollPos);
        this.scroll.setUnitIncrement(Math.max(this.theList.getRowHeight(), 1));
        this.scroll.setBlockIncrement(Math.max(showing - this.theList.getRowHeight(), 1));
    }

    public void markerMoved(Marker m, boolean intermediate) {
        if (m == this.timeMarker && m.position != this.window.getScene().getTime()) {
            this.window.setTime(m.position);
        } else {
            this.repaintGraphs();
        }
    }

    public void doLayout() {
        this.theAxis.setSize(this.theAxis.getSize().width, this.theAxis.getPreferredSize().height);
        super.doLayout();
        this.updateScrollbar();
    }

    public void editSelectedTrack() {
        Object[] sel = this.theList.getSelectedObjects();
        if (sel.length == 1 && sel[0] instanceof Track) {
            Track tr = (Track)sel[0];
            tr.edit(this.window);
            this.finishEditingTrack(tr);
        }
    }

    public void finishEditingTrack(Track tr) {
        Object parent = tr.getParent();
        while (parent != null && parent instanceof Track) {
            parent = ((Track)parent).getParent();
        }
        if (parent instanceof ObjectInfo) {
            this.window.getScene().applyTracksToObject((ObjectInfo)parent);
        }
        this.window.updateImage();
        this.selectedTracksChanged();
        this.repaintAll();
    }

    public void setTracksEnabled(boolean enable) {
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < sel.length) {
            if (sel[i] instanceof Track) {
                Track tr = (Track)sel[i];
                Object parent = tr.getParent();
                while (parent instanceof Track) {
                    parent = ((Track)parent).getParent();
                }
                if (parent instanceof ObjectInfo && v.indexOf(parent) == -1) {
                    v.addElement(parent);
                    undo.addCommand(2, new Object[]{parent, ((ObjectInfo)parent).duplicate()});
                }
                tr.setEnabled(enable);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < v.size()) {
            this.window.getScene().applyTracksToObject((ObjectInfo)v.elementAt(i2));
            ++i2;
        }
        this.theList.repaint();
        this.window.updateImage();
        this.window.updateMenus();
    }

    public void keyframeSelectedTracks() {
        Scene theScene = this.window.getScene();
        Object[] sel = this.theList.getSelectedObjects();
        double time = theScene.getTime();
        UndoRecord undo = new UndoRecord(this.window, false);
        int i = 0;
        while (i < sel.length) {
            if (sel[i] instanceof Track) {
                Track tr = (Track)sel[i];
                if (tr.getParent() instanceof ObjectInfo) {
                    ObjectInfo info = (ObjectInfo)tr.getParent();
                    int j = 0;
                    while (j < info.tracks.length) {
                        if (info.tracks[j] == tr) {
                            undo.addCommand(10, new Object[]{info, new Integer(j), tr.duplicate(info)});
                        }
                        ++j;
                    }
                }
                tr.setKeyframe(time, theScene);
            }
            ++i;
        }
        this.window.setUndoRecord(undo);
        this.selectedTracksChanged();
        this.repaintGraphs();
    }

    public void keyframeModifiedTracks() {
        Scene theScene = this.window.getScene();
        int[] sel = theScene.getSelection();
        Vector objects = theScene.getObjects();
        double time = theScene.getTime();
        UndoRecord undo = new UndoRecord(this.window, false);
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(sel[i]);
            boolean posx = false;
            boolean posy = false;
            boolean posz = false;
            boolean rotx = false;
            boolean roty = false;
            boolean rotz = false;
            int j = 0;
            while (j < info.tracks.length) {
                Track tr = info.tracks[j];
                if (!(!tr.isEnabled() || tr instanceof PositionTrack && posx && posy && posz || tr instanceof RotationTrack && rotx && roty && rotz)) {
                    undo.addCommand(10, new Object[]{info, new Integer(j), tr.duplicate(info)});
                    boolean modified = tr.setKeyframeIfModified(time, theScene);
                    if (modified) {
                        if (tr instanceof PositionTrack) {
                            PositionTrack pt = (PositionTrack)tr;
                            posx |= pt.affectsX();
                            posy |= pt.affectsY();
                            posz |= pt.affectsZ();
                        }
                        if (tr instanceof RotationTrack) {
                            RotationTrack rt = (RotationTrack)tr;
                            rotx |= rt.affectsX();
                            roty |= rt.affectsY();
                            rotz |= rt.affectsZ();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.window.setUndoRecord(undo);
        this.selectedTracksChanged();
        this.repaintGraphs();
    }

    public void duplicateSelectedTracks() {
        Scene theScene = this.window.getScene();
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<ObjectInfo> modifiedObj = new Vector<ObjectInfo>();
        Vector<Track> addedTrack = new Vector<Track>();
        int i = 0;
        while (i < sel.length) {
            Track tr;
            if (sel[i] instanceof Track && (tr = (Track)sel[i]).getParent() instanceof ObjectInfo) {
                ObjectInfo info = (ObjectInfo)tr.getParent();
                if (modifiedObj.indexOf(info) < 0) {
                    undo.addCommand(11, new Object[]{info, info.tracks});
                    modifiedObj.addElement(info);
                }
                int j = 0;
                while (j < info.tracks.length) {
                    if (info.tracks[j] == tr) {
                        Track newtr = tr.duplicate(info);
                        newtr.setName("Copy of " + tr.getName());
                        info.addTrack(newtr, j + 1);
                        addedTrack.addElement(newtr);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.window.setUndoRecord(undo);
        this.rebuildList();
        int i2 = 0;
        while (i2 < addedTrack.size()) {
            TreeElement el = this.theList.findElement(addedTrack.elementAt(i2));
            if (el != null) {
                el.setSelected(true);
            }
            ++i2;
        }
        this.repaintGraphs();
    }

    public void deleteSelectedTracks() {
        Scene theScene = this.window.getScene();
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<ObjectInfo> modifiedObj = new Vector<ObjectInfo>();
        int i = 0;
        while (i < sel.length) {
            Track tr;
            if (sel[i] instanceof Track && (tr = (Track)sel[i]).getParent() instanceof ObjectInfo) {
                ObjectInfo info = (ObjectInfo)tr.getParent();
                if (modifiedObj.indexOf(info) < 0) {
                    undo.addCommand(11, new Object[]{info, info.tracks});
                    modifiedObj.addElement(info);
                }
                info.removeTrack(tr);
            }
            ++i;
        }
        this.window.setUndoRecord(undo);
        this.rebuildList();
        this.repaintGraphs();
    }

    public void selectAllTracks() {
        Scene theScene = this.window.getScene();
        int[] sel = theScene.getSelection();
        Vector objects = theScene.getObjects();
        this.theList.setUpdateEnabled(false);
        int i = 0;
        while (i < sel.length) {
            ObjectInfo info = (ObjectInfo)objects.elementAt(sel[i]);
            TreeElement el = this.theList.findElement(info);
            if (el != null) {
                int j = 0;
                while (j < el.getNumChildren()) {
                    this.theList.setSelected(el.getChild(j), true);
                    ++j;
                }
            }
            ++i;
        }
        this.theList.setUpdateEnabled(true);
        this.selectedTracksChanged();
        this.window.updateMenus();
    }

    public void addTrack(Object[] obj, Class trackClass) {
        Scene theScene = this.window.getScene();
        UndoRecord undo = new UndoRecord(this.window, false);
        try {
            Constructor con = trackClass.getConstructor(class$artofillusion$ObjectInfo == null ? (class$artofillusion$ObjectInfo = Score.class$("artofillusion.ObjectInfo")) : class$artofillusion$ObjectInfo);
            int i = 0;
            while (i < obj.length) {
                block5: {
                    ObjectInfo info;
                    block6: {
                        if (!(obj[i] instanceof ObjectInfo)) break block5;
                        info = (ObjectInfo)obj[i];
                        if (trackClass != (class$artofillusion$animation$PoseTrack == null ? Score.class$("artofillusion.animation.PoseTrack") : class$artofillusion$animation$PoseTrack)) break block6;
                        Object3D posable = info.object.getPosableObject();
                        if (posable == null) break block5;
                        if (posable == info.object) break block6;
                        MessageDialog dlg = new MessageDialog((Frame)this.window, new String[]{"'" + info.name + "' must be converted to an Actor before a Pose track can", "be attached to it.  Once you do this, you will no longer be able", "to add or delete vertices.  Are you sure you want to do this?"}, new String[]{"Yes", "No"});
                        if (dlg.getChoice() == 1) break block5;
                        theScene.replaceObject(info.object, posable, undo);
                    }
                    undo.addCommand(11, new Object[]{info, info.tracks});
                    info.addTrack((Track)con.newInstance(info), 0);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.window.setUndoRecord(undo);
        this.rebuildList();
    }

    public void editSelectedKeyframe() {
        if (this.selection.length != 1) {
            return;
        }
        this.selection[0].track.editKeyframe(this.window, this.selection[0].keyIndex);
        this.tracksModified(true);
    }

    public void deleteSelectedKeyframes() {
        Hashtable<Track, Track> changedTracks = new Hashtable<Track, Track>();
        int i = 0;
        while (i < this.selection.length) {
            Track tr = this.selection[i].track;
            Keyframe[] keys = tr.getTimecourse().getValues();
            int j = 0;
            while (j < keys.length) {
                if (keys[j] == this.selection[i].key) {
                    if (changedTracks.get(tr) == null) {
                        changedTracks.put(tr, tr.duplicate(tr.getParent()));
                    }
                    tr.deleteKeyframe(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.selection = new SelectionInfo[0];
        UndoRecord undo = new UndoRecord(this.window, false);
        Enumeration enumeration = changedTracks.keys();
        while (enumeration.hasMoreElements()) {
            Track tr = (Track)enumeration.nextElement();
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo) {
                this.window.getScene().applyTracksToObject((ObjectInfo)parent);
            }
            undo.addCommand(12, new Object[]{tr, changedTracks.get(tr)});
        }
        this.window.setUndoRecord(undo);
        this.window.updateMenus();
        this.tracksModified(true);
    }

    public boolean confirmClose() {
        return true;
    }

    public void setTool(EditingTool tool) {
        if (this.view != this.viewTools.getSelection()) {
            this.view = this.viewTools.getSelection();
            this.layoutGraphs();
        }
        if (this.mode != this.modeTools.getSelection()) {
            this.mode = this.modeTools.getSelection();
            int i = 0;
            while (i < this.graphs.size()) {
                ((TrackDisplay)this.graphs.elementAt(i)).setMode(this.mode);
                ++i;
            }
            this.setHelpText(MODE_HELP_TEXT[this.mode]);
        }
    }

    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    public Frame getFrame() {
        return this.window;
    }

    public void updateImage() {
    }

    public void updateMenus() {
    }

    public void setUndoRecord(UndoRecord command) {
        this.window.setUndoRecord(command);
    }

    public Scene getScene() {
        return this.window.getScene();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

