/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayeredMapping;
import artofillusion.LayoutWindow;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.Texture;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.ui.GenericTreeElement;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.TreeList;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class TextureTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    WeightTrack theWeight;
    TextureParameter[] param;

    public TextureTrack(ObjectInfo info) {
        super("Texture");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.param = info.texParam;
    }

    public void apply(double time) {
        ArrayKeyframe val = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (val == null) {
            return;
        }
        double weight = this.theWeight.getWeight(time);
        int i = 0;
        while (i < this.info.texParam.length) {
            int j = 0;
            while (j < this.param.length) {
                if (this.info.texParam[i].equals(this.param[j])) {
                    double v = weight == 1.0 ? val.val[j] : (1.0 - weight) * this.info.texParamValue[i] + weight * val.val[j];
                    if (v < this.info.texParam[i].minVal) {
                        v = this.info.texParam[i].minVal;
                    }
                    if (v > this.info.texParam[i].maxVal) {
                        v = this.info.texParam[i].maxVal;
                    }
                    this.info.texParamValue[i] = v;
                }
                ++j;
            }
            ++i;
        }
    }

    public Track duplicate(Object obj) {
        TextureTrack t = new TextureTrack((ObjectInfo)obj);
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.param = this.param;
        return t;
    }

    public void copy(Track tr) {
        TextureTrack t = (TextureTrack)tr;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.param = t.param;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public void setKeyframe(double time, Scene sc) {
        double[] d = new double[this.param.length];
        int i = 0;
        while (i < this.info.texParam.length) {
            int j = 0;
            while (j < this.param.length) {
                if (this.info.texParam[i].equals(this.param[j])) {
                    d[j] = this.info.texParamValue[i];
                }
                ++j;
            }
            ++i;
        }
        this.tc.addTimepoint(new ArrayKeyframe(d), time, new Smoothness());
    }

    public boolean setKeyframeIfModified(double time, Scene sc) {
        double[] d = new double[this.param.length];
        boolean change = false;
        ArrayKeyframe key = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        int i = 0;
        while (i < this.info.texParam.length) {
            int j = 0;
            while (j < this.param.length) {
                if (this.info.texParam[i].equals(this.param[j])) {
                    d[j] = this.info.texParamValue[i];
                    if (key == null || d[j] != key.val[j]) {
                        change = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (change) {
            this.tc.addTimepoint(new ArrayKeyframe(d), time, new Smoothness());
        }
        return change;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        String[] names = new String[this.param.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.param[i].name;
            ++i;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        double[] d = new double[this.param.length];
        int i = 0;
        while (i < this.info.texParam.length) {
            int j = 0;
            while (j < this.param.length) {
                if (this.info.texParam[i].equals(this.param[j])) {
                    d[j] = this.info.texParamValue[i];
                }
                ++j;
            }
            ++i;
        }
        return d;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.param.length][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = this.param[i].minVal;
            range[i][1] = this.param[i].maxVal;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void parametersChanged() {
        boolean[] exists = new boolean[this.param.length];
        int num = 0;
        int i = 0;
        while (i < this.param.length) {
            int j = 0;
            while (j < this.info.texParam.length) {
                if (this.param[i].equals(this.info.texParam[j])) {
                    exists[i] = true;
                    ++num;
                    break;
                }
                ++j;
            }
            ++i;
        }
        TextureParameter[] newparam = new TextureParameter[num];
        int i2 = 0;
        int j = 0;
        while (i2 < exists.length) {
            if (exists[i2]) {
                newparam[j++] = this.param[i2];
            }
            ++i2;
        }
        this.param = newparam;
        Keyframe[] key = this.tc.getValues();
        int k = 0;
        while (k < key.length) {
            double[] newval = new double[num];
            int i3 = 0;
            int j2 = 0;
            while (i3 < exists.length) {
                if (exists[i3]) {
                    newval[j2++] = ((ArrayKeyframe)key[k]).val[i3];
                }
                ++i3;
            }
            ((ArrayKeyframe)key[k]).val = newval;
            ++k;
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeShort(this.param.length);
        int[] index = new int[this.param.length];
        int i = 0;
        while (i < this.param.length) {
            int j = 0;
            while (j < this.info.texParam.length) {
                if (this.param[i].equals(this.info.texParam[j])) {
                    index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < index.length) {
            out.writeShort(index[i2]);
            ++i2;
        }
        out.writeInt(t.length);
        int i3 = 0;
        while (i3 < t.length) {
            out.writeDouble(t[i3]);
            ((ArrayKeyframe)v[i3]).writeToStream(out);
            s[i3].writeToStream(out);
            ++i3;
        }
        this.theWeight.writeToStream(out, scene);
    }

    public TextureTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.info = (ObjectInfo)parent;
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        short numParams = in.readShort();
        this.param = new TextureParameter[numParams];
        int i = 0;
        while (i < this.param.length) {
            this.param[i] = this.info.texParam[in.readShort()];
            ++i;
        }
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i2 = 0;
        while (i2 < keys) {
            t[i2] = in.readDouble();
            v[i2] = new ArrayKeyframe(in, this);
            s[i2] = new Smoothness(in);
            ++i2;
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight = new WeightTrack(in, this, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField[] valField = new ValueField[this.param.length];
        ValueSlider[] valSlider = new ValueSlider[this.param.length];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (left)");
        final Label rightLabel = new Label(" (right)");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        int i = 0;
        while (i < this.param.length) {
            if (this.param[i].minVal == -1.7976931348623157E308 || this.param[i].maxVal == Double.MAX_VALUE) {
                final TextureParameter tp = this.param[i];
                valField[i] = new ValueField(key.val[i], 0, 5);
                valField[i].setValueChecker(new ValueChecker(){

                    public boolean isValid(double v) {
                        return v >= tp.minVal && v <= tp.maxVal;
                    }
                });
            } else {
                valSlider[i] = new ValueSlider(this.param[i].minVal, this.param[i].maxVal, 50, key.val[i]);
            }
            ++i;
        }
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        int i2 = 0;
        while (i2 < this.param.length) {
            p.add((Component)new Label(this.param[i2].name), gc);
            ++i2;
        }
        p.add((Component)new Label("Time"), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        int i3 = 0;
        while (i3 < this.param.length) {
            if (valField[i3] != null) {
                p.add((Component)valField[i3], gc);
            } else {
                p.add((Component)valSlider[i3], gc);
            }
            ++i3;
        }
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label("Smoothness:"), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Frame)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        int i4 = 0;
        while (i4 < valField.length) {
            key.val[i4] = valField[i4] != null ? valField[i4].getValue() : valSlider[i4].getValue();
            ++i4;
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        TreeList tree = new TreeList(win);
        ScrollPane sp = new ScrollPane();
        Vector<GenericTreeElement> elements = new Vector<GenericTreeElement>();
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        if (this.info.object.getTextureMapping() instanceof LayeredMapping) {
            LayeredMapping map = (LayeredMapping)this.info.object.getTextureMapping();
            Texture[] layer = map.getLayers();
            int i = 0;
            while (i < layer.length) {
                Vector<GenericTreeElement> v = new Vector<GenericTreeElement>();
                TextureParameter[] p = map.getLayerParameters(i);
                int j = 0;
                while (j < p.length) {
                    int k = 0;
                    while (!this.info.texParam[k].equals(p[j])) {
                        ++k;
                    }
                    if (!this.info.texParamPerVertex[k]) {
                        GenericTreeElement el = new GenericTreeElement(p[j].name, p[j].duplicate(), null, tree, null);
                        k = 0;
                        while (k < this.param.length) {
                            if (this.param[k].equals(p[j])) {
                                el.setSelected(true);
                            }
                            ++k;
                        }
                        v.addElement(el);
                    }
                    ++j;
                }
                if (v.size() == 0) {
                    GenericTreeElement el = new GenericTreeElement("(no adjustable parameters)", null, null, tree, null);
                    el.setSelectable(false);
                    v.addElement(el);
                }
                GenericTreeElement el = new GenericTreeElement("Layer " + (i + 1) + ": " + layer[i].getName(), null, null, tree, v);
                el.setSelectable(false);
                el.setExpanded(true);
                elements.addElement(el);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.info.texParam.length) {
                if (!this.info.texParamPerVertex[i]) {
                    elements.addElement(new GenericTreeElement(this.info.texParam[i].name, this.info.texParam[i], null, tree, null));
                }
                ++i;
            }
        }
        if (elements.size() == 0) {
            GenericTreeElement el = new GenericTreeElement("(no adjustable parameters)", null, null, tree, null);
            el.setSelectable(false);
            elements.addElement(el);
        }
        GenericTreeElement texElem = new GenericTreeElement("Texture", null, null, tree, elements);
        texElem.setSelectable(false);
        texElem.setExpanded(true);
        tree.addElement(texElem);
        tree.setPreferredSize(150, 100);
        sp.setSize(150, 250);
        tree.setBackground(Color.white);
        Panel p = new Panel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)new Label("Track Name:"), gc);
        p.add((Component)new Label("Smoothing Method:"), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets.right = 0;
        p.add((Component)nameField, gc);
        p.add((Component)smoothChoice, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        p.add((Component)new Label("Select all parameters this track should control:"), gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        p.add((Component)sp, gc);
        sp.add(tree);
        PanelDialog dlg = new PanelDialog((Frame)win, "Options for Texture Track", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        Object[] selected = tree.getSelectedObjects();
        int[] index = new int[selected.length];
        int i = 0;
        while (i < selected.length) {
            index[i] = -1;
            int j = 0;
            while (j < this.param.length) {
                if (this.param[j].equals((TextureParameter)selected[i])) {
                    index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        this.param = new TextureParameter[selected.length];
        System.arraycopy(selected, 0, this.param, 0, selected.length);
        Keyframe[] key = this.tc.getValues();
        int i2 = 0;
        while (i2 < key.length) {
            double[] newval = new double[this.param.length];
            int j = 0;
            while (j < newval.length) {
                if (index[j] > -1) {
                    newval[j] = ((ArrayKeyframe)key[i2]).val[index[j]];
                } else {
                    int k = 0;
                    while (k < this.info.texParam.length) {
                        if (this.info.texParam[k].equals(this.param[j])) {
                            newval[j] = this.info.texParamValue[k];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ((ArrayKeyframe)key[i2]).val = newval;
            ++i2;
        }
    }
}

