/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ScalarKeyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class WeightTrack
extends Track {
    Track parent;
    Timecourse tc;
    int smoothingMethod;

    public WeightTrack(Track parent) {
        super("Weight");
        this.parent = parent;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 1;
    }

    public double getWeight(double time) {
        if (!this.enabled) {
            return 1.0;
        }
        ScalarKeyframe w = (ScalarKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (w == null) {
            return 1.0;
        }
        if (w.val > 1.0) {
            return 1.0;
        }
        if (w.val < 0.0) {
            return 0.0;
        }
        return w.val;
    }

    public void apply(double time) {
    }

    public Track duplicate(Object parent) {
        WeightTrack t = new WeightTrack((Track)parent);
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate(null);
        return t;
    }

    public void copy(Track tr) {
        WeightTrack t = (WeightTrack)tr;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(null);
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setTimecourse(Timecourse t) {
        this.tc = t;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public void setKeyframe(double time, Scene sc) {
        this.tc.addTimepoint(new ScalarKeyframe(1.0), time, new Smoothness());
    }

    public boolean setKeyframeIfModified(double time, Scene sc) {
        return false;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return true;
    }

    public Object getParent() {
        return this.parent;
    }

    public String[] getValueNames() {
        return new String[]{"Weight"};
    }

    public double[] getDefaultGraphValues() {
        return new double[]{1.0};
    }

    public double[][] getValueRange() {
        return new double[][]{{0.0, 1.0}};
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
            ++i;
        }
    }

    public WeightTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new ScalarKeyframe(in, parent);
            s[i] = new Smoothness(in);
            ++i;
        }
        this.parent = (Track)parent;
        this.tc = new Timecourse(v, t, s);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ScalarKeyframe key = (ScalarKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueSlider weightSlider = new ValueSlider(0.0, 1.0, 100, key.val);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (left)");
        final Label rightLabel = new Label(" (right)");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)new Label("Weight"), gc);
        p.add((Component)new Label("Time"), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)weightSlider, gc);
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label("Smoothness:"), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Frame)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.parent)}));
        key.val = weightSlider.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        ComponentsDialog dlg = new ComponentsDialog((Frame)win, "Options for Weight Track", new Component[]{nameField, smoothChoice}, new String[]{"Track Name:", "Smoothing Method:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.parent)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
    }
}

