/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class CompareModule
extends Module {
    double value;
    double error;
    double deriv;
    double lastBlur;
    boolean valueOk;
    boolean gradOk;
    Vec3 gradient = new Vec3();

    public CompareModule(Point position) {
        super(">", new IOPort[]{new IOPort(0, 0, 0, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 1, new String[]{"Value 2", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Comparison"})}, position);
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        double value1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double value2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double error1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double error2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double min1 = value1 - error1;
        double max1 = value1 + error1;
        double min2 = value2 - error2;
        double max2 = value2 + error2;
        if (min1 > max2) {
            this.value = 1.0;
            this.error = 0.0;
        } else if (min2 > max1) {
            this.value = 0.0;
            this.error = 0.0;
        } else if (value1 > value2) {
            this.error = 0.5 * (max2 - min1) / (max1 - min2);
            this.value = 1.0 - this.error;
            this.deriv = 1.0 / (this.error > error2 ? error1 : error2);
        } else {
            this.value = this.error = 0.5 * (max1 - min2) / (max2 - min1);
            this.deriv = 1.0 / (this.error > error2 ? error1 : error2);
        }
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.error == 0.0) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.gradOk) {
            grad.set(this.gradient);
            return;
        }
        this.gradOk = true;
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        }
        if (this.linkFrom[1] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.gradient, blur);
        }
        grad.subtract(this.gradient);
        grad.scale(this.deriv);
        this.gradient.set(grad);
    }
}

