/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class CosineModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double value;
    double error;
    double valueIn;
    double errorIn;
    double lastBlur;
    Vec3 gradient = new Vec3();

    public CosineModule(Point position) {
        super("Cos", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Value", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Cosine"})}, position);
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        if (this.linkFrom[0] == null) {
            this.value = 1.0;
            this.error = 0.0;
            this.errorOk = true;
            this.valueOk = true;
            return 1.0;
        }
        this.valueIn = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.errorIn = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (this.errorIn == 0.0) {
            this.value = Math.cos(this.valueIn);
            this.error = 0.0;
            this.errorOk = true;
            this.valueOk = true;
            return this.value;
        }
        this.value = (Math.sin(this.valueIn + this.errorIn) - Math.sin(this.valueIn - this.errorIn)) / (2.0 * this.errorIn);
        this.valueOk = true;
        this.lastBlur = blur;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        this.errorOk = true;
        if (this.errorIn == 0.0) {
            this.error = 0.0;
            return 0.0;
        }
        this.error = Math.abs(Math.sin(this.valueIn) * this.errorIn);
        if (this.error > 0.5) {
            this.error = 0.5;
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(-Math.sin(this.valueIn));
        grad.set(this.gradient);
    }
}

