/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.SVD;
import artofillusion.Scene;
import artofillusion.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;

public class FunctionModule
extends Module {
    boolean repeat;
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double[] x = new double[]{0.0, 1.0};
    double[] y = new double[]{0.0, 1.0};
    double value;
    double error;
    double deriv;
    double lastBlur;
    double[] a0;
    double[] a1;
    double[] a2;
    double[] a3;
    double[] b;
    short shape = 0;
    Vec3 gradient;
    public static final short LINEAR = 0;
    public static final short INTERPOLATING = 1;

    public FunctionModule(Point position) {
        super("", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
        this.calcCoefficients();
        this.gradient = new Vec3();
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    private double calcValue(double value) {
        if (value <= 0.0 || value >= 1.0) {
            if (this.repeat) {
                value -= Math.floor(value);
            } else {
                if (value <= 0.0) {
                    return this.y[0];
                }
                return this.y[this.y.length - 1];
            }
        }
        int i = 1;
        while (i < this.x.length && value > this.x[i]) {
            ++i;
        }
        --i;
        if (this.shape == 1) {
            return this.a0[i] + value * (2.0 * this.a1[i] + value * (3.0 * this.a2[i] + value * 4.0 * this.a3[i]));
        }
        return this.a0[i] + value * 2.0 * this.a1[i];
    }

    private double integral(double valueIn) {
        double result;
        double vf;
        if (this.repeat) {
            double vi = Math.floor(valueIn);
            vf = valueIn - vi;
            result = vi * this.b[this.b.length - 1];
        } else {
            if (valueIn <= 0.0) {
                return valueIn * this.y[0];
            }
            if (valueIn >= 1.0) {
                return this.b[this.b.length - 1] + (valueIn - 1.0) * this.y[this.y.length - 1];
            }
            vf = (float)valueIn;
            result = 0.0;
        }
        if (vf == 0.0) {
            return result;
        }
        int i = 1;
        while (i < this.x.length && vf > this.x[i]) {
            ++i;
        }
        result = this.shape == 1 ? (result += this.b[i] + vf * (this.a0[i] + vf * (this.a1[i] + vf * (this.a2[i] + vf * this.a3[i])))) : (result += this.b[--i] + vf * (this.a0[i] + vf * this.a1[i]));
        return result;
    }

    private void calcCoefficients() {
        this.a0 = new double[this.x.length - 1];
        this.a1 = new double[this.x.length - 1];
        this.a2 = new double[this.x.length - 1];
        this.a3 = new double[this.x.length - 1];
        this.b = new double[this.x.length];
        if (this.shape == 0) {
            int i = 0;
            while (i < this.a0.length) {
                double dx = this.x[i + 1] - this.x[i];
                if (dx != 0.0) {
                    this.a1[i] = (this.y[i + 1] - this.y[i]) / dx;
                    this.a0[i] = this.y[i] - this.a1[i] * this.x[i];
                    int n = i;
                    this.a1[n] = this.a1[n] * 0.5;
                    this.b[i + 1] = this.b[i] + this.x[i + 1] * (this.a0[i] + this.x[i + 1] * this.a1[i]) - this.x[i] * (this.a0[i] + this.x[i] * this.a1[i]);
                }
                ++i;
            }
            int i2 = 1;
            while (i2 < this.b.length - 1) {
                int n = i2;
                this.b[n] = this.b[n] - this.x[i2] * (this.a0[i2] + this.x[i2] * this.a1[i2]);
                ++i2;
            }
            return;
        }
        double[][] m = new double[4][4];
        double[] a = new double[4];
        double[] deriv = new double[this.x.length];
        int i = 1;
        while (i < this.x.length - 1) {
            if (this.x[i - 1] != this.x[i + 1]) {
                deriv[i] = (this.y[i + 1] - this.y[i - 1]) / (this.x[i + 1] - this.x[i]);
            }
            ++i;
        }
        if (this.repeat) {
            double d = (this.y[1] - this.y[this.y.length - 2]) / (1.0 + this.x[1] - this.x[this.x.length - 2]);
            deriv[this.x.length - 1] = d;
            deriv[0] = d;
        }
        int i3 = 0;
        while (i3 < this.a0.length) {
            m[0][0] = 0.0;
            m[0][1] = 1.0;
            m[0][2] = 2.0 * this.x[i3];
            m[0][3] = 3.0 * this.x[i3] * this.x[i3];
            a[0] = deriv[i3];
            m[1][0] = 1.0;
            m[1][1] = this.x[i3];
            m[1][2] = this.x[i3] * this.x[i3];
            m[1][3] = this.x[i3] * this.x[i3] * this.x[i3];
            a[1] = this.y[i3];
            m[2][0] = 1.0;
            m[2][1] = this.x[i3 + 1];
            m[2][2] = this.x[i3 + 1] * this.x[i3 + 1];
            m[2][3] = this.x[i3 + 1] * this.x[i3 + 1] * this.x[i3 + 1];
            a[2] = this.y[i3 + 1];
            m[3][0] = 0.0;
            m[3][1] = 1.0;
            m[3][2] = 2.0 * this.x[i3 + 1];
            m[3][3] = 3.0 * this.x[i3 + 1] * this.x[i3 + 1];
            a[3] = deriv[i3 + 1];
            SVD.solve(m, a);
            this.a0[i3] = a[0];
            this.a1[i3] = 0.5 * a[1];
            this.a2[i3] = a[2] / 3.0;
            this.a3[i3] = 0.25 * a[3];
            this.b[i3 + 1] = this.b[i3] + this.x[i3 + 1] * (this.a0[i3] + this.x[i3 + 1] * (this.a1[i3] + this.x[i3 + 1] * (this.a2[i3] + this.x[i3 + 1] * this.a3[i3]))) - this.x[i3] * (this.a0[i3] + this.x[i3] * (this.a1[i3] + this.x[i3] * (this.a2[i3] + this.x[i3] * this.a3[i3])));
            ++i3;
        }
        int i4 = 1;
        while (i4 < this.b.length - 1) {
            int n = i4;
            this.b[n] = this.b[n] - this.x[i4] * (this.a0[i4] + this.x[i4] * (this.a1[i4] + this.x[i4] * (this.a2[i4] + this.x[i4] * this.a3[i4])));
            ++i4;
        }
    }

    public double getAverageValue(int which, double blur) {
        double errorIn;
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.lastBlur = blur;
        this.valueOk = true;
        double valueIn = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double d = errorIn = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (errorIn == 0.0) {
            this.value = this.calcValue(valueIn);
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        this.value = (this.integral(valueIn + errorIn) - this.integral(valueIn - errorIn)) / (2.0 * errorIn);
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (this.errorOk && blur == this.lastBlur) {
            return this.error;
        }
        this.lastBlur = blur;
        this.errorOk = true;
        if (this.linkFrom[0] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
            this.error = 0.0;
            this.gradOk = true;
            return 0.0;
        }
        double valueIn = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (valueIn <= 0.0 || valueIn >= 1.0) {
            if (!this.repeat) {
                this.gradient.set(0.0, 0.0, 0.0);
                this.error = 0.0;
                this.gradOk = true;
                return 0.0;
            }
            valueIn -= Math.floor(valueIn);
        }
        int i = 1;
        while (i < this.x.length && valueIn > this.x[i]) {
            ++i;
        }
        this.error = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.deriv = this.shape == 1 ? 2.0 * this.a1[i] + valueIn * (6.0 * this.a2[i] + valueIn * 12.0 * this.a3[i]) : 2.0 * this.a1[--i];
        this.error *= Math.abs(this.deriv);
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.errorOk || blur != this.lastBlur) {
            this.getValueError(which, blur);
        }
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            this.gradient.set(0.0, 0.0, 0.0);
            grad.set(0.0, 0.0, 0.0);
            this.gradOk = true;
            return;
        }
        this.lastBlur = blur;
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(this.deriv);
        grad.set(this.gradient);
    }

    public void calcSize() {
        this.bounds.width = 50;
        this.bounds.height = 35;
    }

    protected void drawContents(Graphics g) {
        Rectangle r = new Rectangle(this.bounds.x + 5, this.bounds.y + 5, this.bounds.width - 10, this.bounds.height - 10);
        double miny = Double.MAX_VALUE;
        double maxy = -1.7976931348623157E308;
        int i = 0;
        while (i < this.y.length) {
            if (this.y[i] < miny) {
                miny = this.y[i];
            }
            if (this.y[i] > maxy) {
                maxy = this.y[i];
            }
            ++i;
        }
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        if (this.shape == 1) {
            int lastx = (int)((double)r.x + this.x[0] * (double)r.width);
            int lasty = (int)((double)r.y + (maxy - this.y[0]) * (double)r.height / (maxy - miny));
            int i2 = 0;
            while (i2 < this.x.length - 1) {
                double dx = this.x[i2 + 1] - this.x[i2];
                int nextx = 0;
                int nexty = 0;
                if (dx == 0.0) {
                    nextx = (int)((double)r.x + this.x[i2 + 1] * (double)r.width);
                    nexty = (int)((double)r.y + (maxy - this.y[i2 + 1]) * (double)r.height / (maxy - miny));
                } else {
                    int j = 1;
                    while (j < 8) {
                        double xf = this.x[i2] + (double)j * 0.125 * dx;
                        double yf = this.calcValue(xf);
                        nextx = (int)((double)r.x + xf * (double)r.width);
                        nexty = (int)((double)r.y + (maxy - yf) * (double)r.height / (maxy - miny));
                        g.drawLine(lastx, lasty, nextx, nexty);
                        lastx = nextx;
                        lasty = nexty;
                        ++j;
                    }
                }
                g.drawLine(lastx, lasty, nextx, nexty);
                lastx = nextx;
                lasty = nexty;
                ++i2;
            }
            return;
        }
        int i3 = 0;
        while (i3 < this.x.length - 1) {
            int x1 = (int)((double)r.x + this.x[i3] * (double)r.width);
            int y1 = (int)((double)r.y + (maxy - this.y[i3]) * (double)r.height / (maxy - miny));
            int x2 = (int)((double)r.x + this.x[i3 + 1] * (double)r.width);
            int y2 = (int)((double)r.y + (maxy - this.y[i3 + 1]) * (double)r.height / (maxy - miny));
            g.drawLine(x1, y1, x2, y2);
            ++i3;
        }
    }

    public Module duplicate() {
        FunctionModule mod = new FunctionModule(new Point(this.bounds.x, this.bounds.y));
        mod.repeat = this.repeat;
        mod.shape = this.shape;
        mod.x = new double[this.x.length];
        mod.y = new double[this.y.length];
        int i = 0;
        while (i < this.x.length) {
            mod.x[i] = this.x[i];
            mod.y[i] = this.y[i];
            ++i;
        }
        mod.calcCoefficients();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.x.length);
        int i = 0;
        while (i < this.x.length) {
            out.writeDouble(this.x[i]);
            out.writeDouble(this.y[i]);
            ++i;
        }
        out.writeBoolean(this.repeat);
        out.writeShort(this.shape);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int num = in.readInt();
        this.x = new double[num];
        this.y = new double[num];
        int i = 0;
        while (i < this.x.length) {
            this.x[i] = in.readDouble();
            this.y[i] = in.readDouble();
            ++i;
        }
        this.repeat = in.readBoolean();
        this.shape = in.readShort();
        this.calcCoefficients();
    }

    public boolean edit(Frame fr, Scene theScene) {
        EditingDialog dlg = new EditingDialog(fr);
        return dlg.clickedOk;
    }

    private class EditingDialog
    extends Dialog
    implements ActionListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener {
        Canvas canvas;
        TextField xField;
        TextField yField;
        Checkbox repeatBox;
        Checkbox smoothBox;
        Button deleteButton;
        Point clickPoint;
        Point[] handlePos;
        Rectangle graphBounds;
        FontMetrics fm;
        NumberFormat hFormat;
        NumberFormat vFormat;
        int selected;
        FunctionModule editModule;
        boolean clickedOk;
        boolean fixRange;
        double[] x;
        double[] y;
        double miny;
        double maxy;
        double labelstep;
        static final int HANDLE_SIZE = 5;

        public EditingDialog(Frame parent) {
            super(parent, "Function", true);
            Panel p = new Panel();
            GridBagConstraints gc = new GridBagConstraints();
            p.setLayout(new BorderLayout());
            p.add((Component)new Label("Drag to move handles.  Control-click to add a handle."), "North");
            this.canvas = new Canvas(this){
                private final /* synthetic */ EditingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void paint(Graphics g) {
                    EditingDialog.access$000(this.this$1, g);
                    EditingDialog.access$100(this.this$1, g, this.this$1.graphBounds);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(200, 150);
                }
            };
            this.canvas.addKeyListener(this);
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
            this.canvas.setBackground(Color.white);
            this.graphBounds = new Rectangle();
            this.hFormat = NumberFormat.getInstance();
            this.vFormat = NumberFormat.getInstance();
            this.hFormat.setMaximumFractionDigits(1);
            p.add((Component)this.canvas, "Center");
            this.add((Component)p, "North");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridy = 0;
            gc.insets = new Insets(0, 0, 0, 10);
            p.add((Component)new Label("X:"), gc);
            this.xField = new TextField("", 5);
            p.add((Component)this.xField, gc);
            this.xField.addKeyListener(this);
            this.xField.addTextListener(this);
            p.add((Component)new Label("Y:"), gc);
            this.yField = new TextField("", 5);
            p.add((Component)this.yField, gc);
            this.yField.addKeyListener(this);
            this.yField.addTextListener(this);
            Button b = new Button("Add");
            p.add((Component)b, gc);
            b.addActionListener(this);
            b.setActionCommand("add");
            b = new Button("Delete");
            p.add((Component)b, gc);
            b.addActionListener(this);
            b.setActionCommand("delete");
            this.deleteButton = b;
            gc.gridy = 1;
            gc.gridwidth = 4;
            this.repeatBox = new Checkbox("Function is Periodic", FunctionModule.this.repeat);
            p.add((Component)this.repeatBox, gc);
            gc.gridwidth = 2;
            this.smoothBox = new Checkbox("Smooth Curve", FunctionModule.this.shape == 1);
            p.add((Component)this.smoothBox, gc);
            this.repeatBox.setState(FunctionModule.this.repeat);
            this.smoothBox.setState(FunctionModule.this.shape == 1);
            this.repeatBox.addItemListener(this);
            this.smoothBox.addItemListener(this);
            this.add((Component)p, "Center");
            p = new Panel();
            b = new Button("OK");
            p.add(b);
            b.addActionListener(this);
            b.setActionCommand("ok");
            b = new Button("Cancel");
            p.add(b);
            b.addActionListener(this);
            b.setActionCommand("cancel");
            this.add((Component)p, "South");
            this.editModule = (FunctionModule)FunctionModule.this.duplicate();
            this.x = this.editModule.x;
            this.y = this.editModule.y;
            this.findRange();
            this.adjustComponents();
            this.handlePos = new Point[this.x.length];
            int i = 0;
            while (i < this.x.length) {
                this.x[i] = FunctionModule.this.x[i];
                this.y[i] = FunctionModule.this.y[i];
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            this.pack();
            this.fm = this.canvas.getFontMetrics(this.canvas.getFont());
            this.show();
            this.canvas.requestFocus();
        }

        private void adjustComponents() {
            this.xField.setText("" + this.x[this.selected]);
            this.yField.setText("" + this.y[this.selected]);
            boolean movable = this.selected > 0 && this.selected < this.x.length - 1;
            this.xField.setEnabled(movable);
            this.deleteButton.setEnabled(movable);
        }

        private void findRange() {
            if (this.fixRange) {
                return;
            }
            this.miny = Double.MAX_VALUE;
            this.maxy = -1.7976931348623157E308;
            int i = 0;
            while (i < this.y.length) {
                if (this.y[i] < this.miny) {
                    this.miny = this.y[i];
                }
                if (this.y[i] > this.maxy) {
                    this.maxy = this.y[i];
                }
                ++i;
            }
            if (this.miny == this.maxy) {
                this.miny = Math.floor(this.miny);
                this.maxy = this.miny + 1.0;
            }
            int decimals = (int)Math.floor(Math.log(this.maxy - this.miny) / Math.log(10.0));
            this.labelstep = Math.pow(10.0, decimals);
            this.vFormat.setMaximumFractionDigits(decimals < 0 ? -decimals : 1);
        }

        private void positionHandles(Rectangle r) {
            int i = 0;
            while (i < this.x.length) {
                this.handlePos[i].x = (int)((double)r.x + this.x[i] * (double)r.width);
                this.handlePos[i].y = (int)((double)r.y + (this.maxy - this.y[i]) * (double)r.height / (this.maxy - this.miny));
                ++i;
            }
        }

        private void paintAxes(Graphics g) {
            String label;
            int maxWidth = 0;
            int fontHeight = this.fm.getHeight();
            Dimension d = this.canvas.getSize();
            double pos = this.labelstep * Math.ceil(this.miny / this.labelstep);
            this.graphBounds.y = 2;
            this.graphBounds.height = d.height - 5 - fontHeight - 5;
            g.setColor(Color.black);
            while (pos <= this.maxy) {
                label = this.vFormat.format(pos);
                int w = this.fm.stringWidth(label);
                if (w > maxWidth) {
                    maxWidth = w;
                }
                g.drawString(label, 0, this.graphBounds.y + (int)((this.maxy - pos) * (double)this.graphBounds.height / (this.maxy - this.miny)) + fontHeight / 2);
                pos += this.labelstep;
            }
            this.graphBounds.x = maxWidth + 5;
            this.graphBounds.width = d.width - maxWidth - 5 - 2;
            pos = this.labelstep * Math.ceil(this.miny / this.labelstep);
            while (pos <= this.maxy) {
                int v = this.graphBounds.y + (int)((this.maxy - pos) * (double)this.graphBounds.height / (this.maxy - this.miny));
                g.drawLine(this.graphBounds.x - 3, v, this.graphBounds.x, v);
                pos += this.labelstep;
            }
            int i = 0;
            while (i < 10) {
                label = this.hFormat.format(0.1 * (double)i);
                int h = this.graphBounds.x + i * this.graphBounds.width / 10;
                g.drawLine(h, this.graphBounds.y + this.graphBounds.height, h, this.graphBounds.y + this.graphBounds.height + 3);
                g.drawString(label, h - this.fm.stringWidth(label) / 2, d.height);
                ++i;
            }
            g.drawLine(this.graphBounds.x, 0, this.graphBounds.x, this.graphBounds.y + this.graphBounds.height);
            g.drawLine(this.graphBounds.x, this.graphBounds.y + this.graphBounds.height, this.graphBounds.x + this.graphBounds.width, this.graphBounds.y + this.graphBounds.height);
            this.positionHandles(this.graphBounds);
        }

        private void paintCanvas(Graphics g, Rectangle r) {
            g.setColor(Color.black);
            if (this.smoothBox.getState()) {
                int lastx = this.handlePos[0].x;
                int lasty = this.handlePos[0].y;
                int i = 0;
                while (i < this.handlePos.length - 1) {
                    double dx = this.x[i + 1] - this.x[i];
                    if (dx == 0.0) {
                        g.drawLine(lastx, lasty, this.handlePos[i + 1].x, this.handlePos[i + 1].y);
                        lastx = this.handlePos[i + 1].x;
                        lasty = this.handlePos[i + 1].y;
                    } else {
                        int j = 1;
                        while (j < 8) {
                            double xf = this.x[i] + (double)j * 0.125 * dx;
                            double yf = this.editModule.calcValue(xf);
                            int nextx = (int)((double)r.x + xf * (double)r.width);
                            int nexty = (int)((double)r.y + (this.maxy - yf) * (double)r.height / (this.maxy - this.miny));
                            g.drawLine(lastx, lasty, nextx, nexty);
                            lastx = nextx;
                            lasty = nexty;
                            ++j;
                        }
                        g.drawLine(lastx, lasty, this.handlePos[i + 1].x, this.handlePos[i + 1].y);
                        lastx = this.handlePos[i + 1].x;
                        lasty = this.handlePos[i + 1].y;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.handlePos.length - 1) {
                    g.drawLine(this.handlePos[i].x, this.handlePos[i].y, this.handlePos[i + 1].x, this.handlePos[i + 1].y);
                    ++i;
                }
            }
            int i = 0;
            while (i < this.handlePos.length) {
                if (this.selected == i) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.fillRect(this.handlePos[i].x - 2, this.handlePos[i].y - 2, 5, 5);
                ++i;
            }
        }

        public void addHandle(double where, double val) {
            double[] newx = new double[this.x.length + 1];
            double[] newy = new double[this.y.length + 1];
            int i = 0;
            while (i < this.x.length && this.x[i] < where) {
                newx[i] = this.x[i];
                newy[i] = this.y[i];
                ++i;
            }
            newx[i] = where;
            newy[i] = val;
            this.selected = i;
            while (i < this.x.length) {
                newx[i + 1] = this.x[i];
                newy[i + 1] = this.y[i];
                ++i;
            }
            this.x = newx;
            this.editModule.x = newx;
            this.y = newy;
            this.editModule.y = newy;
            this.handlePos = new Point[this.x.length];
            i = 0;
            while (i < this.handlePos.length) {
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            this.editModule.calcCoefficients();
            this.adjustComponents();
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
        }

        public void deleteSelectedHandle() {
            if (this.selected == 0 || this.selected == this.x.length - 1) {
                return;
            }
            double[] newx = new double[this.x.length - 1];
            double[] newy = new double[this.y.length - 1];
            int i = 0;
            while (i < this.x.length - 1) {
                if (i < this.selected) {
                    newx[i] = this.x[i];
                    newy[i] = this.y[i];
                } else {
                    newx[i] = this.x[i + 1];
                    newy[i] = this.y[i + 1];
                }
                ++i;
            }
            this.selected = 0;
            this.x = newx;
            this.editModule.x = newx;
            this.y = newy;
            this.editModule.y = newy;
            this.handlePos = new Point[this.x.length];
            i = 0;
            while (i < this.handlePos.length) {
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            this.editModule.calcCoefficients();
            this.adjustComponents();
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("add".equals(command)) {
                this.addHandle(0.5, FunctionModule.this.calcValue(0.5));
            }
            if ("delete".equals(command)) {
                this.deleteSelectedHandle();
            }
            if ("ok".equals(command)) {
                this.clickedOk = true;
                FunctionModule.this.x = this.x;
                FunctionModule.this.y = this.y;
                FunctionModule.this.repeat = this.repeatBox.getState();
                FunctionModule.this.shape = this.smoothBox.getState() ? (short)1 : 0;
                FunctionModule.this.calcCoefficients();
                this.dispose();
            }
            if ("cancel".equals(command)) {
                this.dispose();
            }
        }

        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                this.clickedOk = true;
                FunctionModule.this.x = this.x;
                FunctionModule.this.y = this.y;
                FunctionModule.this.repeat = this.repeatBox.getState();
                FunctionModule.this.shape = this.smoothBox.getState() ? (short)1 : 0;
                FunctionModule.this.calcCoefficients();
                this.dispose();
            }
            if (ev.getKeyCode() == 27) {
                this.dispose();
            }
            if (ev.getSource() != this.canvas) {
                return;
            }
            if (ev.getKeyCode() == 8 || ev.getKeyCode() == 127) {
                this.deleteSelectedHandle();
            }
        }

        public void mousePressed(MouseEvent ev) {
            this.fixRange = true;
            this.clickPoint = ev.getPoint();
            this.canvas.requestFocus();
            if (ev.isControlDown()) {
                double h = (double)(this.clickPoint.x - this.graphBounds.x) / ((double)this.graphBounds.width - 1.0);
                double v = (double)(this.graphBounds.height - this.clickPoint.y + this.graphBounds.y) / ((double)this.graphBounds.height - 1.0);
                v = v * (this.maxy - this.miny) + this.miny;
                this.addHandle(0.001 * (double)((int)(1000.0 * h)), 0.001 * (double)((int)(1000.0 * v)));
                return;
            }
            int i = 0;
            while (i < this.handlePos.length) {
                int xh = this.handlePos[i].x;
                int yh = this.handlePos[i].y;
                if (this.clickPoint.x >= xh - 2 && this.clickPoint.x <= xh + 2 && this.clickPoint.y >= yh - 2 && this.clickPoint.y <= yh + 2) {
                    this.selected = i;
                    this.adjustComponents();
                    this.canvas.repaint();
                    return;
                }
                ++i;
            }
            this.clickPoint = null;
        }

        public void mouseDragged(MouseEvent ev) {
            Point tempPos;
            double temp;
            if (this.clickPoint == null) {
                return;
            }
            Point pos = ev.getPoint();
            this.handlePos[this.selected].x = pos.x;
            double newx = ((double)pos.x - (double)this.graphBounds.x) / ((double)this.graphBounds.width - 1.0);
            double newy = (double)(this.graphBounds.height - pos.y + this.graphBounds.y) / ((double)this.graphBounds.height - 1.0);
            newy = newy * (this.maxy - this.miny) + this.miny;
            if (newx < 0.0) {
                newx = 0.0;
            }
            if (newx > 1.0) {
                newx = 1.0;
            }
            if (newy < this.miny) {
                newy = this.miny;
            }
            if (newy > this.maxy) {
                newy = this.maxy;
            }
            this.y[this.selected] = 0.001 * (double)((int)(1000.0 * newy));
            if (this.selected == 0 || this.selected == this.x.length - 1) {
                this.adjustComponents();
                this.canvas.repaint();
                return;
            }
            this.x[this.selected] = 0.001 * (double)((int)(1000.0 * newx));
            while (this.x[this.selected] < this.x[this.selected - 1]) {
                temp = this.x[this.selected];
                this.x[this.selected] = this.x[this.selected - 1];
                this.x[this.selected - 1] = temp;
                temp = this.y[this.selected];
                this.y[this.selected] = this.y[this.selected - 1];
                this.y[this.selected - 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected - 1];
                this.handlePos[this.selected - 1] = tempPos;
                --this.selected;
            }
            while (this.x[this.selected] > this.x[this.selected + 1]) {
                temp = this.x[this.selected];
                this.x[this.selected] = this.x[this.selected + 1];
                this.x[this.selected + 1] = temp;
                temp = this.y[this.selected];
                this.y[this.selected] = this.y[this.selected + 1];
                this.y[this.selected + 1] = temp;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected + 1];
                this.handlePos[this.selected + 1] = tempPos;
                ++this.selected;
            }
            this.adjustComponents();
            this.canvas.repaint();
        }

        public void mouseReleased(MouseEvent ev) {
            this.clickPoint = null;
            this.editModule.calcCoefficients();
            this.fixRange = false;
            this.findRange();
            this.positionHandles(this.graphBounds);
            this.canvas.repaint();
        }

        public void textValueChanged(TextEvent ev) {
            double newx = Double.NaN;
            double newy = Double.NaN;
            boolean ok = true;
            try {
                newx = Double.valueOf(this.xField.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                newy = Double.valueOf(this.yField.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (newx < 0.0 || newx > 1.0 || Double.isNaN(newx)) {
                this.xField.setForeground(Color.red);
                ok = false;
            } else {
                this.x[this.selected] = newx;
                this.xField.setForeground(Color.black);
            }
            if (Double.isNaN(newy)) {
                this.yField.setForeground(Color.red);
                ok = false;
            } else {
                this.y[this.selected] = newy;
                this.yField.setForeground(Color.black);
            }
            if (ok) {
                this.editModule.calcCoefficients();
                if (!this.fixRange) {
                    this.findRange();
                    this.positionHandles(this.graphBounds);
                    this.canvas.repaint();
                }
            }
        }

        public void itemStateChanged(ItemEvent ev) {
            this.editModule.repeat = this.repeatBox.getState();
            this.editModule.shape = this.smoothBox.getState() ? (short)1 : 0;
            this.editModule.calcCoefficients();
            this.canvas.repaint();
        }

        public void keyReleased(KeyEvent ev) {
        }

        public void keyTyped(KeyEvent ev) {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseMoved(MouseEvent ev) {
        }

        static /* synthetic */ void access$000(EditingDialog x0, Graphics x1) {
            x0.paintAxes(x1);
        }

        static /* synthetic */ void access$100(EditingDialog x0, Graphics x1, Rectangle x2) {
            x0.paintCanvas(x1, x2);
        }
    }
}

