/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class InfoBox {
    String[] text = new String[0];
    Rectangle bounds = new Rectangle();
    static Font defaultFont = Font.decode("Serif");
    static FontMetrics defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);

    public void setText(String[] text) {
        this.text = text;
        this.bounds.height = text.length * (defaultMetrics.getMaxAscent() + defaultMetrics.getMaxDescent()) + 10;
        this.bounds.width = 10;
        int i = 0;
        while (i < text.length) {
            int j = defaultMetrics.stringWidth(text[i]) + 10;
            if (j > this.bounds.width) {
                this.bounds.width = j;
            }
            ++i;
        }
    }

    public void setPosition(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void draw(Graphics g) {
        g.setColor(Color.yellow);
        g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g.setColor(Color.black);
        g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g.setFont(defaultFont);
        int i = 0;
        while (i < this.text.length) {
            g.drawString(this.text[i], this.bounds.x + (this.bounds.width - defaultMetrics.stringWidth(this.text[i])) / 2, this.bounds.y + this.bounds.height * (i + 1) / (this.text.length + 1) + defaultMetrics.getAscent() / 2);
            ++i;
        }
    }
}

